/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tda.mservice.snap;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tda.common.cache.CacheManager;
import kd.tmc.tda.common.helper.SysParamHelper;

public class DecsAnlsSnapScheduleService {
    private static final Log logger = LogFactory.getLog(DecsAnlsSnapScheduleService.class);

    public void schedule(String batch, boolean ishistory) {
        logger.info("\u5f00\u59cb\u6267\u884c\u5feb\u7167\u8c03\u5ea6\u670d\u52a1\uff0c\u5feb\u7167\u7f16\u7801 \uff1a " + batch);
        try (TXHandle tx = TX.notSupported();){
            QFilter filter1 = new QFilter("number", "=", (Object)batch);
            DynamicObject version = TmcDataServiceHelper.loadSingleFromCache((String)"tda_decisanlsversion", (String)"id,orgview,org,versionstate,begintime,endtime,querydate", (QFilter[])filter1.toArray());
            CacheManager.clearSnapDataSetCache((String)batch);
            if (!ishistory) {
                try {
                    long startTime = System.currentTimeMillis();
                    logger.info("\u7f13\u5b58\u9884\u52a0\u8f7d\u8017\u8d39\u65f6\u95f4:" + (System.currentTimeMillis() - startTime));
                }
                catch (Exception e) {
                    logger.info("\u7f13\u5b58\u9884\u52a0\u8f7d\u62a5\u9519\u5f02\u5e38");
                    logger.info(e.getMessage(), (Object)e);
                }
            }
            version.set("begintime", (Object)DateUtils.getCurrentTime());
            QFilter filter = new QFilter("enable", "=", (Object)true);
            filter.and(new QFilter("ishistory", "=", (Object)ishistory));
            Map schedules = TmcDataServiceHelper.loadFromCache((String)"tda_decisanlsreportsnap", (String)"id,snapschedule.id,reporttype,ishistory,cycle", (QFilter[])filter.toArray());
            int orgBatchSize = this.getOrgBatchSize();
            Set qingSet = schedules.values().stream().filter(o -> "qing".equals(o.getString("reporttype"))).collect(Collectors.toSet());
            int qing_count = 0;
            ArrayList<Long> subOrgIds = new ArrayList(0);
            if (qingSet.size() > 0) {
                subOrgIds = this.getQingSnapScheduleOrgsList(version);
                qing_count = Lists.partition(subOrgIds, (int)orgBatchSize).size();
            }
            Set commonSet = schedules.values().stream().filter(o -> "common".equals(o.getString("reporttype"))).collect(Collectors.toSet());
            int common_count = 0;
            ArrayList<Long> secOrgIds = new ArrayList(0);
            if (commonSet.size() > 0) {
                secOrgIds = this.getCommonSnapScheduleOrgsList(version);
                common_count = Lists.partition(secOrgIds, (int)orgBatchSize).size();
            }
            logger.info("\u62a5\u8868\u8c03\u5ea6\u4e00\u6279\u6b21\u7684\u7ec4\u7ec7\u6570\u91cf \uff1a" + orgBatchSize);
            int count = qing_count + common_count;
            HashMap<Date, String> hisVersionMap = new HashMap<Date, String>(16);
            if (ishistory) {
                int maxCycle = schedules.values().stream().mapToInt(s -> s.getInt("cycle")).max().orElse(0);
                Date queryDate = DateUtils.getCurrentDate();
                Date minDate = DateUtils.getLastDay((Date)queryDate, (int)maxCycle);
                QFilter historyFilter = new QFilter("orgview.id", "=", (Object)version.getDynamicObject("orgview").getLong("id"));
                historyFilter.and("versionstate", "=", (Object)"active");
                historyFilter.and("querydate", ">=", (Object)minDate);
                historyFilter.and("querydate", "<", (Object)queryDate);
                historyFilter.and("isupdate", "=", (Object)Boolean.FALSE);
                Object[] historyVersions = TmcDataServiceHelper.load((String)"tda_decisanlsversion", (String)"id,number,orgview,org,versionstate,begintime,endtime,querydate", (QFilter[])historyFilter.toArray());
                if (EmptyUtil.isNoEmpty((Object[])historyVersions)) {
                    for (Object historyVersion : historyVersions) {
                        hisVersionMap.put(historyVersion.getDate("querydate"), historyVersion.getString("number"));
                    }
                }
                count = this.recalccount(schedules, qing_count, common_count, hisVersionMap, queryDate);
            }
            logger.info(batch + "\u7248\u672c\u9700\u8981\u5206\u6279\u8c03\u5ea6\u6b21\u6570 \uff1a" + count);
            this.updateTotalExecuteCount(batch, count);
            Long orgViewId = version.getDynamicObject("orgview").getLong("id");
            for (DynamicObject schedule : schedules.values()) {
                logger.info("\u5f00\u59cb\u6267\u884c\u5feb\u7167\u8c03\u5ea6\u670d\u52a1\uff0c\u8c03\u5ea6\u62a5\u8868\u7c7b\u578b \uff1a " + schedule.getString("reporttype"));
                if ("qing".equals(schedule.getString("reporttype"))) {
                    if (!EmptyUtil.isNoEmpty(subOrgIds)) continue;
                    this.runSnapSchedule(orgViewId, subOrgIds, schedule, batch, orgBatchSize, ishistory, hisVersionMap);
                    continue;
                }
                if (!EmptyUtil.isNoEmpty(secOrgIds)) continue;
                this.runSnapSchedule(orgViewId, secOrgIds, schedule, batch, orgBatchSize, ishistory, hisVersionMap);
            }
        }
        catch (Exception e) {
            logger.info("\u5feb\u7167\u8c03\u5ea6\u670d\u52a1\u5931\u8d25\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
        }
    }

    private int recalccount(Map<Object, DynamicObject> schedules, int qincount, int commoncount, Map<Date, String> historyVersions, Date queryDate) {
        int count = 0;
        for (DynamicObject schedule : schedules.values()) {
            int cycle = schedule.getInt("cycle");
            for (int i = 1; i <= cycle; ++i) {
                Date newLastDate = DateUtils.getLastDay((Date)queryDate, (int)i);
                if (!EmptyUtil.isNoEmpty((String)historyVersions.get(newLastDate))) continue;
                if ("qing".equals(schedule.getString("reporttype"))) {
                    count += qincount;
                    continue;
                }
                count += commoncount;
            }
        }
        return count;
    }

    private List<Long> getQingSnapScheduleOrgsList(DynamicObject version) {
        Long orgViewId = version.getDynamicObject("orgview").getLong("id");
        String orgViewNumber = version.getDynamicObject("orgview").getString("number");
        Long rootOrgId = version.getDynamicObject("org").getLong("id");
        List<Long> subOrgIds = new ArrayList<Long>();
        subOrgIds.add(rootOrgId);
        int orgLevel = this.getOrgSnapLevel();
        if (orgLevel == 0) {
            subOrgIds = TmcOrgDataHelper.getAllSubordinateOrgsForCache((Long)orgViewId, subOrgIds, (boolean)true, (boolean)false);
            logger.info("\u83b7\u53d6\u5168\u90e8\u7ec4\u7ec7\u6570\u91cf \uff1a " + subOrgIds.size());
        } else {
            for (int index = 2; index <= orgLevel; ++index) {
                List levelOrgs = OrgUnitServiceHelper.getOrgByLevel((String)orgViewNumber, (int)index, (boolean)false, (boolean)false);
                logger.info("\u83b7\u53d6\u7b2c" + index + "\u7ea7\u6b21\uff0c\u7ec4\u7ec7\u6570\u91cf \uff1a " + levelOrgs.size());
                subOrgIds.addAll(levelOrgs);
            }
        }
        String batch = version.getString("number");
        logger.info(batch + ":\u8dd1\u8f7b\u5206\u6790\u62a5\u8868\u8c03\u5ea6\uff0c\u7ec4\u7ec7\u6570\u91cf \uff1a " + subOrgIds.size());
        return subOrgIds;
    }

    private List<Long> getCommonSnapScheduleOrgsList(DynamicObject version) {
        Long rootOrgId;
        Long orgViewId = version.getDynamicObject("orgview").getLong("id");
        List<Long> secOrgIds = TmcOrgDataHelper.getSecondOrgIdsForCache((Long)orgViewId, (Long)(rootOrgId = Long.valueOf(version.getDynamicObject("org").getLong("id"))), (boolean)false);
        if (EmptyUtil.isEmpty((Collection)secOrgIds)) {
            secOrgIds = Collections.singletonList(rootOrgId);
        }
        String batch = version.getString("number");
        logger.info(batch + ":\u8dd1\u666e\u901a\u62a5\u8868\u8c03\u5ea6\uff0c\u7ec4\u7ec7\u6570\u91cf \uff1a " + secOrgIds.size());
        return secOrgIds;
    }

    private void runSnapSchedule(Long orgViewId, List<Long> orgIds, DynamicObject schedule, String batch, int orgBatchSize, boolean ishistory, Map<Date, String> hisVersionMap) {
        List orgBatchList = Lists.partition(orgIds, (int)orgBatchSize);
        for (int index = 0; index < orgBatchList.size(); ++index) {
            try {
                List orgList = (List)orgBatchList.get(index);
                logger.info("\u6267\u884c\u7b2c" + index + "\u7ec4\u6570\u636e\uff0c\u7ec4\u7ec7id\u6709" + JSON.toJSONString((Object)orgList));
                Date queryDate = DateUtils.getCurrentDate();
                if (!ishistory) {
                    this.snapSchedule(orgViewId, orgList, schedule, batch, queryDate, index, batch, ishistory);
                } else {
                    int cycle = schedule.getInt("cycle");
                    for (int k = 1; k <= cycle; ++k) {
                        Date newQueryDate = DateUtils.getLastDay((Date)queryDate, (int)k);
                        String historyBatch = hisVersionMap.get(newQueryDate);
                        if (!EmptyUtil.isNoEmpty((String)historyBatch)) continue;
                        this.deleteHistoryDataSet(historyBatch, schedule);
                        this.snapSchedule(orgViewId, orgList, schedule, historyBatch, newQueryDate, index, batch, ishistory);
                    }
                }
            }
            catch (Exception e) {
                logger.info(index + "\u7ec4\u7ebf\u7a0b\u6c60\u6267\u884c\u5f02\u5e38\uff1a" + ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                throw new KDBizException(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            logger.info(index + "\u7ec4\u6570\u636e\u6267\u884c\u5b8c\u6210\uff0c\u8be5\u7ec4\u6709" + orgBatchList.size() + " \u4e2a\u4efb\u52a1");
        }
    }

    private void deleteHistoryDataSet(String historyBatch, DynamicObject schedule) {
        DynamicObjectCollection scheduleJobs = schedule.getDynamicObjectCollection("snapschedule");
        HashSet<Long> formIdSet = new HashSet<Long>(16);
        for (DynamicObject scheduleJob : scheduleJobs) {
            formIdSet.add(scheduleJob.getLong("fbasedataid_id"));
        }
        QFilter fi = new QFilter("id", "in", formIdSet);
        fi.and(new QFilter("enable", "=", (Object)true));
        Map snapSchedules = TmcDataServiceHelper.loadFromCache((String)"fcs_snapschedule", (String)"reportform", (QFilter[])fi.toArray());
        QFilter deleteFilter = new QFilter("number", "=", (Object)historyBatch);
        deleteFilter.and("formid", "in", snapSchedules.values().stream().map(r -> r.getDynamicObject("reportform").getString("id")).collect(Collectors.toSet()));
        DeleteServiceHelper.delete((String)"fcs_datasnap", (QFilter[])deleteFilter.toArray());
    }

    private void updateTotalExecuteCount(String batch, int count) {
        String sSQL = "Update T_Tda_DecisAnlsVersion Set FTotalExecCount = ? Where Fnumber = ?";
        TmcDataServiceHelper.execute((DBRoute)DBRouteConst.TMC, (String)sSQL, (Object[])new Object[]{count, batch});
    }

    private int getOrgBatchSize() {
        int orgBatchCount = (Integer)SysParamHelper.getSysParamValue((String)"orgbatchcount", Integer.class);
        logger.info("\u7ec4\u7ec7\u5206\u6279\u6570\uff1a" + orgBatchCount);
        return orgBatchCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snapSchedule(Long orgViewId, List<Long> orgList, DynamicObject schedule, String batch, Date queryDate, int index, String updateStatusBatch, boolean ishistory) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("type", "dataSnap");
        paramMap.put("orgViewId", orgViewId);
        paramMap.put("orgList", orgList);
        paramMap.put("schedule", schedule.getPkValue());
        paramMap.put("batch", batch);
        paramMap.put("index", index);
        paramMap.put("queryDate", queryDate);
        paramMap.put("updateStatusBatch", updateStatusBatch);
        paramMap.put("ishistory", ishistory);
        try (MessagePublisher pub = MQFactory.get().createSimplePublisher("tmc", "tda.snapschedule");){
            logger.info("------snapSchedule MQ Message Send------");
            pub.publish(paramMap);
        }
    }

    private int getOrgSnapLevel() {
        int orgLevel = (Integer)SysParamHelper.getSysParamValue((String)"snaplevel", Integer.class);
        logger.info("\u7ec4\u7ec7\u7ea7\u6b21\u6570\uff1a" + orgLevel);
        return orgLevel;
    }
}

