/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.service;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.SettleTagEnum;

public class BizBillWriteBackExchangeBillService {
    public static final String[] BIZ_BILL_PROPS = new String[]{"id", "billstatus", "tradebill", "operate", "bizamt1", "bizamt2", "recbillno", "paybillno", "exchangebillno"};
    private static final Log logger = LogFactory.getLog(BizBillWriteBackExchangeBillService.class);

    public void execute(Object params) {
        String operate;
        List disposeData = (List)params;
        Map applyMap = (Map)disposeData.get(0);
        switch (operate = applyMap.get("operate").toString()) {
            case "saveValidate": 
            case "submitValidate": {
                logger.info("\u5916\u5e01\u5151\u6362\u5355\u201c" + operate + "\u201c\u64cd\u4f5c\u8c03\u7528\u201d\u91d1\u878d\u4ea4\u6613\u751f\u547d\u5468\u671f\u5904\u7406\u201c\u53cd\u5199\u670d\u52a1 start");
                this.repeatValidate(applyMap);
                this.amountValidate(applyMap);
                logger.info("\u5916\u5e01\u5151\u6362\u5355\u201c" + operate + "\u201c\u64cd\u4f5c\u8c03\u7528\u201d\u91d1\u878d\u4ea4\u6613\u751f\u547d\u5468\u671f\u5904\u7406\u201c\u53cd\u5199\u670d\u52a1 end");
                break;
            }
            case "exchangeValidate": {
                logger.info("\u5916\u5e01\u5151\u6362\u5355\u201cexchangeValidate\u201c\u64cd\u4f5c\u8c03\u7528\u201d\u91d1\u878d\u4ea4\u6613\u751f\u547d\u5468\u671f\u5904\u7406\u201c\u53cd\u5199\u670d\u52a1 start");
                this.amountValidate(applyMap);
                logger.info("\u5916\u5e01\u5151\u6362\u5355\u201cexchangeValidate\u201c\u64cd\u4f5c\u8c03\u7528\u201d\u91d1\u878d\u4ea4\u6613\u751f\u547d\u5468\u671f\u5904\u7406\u201c\u53cd\u5199\u670d\u52a1 end");
                break;
            }
            case "exchange": {
                logger.info("\u5916\u5e01\u5151\u6362\u5355\u201cexchange\u201c\u64cd\u4f5c\u8c03\u7528\u201d\u91d1\u878d\u4ea4\u6613\u751f\u547d\u5468\u671f\u5904\u7406\u201c\u53cd\u5199\u670d\u52a1 start");
                this.exchange(applyMap);
                logger.info("\u5916\u5e01\u5151\u6362\u5355\u201cexchange\u201c\u64cd\u4f5c\u8c03\u7528\u201d\u91d1\u878d\u4ea4\u6613\u751f\u547d\u5468\u671f\u5904\u7406\u201c\u53cd\u5199\u670d\u52a1 end");
                break;
            }
            case "cancelexchange": {
                logger.info("\u5916\u5e01\u5151\u6362\u5355\u201ccancelexchange\u201c\u64cd\u4f5c\u8c03\u7528\u201d\u91d1\u878d\u4ea4\u6613\u751f\u547d\u5468\u671f\u5904\u7406\u201c\u53cd\u5199\u670d\u52a1 start");
                this.cancelExchange(applyMap);
                logger.info("\u5916\u5e01\u5151\u6362\u5355\u201ccancelexchange\u201c\u64cd\u4f5c\u8c03\u7528\u201d\u91d1\u878d\u4ea4\u6613\u751f\u547d\u5468\u671f\u5904\u7406\u201c\u53cd\u5199\u670d\u52a1 end");
            }
        }
    }

    private void repeatValidate(Map<String, Object> applyMap) {
        DynamicObject info = (DynamicObject)applyMap.get("info");
        if (info == null) {
            return;
        }
        Long sourcebillid = info.getLong("sourcebillid");
        Long targetId = info.getLong("id");
        Map botpMap = BFTrackerServiceHelper.findTargetBills((String)"tm_businessbill", (Long[])new Long[]{sourcebillid});
        HashSet paybills = null;
        HashSet exchangebills = null;
        if (botpMap.containsKey("cas_paybill")) {
            paybills = (HashSet)botpMap.get("cas_paybill");
            QFilter qFilter = new QFilter("id", "in", (Object)paybills);
            DynamicObjectCollection paybillDbs = QueryServiceHelper.query((String)"cas_paybill", (String)"id,sourcebillid,settletag", (QFilter[])qFilter.toArray());
            for (DynamicObject paybill : paybillDbs) {
                String settleTag = paybill.getString("settletag");
                if (EmptyUtil.isEmpty((String)settleTag) || SettleTagEnum.NON_PL.getValue().equals(settleTag)) continue;
                long payId = paybill.getLong("id");
                paybills.remove(payId);
            }
        }
        if (botpMap.containsKey("cas_exchangebill")) {
            exchangebills = (HashSet)botpMap.get("cas_exchangebill");
            exchangebills.remove(targetId);
        }
        if (EmptyUtil.isNoEmpty(exchangebills)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u5916\u5e01\u5151\u6362\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"BizBillWriteBackExchangeBillService_3", (String)"tmc-tm-mservice", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((Object)paybills)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u5916\u5e01\u5151\u6362\u5355\u3002", (String)"BizBillWriteBackExchangeBillService_4", (String)"tmc-tm-mservice", (Object[])new Object[0]));
        }
    }

    private void amountValidate(Map<String, Object> applyMap) {
        DynamicObject sellCurrency;
        DynamicObject buyCurrency;
        BigDecimal sellAmount;
        BigDecimal buyAmount;
        BigDecimal exchangeSellAmount;
        BigDecimal exchangeBuyAmount;
        logger.info("\u5916\u5e01\u5151\u6362\u5355\u9632\u8d85\u989d\u6821\u9a8c start");
        if (applyMap.get("info") != null && EmptyUtil.isNoEmpty((Object)((DynamicObject)applyMap.get("info")).get("buyamount"))) {
            exchangeBuyAmount = ((DynamicObject)applyMap.get("info")).getBigDecimal("buyamount");
            exchangeSellAmount = ((DynamicObject)applyMap.get("info")).getBigDecimal("sellamount");
        } else {
            exchangeBuyAmount = (BigDecimal)applyMap.get("buyamount");
            exchangeSellAmount = (BigDecimal)applyMap.get("sellamount");
        }
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exchangeBuyAmount, exchangeSellAmount})) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5916\u5e01\u5151\u6362\u5355\u53cd\u5199\u751f\u547d\u5468\u671f\u64cd\u4f5c\u5355\u65f6\uff0c\u672a\u4f20\u5165\u5916\u5e01\u5151\u6362\u5355\u7684\u4e70\u5165\u91d1\u989d\u548c\u5356\u51fa\u91d1\u989d\u3002", (String)"BizBillWriteBackExchangeBillService_0", (String)"tmc-tm-mservice", (Object[])new Object[0]));
        }
        logger.info("exchangeBuyAmount={}, exchangeSellAmount={}", new Object[]{exchangeBuyAmount, exchangeSellAmount});
        DynamicObject bizBill = this.getSourBill(applyMap);
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        DynamicObject protectType = tradeBill.getDynamicObject("protecttype");
        String protectId = protectType.getString("id");
        if (ProductTypeEnum.SWAP.getId().equals(protectId)) {
            buyAmount = bizBill.getBigDecimal("bizamt2");
            sellAmount = bizBill.getBigDecimal("bizamt1");
            buyCurrency = tradeBill.getDynamicObject("reccurrency");
            sellCurrency = tradeBill.getDynamicObject("currency");
        } else {
            String op = bizBill.getString("operate");
            boolean flag = true;
            String tradeType = tradeBill.getString("tradetype");
            String dir = tradeBill.getString("tradedirect");
            if (ProductTypeEnum.FOREXOPTION.getId().equals(protectId)) {
                if (OptionsTradeTypeEnum.call.getValue().equals(tradeType) && TradeDirectionEnum.sell.getValue().equals(dir) || OptionsTradeTypeEnum.put.getValue().equals(tradeType) && TradeDirectionEnum.buy.getValue().equals(dir)) {
                    flag = false;
                }
            } else if (op.indexOf("_f") < 0 && "sell".equals(dir) || op.indexOf("_f") > 0 && "buy".equals(dir)) {
                flag = false;
            }
            if (flag) {
                buyAmount = bizBill.getBigDecimal("bizamt1");
                sellAmount = bizBill.getBigDecimal("bizamt2");
                buyCurrency = tradeBill.getDynamicObject("currency");
                sellCurrency = tradeBill.getDynamicObject("sellcurrency");
            } else {
                buyAmount = bizBill.getBigDecimal("bizamt2");
                sellAmount = bizBill.getBigDecimal("bizamt1");
                buyCurrency = tradeBill.getDynamicObject("sellcurrency");
                sellCurrency = tradeBill.getDynamicObject("currency");
            }
        }
        DynamicObject buyingCurrency = ((DynamicObject)applyMap.get("info")).getDynamicObject("buyingcurrency");
        DynamicObject sellingCurrency = ((DynamicObject)applyMap.get("info")).getDynamicObject("sellingcurrency");
        if (buyCurrency.getLong("id") != buyingCurrency.getLong("id")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e70\u5165\u5e01\u79cd\u9700\u8981\u548c\u4e0a\u6e38\u751f\u547d\u5468\u671f\u5355\u4fdd\u6301\u4e00\u81f4\u3002", (String)"BizBillWriteBackExchangeBillService_5", (String)"tmc-tm-mservice", (Object[])new Object[0]));
        }
        if (sellCurrency.getLong("id") != sellingCurrency.getLong("id")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5356\u51fa\u5e01\u79cd\u9700\u8981\u548c\u4e0a\u6e38\u751f\u547d\u5468\u671f\u5355\u4fdd\u6301\u4e00\u81f4\u3002", (String)"BizBillWriteBackExchangeBillService_6", (String)"tmc-tm-mservice", (Object[])new Object[0]));
        }
        int buyAmtPrecision = buyCurrency.getInt("amtprecision");
        buyAmount = buyAmount.setScale(buyAmtPrecision, 4);
        int sellAmtPrecision = sellCurrency.getInt("amtprecision");
        sellAmount = sellAmount.setScale(sellAmtPrecision, 4);
        logger.info("buyAmount={}, sellAmount={}", new Object[]{buyAmount, sellAmount});
        if (exchangeBuyAmount.compareTo(buyAmount) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e70\u5165\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4e0a\u6e38\u751f\u547d\u5468\u671f\u5355\u91d1\u989d\u3002", (String)"BizBillWriteBackExchangeBillService_1", (String)"tmc-tm-mservice", (Object[])new Object[0]));
        }
        if (exchangeSellAmount.compareTo(sellAmount) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5356\u51fa\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4e0a\u6e38\u751f\u547d\u5468\u671f\u5355\u91d1\u989d\u3002", (String)"BizBillWriteBackExchangeBillService_2", (String)"tmc-tm-mservice", (Object[])new Object[0]));
        }
        logger.info("\u5916\u5e01\u5151\u6362\u5355\u9632\u8d85\u989d\u6821\u9a8c end");
    }

    private void exchange(Map<String, Object> applyMap) {
        DynamicObject sourBill = this.getSourBill(applyMap);
        if (EmptyUtil.isNoEmpty((DynamicObject)sourBill)) {
            String payBillNo;
            boolean canUpdate = true;
            String recBillNo = sourBill.getString("recbillno");
            if (EmptyUtil.isNoEmpty((String)recBillNo)) {
                QFilter recFilter = new QFilter("billstatus", "!=", (Object)"D");
                if (recBillNo.contains(",")) {
                    List recBillNos = Arrays.stream(recBillNo.split(",")).collect(Collectors.toList());
                    recFilter.and("billno", "in", recBillNos);
                } else {
                    recFilter.and("billno", "=", (Object)recBillNo);
                }
                boolean isRec = TmcDataServiceHelper.exists((String)"cas_recbill", (QFilter[])recFilter.toArray());
                if (isRec) {
                    logger.info("\u5b58\u5728\u5355\u636e\u72b6\u6001\u975e\u5df2\u6536\u6b3e\u7684\u6536\u6b3e\u5355\uff0c\u4e0d\u66f4\u65b0\u751f\u547d\u5468\u671f\u64cd\u4f5c\u5355\u72b6\u6001");
                    canUpdate = false;
                }
            }
            if (EmptyUtil.isNoEmpty((String)(payBillNo = sourBill.getString("paybillno"))) && canUpdate) {
                QFilter payFilter = new QFilter("billstatus", "!=", (Object)"D");
                if (payBillNo.contains(",")) {
                    List payBillNos = Arrays.stream(payBillNo.split(",")).collect(Collectors.toList());
                    payFilter.and("billno", "in", payBillNos);
                } else {
                    payFilter.and("billno", "=", (Object)payBillNo);
                }
                boolean isPay = TmcDataServiceHelper.exists((String)"cas_paybill", (QFilter[])payFilter.toArray());
                if (isPay) {
                    logger.info("\u5b58\u5728\u5355\u636e\u72b6\u6001\u975e\u5df2\u4ed8\u6b3e\u7684\u4ed8\u6b3e\u5355\uff0c\u4e0d\u66f4\u65b0\u751f\u547d\u5468\u671f\u64cd\u4f5c\u5355\u72b6\u6001");
                    canUpdate = false;
                }
            }
            if (canUpdate) {
                sourBill.set("billstatus", (Object)TcBillStatusEnum.SETTLE_DONE.getValue());
                this.saveSourBill(sourBill);
            }
        }
    }

    private void cancelExchange(Map<String, Object> applyMap) {
        DynamicObject sourBill = this.getSourBill(applyMap);
        if (EmptyUtil.isNoEmpty((DynamicObject)sourBill)) {
            sourBill.set("billstatus", (Object)TcBillStatusEnum.SETTLE_ING.getValue());
            this.saveSourBill(sourBill);
        }
    }

    private DynamicObject getSourBill(Map<String, Object> applyMap) {
        Long sourId = null;
        if (applyMap.get("info") != null && ((DynamicObject)applyMap.get("info")).get("sourcebillid") != null) {
            sourId = ((DynamicObject)applyMap.get("info")).getLong("sourcebillid");
            logger.info("applyMap.info.sourceBillId={}", (Object)sourId);
        }
        if (EmptyUtil.isEmpty(sourId)) {
            Long targetpk = (Long)applyMap.get("targetpk");
            Object[] sourceBillIds = TmcBotpHelper.getSourceBillIds((String)"cas_exchangebill", (Object)targetpk, (String)"tm_businessbill");
            sourId = EmptyUtil.isNoEmpty((Object[])sourceBillIds) ? (Long)sourceBillIds[0] : 0L;
            logger.info("\u901a\u8fc7BOTP\u5173\u8054\u5173\u7cfb\u83b7\u53d6sourceBillId\uff0cexChangeBillId={}\uff0csourceBillId={}", new Object[]{targetpk, sourId});
        }
        QFilter qFilter = new QFilter("id", "=", sourId);
        return TmcDataServiceHelper.loadSingle((String)"tm_businessbill", (String)String.join((CharSequence)",", BIZ_BILL_PROPS), (QFilter[])qFilter.toArray());
    }

    private void saveSourBill(DynamicObject sourBill) {
        try (TXHandle h = TX.requiresNew();){
            try {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sourBill});
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }
}

