/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.tm.common.enums.SwapExchangeType;
import kd.tmc.tm.common.enums.SwapTypeEnum;

public class RateSwapExchangeBillWriteBackService {
    private static final String TMC_TM_MSERVICE = "tmc-tm-mservice";

    public void execute(List<Map<String, Object>> params) {
        String operate;
        Map<String, Object> applyMap = params.get(0);
        switch (operate = (String)applyMap.get("operate")) {
            case "saveValidate": 
            case "submitValidate": {
                DynamicObject bill = this.getBill(applyMap);
                if (bill != null) {
                    this.validateSwapConditionsOfSettle(bill);
                    this.validateAmtAndCurr(applyMap, bill);
                }
                this.validateRepeatedPushExchangeBill(applyMap);
                break;
            }
            case "exchangeValidate": {
                this.validateAmtAndCurr(applyMap, this.getBill(applyMap));
            }
        }
    }

    private DynamicObject getBill(Map<String, Object> applyMap) {
        DynamicObject info = (DynamicObject)applyMap.get("info");
        if (info == null) {
            return null;
        }
        Long sourcebillid = info.getLong("sourcebillid");
        return TmcDataServiceHelper.loadSingle((Object)sourcebillid, (String)"tm_rateswap", (String)"id,billno,initexamount,recinitexamount,currency,reccurrency,bizdate,paybillno,lockpayamt,billstatus,rateswaptype,initpriextype,isbuysettle");
    }

    private void validateAmtAndCurr(Map<String, Object> applyMap, DynamicObject rateSwap) {
        DynamicObject info = (DynamicObject)applyMap.get("info");
        if (info == null || rateSwap == null) {
            return;
        }
        DynamicObject buyingcurrency = info.getDynamicObject("buyingcurrency");
        DynamicObject sellingcurrency = info.getDynamicObject("sellingcurrency");
        BigDecimal buyamount = info.getBigDecimal("buyamount");
        BigDecimal sellamount = info.getBigDecimal("sellamount");
        DynamicObject currency = rateSwap.getDynamicObject("currency");
        DynamicObject reccurrency = rateSwap.getDynamicObject("reccurrency");
        BigDecimal initexamount = rateSwap.getBigDecimal("initexamount");
        BigDecimal recinitexamount = rateSwap.getBigDecimal("recinitexamount");
        int amtprecision = currency.getInt("amtprecision");
        initexamount = initexamount.setScale(amtprecision, RoundingMode.HALF_UP).abs();
        int recamtprecision = reccurrency.getInt("amtprecision");
        recinitexamount = recinitexamount.setScale(recamtprecision, RoundingMode.HALF_UP).abs();
        String sourceBillNo = rateSwap.getString("billno");
        StringBuilder sb = new StringBuilder();
        if (buyingcurrency.getLong("id") != currency.getLong("id")) {
            this.appendEnter(sb);
            sb.append(String.format(ResManager.loadKDString((String)"\u5916\u5e01\u5151\u6362\u5355\u7684\u4e70\u5165\u5e01\u79cd\u4e0d\u7b49\u4e8e\u4e92\u6362\u5355\u636e%1$s\u7684\u6536\u53d6\u5e01\u79cd\u3002", (String)"RateSwapExchangeBillWriteBackService_01", (String)TMC_TM_MSERVICE, (Object[])new Object[0]), sourceBillNo));
        }
        if (sellingcurrency.getLong("id") != reccurrency.getLong("id")) {
            this.appendEnter(sb);
            sb.append(String.format(ResManager.loadKDString((String)"\u5916\u5e01\u5151\u6362\u5355\u7684\u5356\u51fa\u5e01\u79cd\u4e0d\u7b49\u4e8e\u4e92\u6362\u5355\u636e%1$s\u7684\u652f\u4ed8\u5e01\u79cd\u3002", (String)"RateSwapExchangeBillWriteBackService_02", (String)TMC_TM_MSERVICE, (Object[])new Object[0]), sourceBillNo));
        }
        if (buyamount.compareTo(initexamount) > 0) {
            this.appendEnter(sb);
            sb.append(String.format(ResManager.loadKDString((String)"\u4e70\u5165\u91d1\u989d%1$s\u8d85\u8fc7\u4e92\u6362\u5355\u636e%2$s\u53ef\u6536\u53d6\u91d1\u989d%3$s\u3002", (String)"RateSwapExchangeBillWriteBackService_03", (String)TMC_TM_MSERVICE, (Object[])new Object[0]), buyamount, sourceBillNo, initexamount));
        }
        if (sellamount.compareTo(recinitexamount) > 0) {
            this.appendEnter(sb);
            sb.append(String.format(ResManager.loadKDString((String)"\u5356\u51fa\u91d1\u989d%1$s\u8d85\u8fc7\u4e92\u6362\u5355\u636e%2$s\u53ef\u652f\u4ed8\u91d1\u989d%3$s\u3002", (String)"RateSwapExchangeBillWriteBackService_04", (String)TMC_TM_MSERVICE, (Object[])new Object[0]), sellamount, sourceBillNo, recinitexamount));
        }
        if (sb.length() > 0) {
            throw new KDBizException(sb.toString());
        }
    }

    private void validateRepeatedPushExchangeBill(Map<String, Object> applyMap) {
        DynamicObject info = (DynamicObject)applyMap.get("info");
        if (info == null) {
            return;
        }
        long sourcebillid = info.getLong("sourcebillid");
        Long targetId = info.getLong("id");
        Long payBillTableId = TmcBotpHelper.getTableIdByEntityKey((String)"cas_paybill");
        Long recBillTableId = TmcBotpHelper.getTableIdByEntityKey((String)"cas_recbill");
        Long exchangeBillTableId = TmcBotpHelper.getTableIdByEntityKey((String)"cas_exchangebill");
        Map dirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)"tm_rateswap", (Long[])new Long[]{sourcebillid});
        if (dirtTargetBills != null && !CollectionUtils.isEmpty((Map)dirtTargetBills)) {
            List bfRows = (List)dirtTargetBills.get(sourcebillid);
            for (BFRow bfRow : bfRows) {
                Long exchangeBillId;
                BFRowId tRow = bfRow.getId();
                if (Objects.equals(tRow.getMainTableId(), payBillTableId)) {
                    Long paybillId = tRow.getBillId();
                    if (Objects.equals(paybillId, targetId)) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u6536\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u5916\u5e01\u5151\u6362\u5355\u3002", (String)"RateSwapGenExchangeBillOpValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
                if (Objects.equals(tRow.getMainTableId(), recBillTableId)) {
                    Long recbillId = tRow.getBillId();
                    if (Objects.equals(recbillId, targetId)) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u6536\u4ed8\u6b3e\u5355\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u5916\u5e01\u5151\u6362\u5355\u3002", (String)"RateSwapGenExchangeBillOpValidator_1", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
                if (!Objects.equals(tRow.getMainTableId(), exchangeBillTableId) || Objects.equals(exchangeBillId = tRow.getBillId(), targetId)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u6e38\u5df2\u7ecf\u5b58\u5728\u5916\u5e01\u5151\u6362\u5355\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u751f\u6210\u3002", (String)"RateSwapGenExchangeBillOpValidator_0", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
    }

    private void validateSwapConditionsOfSettle(DynamicObject sourceBill) {
        String swapType = sourceBill.getString("rateswaptype");
        String initPriExType = sourceBill.getString("initpriextype");
        if (!SwapTypeEnum.currency.getValue().equals(swapType) || !SwapExchangeType.Actual.getValue().equals(initPriExType)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u5bf9\u671f\u521d\u672c\u91d1\u4ea4\u6362\u4e3a\u5b9e\u9645\u672c\u91d1\u7684\u8d27\u5e01\u4e92\u6362\u5355\u636e\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractRecOrPayOpValidator_3", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    private void appendEnter(StringBuilder sb) {
        if (sb != null && sb.length() > 0) {
            sb.append("\n");
        }
    }
}

