/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.tmc.fbp.common.helper.WorkCalendarHelper;
import kd.tmc.tm.common.enums.AccrualExDivMethodEnum;

public class BondIssueBizHelper {
    public static Date getAccrualExDivDate(DynamicObject bondIssueBill, Date CouponDate) {
        AccrualExDivMethodEnum method = AccrualExDivMethodEnum.valueOf(bondIssueBill.getString("accrualexdivmethod"));
        int exDivDay = bondIssueBill.getInt("exdivdays");
        String daysType = bondIssueBill.getString("daystype");
        DynamicObjectCollection workCalendars = bondIssueBill.getDynamicObjectCollection("calendars");
        Calendar exDivDate = Calendar.getInstance();
        exDivDate.setTime(CouponDate);
        int day = exDivDate.get(5);
        switch (method) {
            case None: {
                return null;
            }
            case CouponMonthFirstDay: {
                exDivDate.set(5, 1);
                break;
            }
            case LastMonthEndDay: {
                exDivDate.set(5, 1);
                exDivDate.add(5, -1);
                break;
            }
            case LastMonth: {
                exDivDate.add(2, -1);
                break;
            }
            case AusDomestic: {
                exDivDate.add(5, -7);
                break;
            }
            case Bund: {
                if (day >= 3 && day <= 16) {
                    exDivDate.set(5, 1);
                    break;
                }
                exDivDate.set(5, 15);
                break;
            }
            case CouponMonth: {
                if (exDivDay >= day) break;
                exDivDate.set(5, exDivDay);
                break;
            }
            case BeforeDay: {
                if (daysType.equals("workday")) {
                    exDivDate.setTime(WorkCalendarHelper.getLastWorkDate((DynamicObjectCollection)workCalendars, (Date)exDivDate.getTime(), (int)exDivDay));
                    break;
                }
                exDivDate.add(5, -exDivDay);
                break;
            }
            case Gilt: {
                exDivDate.add(5, -37);
                break;
            }
            case IrishGilt: {
                exDivDate.add(5, -21);
            }
        }
        return exDivDate.getTime();
    }
}

