/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;

public class ForexHelper {
    public static Set<Long> getExCurrency(Long orgId) {
        DynamicObject exCurrency = BusinessDataServiceHelper.loadSingle((String)"tbd_excurrency", (String)"excurrency", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId).and("enable", "=", (Object)true)});
        if (EmptyUtil.isEmpty((DynamicObject)exCurrency)) {
            return null;
        }
        HashSet<Long> idSet = new HashSet<Long>(8);
        DynamicObjectCollection rows = (DynamicObjectCollection)exCurrency.get("excurrency");
        for (DynamicObject row : rows) {
            DynamicObject baseDataObj = row.getDynamicObject("fbasedataid");
            Long baseDataId = (Long)baseDataObj.getPkValue();
            idSet.add(baseDataId);
        }
        return idSet;
    }

    public static BigDecimal exchangeAmount(DynamicObject currency, BigDecimal amount, String forexQuote, BigDecimal exRate) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{currency, amount, forexQuote, exRate})) {
            return amount;
        }
        String settleCurrencyNumber = currency.getString("number");
        if (EmptyUtil.isEmpty((String)settleCurrencyNumber)) {
            return amount;
        }
        if ((forexQuote = forexQuote.trim()).startsWith(settleCurrencyNumber)) {
            amount = amount.multiply(exRate);
        }
        if (forexQuote.endsWith(settleCurrencyNumber)) {
            amount = amount.divide(exRate, 10, 4);
        }
        return amount;
    }

    public static DynamicObject getDefaultPlCurrency(DynamicObject bizBill) {
        String protectType = bizBill.getDynamicObject("protecttype").getString("number");
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        String operate = bizBill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf(operate);
        switch (bizOp) {
            case expiredey: 
            case expiredey_n: 
            case expiredey_f: {
                if (ProductTypeEnum.FOREXFORWARD.getValue().equals(protectType)) {
                    if (DeliveryWayEnum.non_deliverable.getValue().equals(tradeBill.get("deliveryway"))) {
                        return tradeBill.getDynamicObject("settlecurrency");
                    }
                    return tradeBill.getDynamicObject("sellcurrency");
                }
                if (!ProductTypeEnum.FOREXSWAPS.getValue().equals(protectType)) break;
                return tradeBill.getDynamicObject("sellcurrency");
            }
            case flat: 
            case flat_n: 
            case flat_f: {
                if (ProductTypeEnum.FOREXFORWARD.getValue().equals(protectType)) {
                    if (DeliveryWayEnum.non_deliverable.getValue().equals(tradeBill.get("deliveryway"))) {
                        return tradeBill.getDynamicObject("settlecurrency");
                    }
                    return tradeBill.getDynamicObject("sellcurrency");
                }
                if (!ProductTypeEnum.FOREXSPOT.getValue().equals(protectType) && !ProductTypeEnum.FOREXSWAPS.getValue().equals(protectType)) break;
                return tradeBill.getDynamicObject("sellcurrency");
            }
            case bdelivery: 
            case bdelivery_n: 
            case bdelivery_f: {
                if (!ProductTypeEnum.FOREXFORWARD.getValue().equals(protectType) && !ProductTypeEnum.FOREXSWAPS.getValue().equals(protectType)) break;
                if (DeliveryWayEnum.non_deliverable.getValue().equals(tradeBill.get("deliveryway"))) {
                    return tradeBill.getDynamicObject("settlecurrency");
                }
                return tradeBill.getDynamicObject("sellcurrency");
            }
            case defer: 
            case maudate: 
            case defer_n: 
            case defer_f: 
            case maudate_n: 
            case maudate_f: {
                if (!ProductTypeEnum.FOREXFORWARD.getValue().equals(protectType) && !ProductTypeEnum.FOREXSWAPS.getValue().equals(protectType)) break;
                if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(bizBill.get("exratecalmtd"))) {
                    if (DeliveryWayEnum.non_deliverable.getValue().equals(tradeBill.get("deliveryway"))) {
                        return tradeBill.getDynamicObject("settlecurrency");
                    }
                    return tradeBill.getDynamicObject("sellcurrency");
                }
                return null;
            }
            case exercise: 
            case giveup: {
                if (!ProductTypeEnum.FOREXOPTION.getValue().equals(protectType)) break;
                return tradeBill.getDynamicObject("sellcurrency");
            }
        }
        return null;
    }

    public static void setBuyAmtAndSellAmtInfo(DynamicObject tradeBill) {
        String tradeDir = tradeBill.getString("tradedirect");
        if (EmptyUtil.isEmpty((String)tradeDir)) {
            return;
        }
        DynamicObject productType = tradeBill.getDynamicObject("protecttype");
        ProductTypeEnum productTypeEnum = ProductTypeEnum.getEnumById((String)String.valueOf(productType.getPkValue()));
        switch (productTypeEnum) {
            case FOREXSPOT: 
            case FOREXFORWARD: {
                if (TradeDirectionEnum.buy.getValue().equals(tradeDir)) {
                    tradeBill.set("buy_currency", tradeBill.get("currency"));
                    tradeBill.set("buy_amount", tradeBill.get("amount"));
                    tradeBill.set("sell_currency", tradeBill.get("sellcurrency"));
                    tradeBill.set("sell_amount", tradeBill.get("sellamount"));
                    break;
                }
                tradeBill.set("sell_currency", tradeBill.get("currency"));
                tradeBill.set("sell_amount", tradeBill.get("amount"));
                tradeBill.set("buy_currency", tradeBill.get("sellcurrency"));
                tradeBill.set("buy_amount", tradeBill.get("sellamount"));
                break;
            }
            case FOREXSWAPS: {
                if (TradeDirectionEnum.buy.getValue().equals(tradeDir)) {
                    tradeBill.set("buy_currency", tradeBill.get("currency"));
                    tradeBill.set("buy_amount", tradeBill.get("amount"));
                    tradeBill.set("sell_currency", tradeBill.get("sellcurrency"));
                    tradeBill.set("sell_amount", tradeBill.get("sellamount"));
                    tradeBill.set("far_buy_currency", tradeBill.get("sellcurrency"));
                    tradeBill.set("far_buy_amount", tradeBill.get("sellamount_far"));
                    tradeBill.set("far_sell_currency", tradeBill.get("currency"));
                    tradeBill.set("far_sell_amount", tradeBill.get("buyamount_far"));
                    break;
                }
                tradeBill.set("sell_currency", tradeBill.get("currency"));
                tradeBill.set("sell_amount", tradeBill.get("amount"));
                tradeBill.set("buy_currency", tradeBill.get("sellcurrency"));
                tradeBill.set("buy_amount", tradeBill.get("sellamount"));
                tradeBill.set("far_sell_currency", tradeBill.get("sellcurrency"));
                tradeBill.set("far_sell_amount", tradeBill.get("sellamount_far"));
                tradeBill.set("far_buy_currency", tradeBill.get("currency"));
                tradeBill.set("far_buy_amount", tradeBill.get("buyamount_far"));
                break;
            }
            case FOREXOPTION: {
                String tradeType = tradeBill.getString("tradetype");
                if (OptionsTradeTypeEnum.call.getValue().equals(tradeType) && TradeDirectionEnum.buy.getValue().equals(tradeDir) || OptionsTradeTypeEnum.put.getValue().equals(tradeType) && TradeDirectionEnum.sell.getValue().equals(tradeDir)) {
                    tradeBill.set("buy_currency", tradeBill.get("currency"));
                    tradeBill.set("buy_amount", tradeBill.get("amount"));
                    tradeBill.set("sell_currency", tradeBill.get("sellcurrency"));
                    tradeBill.set("sell_amount", tradeBill.get("sellamount"));
                    break;
                }
                tradeBill.set("sell_currency", tradeBill.get("currency"));
                tradeBill.set("sell_amount", tradeBill.get("amount"));
                tradeBill.set("buy_currency", tradeBill.get("sellcurrency"));
                tradeBill.set("buy_amount", tradeBill.get("sellamount"));
                break;
            }
        }
    }
}

