/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.model.ModelAgent;

public class ForexOptionsHelper {
    public static boolean callAndBuyORPutAndsell(String dir, String tradeType) {
        boolean result = OptionsTradeTypeEnum.call.getValue().equals(tradeType) && TradeDirectionEnum.buy.getValue().equals(dir) || OptionsTradeTypeEnum.put.getValue().equals(tradeType) && TradeDirectionEnum.sell.getValue().equals(dir);
        return result;
    }

    public static boolean callAndSellORPutAndBuy(String dir, String tradeType) {
        boolean result = OptionsTradeTypeEnum.call.getValue().equals(tradeType) && TradeDirectionEnum.sell.getValue().equals(dir) || OptionsTradeTypeEnum.put.getValue().equals(tradeType) && TradeDirectionEnum.buy.getValue().equals(dir);
        return result;
    }

    public static BigDecimal calAmountForwardDirection(BigDecimal subtractor, BigDecimal minuend, BigDecimal principal, ModelAgent model) {
        return subtractor.subtract(minuend).max(BigDecimal.ZERO).multiply(principal).multiply(BigDecimal.valueOf(ForexOptionsHelper.getFLagByTradeDirect(model)));
    }

    public static BigDecimal calAmountReverseDirection(BigDecimal subtractor, BigDecimal minuend, BigDecimal principal, ModelAgent model) {
        BigDecimal calSubtractor = BigDecimal.ZERO;
        if (subtractor.compareTo(BigDecimal.ZERO) > 0) {
            calSubtractor = BigDecimal.ONE.divide(subtractor, 10, 4);
        }
        BigDecimal calMinuend = BigDecimal.ZERO;
        if (minuend.compareTo(BigDecimal.ZERO) > 0) {
            calMinuend = BigDecimal.ONE.divide(minuend, 10, 4);
        }
        return calSubtractor.subtract(calMinuend).max(BigDecimal.ZERO).multiply(principal).multiply(BigDecimal.valueOf(ForexOptionsHelper.getFLagByTradeDirect(model)));
    }

    protected static double getFLagByTradeDirect(ModelAgent model) {
        String tradedirect = (String)model.getValue("tradedirect");
        return TradeDirectionEnum.sell.getValue().equals(tradedirect) ? -1.0 : 1.0;
    }
}

