/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;

public class ForwRateAgreeCFBizHelper {
    public static Map<Date, BigDecimal> getDFs(IFormView view, ModelAgent forwRateAgree, Date paydate, Date lastPaydate) {
        Date referdate = (Date)forwRateAgree.getValue("referdate");
        if (EmptyUtil.isEmpty((Object)referdate)) {
            referdate = TcDateUtils.getCurrentDate();
        }
        DynamicObject priceRule = (DynamicObject)forwRateAgree.getValue("pricerule");
        DynamicObject market = (DynamicObject)forwRateAgree.getValue("market");
        Date adjSettledate = (Date)forwRateAgree.getValue("adjustsettledate");
        Date adjEnddate = (Date)forwRateAgree.getValue("adjustenddate");
        Date[] queryList = new Date[]{adjSettledate, TcDateUtils.getLastDay((Date)adjSettledate, (int)1), adjEnddate, TcDateUtils.getLastDay((Date)adjEnddate, (int)1), paydate, lastPaydate};
        PriceRuleInfo info = MarketDataHelper.getDiscfactor((IFormView)view, (Date)referdate, (DynamicObject)priceRule, (Long[])new Long[]{market.getLong("id")}, (Date[])queryList);
        return info.getYieldCurve()[0].getDfMap();
    }

    public static BigDecimal getPayAmount(BigDecimal useRate, ModelAgent forwRateAgree) {
        String payRule = (String)forwRateAgree.getValue("payrule");
        String direct = (String)forwRateAgree.getValue("tradedirect");
        BigDecimal contractRate = (BigDecimal)forwRateAgree.getValue("contractrate");
        BigDecimal amount = (BigDecimal)forwRateAgree.getValue("amount");
        BasisEnum basis = BasisEnum.valueOf((String)((String)forwRateAgree.getValue("basis")));
        Object[] calendars = new DynamicObject[]{};
        DynamicObjectCollection workCalendars = (DynamicObjectCollection)forwRateAgree.getValue("indexcalendar");
        int periodDays = TradeBusinessHelper.getBasis_BetweenDay((Date)((Date)forwRateAgree.getValue("adjustsettledate")), (Date)((Date)forwRateAgree.getValue("adjustenddate")), (BasisEnum)basis, (DynamicObject[])((DynamicObject[])workCalendars.toArray(calendars)));
        BigDecimal hundred = new BigDecimal("100");
        BigDecimal payAmount = BigDecimal.ZERO;
        if (useRate == null) {
            return payAmount;
        }
        if (payRule.equals("advance")) {
            Date paydate = (Date)forwRateAgree.getValue("adjustsettledate");
            double yrbasis = TradeBusinessHelper.getBasis_YearDay((int)paydate.getYear(), (BasisEnum)basis);
            BigDecimal periodDays_div_yrbasis = new BigDecimal(periodDays).divide(new BigDecimal(String.valueOf(yrbasis)), 6, 4);
            payAmount = direct.equals("buy") ? amount.multiply(useRate.subtract(contractRate)).divide(hundred).multiply(periodDays_div_yrbasis).divide(BigDecimal.ONE.add(useRate.divide(hundred).multiply(periodDays_div_yrbasis)), 6, 4) : amount.multiply(contractRate.subtract(useRate)).divide(hundred).multiply(periodDays_div_yrbasis).divide(BigDecimal.ONE.add(useRate.divide(hundred).multiply(periodDays_div_yrbasis)), 6, 4);
        } else {
            Date paydate = (Date)forwRateAgree.getValue("adjustenddate");
            double yrbasis = TradeBusinessHelper.getBasis_YearDay((int)paydate.getYear(), (BasisEnum)basis);
            BigDecimal periodDays_div_yrbasis = new BigDecimal(periodDays).divide(new BigDecimal(String.valueOf(yrbasis)), 6, 4);
            payAmount = direct.equals("buy") ? amount.multiply(useRate.subtract(contractRate)).divide(hundred).multiply(periodDays_div_yrbasis) : amount.multiply(contractRate.subtract(useRate)).divide(hundred).multiply(periodDays_div_yrbasis);
        }
        return payAmount;
    }
}

