/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.tmc.fbp.common.bean.tc.FreqPeriodListBean;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.enums.ConfigPayTypeEnum;
import kd.tmc.tm.common.enums.QuotaFrequency;
import kd.tmc.tm.common.enums.RateSwapsPayTypeEnum;
import kd.tmc.tm.common.enums.RateTypeEnum;
import kd.tmc.tm.common.enums.SwapExchangeType;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.CashFlowDAOHelper;

public class RateSwapHelper {
    public static Map<String, Object> getCashFlowToRateCfg(Long rateSwapId) {
        DynamicObject[] cashflowCol;
        HashMap<String, Object> result = new HashMap<String, Object>();
        DynamicObject tradebill = TmcDataServiceHelper.loadSingle((String)"tm_rateswap", (String)"ratetype,recratetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)rateSwapId)});
        String rateType = tradebill.getString("ratetype");
        String recRateType = tradebill.getString("recratetype");
        QFilter filter = new QFilter("billid", "=", (Object)tradebill.getLong("id"));
        QFilter filter_buy = new QFilter("cfdirection", "=", (Object)"buy");
        QFilter filter_sell = new QFilter("cfdirection", "=", (Object)"sell");
        DynamicObject resetCashFlow_Buy = null;
        DynamicObject resetCashFlow_Sell = null;
        if (RateTypeEnum.rate_float.getValue().equals(rateType)) {
            cashflowCol = CashFlowDAOHelper.loadAsc("cftype,cfispay,entrys.cfisratecfg,entrys.cfratefixdate", new QFilter[]{filter, filter_buy});
            resetCashFlow_Buy = RateSwapHelper.findCashFlowNeedRateCfg(cashflowCol);
        }
        if (RateTypeEnum.rate_float.getValue().equals(recRateType)) {
            cashflowCol = CashFlowDAOHelper.loadAsc("cftype,cfispay,entrys.cfisratecfg,entrys.cfratefixdate", new QFilter[]{filter, filter_sell});
            resetCashFlow_Sell = RateSwapHelper.findCashFlowNeedRateCfg(cashflowCol);
        }
        if (resetCashFlow_Buy != null && resetCashFlow_Sell != null) {
            Date sellDate;
            Date buyDate = resetCashFlow_Buy.getDate("cfratefixdate");
            if (buyDate.before(sellDate = resetCashFlow_Sell.getDate("cfratefixdate"))) {
                result.put("buy", resetCashFlow_Buy);
            } else if (buyDate.after(sellDate)) {
                result.put("sell", resetCashFlow_Sell);
            } else {
                result.put("buy", resetCashFlow_Buy);
                result.put("sell", resetCashFlow_Sell);
            }
        } else if (EmptyUtil.isNoEmpty(resetCashFlow_Buy)) {
            result.put("buy", resetCashFlow_Buy);
        } else if (EmptyUtil.isNoEmpty(resetCashFlow_Sell)) {
            result.put("sell", resetCashFlow_Sell);
        } else {
            result.put("error", ResManager.loadKDString((String)"\u8be5\u4ea4\u6613\u5f53\u524d\u65e0\u9700\u5229\u7387\u786e\u8ba4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"RateSwapHelper_8", (String)"tmc-tm-common", (Object[])new Object[0]));
        }
        return result;
    }

    private static DynamicObject findCashFlowNeedRateCfg(DynamicObject[] cashflowCol) {
        for (DynamicObject cashFlow : cashflowCol) {
            if (!CashFlowTypeEnum.floatrate.getValue().equals(cashFlow.getString("cftype")) || cashFlow.getBoolean("cfispay")) continue;
            DynamicObjectCollection resetCol = cashFlow.getDynamicObjectCollection("entrys");
            resetCol.sort(Comparator.comparing(o -> o.getDate("cfratefixdate")));
            for (DynamicObject resetCashFlow : resetCol) {
                if (resetCashFlow.getBoolean("cfisratecfg")) continue;
                return resetCashFlow;
            }
        }
        return null;
    }

    public static Map<String, Object> getCashFlowToInterestPay(Long rateSwapId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        QFilter filter = new QFilter("billid", "=", (Object)rateSwapId);
        QFilter filter_buy = new QFilter("cfdirection", "=", (Object)"buy");
        QFilter filter_sell = new QFilter("cfdirection", "=", (Object)"sell");
        String selectProps = "billno,cfdirection,cfpaydate,cfamount,cfcurrency,cftype,cfispay,entrys.cfisratecfg,entrys.cfratefixdate,entrys.cfperioddays,entrys.cfuserate,entrys.cfadjstartdate,entrys.cfadjenddate";
        DynamicObject[] cashflowCol = CashFlowDAOHelper.loadAsc(selectProps, new QFilter[]{filter, filter_buy});
        DynamicObject cashflow_pay = RateSwapHelper.findCashFlowNeedInterestPay(cashflowCol);
        cashflowCol = CashFlowDAOHelper.loadAsc(selectProps, new QFilter[]{filter, filter_sell});
        DynamicObject cashflow_rec = RateSwapHelper.findCashFlowNeedInterestPay(cashflowCol);
        if (cashflow_pay != null && cashflow_rec != null) {
            Date sellDate;
            Date buyDate = cashflow_pay.getDate("cfpaydate");
            if (buyDate.before(sellDate = cashflow_rec.getDate("cfpaydate"))) {
                if (RateSwapHelper.canPay(cashflow_pay)) {
                    result.put("buy", cashflow_pay);
                } else {
                    result.put("error", ResManager.loadKDString((String)"\u652f\u4ed8\u65b9\u73b0\u91d1\u6d41\u8fd8\u672a\u5229\u7387\u786e\u8ba4\u5b8c\u6bd5\u3002", (String)"RateSwapHelper_0", (String)"tmc-tm-common", (Object[])new Object[0]));
                }
            } else if (buyDate.after(sellDate)) {
                if (RateSwapHelper.canPay(cashflow_rec)) {
                    result.put("sell", cashflow_rec);
                } else {
                    result.put("error", ResManager.loadKDString((String)"\u6536\u53d6\u65b9\u73b0\u91d1\u6d41\u5229\u7387\u786e\u8ba4\u672a\u5b8c\u6210\u3002", (String)"RateSwapHelper_1", (String)"tmc-tm-common", (Object[])new Object[0]));
                }
            } else if (RateSwapHelper.canPay(cashflow_pay) && RateSwapHelper.canPay(cashflow_rec)) {
                result.put("buy", cashflow_pay);
                result.put("sell", cashflow_rec);
            } else {
                result.put("error", ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u652f\u4ed8\u65b9\u548c\u6536\u53d6\u65b9\u73b0\u91d1\u6d41\u90fd\u5df2\u5229\u7387\u786e\u8ba4\u3002", (String)"RateSwapHelper_2", (String)"tmc-tm-common", (Object[])new Object[0]));
            }
        } else if (cashflow_pay != null) {
            if (RateSwapHelper.canPay(cashflow_pay)) {
                result.put("buy", cashflow_pay);
            } else {
                result.put("error", ResManager.loadKDString((String)"\u652f\u4ed8\u65b9\u73b0\u91d1\u6d41\u8fd8\u672a\u5229\u7387\u786e\u8ba4\u5b8c\u6bd5\u3002", (String)"RateSwapHelper_0", (String)"tmc-tm-common", (Object[])new Object[0]));
            }
        } else if (cashflow_rec != null) {
            if (RateSwapHelper.canPay(cashflow_rec)) {
                result.put("sell", cashflow_rec);
            } else {
                result.put("error", ResManager.loadKDString((String)"\u6536\u53d6\u65b9\u73b0\u91d1\u6d41\u5229\u7387\u786e\u8ba4\u672a\u5b8c\u6210\u3002", (String)"RateSwapHelper_1", (String)"tmc-tm-common", (Object[])new Object[0]));
            }
        } else {
            result.put("error", ResManager.loadKDString((String)"\u8be5\u4ea4\u6613\u5f53\u524d\u65e0\u9700\u5229\u606f\u652f\u4ed8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"RateSwapHelper_3", (String)"tmc-tm-common", (Object[])new Object[0]));
        }
        return result;
    }

    private static DynamicObject findCashFlowNeedInterestPay(DynamicObject[] cashflowCol) {
        for (DynamicObject cashFlow : cashflowCol) {
            if (CashFlowTypeEnum.fixedrate.getValue().equals(cashFlow.getString("cftype")) && !cashFlow.getBoolean("cfispay")) {
                return cashFlow;
            }
            if (!CashFlowTypeEnum.floatrate.getValue().equals(cashFlow.getString("cftype")) || cashFlow.getBoolean("cfispay")) continue;
            return cashFlow;
        }
        return null;
    }

    private static boolean canPay(DynamicObject cashFlow) {
        if (CashFlowTypeEnum.fixedrate.getValue().equals(cashFlow.getString("cftype")) && !cashFlow.getBoolean("cfispay")) {
            return true;
        }
        if (CashFlowTypeEnum.floatrate.getValue().equals(cashFlow.getString("cftype")) && !cashFlow.getBoolean("cfispay")) {
            DynamicObjectCollection resetCol = cashFlow.getDynamicObjectCollection("entrys");
            boolean canPay = true;
            for (DynamicObject resetRow : resetCol) {
                if (resetRow.getBoolean("cfisratecfg")) continue;
                canPay = false;
                break;
            }
            return canPay;
        }
        return false;
    }

    public static Map<String, Object> getCashFlowToCapitalPay(Long rateSwapId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        DynamicObject rateSwap = TmcDataServiceHelper.loadSingle((Object)rateSwapId, (String)"tm_rateswap");
        String swapType = rateSwap.getString("rateswaptype");
        String endType = rateSwap.getString("endpriextype");
        if (SwapTypeEnum.currency.getValue().equals(swapType) && SwapExchangeType.Actual.getValue().equals(endType)) {
            QFilter filter = new QFilter("billid", "=", (Object)rateSwapId);
            QFilter filter_buy = new QFilter("cfdirection", "=", (Object)"buy");
            QFilter filter_sell = new QFilter("cfdirection", "=", (Object)"sell");
            String selProps = "billno, cfdirection,cfpaydate,cfamount,cfcurrency,cftype,cfispay";
            DynamicObject[] cashflowCol = CashFlowDAOHelper.loadAsc(selProps, new QFilter[]{filter, filter_buy});
            DynamicObject cashflow_pay = cashflowCol[cashflowCol.length - 1];
            if (cashflow_pay.getBoolean("cfispay")) {
                result.put("error", ResManager.loadKDString((String)"\u8be5\u4ea4\u6613\u5f53\u524d\u65e0\u9700\u672c\u91d1\u652f\u4ed8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"RateSwapHelper_4", (String)"tmc-tm-common", (Object[])new Object[0]));
                return result;
            }
            cashflow_pay = RateSwapHelper.findCashFlowNeedCapitalPay(cashflowCol);
            cashflowCol = CashFlowDAOHelper.loadAsc(selProps, new QFilter[]{filter, filter_sell});
            DynamicObject cashflow_rec = RateSwapHelper.findCashFlowNeedCapitalPay(cashflowCol);
            if (cashflow_pay != null && cashflow_rec != null) {
                result.put("buy", cashflow_pay);
                result.put("sell", cashflow_rec);
            } else if (EmptyUtil.isNoEmpty((DynamicObject)cashflow_pay)) {
                result.put("error", ResManager.loadKDString((String)"\u6536\u53d6\u65b9\u73b0\u91d1\u6d41\u6709\u5229\u606f\u652f\u4ed8\u672a\u5b8c\u6210\u3002", (String)"RateSwapHelper_5", (String)"tmc-tm-common", (Object[])new Object[0]));
            } else if (EmptyUtil.isNoEmpty((DynamicObject)cashflow_rec)) {
                result.put("error", ResManager.loadKDString((String)"\u652f\u4ed8\u65b9\u73b0\u91d1\u6d41\u6709\u5229\u606f\u652f\u4ed8\u672a\u5b8c\u6210\u3002", (String)"RateSwapHelper_6", (String)"tmc-tm-common", (Object[])new Object[0]));
            } else {
                result.put("error", ResManager.loadKDString((String)"\u652f\u4ed8\u65b9\u3001\u6536\u53d6\u65b9\u73b0\u91d1\u6d41\u6709\u5229\u606f\u652f\u4ed8\u672a\u5b8c\u6210\u3002", (String)"RateSwapHelper_7", (String)"tmc-tm-common", (Object[])new Object[0]));
            }
        } else {
            result.put("error", ResManager.loadKDString((String)"\u8be5\u4ea4\u6613\u5f53\u524d\u65e0\u9700\u672c\u91d1\u652f\u4ed8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"RateSwapHelper_4", (String)"tmc-tm-common", (Object[])new Object[0]));
        }
        return result;
    }

    private static DynamicObject findCashFlowNeedCapitalPay(DynamicObject[] cashflowCol) {
        DynamicObject endRow;
        boolean canPay = true;
        for (int i = 0; i < cashflowCol.length; ++i) {
            DynamicObject cashFlow = cashflowCol[i];
            if (CashFlowTypeEnum.capital.getValue().equals(cashFlow.getString("cftype")) || cashFlow.getBoolean("cfispay")) continue;
            canPay = false;
            break;
        }
        if (canPay && !(endRow = cashflowCol[cashflowCol.length - 1]).getBoolean("cfispay") && CashFlowTypeEnum.capital.getValue().equals(endRow.getString("cftype"))) {
            return endRow;
        }
        return null;
    }

    public static Date getLastPayDate(DynamicObject[] cashFlow, Long currentCFId) {
        Date lastPaydate = null;
        for (int i = 0; i < cashFlow.length; ++i) {
            if (cashFlow[i].getLong("id") != currentCFId.longValue() || i <= 0 || !CashFlowTypeEnum.fixedrate.getValue().equals(cashFlow[i - 1].getString("cftype")) && !CashFlowTypeEnum.floatrate.getValue().equals(cashFlow[i - 1].getString("cftype"))) continue;
            lastPaydate = cashFlow[i - 1].getDate("cfpaydate");
            break;
        }
        return lastPaydate;
    }

    public static BizOperateEnum getBizOp(BizOperateEnum operateEnum, Long cashFlowId, DynamicObject[] cashflow, boolean isUnAudit) {
        if (BizOperateEnum.ratecfg == operateEnum) {
            for (int i = 0; i < cashflow.length; ++i) {
                DynamicObject payCF = cashflow[i];
                DynamicObjectCollection entrys = payCF.getDynamicObjectCollection("entrys");
                for (int j = 0; j < entrys.size(); ++j) {
                    if (((DynamicObject)entrys.get(j)).getLong("id") != cashFlowId.longValue()) continue;
                    if (isUnAudit) {
                        if (i == 0 && j == 0) {
                            return null;
                        }
                        return BizOperateEnum.ratecfg;
                    }
                    if (j == entrys.size() - 1) {
                        return BizOperateEnum.ratecfgWaitPay;
                    }
                    return BizOperateEnum.ratecfg;
                }
            }
        }
        if (BizOperateEnum.interestpay == operateEnum) {
            int end = cashflow.length;
            if (CashFlowTypeEnum.capital.getValue().equals(cashflow[end - 1].getString("cftype"))) {
                --end;
            }
            int start = 0;
            if (CashFlowTypeEnum.capital.getValue().equals(cashflow[start].getString("cftype"))) {
                ++start;
            }
            for (int i = start; i < end; ++i) {
                DynamicObject payCF = cashflow[i];
                if (payCF.getLong("id") != cashFlowId.longValue()) continue;
                if (isUnAudit) {
                    if (CashFlowTypeEnum.fixedrate.getValue().equals(payCF.getString("cftype"))) {
                        if (i == start) {
                            return null;
                        }
                        return BizOperateEnum.interestpay;
                    }
                    return BizOperateEnum.ratecfgWaitPay;
                }
                if (i == end - 1) {
                    if (i == cashflow.length - 1) {
                        return BizOperateEnum.interestpayAll;
                    }
                    return BizOperateEnum.waitCapitalpay;
                }
                return BizOperateEnum.interestpay;
            }
        }
        if (BizOperateEnum.capitalpay == operateEnum) {
            if (isUnAudit) {
                return BizOperateEnum.waitCapitalpay;
            }
            return BizOperateEnum.capitalpay;
        }
        return null;
    }

    public static LinkedList<Date> getDateList_PayStage(String payFreq, Date valueDate, boolean isStub, boolean isPayDateFoward, boolean isStubFront, Date firstCopDate, Date penuCopDate, DynamicObject model) {
        LinkedList<Date> dateList = new LinkedList<Date>();
        Date endDate = model.getDate("enddate");
        RateSwapHelper.genBaseSeqAndDate(payFreq, valueDate, dateList, model);
        if (isStub) {
            RateSwapHelper.adjustByStub(dateList, endDate, payFreq, isStubFront, valueDate, firstCopDate, penuCopDate);
        }
        if (isPayDateFoward) {
            dateList.addFirst(valueDate);
            dateList.removeLast();
        }
        return dateList;
    }

    protected static void genBaseSeqAndDate(String payFreq, Date valueDate, LinkedList<Date> dateList, DynamicObject model) {
        int freqMonth = PayFrequeEnum.valueOf((String)payFreq).getMonth();
        String term = model.getString("term");
        Date endDate = model.getDate("enddate");
        Date startDate = model.getDate("startdate");
        startDate = TcDateUtils.truncateDate((Date)startDate);
        endDate = TcDateUtils.truncateDate((Date)endDate);
        if (RateSwapHelper.isIntMultiple(term, payFreq) && TcDateUtils.isSameDay((Date)TermUtils.getDateByBaseDate4ymd((String)term, (Date)startDate), (Date)endDate)) {
            int i = 1;
            Date unAdjDate = startDate;
            while (unAdjDate.compareTo(endDate) < 0) {
                unAdjDate = TcDateUtils.getNextMonth((Date)startDate, (int)(i * freqMonth));
                dateList.add(unAdjDate);
                ++i;
            }
        } else {
            Date unAdjDate = endDate;
            dateList.add(unAdjDate);
            while (TcDateUtils.getLastMonth((Date)unAdjDate, (int)freqMonth).after(valueDate)) {
                unAdjDate = TcDateUtils.getLastMonth((Date)unAdjDate, (int)freqMonth);
                dateList.addFirst(unAdjDate);
            }
        }
    }

    public static boolean isIntMultiple(String term, String frequency) {
        int freqMonth;
        if (term.contains("d")) {
            return false;
        }
        int month = TermUtils.transToMonth((String)term);
        return month % (freqMonth = PayFrequeEnum.valueOf((String)frequency).getMonth()) == 0;
    }

    protected static void adjustByStub(LinkedList<Date> dateList, Date endDate, String payFreq, boolean isStubFront, Date valueDate, Date firstCopDate, Date penuCopDate) {
        if (isStubFront) {
            dateList.removeIf(date -> !date.after(firstCopDate));
            dateList.addFirst(firstCopDate);
        } else {
            int freqMonth = PayFrequeEnum.valueOf((String)payFreq).getMonth();
            dateList.clear();
            dateList.addFirst(endDate);
            Date unAdjDate = penuCopDate;
            dateList.addFirst(unAdjDate);
            while (TcDateUtils.getLastMonth((Date)unAdjDate, (int)freqMonth).after(valueDate)) {
                unAdjDate = TcDateUtils.getLastMonth((Date)unAdjDate, (int)freqMonth);
                dateList.addFirst(unAdjDate);
            }
        }
    }

    public static BigDecimal calFloatPlAmt(DynamicObject plInfo, Long rateSwapId) {
        Date referDate = TcDateUtils.getCurrentDate();
        DynamicObject tradeBill = TmcDataServiceHelper.loadSingle((Object)rateSwapId, (String)"tm_rateswap");
        BigDecimal PV_Pay = RateSwapHelper.calPVForFloatPlAmt(referDate, tradeBill, Boolean.TRUE);
        BigDecimal PV_Rec = RateSwapHelper.calPVForFloatPlAmt(referDate, tradeBill, Boolean.FALSE);
        if (SwapTypeEnum.currency.getValue().equals(tradeBill.getString("rateswaptype"))) {
            DynamicObject plCurrency = plInfo.getDynamicObject("plcurrency");
            DynamicObject payCurrency = tradeBill.getDynamicObject("currency");
            String fquote = plInfo.getString("fxquotetype");
            BigDecimal referExrate = plInfo.getBigDecimal("referexrate");
            if (plCurrency.getLong("id") == payCurrency.getLong("id")) {
                PV_Rec = plCurrency.getString("number").equals(fquote.split("/")[0]) ? (EmptyUtil.isEmpty((BigDecimal)referExrate) ? BigDecimal.ZERO : PV_Rec.divide(referExrate, 10, 4)) : PV_Rec.multiply(referExrate);
            } else {
                PV_Pay = plCurrency.getString("number").equals(fquote.split("/")[0]) ? (EmptyUtil.isEmpty((BigDecimal)referExrate) ? BigDecimal.ZERO : PV_Pay.divide(referExrate, 10, 4)) : PV_Pay.multiply(referExrate);
            }
        }
        return PV_Rec.add(PV_Pay);
    }

    public static BigDecimal calPayFloatPlAmt(DynamicObject plInfo, Long rateSwapId) {
        Date referDate = TcDateUtils.getCurrentDate();
        DynamicObject tradeBill = TmcDataServiceHelper.loadSingle((Object)rateSwapId, (String)"tm_rateswap");
        BigDecimal PV_Pay = RateSwapHelper.calPVForFloatPlAmt(referDate, tradeBill, Boolean.TRUE);
        if (SwapTypeEnum.currency.getValue().equals(tradeBill.getString("rateswaptype"))) {
            DynamicObject plCurrency = plInfo.getDynamicObject("plcurrency");
            DynamicObject payCurrency = tradeBill.getDynamicObject("currency");
            String fquote = plInfo.getString("fxquotetype");
            BigDecimal referExrate = plInfo.getBigDecimal("referexrate");
            if (plCurrency.getLong("id") != payCurrency.getLong("id")) {
                PV_Pay = plCurrency.getString("number").equals(fquote.split("/")[0]) ? (EmptyUtil.isEmpty((BigDecimal)referExrate) ? BigDecimal.ZERO : PV_Pay.divide(referExrate, 10, 4)) : PV_Pay.multiply(referExrate);
            }
        }
        return PV_Pay;
    }

    public static BigDecimal calRecFloatPlAmt(DynamicObject plInfo, Long rateSwapId) {
        Date referDate = TcDateUtils.getCurrentDate();
        DynamicObject tradeBill = TmcDataServiceHelper.loadSingle((Object)rateSwapId, (String)"tm_rateswap");
        BigDecimal PV_Rec = RateSwapHelper.calPVForFloatPlAmt(referDate, tradeBill, Boolean.FALSE);
        if (SwapTypeEnum.currency.getValue().equals(tradeBill.getString("rateswaptype"))) {
            DynamicObject plCurrency = plInfo.getDynamicObject("plcurrency");
            DynamicObject payCurrency = tradeBill.getDynamicObject("currency");
            String fquote = plInfo.getString("fxquotetype");
            BigDecimal referExrate = plInfo.getBigDecimal("referexrate");
            if (plCurrency.getLong("id") == payCurrency.getLong("id")) {
                PV_Rec = plCurrency.getString("number").equals(fquote.split("/")[0]) ? (EmptyUtil.isEmpty((BigDecimal)referExrate) ? BigDecimal.ZERO : PV_Rec.divide(referExrate, 10, 4)) : PV_Rec.multiply(referExrate);
            }
        }
        return PV_Rec;
    }

    private static BigDecimal calPVForFloatPlAmt(Date referDate, DynamicObject tradeBill, Boolean isPay) {
        QFilter filter = new QFilter("billid", "=", (Object)tradeBill.getLong("id"));
        QFilter filter_dir = new QFilter("cfdirection", "=", (Object)(isPay != false ? "buy" : "sell"));
        QFilter filter_cfpaydate = new QFilter("cfpaydate", ">=", (Object)referDate);
        DynamicObject[] cashflowCol = CashFlowDAOHelper.loadAsc("cfdirection,cfpaydate,cfamount,cfcurrency,cftype,cfispay,cfishis", new QFilter[]{filter, filter_dir, filter_cfpaydate});
        ArrayList<Date> dateList = new ArrayList<Date>(cashflowCol.length);
        for (DynamicObject cashflow : cashflowCol) {
            dateList.add(cashflow.getDate("cfpaydate"));
        }
        DynamicObject priceRule = tradeBill.getDynamicObject("pricerule");
        DynamicObject market = isPay != false ? tradeBill.getDynamicObject("market") : tradeBill.getDynamicObject("recmarket");
        PriceRuleInfo prInfo = MarketDataHelper.getDiscfactor(null, (Date)referDate, (DynamicObject)priceRule, (Long[])new Long[]{market.getLong("id")}, (Date[])dateList.toArray(new Date[0]));
        Map dfs = prInfo.getYieldCurve()[0].getDfMap();
        BigDecimal PV = BigDecimal.ZERO;
        for (DynamicObject cashflow : cashflowCol) {
            BigDecimal df = (BigDecimal)dfs.get(new Date(cashflow.getDate("cfpaydate").getTime()));
            BigDecimal amt = cashflow.getBigDecimal("cfamount");
            PV = PV.add(df.multiply(amt));
        }
        return PV;
    }

    public static DynamicObject createSwapPlInfo(DynamicObject tradeBill) {
        DynamicObjectCollection entrys;
        boolean hasBuySettle;
        ForexQuoteInfo fqInfo;
        Long fqId;
        DynamicObject forexquote;
        DynamicObject plInfo = TmcDataServiceHelper.newDynamicObject((String)"tbo_plinfo");
        Long orgId = tradeBill.getDynamicObject("org").getLong("id");
        plInfo.set("createtime", (Object)new Date());
        plInfo.set("tradebill", (Object)tradeBill.getLong("id"));
        plInfo.set("org", (Object)orgId);
        String billNo = CodeRuleServiceHelper.getNumber((String)"tbo_plinfo", (DynamicObject)plInfo, null);
        if (EmptyUtil.isEmpty((String)billNo)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u786e\u8ba4\u5df2\u6b63\u786e\u8bbe\u7f6e\u635f\u76ca\u5355\u636e\u7f16\u53f7\u89c4\u5219\u3002", (String)"TradeBillCfgOpService_6", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
        plInfo.set("billno", (Object)billNo);
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        RateSwapHelper.validateBaseCurrency(localCurrencyId);
        DynamicObject localcurrency = TmcDataServiceHelper.loadSingleFromCache((Object)localCurrencyId, (String)"bd_currency");
        DynamicObject recCurr = tradeBill.getDynamicObject("reccurrency");
        DynamicObject payCurr = tradeBill.getDynamicObject("currency");
        plInfo.set("localcurrency", (Object)localcurrency);
        plInfo.set("tradetype", (Object)tradeBill.getDynamicObject("protecttype"));
        plInfo.set("swaptype", (Object)tradeBill.getString("rateswaptype"));
        plInfo.set("billstatus", (Object)TcBillStatusEnum.SAVE.getValue());
        plInfo.set("plcurrency_s", (Object)recCurr);
        plInfo.set("plcurrency", (Object)recCurr);
        plInfo.set("buycurrency", (Object)payCurr);
        plInfo.set("sellcurrency", (Object)recCurr);
        plInfo.set("buyamount", tradeBill.get("amount"));
        plInfo.set("sellamount", tradeBill.get("recamount"));
        plInfo.set("updatedate", (Object)DateUtils.getCurrentDate());
        plInfo.set("tradebizdate", tradeBill.get("bizdate"));
        if (SwapTypeEnum.currency.getValue().equals(tradeBill.getString("rateswaptype")) && SwapExchangeType.Actual.getValue().equals(tradeBill.getString("initpriextype"))) {
            plInfo.set("plcurrency", tradeBill.get("plcurrency"));
        }
        DynamicObject plcurrency = plInfo.getDynamicObject("plcurrency");
        String swapType = tradeBill.getString("rateswaptype");
        String localPair = plcurrency.getString("number") + "/" + localcurrency.getString("number");
        String pair = payCurr.getString("number") + "/" + recCurr.getString("number");
        DynamicObject priceRule = tradeBill.getDynamicObject("pricerule");
        if (SwapTypeEnum.currency.getValue().equals(swapType) && priceRule != null && priceRule.getDynamicObject("forexquote") != null) {
            forexquote = priceRule.getDynamicObject("forexquote");
            fqId = forexquote.getLong("id");
            if (localCurrencyId.longValue() != plcurrency.getLong("id")) {
                ForexQuoteInfo localFqInfo = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)fqId, (String)localPair, (Date)DateUtils.getCurrentDate(), null);
                ForexQuoteInfo fqInfo2 = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)fqId, (String)pair, (Date)DateUtils.getCurrentDate(), null);
                if (localFqInfo != null && fqInfo2 != null) {
                    plInfo.set("forexquote", forexquote.getPkValue());
                    plInfo.set("fxquote_local", (Object)localFqInfo.getFxquote());
                    plInfo.set("fxquotetype", (Object)localFqInfo.getFxquote());
                    plInfo.set("issuedate", (Object)localFqInfo.getIssuetime());
                }
            } else {
                fqInfo = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)fqId, (String)pair, (Date)DateUtils.getCurrentDate(), null);
                if (fqInfo != null) {
                    plInfo.set("forexquote", forexquote.getPkValue());
                    plInfo.set("fxquote_local", (Object)fqInfo.getFxquote());
                    plInfo.set("issuedate", (Object)fqInfo.getIssuetime());
                }
            }
        }
        if (SwapTypeEnum.rate.getValue().equals(swapType) && localCurrencyId.longValue() != recCurr.getLong("id") && priceRule != null && priceRule.getDynamicObject("forexquote") != null && (fqInfo = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)(fqId = Long.valueOf((forexquote = priceRule.getDynamicObject("forexquote")).getLong("id"))), (String)localPair, (Date)DateUtils.getCurrentDate(), null)) != null) {
            plInfo.set("forexquote", forexquote.getPkValue());
            plInfo.set("fxquote_local", (Object)fqInfo.getFxquote());
            plInfo.set("issuedate", (Object)fqInfo.getIssuetime());
        }
        if (SwapTypeEnum.currency.getValue().equals(swapType) && SwapExchangeType.Actual.getValue().equals(tradeBill.getString("initpriextype")) && !(hasBuySettle = (entrys = plInfo.getDynamicObjectCollection("entrys")).stream().anyMatch(e -> "buysettle".equals(e.getString("biztype"))))) {
            int seq = entrys.size() + 1;
            DynamicObject newRecord = entrys.addNew();
            newRecord.set("seq", (Object)seq);
            newRecord.set("biztype", (Object)"buysettle");
            newRecord.set("bizdate", tradeBill.get("bizdate"));
            newRecord.set("settledate", tradeBill.get("buysettledate"));
            newRecord.set("plamt", tradeBill.get("plamt"));
            newRecord.set("bizbillplcurrency", tradeBill.get("plcurrency"));
            DynamicObject baseCurrency = tradeBill.getDynamicObject("basecurrency");
            DynamicObject plCurrency = tradeBill.getDynamicObject("plcurrency");
            if (baseCurrency != null && plCurrency != null && baseCurrency.getString("number").equals(plCurrency.getString("number"))) {
                newRecord.set("pllocalamt", tradeBill.get("plamt"));
            } else {
                newRecord.set("pllocalamt", tradeBill.get("baseplamt"));
            }
            newRecord.set("bizbillvoucherpl", tradeBill.get("voucherpl"));
            plInfo.set("pllocalamt_sum", newRecord.get("pllocalamt"));
        }
        RateSwapHelper.setAmtprecision(plInfo, null);
        return plInfo;
    }

    public static void setAmtprecision(DynamicObject obj, DynamicObject parentObj) {
        if (obj == null) {
            return;
        }
        DataEntityPropertyCollection properties = obj.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (property instanceof AmountProp) {
                AmountProp amountProp = (AmountProp)property;
                String controlPropName = amountProp.getControlPropName();
                BigDecimal amount = obj.getBigDecimal(property.getName());
                DynamicObject currency = null;
                if (obj.containsProperty(controlPropName)) {
                    currency = obj.getDynamicObject(controlPropName);
                } else if (parentObj != null && parentObj.containsProperty(controlPropName)) {
                    currency = parentObj.getDynamicObject(controlPropName);
                }
                if (currency != null && !EmptyUtil.isEmpty((BigDecimal)amount)) {
                    int amtprecision = currency.getInt("amtprecision");
                    obj.set(property.getName(), (Object)amount.setScale(amtprecision, RoundingMode.HALF_UP));
                }
            }
            if (!(property instanceof EntryProp)) continue;
            EntryProp entryProp = (EntryProp)property;
            String name = entryProp.getName();
            DynamicObjectCollection dynamicObjectCollection = obj.getDynamicObjectCollection(name);
            for (DynamicObject object : dynamicObjectCollection) {
                RateSwapHelper.setAmtprecision(object, obj);
            }
        }
    }

    private static void validateBaseCurrency(Long localCurrencyId) {
        if (EmptyUtil.isEmpty((Long)localCurrencyId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5f53\u524d\u4ea4\u6613\u4e3b\u4f53\u7684\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u540e\u518d\u8fdb\u884c\u4ea4\u6613\u786e\u8ba4\u3002", (String)"TradeBillCfgOpService_4", (String)"tmc-tm-business", (Object[])new Object[0]));
        }
    }

    public static void calFirstComfirmDate(IDataModel model, IFormView view, boolean isPay, boolean isClear, boolean isPage) {
        RateSwapHelper.calFirstComfirmDate(model, view, isPay, isClear, isPage, null, null, null, null);
    }

    public static void calFirstComfirmDate(IDataModel model, IFormView view, boolean isPay, boolean isClear, boolean isPage, String prefix, IPageCache cache, List<String> allCashFlowPlugin, String className) {
        boolean isfloat;
        boolean isDay = QuotaFrequency.Day.getValue().equals(model.getValue("ratequotafreq"));
        String rateTypeProp = "ratetype";
        String rateResetTypeProp = "rateresettype";
        String resetOffsetProp = "rateresetoffset";
        String valueDateProp = "valuedate";
        String firstFixedDateProp = "firstfixeddate";
        String firstPayCopDateProp = "firstpaycopdate";
        String firstfixedrate = "firstfixedrate";
        String workCalendarProp = "payworkcalendar";
        String cashflowEntryName = "paycashflow";
        String cftypeName = "cftype";
        String cfadjenddateName = "cfadjenddate";
        String cfpaydateName = "cfpaydate";
        String cffixrateName = "cffixrate";
        if (!isPay) {
            isDay = model.getValue("recratequotafreq").equals(QuotaFrequency.Day.getValue());
            rateTypeProp = "recratetype";
            rateResetTypeProp = "recrateresettype";
            resetOffsetProp = "recrateresetoffset";
            valueDateProp = "recvaluedate";
            firstFixedDateProp = "recfirstfixeddate";
            firstfixedrate = "recfirstfixedrate";
            firstPayCopDateProp = "recfirstpaycopdate";
            workCalendarProp = "recworkcalendar";
            cashflowEntryName = "reccashflow";
            cftypeName = "cftype_s";
            cfadjenddateName = "cfadjenddate_s";
            cfpaydateName = "cfpaydate_s";
            cffixrateName = "cffixrate_s";
        }
        if (isfloat = model.getValue(rateTypeProp).equals(RateTypeEnum.rate_float.getValue())) {
            DynamicObjectCollection entryEntity;
            BigDecimal firsCffixrate;
            Date firstPayCopDate;
            Date valueDate;
            boolean isForward = model.getValue(rateResetTypeProp).equals(ConfigPayTypeEnum.forward.getValue());
            DynamicObjectCollection wc = (DynamicObjectCollection)model.getValue(workCalendarProp);
            int Offset = (Integer)model.getValue(resetOffsetProp);
            if (isForward && !EmptyUtil.isEmpty((Object)(valueDate = (Date)model.getValue(valueDateProp)))) {
                Date firstFixDate = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)wc, (Date)valueDate, (int)(-Offset), (AdjustMethodEnum)AdjustMethodEnum.backward);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)firstFixedDateProp, (Object)firstFixDate);
            }
            boolean isTip = false;
            if (isDay && !isForward) {
                firstPayCopDate = null;
                firsCffixrate = null;
                if (isClear) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)firstFixedDateProp, null);
                    return;
                }
                entryEntity = model.getEntryEntity(cashflowEntryName);
                Object id = 0L;
                for (DynamicObject dynamicObject : entryEntity) {
                    if ("floatrate".equals(dynamicObject.getString(cftypeName))) {
                        id = dynamicObject.getLong("id");
                        continue;
                    }
                    if (!EmptyUtil.isNoEmpty((Long)id) || !((Long)id).equals(dynamicObject.getLong("pid"))) continue;
                    firstPayCopDate = dynamicObject.getDate(cfadjenddateName);
                    firsCffixrate = dynamicObject.getBigDecimal(cffixrateName);
                    break;
                }
                if (EmptyUtil.isNoEmpty(firstPayCopDate)) {
                    Date firstFixedDate = (Date)model.getValue(firstFixedDateProp);
                    Date firstFixDate = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)wc, (Date)firstPayCopDate, (int)(-Offset), (AdjustMethodEnum)AdjustMethodEnum.backward);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)firstFixedDateProp, (Object)firstFixDate);
                    if (isPage) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)firstfixedrate, firsCffixrate);
                    } else if (firstFixedDate == null || firstFixedDate.compareTo(firstFixDate) != 0) {
                        isTip = true;
                    }
                }
            }
            if (!isDay && !isForward) {
                if (isClear) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)firstFixedDateProp, null);
                    return;
                }
                firstPayCopDate = null;
                firsCffixrate = null;
                entryEntity = model.getEntryEntity(cashflowEntryName);
                for (DynamicObject dynamicObject : entryEntity) {
                    if (!"floatrate".equals(dynamicObject.getString(cftypeName))) continue;
                    firstPayCopDate = dynamicObject.getDate(cfpaydateName);
                    break;
                }
                if (EmptyUtil.isNoEmpty(firstPayCopDate)) {
                    Date firstFixedDate = (Date)model.getValue(firstFixedDateProp);
                    Date firstFixDate = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)wc, (Date)firstPayCopDate, (int)(-Offset), (AdjustMethodEnum)AdjustMethodEnum.backward);
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)firstFixedDateProp, (Object)firstFixDate);
                    if (isPage) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)view, (IDataModel)model, (String)firstfixedrate, firsCffixrate);
                    } else if (firstFixedDate == null || firstFixedDate.compareTo(firstFixDate) != 0) {
                        isTip = true;
                    }
                }
            }
            if (!isPage) {
                Set<String> checkedPlugin;
                if (isTip) {
                    if (EmptyUtil.isEmpty(allCashFlowPlugin) || allCashFlowPlugin.size() == 1) {
                        view.showSuccessNotification(ResManager.loadKDString((String)"%s\u9996\u6b21\u5229\u7387\u786e\u5b9a\u65e5\u5df2\u6839\u636e\u73b0\u91d1\u6d41\u8ba1\u7b97\u66f4\u65b0\u3002", (String)"RateSwapHelper_9", (String)"tmc-tm-common", (Object[])new Object[]{prefix}));
                    } else if (EmptyUtil.isEmpty((String)cache.get("comfirmDatecheckedPlugin"))) {
                        checkedPlugin = new HashSet();
                        checkedPlugin.add(className);
                        cache.put("comfirmDatecheckedPlugin", SerializationUtils.toJsonString(checkedPlugin));
                        cache.put("comfirmDatecheckedPrefix", prefix);
                    } else {
                        checkedPlugin = (Set)SerializationUtils.fromJsonString((String)cache.get("comfirmDatecheckedPlugin"), Set.class);
                        checkedPlugin.add(className);
                        if (checkedPlugin.size() == allCashFlowPlugin.size()) {
                            String prefixCache = cache.get("comfirmDatecheckedPrefix");
                            cache.remove("comfirmDatecheckedPlugin");
                            cache.remove("comfirmDatecheckedPrefix");
                            cache.remove("comfirmDatecheckedTip");
                            String msg = "";
                            msg = EmptyUtil.isEmpty((String)prefixCache) ? prefix : prefixCache + "\u3001" + prefix;
                            view.showSuccessNotification(ResManager.loadKDString((String)"%s\u9996\u6b21\u5229\u7387\u786e\u5b9a\u65e5\u5df2\u6839\u636e\u73b0\u91d1\u6d41\u8ba1\u7b97\u66f4\u65b0\u3002", (String)"RateSwapHelper_9", (String)"tmc-tm-common", (Object[])new Object[]{msg}));
                        }
                    }
                } else if (EmptyUtil.isEmpty((String)cache.get("comfirmDatecheckedPlugin"))) {
                    checkedPlugin = new HashSet<String>();
                    checkedPlugin.add(className);
                    cache.put("comfirmDatecheckedPlugin", SerializationUtils.toJsonString(checkedPlugin));
                    cache.put("comfirmDatecheckedPrefix", "");
                    cache.put("comfirmDatecheckedTip", "1");
                } else {
                    String comfirmDatecheckedPrefix = cache.get("comfirmDatecheckedPrefix");
                    cache.remove("comfirmDatecheckedPlugin");
                    cache.remove("comfirmDatecheckedPrefix");
                    String comfirmDatecheckedTip = cache.get("comfirmDatecheckedTip");
                    cache.remove("comfirmDatecheckedTip");
                    if (EmptyUtil.isEmpty((String)comfirmDatecheckedTip)) {
                        view.showSuccessNotification(ResManager.loadKDString((String)"%s\u9996\u6b21\u5229\u7387\u786e\u5b9a\u65e5\u5df2\u6839\u636e\u73b0\u91d1\u6d41\u8ba1\u7b97\u66f4\u65b0\u3002", (String)"RateSwapHelper_9", (String)"tmc-tm-common", (Object[])new Object[]{comfirmDatecheckedPrefix}));
                    }
                }
            }
        } else if (!isPage) {
            if (EmptyUtil.isEmpty((String)cache.get("comfirmDatecheckedPlugin"))) {
                HashSet<String> checkedPlugin = new HashSet<String>();
                checkedPlugin.add(className);
                cache.put("comfirmDatecheckedPlugin", SerializationUtils.toJsonString(checkedPlugin));
                cache.put("comfirmDatecheckedTip", "1");
            } else {
                String comfirmDatecheckedPrefix = cache.get("comfirmDatecheckedPrefix");
                cache.remove("comfirmDatecheckedPlugin");
                cache.remove("comfirmDatecheckedPrefix");
                String comfirmDatecheckedTip = cache.get("comfirmDatecheckedTip");
                cache.remove("comfirmDatecheckedTip");
                if (EmptyUtil.isEmpty((String)comfirmDatecheckedTip)) {
                    view.showSuccessNotification(ResManager.loadKDString((String)"%s\u9996\u6b21\u5229\u7387\u786e\u5b9a\u65e5\u5df2\u6839\u636e\u73b0\u91d1\u6d41\u8ba1\u7b97\u66f4\u65b0\u3002", (String)"RateSwapHelper_9", (String)"tmc-tm-common", (Object[])new Object[]{comfirmDatecheckedPrefix}));
                }
            }
        }
    }

    public static FreqPeriodListBean createFreqPeriodList(DynamicObject rateSwapBill, boolean buy) {
        String basisStr = rateSwapBill.getString(buy ? "basis" : "recbasis");
        String payType = rateSwapBill.getString(buy ? "paytype" : "recpaytype");
        boolean isPayStage = RateSwapsPayTypeEnum.pay_stages.getValue().equals(payType);
        BasisEnum basis = BasisEnum.getEnum((String)basisStr);
        if (isPayStage && BasisEnum.ICMA_Actual_actual == basis) {
            Date valueDate = rateSwapBill.getDate(buy ? "valuedate" : "recvaluedate");
            Date endDate = rateSwapBill.getDate("enddate");
            String payFreqStr = rateSwapBill.getString(buy ? "payfrequency" : "recpayfrequency");
            DynamicObjectCollection payWc = rateSwapBill.getDynamicObjectCollection(buy ? "payworkcalendar" : "recworkcalendar");
            Boolean isStub = rateSwapBill.getBoolean(buy ? "stub" : "recstub");
            String stubType = rateSwapBill.getString(buy ? "stubtype" : "recstubtype");
            Date firstCopDate = rateSwapBill.getDate(buy ? "firstpaycopdate" : "recfirstpaycopdate");
            Date penuCopDate = rateSwapBill.getDate(buy ? "penupaycopdate" : "recpenupaycopdate");
            String adjMethod = rateSwapBill.getString(buy ? "dateadjustmethod" : "recdateadjustmethod");
            PayFrequeEnum freq = PayFrequeEnum.valueOf((String)payFreqStr);
            boolean isStubFront = "front".equals(stubType);
            return new FreqPeriodListBean(valueDate, endDate, isStub.booleanValue(), isStubFront, firstCopDate, penuCopDate, freq, AdjustMethodEnum.getEnumByValue((String)adjMethod), payWc, true);
        }
        return null;
    }
}

