/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.bean.tc.PriceRuleInfo;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.helper.CashFlowDAOHelper;
import kd.tmc.tm.common.helper.RateSwapCFCalHelper;

public class RateSwapPlHelper {
    private static Log logger = LogFactory.getLog(RateSwapPlHelper.class);

    private static BigDecimal calPVForFloatPlAmt(Date referDate, DynamicObject tradeBill, Boolean isPay) {
        QFilter filter = new QFilter("billid", "=", (Object)tradeBill.getLong("id"));
        QFilter filter_dir = new QFilter("cfdirection", "=", (Object)(isPay != false ? "buy" : "sell"));
        QFilter filter_cfpaydate = new QFilter("cfpaydate", ">=", (Object)referDate);
        DynamicObject[] cashflowCol = CashFlowDAOHelper.loadAsc("billno, id,cfpaydate,cfamount,cftype,cfispay,cfosprincipal,cfratefixindex,cfisratecfg,cfratefixdate,cfresetpredictrate,cfisratecfg,cfuserate,cfamount,cfdiscfactor,cfpv,cfadjstartdate,cfadjenddate,cfpayamount,cfinterest,cftheta", new QFilter[]{filter, filter_dir, filter_cfpaydate});
        ArrayList<Date> dateList = new ArrayList<Date>(cashflowCol.length * 2);
        for (DynamicObject cashflow : cashflowCol) {
            Date payDate = cashflow.getDate("cfpaydate");
            dateList.add(payDate);
            dateList.add(TcDateUtils.getLastDay((Date)payDate, (int)1));
        }
        DynamicObject priceRule = tradeBill.getDynamicObject("pricerule");
        DynamicObject market = isPay != false ? tradeBill.getDynamicObject("market") : tradeBill.getDynamicObject("recmarket");
        PriceRuleInfo prInfo = MarketDataHelper.getDiscfactor(null, (Date)referDate, (DynamicObject)priceRule, (Long[])new Long[]{market.getLong("id")}, (Date[])dateList.toArray(new Date[0]));
        Map dfs = prInfo.getYieldCurve()[0].getDfMap();
        RateSwapCFCalHelper.calCashFlows_swap(cashflowCol, referDate, tradeBill, dfs, isPay);
        BigDecimal PV = BigDecimal.ZERO;
        for (DynamicObject cashflow : cashflowCol) {
            boolean cfispay = cashflow.getBoolean("cfispay");
            if (cfispay) continue;
            BigDecimal pv = cashflow.getBigDecimal("cfpv");
            PV = PV.add(pv);
        }
        return PV;
    }

    public static BigDecimal calPayFloatPlAmt(DynamicObject plInfo, DynamicObject tradeBill) {
        Date referDate = plInfo.getDate("updatedate");
        BigDecimal PV_Pay = RateSwapPlHelper.calPVForFloatPlAmt(referDate, tradeBill, Boolean.TRUE);
        return RateSwapPlHelper.calForexAmt(plInfo, tradeBill, PV_Pay);
    }

    private static BigDecimal calForexAmt(DynamicObject plInfo, DynamicObject tradeBill, BigDecimal pv) {
        if ("currency".equals(tradeBill.getString("rateswaptype"))) {
            DynamicObject plCurrency = plInfo.getDynamicObject("plcurrency");
            DynamicObject payCurrency = tradeBill.getDynamicObject("currency");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, payCurrency})) {
                int amtprecision = plCurrency.getInt("amtprecision");
                String fquote = plInfo.getString("fxquotetype");
                BigDecimal referExrate = plInfo.getBigDecimal("referexrate");
                if (plCurrency.getLong("id") != payCurrency.getLong("id")) {
                    pv = plCurrency.getString("number").equals(fquote.split("/")[0]) ? (EmptyUtil.isEmpty((BigDecimal)referExrate) ? BigDecimal.ZERO : pv.divide(referExrate, amtprecision, RoundingMode.HALF_UP)) : pv.multiply(referExrate).setScale(amtprecision, RoundingMode.HALF_UP);
                }
            }
        }
        return pv;
    }

    public static BigDecimal calRecFloatPlAmt(DynamicObject plInfo, DynamicObject tradeBill) {
        Date referDate = plInfo.getDate("updatedate");
        BigDecimal PV_Rec = RateSwapPlHelper.calPVForFloatPlAmt(referDate, tradeBill, Boolean.FALSE);
        if ("currency".equals(tradeBill.getString("rateswaptype"))) {
            DynamicObject plCurrency = plInfo.getDynamicObject("plcurrency");
            DynamicObject payCurrency = tradeBill.getDynamicObject("currency");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, payCurrency})) {
                String fquote = plInfo.getString("fxquotetype");
                BigDecimal referExrate = plInfo.getBigDecimal("referexrate");
                if (plCurrency.getLong("id") == payCurrency.getLong("id")) {
                    PV_Rec = plCurrency.getString("number").equals(fquote.split("/")[0]) ? (EmptyUtil.isEmpty((BigDecimal)referExrate) ? BigDecimal.ZERO : PV_Rec.divide(referExrate, 10, 4)) : PV_Rec.multiply(referExrate);
                }
            }
        }
        return PV_Rec;
    }
}

