/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.common.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ReqLimitHelper {
    private static final Log logger = LogFactory.getLog(ReqLimitHelper.class);

    public static void occLimitAmt(DynamicObject bill, DynamicObject limit, Map<Long, BigDecimal> reqnoteCurrencyAmtMap) {
        ReqLimitHelper.updateLimitAmt(bill, limit, reqnoteCurrencyAmtMap, true, true);
    }

    public static void returnLimitAmt(DynamicObject bill, DynamicObject limit, Map<Long, BigDecimal> reqnoteCurrencyAmtMap) {
        ReqLimitHelper.updateLimitAmt(bill, limit, reqnoteCurrencyAmtMap, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLimitAmt(DynamicObject bill, DynamicObject limit, Map<Long, BigDecimal> reqnoteCurrencyAmtMap, boolean isAdd, boolean isUse) {
        List<Object> requestIds = new ArrayList(10);
        try {
            long limitId = limit.getLong("id");
            String limitIdStr = String.valueOf(limitId);
            DynamicObjectCollection entryEntities = limit.getDynamicObjectCollection("entryentity");
            ArrayList<String> lockIds = new ArrayList<String>(entryEntities.size());
            HashMap<Long, DynamicObject> currMap = new HashMap<Long, DynamicObject>();
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObject curr = entryEntity.getDynamicObject("currency");
                Long currId = (Long)curr.getPkValue();
                currMap.put(currId, entryEntity);
                lockIds.add(limitIdStr + currId);
            }
            Map request = MutexServiceHelper.batchRequest(lockIds, (String)"reqlimit_lock", (String)"reqlimit");
            logger.info("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(requestIds));
            requestIds = request.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toList());
            List requestFailIds = request.entrySet().stream().filter(s -> (Boolean)s.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toList());
            if (EmptyUtil.isNoEmpty(requestFailIds)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u4e92\u65a5\u9501\uff0c\u8bf7\u7a0d\u540e\u5904\u7406\u3002", (String)"ReqNoteLimitOccService_1", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(reqnoteCurrencyAmtMap.size());
            for (Map.Entry entry : reqnoteCurrencyAmtMap.entrySet()) {
                BigDecimal newremainamt;
                BigDecimal newuseamt;
                DynamicObject currEntry;
                Long currencyId = (Long)entry.getKey();
                BigDecimal amt = (BigDecimal)entry.getValue();
                if (EmptyUtil.isEmpty((BigDecimal)amt) || (currEntry = (DynamicObject)currMap.get(currencyId)) == null) continue;
                BigDecimal useamt = currEntry.getBigDecimal("useamt");
                BigDecimal remainamt = currEntry.getBigDecimal("remainamt");
                if (isAdd) {
                    newuseamt = useamt.add(amt);
                    newremainamt = remainamt.subtract(amt);
                } else {
                    newuseamt = useamt.subtract(amt);
                    newremainamt = remainamt.add(amt);
                }
                paramList.add(new Object[]{newuseamt, newremainamt, limitId, currencyId, useamt, remainamt});
            }
            if (!EmptyUtil.isEmpty(paramList)) {
                String updateSql = "update t_tm_reqlimit_entry set fuseamt=?,fremainamt=? where fid=? and fcurrencyid=? and fuseamt=? and fremainamt=?";
                int[] nArray = DB.executeBatch((DBRoute)new DBRoute(DBRouteConst.TMC.getRouteKey()), (String)updateSql, paramList);
                int count = Arrays.stream(nArray).sum();
                if (paramList.size() != count) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5360\u7528\u5355\u7684\u53ef\u7528\u989d\u5ea6\u5df2\u4fee\u6539\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ReqNoteLimitOccService_0", (String)"tmc-tm-business", (Object[])new Object[0]));
                }
            }
            if (isUse) {
                if (isAdd) {
                    ReqLimitHelper.addLimitUse(bill, limit, reqnoteCurrencyAmtMap);
                } else {
                    ReqLimitHelper.delLimitUse(bill, limit, reqnoteCurrencyAmtMap);
                }
            }
        }
        finally {
            if (requestIds.size() > 0) {
                MutexServiceHelper.batchRelease(requestIds, (String)"reqlimit_lock", (String)"reqlimit");
                logger.info("\u91ca\u653e\u5206\u5e03\u5f0f\u9501:" + JSON.toJSONString(requestIds));
            }
        }
    }

    private static void addLimitUse(DynamicObject entity, DynamicObject limitDb, Map<Long, BigDecimal> reqnoteCurrencyAmtMap) {
        long id = entity.getLong("id");
        String billNo = entity.getString("billno");
        Long limitId = limitDb.getLong("id");
        String limitNo = limitDb.getString("billno");
        String entityName = entity.getDataEntityType().getName();
        DynamicObject productType = entity.getDynamicObject("producttype");
        Set<Long> currIds = reqnoteCurrencyAmtMap.keySet();
        QFilter qFilter = new QFilter("limitid", "=", (Object)limitId);
        qFilter.and("currency.id", "in", currIds);
        Object[] limitUses = TmcDataServiceHelper.load((String)"tm_reqlimit_use", (String)"limitid,billno,currency,limitamt,useamt,remainamt,entryentity.bill,entryentity.billtype,entryentity.billid,entryentity.producttype,entryentity.billuseamt,entryentity.useamtratio", (QFilter[])qFilter.toArray());
        DynamicObjectCollection entryEntities = limitDb.getDynamicObjectCollection("entryentity");
        HashMap<Long, DynamicObject> currMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject entryEntity : entryEntities) {
            Object[] curr = entryEntity.getDynamicObject("currency");
            Long currId = (Long)curr.getPkValue();
            currMap.put(currId, entryEntity);
        }
        String updateLimitUseSql = "update t_tm_reqlimit_use set flimitamt=?,fuseamt=?,fremainamt=? where fid=? and fuseamt=?";
        ArrayList<Object[]> updateLimitUseParamList = new ArrayList<Object[]>(limitUses.length);
        for (DynamicObject dynamicObject : limitUses) {
            DynamicObject currency = dynamicObject.getDynamicObject("currency");
            BigDecimal useamt = dynamicObject.getBigDecimal("useamt");
            long currId = currency.getLong("id");
            if (!reqnoteCurrencyAmtMap.containsKey(currId)) continue;
            BigDecimal amt = reqnoteCurrencyAmtMap.remove(currId);
            DynamicObject currEntry = (DynamicObject)currMap.get(currId);
            if (EmptyUtil.isEmpty((BigDecimal)amt) || currEntry == null) continue;
            Object[] updateLimitUseParam = new Object[]{currEntry.getBigDecimal("limitamt"), currEntry.getBigDecimal("useamt"), currEntry.getBigDecimal("remainamt"), dynamicObject.getLong("id"), useamt};
            updateLimitUseParamList.add(updateLimitUseParam);
            DynamicObjectCollection entryentities = dynamicObject.getDynamicObjectCollection("entryentity");
            DynamicObject newEntry = entryentities.addNew();
            newEntry.set("bill", (Object)billNo);
            newEntry.set("billtype", (Object)entityName);
            newEntry.set("billid", (Object)id);
            newEntry.set("producttype", (Object)productType);
            newEntry.set("billuseamt", (Object)amt);
            newEntry.set("useamtratio", (Object)amt.multiply(BigDecimal.valueOf(100L)).divide(currEntry.getBigDecimal("limitamt"), 2, RoundingMode.HALF_UP));
        }
        ArrayList<DynamicObject> limits = new ArrayList<DynamicObject>(reqnoteCurrencyAmtMap.size());
        Set<Map.Entry<Long, BigDecimal>> entries = reqnoteCurrencyAmtMap.entrySet();
        for (Map.Entry<Long, BigDecimal> entry : entries) {
            DynamicObject currEntry;
            Long currencyId = entry.getKey();
            BigDecimal amt = entry.getValue();
            if (EmptyUtil.isEmpty((BigDecimal)amt) || (currEntry = (DynamicObject)currMap.get(currencyId)) == null) continue;
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tm_reqlimit_use");
            DynamicObject newLimitUse = new DynamicObject((DynamicObjectType)entityType);
            newLimitUse.set("limitid", (Object)limitId);
            newLimitUse.set("billno", (Object)limitNo);
            newLimitUse.set("currency", (Object)currencyId);
            DynamicObjectCollection entryentities = newLimitUse.getDynamicObjectCollection("entryentity");
            DynamicObject newEntry = entryentities.addNew();
            newEntry.set("bill", (Object)billNo);
            newEntry.set("billtype", (Object)entityName);
            newEntry.set("billid", (Object)id);
            newEntry.set("producttype", (Object)productType);
            newEntry.set("billuseamt", (Object)amt);
            newEntry.set("useamtratio", (Object)amt.multiply(BigDecimal.valueOf(100L)).divide(currEntry.getBigDecimal("limitamt"), 2, RoundingMode.HALF_UP));
            limits.add(newLimitUse);
        }
        if (!EmptyUtil.isEmpty(limits)) {
            TmcDataServiceHelper.save((DynamicObject[])limits.toArray(new DynamicObject[0]));
        }
        if (!updateLimitUseParamList.isEmpty()) {
            int[] resultArr = DB.executeBatch((DBRoute)new DBRoute(DBRouteConst.TMC.getRouteKey()), (String)updateLimitUseSql, updateLimitUseParamList);
            int n = Arrays.stream(resultArr).sum();
            if (updateLimitUseParamList.size() != n) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5916\u6c47\u4ea4\u6613\u989d\u5ea6\u5360\u7528\u5355\u7684\u53ef\u7528\u989d\u5ea6\u5df2\u4fee\u6539\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ReqNoteLimitOccService_0", (String)"tmc-tm-business", (Object[])new Object[0]));
            }
        }
        if (!EmptyUtil.isEmpty((Object[])limitUses)) {
            TmcDataServiceHelper.save((DynamicObject[])limitUses);
        }
    }

    private static void delLimitUse(DynamicObject entity, DynamicObject limitDb, Map<Long, BigDecimal> reqnoteCurrencyAmtMap) {
        long reqNoteId = entity.getLong("id");
        Set<Long> currIds = reqnoteCurrencyAmtMap.keySet();
        QFilter qFilter = new QFilter("limitid", "=", (Object)limitDb.getLong("id"));
        qFilter.and("currency.id", "in", currIds);
        DynamicObject[] limitUses = TmcDataServiceHelper.load((String)"tm_reqlimit_use", (String)"limitid,billno,currency,limitamt,useamt,remainamt,entryentity.bill,entryentity.billtype,entryentity.billid,entryentity.producttype,entryentity.billuseamt,entryentity.useamtratio", (QFilter[])qFilter.toArray());
        DynamicObjectCollection entryEntities = limitDb.getDynamicObjectCollection("entryentity");
        HashMap<Long, DynamicObject> currMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObject curr = entryEntity.getDynamicObject("currency");
            Long currId = (Long)curr.getPkValue();
            currMap.put(currId, entryEntity);
        }
        ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
        for (DynamicObject limitUse : limitUses) {
            DynamicObject currency = limitUse.getDynamicObject("currency");
            long currId = currency.getLong("id");
            if (!reqnoteCurrencyAmtMap.containsKey(currId)) continue;
            BigDecimal amt = reqnoteCurrencyAmtMap.remove(currId);
            DynamicObject currEntry = (DynamicObject)currMap.get(currId);
            if (EmptyUtil.isEmpty((BigDecimal)amt) || currEntry == null) continue;
            DynamicObjectCollection entryentities = limitUse.getDynamicObjectCollection("entryentity");
            entryentities.removeIf(e -> e.getLong("billid") == reqNoteId);
            saveList.add(limitUse);
        }
        if (saveList.size() > 0) {
            TmcDataServiceHelper.save((DynamicObject[])limitUses);
        }
    }
}

