/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.report.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.events.CreateColumnEvent;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tbo.common.enums.DateRangeEnum;

public class ReportHelper {
    public static String getUnit(String currencyUnit) {
        String divisor = "1";
        switch (currencyUnit) {
            case "Billion": {
                divisor = "100000000";
                break;
            }
            case "Million": {
                divisor = "1000000";
                break;
            }
            case "TenThousand": {
                divisor = "10000";
                break;
            }
            case "Thousand": {
                divisor = "1000";
                break;
            }
        }
        return divisor;
    }

    public static void setDateFilterAfterSchemeLoad(IReportView view, DynamicObject scheme, String dataRangeProp, String startProp, String endProp) {
        DataEntityPropertyCollection props = scheme.getDynamicObjectType().getProperties();
        if (props.containsKey((Object)dataRangeProp)) {
            Date currentDate = TcDateUtils.getCurrentDate();
            IDataModel model = view.getModel();
            model.beginInit();
            String dateRangeValue = (String)model.getValue(dataRangeProp);
            if (DateRangeEnum.WEEK.getValue().equals(model.getValue(dataRangeProp))) {
                model.setValue(endProp, (Object)currentDate);
                model.setValue(startProp, (Object)TcDateUtils.getFirstDayOfWeek((Date)currentDate));
            } else if (DateRangeEnum.MONTH.getValue().equals(dateRangeValue)) {
                model.setValue(endProp, (Object)currentDate);
                model.setValue(startProp, (Object)TcDateUtils.getFirstDayOfMonth((Date)currentDate));
            } else if (DateRangeEnum.YEAR.getValue().equals(dateRangeValue)) {
                model.setValue(endProp, (Object)currentDate);
                model.setValue(startProp, (Object)TcDateUtils.getFirstYearDate((Date)currentDate));
            }
            model.endInit();
            view.updateView(startProp);
            view.updateView(endProp);
        }
    }

    public static String getFirstColumnText(Map<String, Object> paramMap) {
        String statim = (String)paramMap.get("dimension_filter");
        String[] statimArr = statim.split(",");
        if (statimArr.length > 0) {
            return "," + statimArr[0] + ".name as orgtext";
        }
        return "";
    }

    public static String getGroupColums(String statim) {
        String[] statimArr = statim.split(",");
        if (statimArr.length > 0) {
            return statimArr[0];
        }
        return "";
    }

    public static Map<String, LocaleString> getColumnField(CreateColumnEvent event) {
        List columns = event.getColumns();
        return columns.stream().collect(Collectors.toMap(k -> ((ReportColumn)k).getFieldKey(), AbstractReportColumn::getCaption, (e1, e2) -> e1));
    }

    public static DataSet calRateDataSet(List<Long> currencyIds, List<Object[]> rateList, DataSet sourceDataSet, DynamicObject forexQuote, DynamicObject toCurrency, List<String> currencyIdNames, List<String> currencyNumberNames, Date endDate, Set<String> tipPairs) {
        ArrayList<Field> field = new ArrayList<Field>();
        field.add(new Field("currency", (DataType)DataType.LongType));
        field.add(new Field("rate", (DataType)DataType.BigDecimalType));
        RowMeta rowMeta = new RowMeta(field.toArray(new Field[0]));
        Algo algo = Algo.create((String)"");
        BigDecimal rate = null;
        HashMap<String, BigDecimal> exchgRateCache = new HashMap<String, BigDecimal>(16);
        for (Row row : sourceDataSet.copy()) {
            for (int i = 0; i < currencyIdNames.size(); ++i) {
                String cuPair;
                Long currnecyId = row.getLong(currencyIdNames.get(i));
                String currnecyNumber = row.getString(currencyNumberNames.get(i));
                if (currencyIds.contains(currnecyId)) continue;
                currencyIds.add(currnecyId);
                if (EmptyUtil.isEmpty((String)currnecyNumber) || currnecyNumber.equals(toCurrency.getString("number"))) {
                    rate = BigDecimal.ONE;
                } else if (EmptyUtil.isNoEmpty((DynamicObject)forexQuote) && (rate = (BigDecimal)exchgRateCache.get(cuPair = currnecyNumber + "/" + toCurrency.getString("number"))) == null) {
                    ForexQuoteInfo fQuoteInfo = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)((Long)forexQuote.getPkValue()), (String)cuPair, (Date)endDate, null);
                    if (fQuoteInfo == null) {
                        tipPairs.add(cuPair);
                        continue;
                    }
                    rate = cuPair.equals(fQuoteInfo.getFxquote()) ? fQuoteInfo.getBuyPrice() : BigDecimal.ONE.divide(fQuoteInfo.getSellPrice(), 19, RoundingMode.HALF_UP);
                    exchgRateCache.put(cuPair, rate);
                }
                Object[] obj = new Object[]{currnecyId, rate};
                rateList.add(obj);
            }
        }
        return algo.createDataSet(rateList, rowMeta);
    }

    public static String[] concat(String[] a, String[] b) {
        String[] newArry = new String[a.length + b.length];
        System.arraycopy(a, 0, newArry, 0, a.length);
        System.arraycopy(b, 0, newArry, a.length, b.length);
        return newArry;
    }

    public static Set<Long> getDataSetIds(DataSet dataSet, String idField) {
        DataSet fsDS = dataSet.copy();
        HashSet<Long> ids = new HashSet<Long>(16);
        for (Row row : fsDS) {
            ids.add(row.getLong(idField));
        }
        return ids;
    }

    public static void dealFilter(List<QFilter> qFilters, String property, FilterItemInfo filterItemInfo) {
        if (EmptyUtil.isNoEmpty((Object)filterItemInfo.getValue())) {
            if (filterItemInfo.getValue() instanceof DynamicObjectCollection) {
                DynamicObjectCollection col = (DynamicObjectCollection)filterItemInfo.getValue();
                if (col.size() == 1) {
                    qFilters.add(new QFilter(property, "=", (Object)((DynamicObject)col.get(0)).getLong("id")));
                } else {
                    HashSet<Long> ids = new HashSet<Long>(col.size());
                    for (DynamicObject obj : col) {
                        ids.add(obj.getLong("id"));
                    }
                    qFilters.add(new QFilter(property, "in", ids));
                }
            } else if (filterItemInfo.getValue() instanceof DynamicObject) {
                qFilters.add(new QFilter(property, "=", ((DynamicObject)filterItemInfo.getValue()).getPkValue()));
            } else if (filterItemInfo.getValue() instanceof String) {
                qFilters.add(new QFilter(property, "=", filterItemInfo.getValue()));
            }
        }
    }
}

