/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.report.plcount;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.tbo.report.helper.ReportHelper;
import kd.tmc.tm.common.enums.BizOperateEnum;

public class ForexPlCountListRpt
extends AbstractTmcTreeReportDataPlugin {
    private boolean isShowFloatPlamt;
    private boolean isShowGainpLossPlamt;
    private boolean isShowTotalPlamt;
    private final List<String> bizRecordAmtList = new ArrayList<String>();
    private final List<String> bizRecordPlList = new ArrayList<String>();
    private final List<String> endDateList = new ArrayList<String>();
    private static final String[] HEAD_SELECT_FIELD = new String[]{"id", "orgtext", "protecttypeid", "biztypeid", "bizamt", "amount", "bizdate", "floatplamt", "gainplamt", "lossplamt", "totalplamt", "coamtcurrency", "plcurrency", "swapdir"};
    private static final String TM_FOREX_QUERY = ",id,pair,amount,bizrestamt,settledelay,billstatus,bizdate,protecttype.number,protecttype.name,'' as swapdir,currency,currency.number as currencynumber";
    private static final String TM_SWAPS_QUERY = ",id,pair,amount,bizrestamt,farbizrestamt,swaptype,settledelay,billstatus,bizdate,protecttype.number,protecttype.name,buyamount_far,'isnear' as swapdir,currency,currency.number as currencynumber";
    private static final String PL_INFO = "id,org,tradebill.id as tradeid,bizrecord as bizrecordid,entrys.biztype,entrys.bizbillplcurrency bizbillplcurrency,entrys.bizbillplcurrency.number bizbillplcurrencynumber, entrys.plamt,entrys.bizdate,swapdir";
    private static final String PL_HISTORY_INFO = "plbill,updatedate,floatplamt,plcurrency,plcurrency.number as plcurrencyNumber";
    private static final String[] DEAL_SELECT = new String[]{"id", "orgtext", "protecttypeid", "biztypeid", "rate", "bizamt", "coamtcurrency", "billstatus", "bizdate", "amount", "swapdir"};
    private static final String BIZ_RECORD = "id recordeid,pid,srcbizbill,lv,seqno,tradebillid,restamt,swapdir,entryentity.bizop,entryentity.opdate,entryentity.amount";
    private String[] groupArr;
    private List<String> amountFields;
    private String[] dimensions;
    private String showType;
    private final List<Long> currencyIds = new ArrayList<Long>();
    private final List<Object[]> rateList = new ArrayList<Object[]>();
    private final List<Long> plCurrencyIds = new ArrayList<Long>();
    private final List<Object[]> plRateList = new ArrayList<Object[]>();
    private final LinkedHashSet<String> tipPairs = new LinkedHashSet(16);

    public DataSet queryDataSet(ReportQueryParam param) {
        Map paramMap = this.transQueryParam(param);
        Date startDate = (Date)paramMap.get("startdate_filter");
        this.groupArr = ForexPlCountListRpt.getStatDim(paramMap);
        this.buildBaseList(paramMap);
        this.buildBizRecordList(paramMap);
        DataSet forexData = this.queryForexData(paramMap);
        DataSet forexAllData = this.querySwapsDataUnionForex(forexData, paramMap);
        DataSet calForexData = this.calForexDataByRateUnit(forexAllData, paramMap).distinct();
        DataSet amountSum = startDate != null ? calForexData.copy().filter("to_char(bizdate, 'yyyyMMdd') >=" + TcDateUtils.formatString((Date)startDate, (String)"yyyyMMdd")).groupBy(this.groupArr).sum("amount").finish() : calForexData.copy().groupBy(this.groupArr).sum("amount").finish();
        DataSet bizRecordData = this.queryBizRecordData(forexAllData);
        calForexData = this.dealHistoryBizRecordDataSet(calForexData, bizRecordData, paramMap);
        DataSet plInfoData = this.queryPlInfoData(calForexData, paramMap);
        DataSet calPlInfoData = this.calPlInfoData(plInfoData, paramMap);
        List<String> selectFields = this.getSelectFields(paramMap);
        String[] dealArray = ReportHelper.concat(HEAD_SELECT_FIELD, this.endDateList.toArray(new String[0]));
        dealArray = ReportHelper.concat(selectFields.toArray(new String[0]), dealArray);
        dealArray = ReportHelper.concat(dealArray, this.bizRecordAmtList.toArray(new String[0]));
        if (!this.bizRecordPlList.isEmpty()) {
            dealArray = ReportHelper.concat(dealArray, this.bizRecordPlList.toArray(new String[0]));
        }
        ArrayList<String> sumFields = new ArrayList<String>(16);
        calForexData = this.updateTextByProtectType(calForexData, paramMap);
        DataSet allDataSet = calForexData.leftJoin(calPlInfoData).on("recordeid", "bizrecordid").select(dealArray).finish();
        allDataSet = allDataSet.filter("org != null");
        DataSet bills = startDate != null ? allDataSet.copy().filter("to_char(bizdate, 'yyyyMMdd') >=" + TcDateUtils.formatString((Date)startDate, (String)"yyyyMMdd")) : allDataSet.copy();
        this.dimensions = ((String)paramMap.get("dimension_filter")).split(",");
        this.showType = (String)paramMap.get("filter_showttype");
        sumFields.add("hbizamt");
        sumFields.add("plamt");
        sumFields.add("floatplamt");
        sumFields.add("gainplamt");
        sumFields.add("lossplamt");
        sumFields.add("totalplamt");
        sumFields.addAll(this.bizRecordAmtList);
        sumFields.addAll(this.bizRecordPlList);
        this.amountFields = sumFields;
        GroupbyDataSet calForexDataGroup = bills.groupBy(ReportHelper.concat(this.groupArr, new String[]{"id", "swapdir"}));
        for (String string : this.amountFields) {
            calForexDataGroup.sum(string);
        }
        bills = calForexDataGroup.finish();
        GroupbyDataSet groupbyDataSet = bills.groupBy(this.groupArr);
        for (String sum : this.amountFields) {
            groupbyDataSet.sum(sum);
        }
        DataSet dataSet = groupbyDataSet.finish();
        JoinDataSet joinDataSet = dataSet.leftJoin(amountSum);
        for (String group : this.groupArr) {
            if ("orgtext".equals(group)) continue;
            joinDataSet.on(group, group);
        }
        this.amountFields.add("contractamt");
        DataSet ds = joinDataSet.select(dataSet.getRowMeta().getFieldNames(), new String[]{"amount contractamt"}).finish();
        ArrayList<String> endSumFields = new ArrayList<String>(16);
        endSumFields.add("hbizamt_end");
        endSumFields.add("floatplamt_end");
        this.amountFields.addAll(endSumFields);
        allDataSet = allDataSet.addFields(new String[]{"hbizamt", "floatplamt"}, new String[]{"hbizamt_end", "floatplamt_end"});
        GroupbyDataSet allDataGroup = allDataSet.groupBy(this.groupArr);
        for (String endSumField : endSumFields) {
            allDataGroup.sum(endSumField);
        }
        DataSet endDataSet = allDataGroup.finish();
        JoinDataSet endJoinDataSet = endDataSet.leftJoin(ds);
        for (String group : this.groupArr) {
            if ("orgtext".equals(group)) continue;
            endJoinDataSet.on(group, group);
        }
        String[] fieldNames = ds.getRowMeta().getFieldNames();
        String[] fields = ReportHelper.concat(fieldNames, new String[]{"hbizamt_end", "floatplamt_end"});
        DataSet allDs = endJoinDataSet.select(fields).finish();
        allDs = allDs.filter("contractamt !=0 and contractamt != null or hbizamt_end != 0 and hbizamt_end != null or floatplamt_end !=0 and floatplamt_end!= null");
        return allDs;
    }

    public DataSet reDealResultDataSet(DataSet dataSet, ReportQueryParam param) {
        if (dataSet == null || dataSet.isEmpty()) {
            return dataSet;
        }
        Map paramMap = this.transQueryParam(param);
        DynamicObject plCurrency = (DynamicObject)paramMap.get("plcurrency_filter");
        DynamicObject coamtCurrency = (DynamicObject)paramMap.get("coamtcurrency_filter");
        return dataSet.addFields(new String[]{String.valueOf(coamtCurrency.getLong("id")), String.valueOf(plCurrency.getLong("id"))}, new String[]{"coamtcurrency", "plcurrency"});
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        boolean showTotal = (Boolean)paramMap.get("total_filter");
        int dimensionLength = this.dimensions.length;
        if (!showTotal || dimensionLength < 2) {
            return bizDs;
        }
        DataSet subTotalDs = bizDs.copy();
        String[] orderBy = this.getOrderBy(paramMap);
        for (int i = 0; i < dimensionLength - 1; ++i) {
            List<String> groups = this.getSubGroups(this.dimensions, i);
            subTotalDs = this.addSubTotalDataSet(subTotalDs, groups, this.amountFields, "orgtext");
            bizDs = bizDs.union(subTotalDs).orderBy(this.getSubOrderBy(orderBy, i));
        }
        return bizDs.updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"}).updateFields(new String[]{"rowid", "pid", "isgroupnode"}, new String[]{this.uniqueRow, "'0'", "'0'"});
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        boolean showTotal = (Boolean)paramMap.get("total_filter");
        if (!showTotal) {
            return bizDs;
        }
        return super.addSumRowDataSet(bizDs, paramMap);
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedOrgTree() {
        return this.dimensions.length == 1 && "org".equals(this.dimensions[0]) && "step".equals(this.showType);
    }

    public List<String> groupFields() {
        return Arrays.asList(this.groupArr);
    }

    public List<String> sumAmountFields() {
        return this.amountFields;
    }

    public String sumNameField() {
        return "orgtext";
    }

    private List<String> getSubGroups(String[] dimensions, int level) {
        ArrayList<String> groups = new ArrayList<String>(6);
        groups.addAll(Arrays.asList(dimensions).subList(0, dimensions.length - level - 1));
        if (groups.contains("protecttype")) {
            groups.add("protecttypeid");
        }
        if (groups.contains("biztype")) {
            groups.add("biztypeid");
        }
        return groups;
    }

    private String[] getSubOrderBy(String[] dimensions, int level) {
        if (dimensions.length < level) {
            return dimensions;
        }
        String[] orders = new String[dimensions.length - level - 1];
        System.arraycopy(dimensions, 0, orders, 0, dimensions.length - level - 1);
        return orders;
    }

    private void buildBaseList(Map<String, Object> param) {
        this.endDateList.add("hbizamt");
        this.endDateList.add("plamt");
        boolean isShowGainloss = (Boolean)param.get("gainloss_filter");
        this.isShowFloatPlamt = !isShowGainloss;
        this.isShowGainpLossPlamt = isShowGainloss;
        this.isShowTotalPlamt = true;
    }

    private DataSet updateTextByProtectType(DataSet calForexData, Map<String, Object> paramMap) {
        String statDim = (String)paramMap.get("dimension_filter");
        if ("protecttype".equals(ReportHelper.getGroupColums(statDim))) {
            String isnear = ResManager.loadKDString((String)"\u5916\u6c47\u6389\u671f-\u8fd1\u7aef", (String)"ForexPlCountListRpt_0", (String)"tmc-tm-report", (Object[])new Object[0]);
            String isfar = ResManager.loadKDString((String)"\u5916\u6c47\u6389\u671f-\u8fdc\u7aef", (String)"ForexPlCountListRpt_1", (String)"tmc-tm-report", (Object[])new Object[0]);
            calForexData = calForexData.updateField("orgtext", String.format("case when swapdir = 'isnear' then '%s' when swapdir = 'isfar' then '%s' else orgtext end", isnear, isfar));
        }
        return calForexData;
    }

    private String[] getOrderBy(Map<String, Object> paramMap) {
        String statDim = (String)paramMap.get("dimension_filter");
        if (statDim.contains("protecttype")) {
            statDim = statDim.replaceAll("protecttype", "protecttypeid");
        }
        if (statDim.contains("biztype")) {
            statDim = statDim.replaceAll("biztype", "biztypeid");
        }
        return statDim.split(",");
    }

    private void buildBizRecordList(Map<String, Object> paramMap) {
        String bizRecordFilter = (String)paramMap.get("bizrecord_filter");
        if (EmptyUtil.isNoEmpty((String)bizRecordFilter)) {
            String[] bizRecords = bizRecordFilter.replaceFirst(",", "").split(",");
            this.bizRecordAmtList.addAll(Arrays.stream(bizRecords).map(b -> b + "_amt").collect(Collectors.toList()));
            this.bizRecordPlList.addAll(Arrays.stream(bizRecords).map(b -> b + "_pl").collect(Collectors.toList()));
        }
    }

    private DataSet queryForexData(Map<String, Object> paramMap) {
        QFilter forexFilter = this.buildForexBaseFilter(paramMap);
        this.buildQueryFilterByForex(paramMap, forexFilter);
        this.buildForexFilterByWipeCom(paramMap, forexFilter);
        this.buildDefineFilter(paramMap, forexFilter);
        String selectField = String.join((CharSequence)",", this.getSelectFields(paramMap));
        String firstColumnText = ReportHelper.getFirstColumnText(paramMap);
        return QueryServiceHelper.queryDataSet((String)"tm_forex_info", (String)"tm_forex_options", (String)(selectField + firstColumnText + TM_FOREX_QUERY), (QFilter[])forexFilter.toArray(), null);
    }

    protected void buildDefineFilter(Map<String, Object> paramMap, QFilter filter) {
        String[] dimensions;
        for (String dimension : dimensions = ((String)paramMap.get("dimension_filter")).split(",")) {
            DynamicObjectCollection counterparties;
            if ("org,protecttype,biztype".contains(dimension) || (counterparties = (DynamicObjectCollection)paramMap.get(dimension + "_filter")) == null || counterparties.isEmpty()) continue;
            filter.and(dimension, "in", counterparties.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
    }

    private DataSet querySwapsDataUnionForex(DataSet forexData, Map<String, Object> paramMap) {
        Set typeNum;
        DynamicObjectCollection protectTypes = (DynamicObjectCollection)paramMap.get("protecttype_filter");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)protectTypes) && (typeNum = protectTypes.stream().filter(f -> ProductTypeEnum.FOREXSWAPS.getId().equals(String.valueOf(f.getLong("id")))).map(s -> s.getLong("id")).collect(Collectors.toSet())).isEmpty()) {
            return forexData;
        }
        QFilter swapsFilter = this.buildForexBaseFilter(paramMap);
        this.buildQueryFilterBySwaps(paramMap, swapsFilter);
        this.buildForexFilterByWipeCom(paramMap, swapsFilter);
        this.buildDefineFilter(paramMap, swapsFilter);
        String selectField = String.join((CharSequence)",", this.getSelectFields(paramMap));
        String firstColumnText = ReportHelper.getFirstColumnText(paramMap);
        boolean isSwapsFilter = (Boolean)paramMap.get("swaps_filter");
        DataSet spotDataSet = QueryServiceHelper.queryDataSet((String)"tm_swaps_info", (String)"tm_forex_swaps", (String)(selectField + firstColumnText + TM_SWAPS_QUERY), (QFilter[])swapsFilter.toArray(), null).updateField("protecttype.name", ResManager.loadKDString((String)"'\u5916\u6c47\u6389\u671f-\u8fd1\u7aef'", (String)"ForexPlCountListRpt_2", (String)"tmc-tm-report", (Object[])new Object[0]));
        spotDataSet = spotDataSet.addField("case when swaptype = 'SpotToSpot' or swaptype = 'SpotToFwd' then 1 else 0 end", "spotflag");
        DataSet farDataSet = spotDataSet.copy().updateFields(new String[]{"biztype", "amount", "bizrestamt", "protecttype.name", "swapdir"}, new String[]{"case when biztype = 'buy' then 'sell' when biztype = 'sell' then 'buy' else 'diff' end", "buyamount_far", "farbizrestamt", ResManager.loadKDString((String)"'\u5916\u6c47\u6389\u671f-\u8fdc\u7aef'", (String)"ForexPlCountListRpt_3", (String)"tmc-tm-report", (Object[])new Object[0]), "'isfar'"});
        farDataSet = farDataSet.updateField("spotflag", "case when swaptype = 'SpotToSpot' then 1 else 0 end");
        DataSet returnData = spotDataSet.union(farDataSet);
        if (!isSwapsFilter) {
            returnData = returnData.filter("spotflag != 1");
        }
        returnData = returnData.removeFields(new String[]{"spotflag"});
        String bizType = (String)paramMap.get("biztype_filter");
        if (EmptyUtil.isNoEmpty((String)bizType)) {
            CharSequence[] bizTypeArray = bizType.replaceFirst(",", "").split(",");
            String join = String.join((CharSequence)"','", bizTypeArray);
            returnData = returnData.filter("biztype in ('" + join + "')");
        }
        return forexData.union(returnData.select(selectField + ",orgtext,id,pair,amount,bizrestamt,settledelay,billstatus,bizdate,protecttype.number,protecttype.name,swapdir,currency,currencynumber"));
    }

    private DataSet queryBizRecordData(DataSet forexData) {
        Set<Long> dataSetIds = ReportHelper.getDataSetIds(forexData, "id");
        QFilter qFilter = new QFilter("tradebillid", "in", dataSetIds);
        return QueryServiceHelper.queryDataSet((String)"tm_bizrecord_data", (String)"tm_bizrecord", (String)BIZ_RECORD, (QFilter[])qFilter.toArray(), null);
    }

    private DataSet dealHistoryBizRecordDataSet(DataSet calForexData, DataSet bizRecordData, Map<String, Object> paramMap) {
        String currUnit = (String)paramMap.get("amtunit_filter");
        String unit = ReportHelper.getUnit(currUnit);
        Date startdate = (Date)paramMap.get("startdate_filter");
        Date enddate = (Date)paramMap.get("enddate_filter");
        String enddateStr = TcDateUtils.formatString((Date)enddate, (String)"yyyyMMdd");
        DataSet ds = bizRecordData.copy();
        HashSet<Long> ids = new HashSet<Long>(16);
        for (Row row : ds) {
            ids.add(row.getLong("srcbizbill"));
        }
        DataSet bizBillDataSet = QueryServiceHelper.queryDataSet((String)"tm_businessbill_info", (String)"tm_businessbill", (String)"id as srcbizbill,bizdate as bizbillopdate", (QFilter[])new QFilter("id", "in", ids).toArray(), null);
        String[] fieldNames = bizRecordData.getRowMeta().getFieldNames();
        bizRecordData = bizRecordData.leftJoin(bizBillDataSet).on("srcbizbill", "srcbizbill").select(fieldNames, new String[]{"to_char(bizbillopdate, 'yyyyMMdd') bizbillopdate"}).finish();
        ArrayList<String> updateList = new ArrayList<String>(16);
        StringBuilder builder = new StringBuilder();
        builder.append("recordeid");
        builder.append(",tradebillid");
        builder.append(",swapdir");
        builder.append(String.format(",restamt/%s restamt", unit));
        builder.append(String.format(",entryentity.amount/%s eamount", unit));
        builder.append(",case when to_char(entryentity.opdate, 'yyyyMMdd') <= '");
        builder.append(enddateStr);
        builder.append("' then ");
        builder.append(String.format("entryentity.amount/%s", unit));
        builder.append(" else 0 end as eamt");
        for (String bizRecord : this.bizRecordAmtList) {
            String[] split = bizRecord.split("_");
            builder.append(",");
            builder.append("case when entryentity.bizop in ('");
            builder.append(split[0]);
            builder.append("','");
            builder.append(split[0]);
            builder.append("_n','");
            builder.append(split[0]);
            builder.append("_f");
            builder.append("') and ");
            builder.append(this.getDateRangeStr("entryentity.opdate", startdate, enddate));
            builder.append(" then ");
            builder.append(String.format("entryentity.amount/%s", unit));
            builder.append(" else 0 end as ");
            builder.append(bizRecord);
            updateList.add(bizRecord + "*rate");
        }
        bizRecordData = bizRecordData.filter("bizbillopdate = null or bizbillopdate <='" + enddateStr + "'");
        DataSet select = bizRecordData.select(builder.toString());
        GroupbyDataSet groupSet = select.groupBy(new String[]{"tradebillid", "swapdir", "recordeid"});
        for (String sum : this.bizRecordAmtList) {
            groupSet.sum(sum);
        }
        groupSet.max("restamt");
        groupSet.sum("eamount");
        groupSet.sum("eamt");
        DataSet gDataset = groupSet.finish();
        List<String> selectFields = this.getSelectFields(paramMap);
        selectFields.add("hbizamt");
        String[] newArray = ReportHelper.concat(this.bizRecordAmtList.toArray(new String[0]), DEAL_SELECT);
        newArray = ReportHelper.concat(selectFields.toArray(new String[0]), newArray);
        newArray = ReportHelper.concat(new String[]{"recordeid"}, newArray);
        for (String sum : this.bizRecordAmtList) {
            gDataset.updateField("sum", "case when " + sum + " = null then 0 else  " + sum + " end");
        }
        gDataset = gDataset.updateFields(new String[]{"eamount", "eamt"}, new String[]{"case when eamount = null then 0 else eamount end", "case when eamt = null then 0 else eamt end"});
        gDataset = gDataset.addField("restamt + eamount - eamt", "hbizamt");
        String[] concat = gDataset.getRowMeta().getFieldNames();
        GroupbyDataSet g2DataSet = gDataset.select(concat).groupBy(new String[]{"recordeid", "tradebillid", "swapdir"});
        g2DataSet.sum("hbizamt");
        for (String sum : this.bizRecordAmtList) {
            g2DataSet.sum(sum);
        }
        DataSet g2Dataset = g2DataSet.finish();
        DataSet dataSet = calForexData.rightJoin(g2Dataset).on("id", "tradebillid").on("swapdir", "swapdir").select(newArray).finish().updateFields(this.bizRecordAmtList.toArray(new String[0]), updateList.toArray(new String[0])).updateFields(new String[]{"hbizamt"}, new String[]{"hbizamt*rate"});
        return dataSet;
    }

    private DataSet queryPlInfoData(DataSet forexData, Map<String, Object> paramMap) {
        DataSet forexDataCopy = forexData.copy();
        HashSet<Long> tradeIds = new HashSet<Long>(16);
        HashSet<Long> bizRecordIds = new HashSet<Long>(16);
        for (Row row : forexDataCopy) {
            tradeIds.add(row.getLong("id"));
            BigDecimal bizRestAmt = row.getBigDecimal("hbizamt");
            if (bizRestAmt == null || bizRestAmt.compareTo(BigDecimal.ZERO) <= 0) continue;
            bizRecordIds.add(row.getLong("recordeid"));
        }
        QFilter qFilter = new QFilter("tradebill.id", "in", tradeIds);
        qFilter.and(new QFilter("bizrecord", "!=", (Object)0L).or(QFilter.isNotNull((String)"bizrecord")));
        DataSet plDataSet = QueryServiceHelper.queryDataSet((String)"tbo_plinfo_data", (String)"tbo_plinfo", (String)PL_INFO, (QFilter[])qFilter.toArray(), null);
        QFilter plFilter = new QFilter("bizrecord", "in", bizRecordIds);
        Date endDate = (Date)paramMap.get("enddate_filter");
        plFilter.and("updatedate", "<=", (Object)endDate);
        String[] fieldNames = plDataSet.getRowMeta().getFieldNames();
        DataSet plHistoryDataSet = QueryServiceHelper.queryDataSet((String)"tbo_plinfo_history_data", (String)"tbo_plinfo_history", (String)PL_HISTORY_INFO, (QFilter[])plFilter.toArray(), (String)"plbill,updatedate");
        DataSet plHDataSet = plHistoryDataSet.groupBy(new String[]{"plbill"}).maxP("updatedate", "floatplamt").maxP("updatedate", "plcurrency").maxP("updatedate", "plcurrencyNumber").finish();
        return plDataSet.leftJoin(plHDataSet).on("id", "plbill").select(fieldNames, new String[]{"floatplamt", "plcurrency", "plcurrencyNumber"}).finish();
    }

    private List<String> getSelectFields(Map<String, Object> paramMap) {
        List fields = (List)paramMap.get("fields");
        HashSet<String> noSelectFields = new HashSet<String>(16);
        noSelectFields.add("orgtext");
        noSelectFields.add("sumlevel");
        noSelectFields.add("hbizamt");
        noSelectFields.add("protecttypeid");
        noSelectFields.add("amount");
        noSelectFields.add("contractamt");
        noSelectFields.add("coamtcurrency");
        noSelectFields.add("plcurrency");
        noSelectFields.add("floatplamt");
        noSelectFields.add("gainplamt");
        noSelectFields.add("lossplamt");
        ArrayList<String> selectField = new ArrayList<String>(16);
        for (String field : fields) {
            if (noSelectFields.contains(field)) continue;
            selectField.add(field);
        }
        return selectField;
    }

    private QFilter buildForexBaseFilter(Map<String, Object> paramMap) {
        QFilter filter = new QFilter("billstatus", "in", (Object)new String[]{TcBillStatusEnum.SURVIVAL.getValue(), TcBillStatusEnum.FINISH.getValue()});
        List orgIds = this.getQueryOrgIds(this.getQueryParam());
        filter.and("org", "in", (Object)orgIds);
        Date endDate = (Date)paramMap.get("enddate_filter");
        if (endDate != null) {
            filter.and(new QFilter("bizdate", "<=", (Object)endDate));
        }
        return filter;
    }

    private void buildQueryFilterByForex(Map<String, Object> paramMap, QFilter filter) {
        DynamicObjectCollection protectTypes = (DynamicObjectCollection)paramMap.get("protecttype_filter");
        Set<Object> typeNum = new HashSet<Long>(4);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)protectTypes)) {
            typeNum = protectTypes.stream().filter(f -> !ProductTypeEnum.FOREXSWAPS.getId().equals(String.valueOf(f.getLong("id")))).map(s -> s.getLong("id")).collect(Collectors.toSet());
        } else {
            typeNum.add(Long.parseLong(ProductTypeEnum.FOREXSPOT.getId()));
            typeNum.add(Long.parseLong(ProductTypeEnum.FOREXFORWARD.getId()));
            typeNum.add(Long.parseLong(ProductTypeEnum.FOREXOPTION.getId()));
        }
        filter.and("protecttype.id", "in", typeNum);
        String bizType = (String)paramMap.get("biztype_filter");
        if (EmptyUtil.isNoEmpty((String)bizType)) {
            String[] bizTypeArray = bizType.replaceFirst(",", "").split(",");
            filter.and("biztype", "in", Arrays.stream(bizTypeArray).collect(Collectors.toSet()));
        }
    }

    private void buildQueryFilterBySwaps(Map<String, Object> paramMap, QFilter filter) {
        filter.and("protecttype.id", "=", (Object)Long.parseLong(ProductTypeEnum.FOREXSWAPS.getId()));
        String bizType = (String)paramMap.get("biztype_filter");
        if (EmptyUtil.isNoEmpty((String)bizType)) {
            String[] bizTypeArray = bizType.replaceFirst(",", "").split(",");
            Set bizTypeSet = Arrays.stream(bizTypeArray).collect(Collectors.toSet());
            if (bizType.contains("buy") && !bizType.contains("sell")) {
                bizTypeSet.add("sell");
            }
            if (!bizType.contains("buy") && bizType.contains("sell")) {
                bizTypeSet.add("buy");
            }
            filter.and("biztype", "in", bizTypeSet);
        }
    }

    private void buildForexFilterByWipeCom(Map<String, Object> paramMap, QFilter forexFilter) {
        DynamicObjectCollection optioncombs;
        Set opIdSet;
        boolean wipecomFilter = (Boolean)paramMap.get("wipecom_filter");
        if (!wipecomFilter) {
            return;
        }
        Date startDate = (Date)paramMap.get("startdate_filter");
        Date enddate = (Date)paramMap.get("enddate_filter");
        enddate = TcDateUtils.addSecond((Date)enddate, (int)86399);
        QFilter filter = new QFilter("billstatus", "=", (Object)TcBillStatusEnum.AUDIT.getValue());
        if (startDate != null) {
            filter.and("auditdate", ">=", (Object)startDate);
        }
        filter.and("auditdate", "<=", (Object)enddate);
        HashSet idSet = new HashSet(16);
        DynamicObjectCollection combtrades = QueryServiceHelper.query((String)"tm_combtrade", (String)"entryentity.tradebill", (QFilter[])filter.toArray());
        Set combIdSet = combtrades.stream().map(e -> e.getLong("entryentity.tradebill")).collect(Collectors.toSet());
        if (EmptyUtil.isNoEmpty(combIdSet)) {
            idSet.addAll(combIdSet);
        }
        if (EmptyUtil.isNoEmpty(opIdSet = (optioncombs = QueryServiceHelper.query((String)"tm_optioncomb", (String)"billno,entrys,entrys.tradeno", (QFilter[])filter.toArray())).stream().map(e -> e.getLong("entrys.tradeno")).collect(Collectors.toSet()))) {
            idSet.addAll(opIdSet);
        }
        if (!idSet.isEmpty()) {
            forexFilter.and("id", "not in", idSet);
        }
    }

    private DataSet calForexDataByRateUnit(DataSet forexData, Map<String, Object> paramMap) {
        DynamicObject currency = (DynamicObject)paramMap.get("coamtcurrency_filter");
        DynamicObject forexQuote = (DynamicObject)paramMap.get("fquote_filter");
        String currUnit = (String)paramMap.get("amtunit_filter");
        Date endDate = (Date)paramMap.get("enddate_filter");
        String unit = ReportHelper.getUnit(currUnit);
        DataSet exchgRateDataSet = ReportHelper.calRateDataSet(this.currencyIds, this.rateList, forexData, forexQuote, currency, Collections.singletonList("currency"), Collections.singletonList("currencynumber"), endDate, this.tipPairs);
        List<String> selectFields = this.getSelectFields(paramMap);
        selectFields.remove("protecttype");
        String[] selectField = new String[]{"id", "orgtext", "rate", "protecttype.name as protecttype", "case when protecttype.number = '01FOREXSPOT' then '1' when protecttype.number = '02FOREXFORWARD' then '2' when protecttype.number = '03FOREXSWAPS' and swapdir = 'isnear' then '3' when protecttype.number = '03FOREXSWAPS' and swapdir = 'isfar' then '4' else '5' end as protecttypeid", "case when biztype = 'buy' then '1' when biztype = 'sell' then '2' else '3' end as biztypeid", String.format("case when billstatus = 'D' then bizrestamt*rate/%s else 0 end as bizamt", unit), String.format("amount*rate/%s as amount", unit), "billstatus", "bizdate", "swapdir", "currency", "currencynumber"};
        selectField = ReportHelper.concat(selectField, selectFields.toArray(new String[0]));
        DataSet finish = forexData.leftJoin(exchgRateDataSet).on("currency", "currency").select(selectField).finish();
        finish = finish.addField(currency.getString("id"), "coamtcurrency");
        return finish;
    }

    private DataSet calPlInfoData(DataSet plInfoData, Map<String, Object> paramMap) {
        DynamicObject currency = (DynamicObject)paramMap.get("plcurrency_filter");
        DynamicObject forexQuote = (DynamicObject)paramMap.get("fquote_filter");
        String currUnit = (String)paramMap.get("amtunit_filter");
        String unit = ReportHelper.getUnit(currUnit);
        Date startDate = (Date)paramMap.get("startdate_filter");
        Date enddate = (Date)paramMap.get("enddate_filter");
        String dateRangeStr = this.getDateRangeStr("entrys.bizdate", startDate, enddate);
        DataSet exchgRateDataSet = ReportHelper.calRateDataSet(this.plCurrencyIds, this.plRateList, plInfoData, forexQuote, currency, Arrays.asList("plcurrency", "bizbillplcurrency"), Arrays.asList("plcurrencyNumber", "bizbillplcurrencynumber"), enddate, this.tipPairs);
        if (!EmptyUtil.isEmpty(this.tipPairs)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u201c%1$s\u201d\u5728\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"ForwRateAgreeListRpt_0", (String)"tmc-tm-report", (Object[])new Object[0]), String.join((CharSequence)"\u3001", this.tipPairs), forexQuote.getString("number")));
        }
        String[] selectField = new String[]{"id", "tradeid", "org", "plcurrency", "swapdir", "bizrecordid", "bizbillplcurrency", "bizbillplcurrencynumber", String.format("floatplamt*rate/%s as floatplamt", unit), String.format("case when floatplamt > 0 then floatplamt*rate/%s else 0 end as gainplamt", unit), String.format("case when floatplamt < 0 then floatplamt*rate/%s else 0 end as lossplamt", unit), "case when " + dateRangeStr + String.format(" then entrys.plamt/%s else 0 end as plamt", unit)};
        String[] select = new String[this.bizRecordPlList.size()];
        for (int i = 0; i < this.bizRecordPlList.size(); ++i) {
            String bizRecord = this.bizRecordPlList.get(i);
            String[] split = bizRecord.split("_");
            String string = split[0];
            select[i] = "case when entrys.biztype in ('" + string + "','" + string + "_n','" + string + "_f') and " + dateRangeStr + String.format(" then entrys.plamt/%s else 0 end as ", unit) + bizRecord;
        }
        String[] concat = ReportHelper.concat(select, selectField);
        DataSet plDataSet = plInfoData.leftJoin(exchgRateDataSet.distinct()).on("plcurrency", "currency").select(concat).finish();
        plDataSet = plDataSet.leftJoin(exchgRateDataSet.distinct()).on("bizbillplcurrency", "currency").select(plDataSet.getRowMeta().getFieldNames(), new String[]{"rate as plexrate"}).finish();
        plDataSet = plDataSet.updateField("plamt", "plamt*plexrate");
        for (String string : this.bizRecordPlList) {
            plDataSet = plDataSet.updateField(string, string + "*plexrate");
        }
        GroupbyDataSet groupbyDataSet = plDataSet.groupBy(new String[]{"id", "tradeid", "bizrecordid", "org", "swapdir", "plcurrency"});
        for (String hisBizRecord : this.bizRecordPlList) {
            groupbyDataSet.sum(hisBizRecord);
        }
        groupbyDataSet.sum("plamt");
        groupbyDataSet.max("floatplamt");
        groupbyDataSet.max("gainplamt");
        groupbyDataSet.max("lossplamt");
        DataSet dataSet2 = groupbyDataSet.finish();
        dataSet2 = dataSet2.addField("floatplamt + plamt", "totalplamt");
        return dataSet2;
    }

    private String getDateRangeStr(String field, Date startDate, Date enddate) {
        StringBuilder sb = new StringBuilder();
        String enddateStr = TcDateUtils.formatString((Date)enddate, (String)"yyyyMMdd");
        if (startDate != null) {
            String startDateStr = TcDateUtils.formatString((Date)startDate, (String)"yyyyMMdd");
            sb.append("to_char(").append(field).append(", 'yyyyMMdd') >= ").append(startDateStr).append(" and to_char(").append(field).append(", 'yyyyMMdd') <= ").append(enddateStr);
        } else {
            sb.append("to_char(").append(field).append(", 'yyyyMMdd') <= ").append(enddateStr);
        }
        return sb.toString();
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        String[] split;
        if (this.isShowFloatPlamt) {
            columns.add((AbstractReportColumn)this.createColum("floatplamt", "plcurrency", new LocaleString(ResManager.loadKDString((String)"\u6d6e\u52a8\u635f\u76ca", (String)"ForexPlCountListRpt_4", (String)"tmc-tm-report", (Object[])new Object[0]))));
        }
        if (this.isShowGainpLossPlamt) {
            columns.add((AbstractReportColumn)this.createColum("gainplamt", "plcurrency", new LocaleString(ResManager.loadKDString((String)"\u6d6e\u52a8\u76c8\u5229", (String)"ForexPlCountListRpt_5", (String)"tmc-tm-report", (Object[])new Object[0]))));
            columns.add((AbstractReportColumn)this.createColum("lossplamt", "plcurrency", new LocaleString(ResManager.loadKDString((String)"\u6d6e\u52a8\u4e8f\u635f", (String)"ForexPlCountListRpt_6", (String)"tmc-tm-report", (Object[])new Object[0]))));
        }
        columns.add((AbstractReportColumn)this.createColum("plamt", "plcurrency", new LocaleString(ResManager.loadKDString((String)"\u5df2\u5b9e\u73b0\u635f\u76ca", (String)"ForexPlCountListRpt_7", (String)"tmc-tm-report", (Object[])new Object[0]))));
        if (this.isShowTotalPlamt) {
            columns.add((AbstractReportColumn)this.createColum("totalplamt", "plcurrency", new LocaleString(ResManager.loadKDString((String)"\u603b\u635f\u76ca", (String)"ForexPlCountListRpt_8", (String)"tmc-tm-report", (Object[])new Object[0]))));
        }
        ReportColumn hbizamtEndColum = this.createColum("hbizamt_end", "coamtcurrency", new LocaleString(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u6301\u4ed3\u91d1\u989d", (String)"ForexPlCountListRpt_11", (String)"tmc-tm-report", (Object[])new Object[0])));
        hbizamtEndColum.setCtlTips(new Tips("text", null, new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u5230\u7edf\u8ba1\u622a\u6b62\u65e5\u671f\u7684\u4ea4\u6613\u6301\u4ed3\u91d1\u989d", (String)"ForexPlCountFilterRpt_14", (String)"tmc-tm-report", (Object[])new Object[0])), false, null));
        columns.add((AbstractReportColumn)hbizamtEndColum);
        ReportColumn floatplamtEndColum = this.createColum("floatplamt_end", "plcurrency", new LocaleString(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u6d6e\u52a8\u635f\u76ca", (String)"ForexPlCountListRpt_12", (String)"tmc-tm-report", (Object[])new Object[0])));
        floatplamtEndColum.setCtlTips(new Tips("text", null, new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u5230\u7edf\u8ba1\u622a\u6b62\u65e5\u671f\u7684\u4ea4\u6613\u6d6e\u52a8\u635f\u76ca", (String)"ForexPlCountFilterRpt_15", (String)"tmc-tm-report", (Object[])new Object[0])), false, null));
        columns.add((AbstractReportColumn)floatplamtEndColum);
        for (String bizRecord : this.bizRecordAmtList) {
            split = bizRecord.split("_");
            columns.add((AbstractReportColumn)this.createColum(bizRecord, "coamtcurrency", new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\u91d1\u989d", (String)"ForexPlCountListRpt_9", (String)"tmc-tm-report", (Object[])new Object[0]), BizOperateEnum.getName((String)split[0])))));
        }
        for (String bizRecord : this.bizRecordPlList) {
            split = bizRecord.split("_");
            columns.add((AbstractReportColumn)this.createColum(bizRecord, "plcurrency", new LocaleString(String.format(ResManager.loadKDString((String)"%1$s\u635f\u76ca", (String)"ForexPlCountListRpt_10", (String)"tmc-tm-report", (Object[])new Object[0]), BizOperateEnum.getName((String)split[0])))));
        }
        return columns;
    }

    private ReportColumn createColum(String field, String currencyField, LocaleString res) {
        ReportColumn col = new ReportColumn();
        col.setFieldKey(field);
        col.setFieldType("amount");
        col.setZeroShow(false);
        col.setCurrencyField(currencyField);
        col.setCaption(res);
        return col;
    }

    private static String[] getStatDim(Map<String, Object> paramMap) {
        String statDim = (String)paramMap.get("dimension_filter");
        Set<String> otherStatdim = Arrays.stream(statDim.split(",")).collect(Collectors.toSet());
        otherStatdim.add("orgtext");
        if (statDim.contains("protecttype")) {
            otherStatdim.add("protecttypeid");
        }
        if (statDim.contains("biztype")) {
            otherStatdim.add("biztypeid");
        }
        String[] statDimArr = new String[otherStatdim.size()];
        return otherStatdim.toArray(statDimArr);
    }
}

