/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.report.plcount;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tbo.common.enums.DateRangeEnum;
import kd.tmc.tbo.report.helper.ReportHelper;

public class ForexPlDetailFilterRpt
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit protectType = (BasedataEdit)this.getView().getControl("protecttype_filter");
        protectType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ((ReportList)this.getControl("reportlistap")).addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit forexquote = (BasedataEdit)this.getView().getControl("fquote_filter");
        Optional.ofNullable(forexquote).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams.containsKey("detail")) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"containsfinished_filter", (Object)1);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("detail")) {
            this.protectTypeFilterChanged();
        }
        this.setMinDateForEndDate();
        this.setMaxDateForStartDate();
    }

    public void afterSetModelValue(DynamicObject scheme) {
        ReportHelper.setDateFilterAfterSchemeLoad(this.getView(), scheme, "daterange_filter", "startdate_filter", "enddate_filter");
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        Long orgId = RequestContext.get().getOrgId();
        String appId = this.getView().getFormShowParameter().getAppId();
        List orgIds = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        if (orgIds.contains(orgId)) {
            this.getModel().setItemValueByID("filter_org", (Object)orgId);
            this.setPlCurrencyByOrg(orgId);
        }
        this.protectTypeFilterChanged();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "protecttype_filter": {
                this.protectTypeFilterChanged();
                break;
            }
            case "filter_org": {
                this.orgFilterChanged();
                break;
            }
            case "startdate_filter": {
                this.setMinDateForEndDate();
                break;
            }
            case "daterange_filter": {
                Date currentDate = TcDateUtils.getCurrentDate();
                this.getModel().setValue("enddate_filter", (Object)currentDate);
                if (DateRangeEnum.WEEK.getValue().equals(this.getModel().getValue("daterange_filter"))) {
                    this.getModel().setValue("startdate_filter", (Object)TcDateUtils.getFirstDayOfWeek((Date)currentDate));
                    break;
                }
                if (DateRangeEnum.MONTH.getValue().equals(this.getModel().getValue("daterange_filter"))) {
                    this.getModel().setValue("startdate_filter", (Object)TcDateUtils.getFirstDayOfMonth((Date)currentDate));
                    break;
                }
                if (DateRangeEnum.YEAR.getValue().equals(this.getModel().getValue("daterange_filter"))) {
                    this.getModel().setValue("startdate_filter", (Object)TcDateUtils.getFirstYearDate((Date)currentDate));
                    break;
                }
                this.getModel().setValue("startdate_filter", null);
                break;
            }
            case "enddate_filter": {
                this.setMaxDateForStartDate();
            }
        }
    }

    private void setMinDateForEndDate() {
        Date startDate = (Date)this.getModel().getValue("startdate_filter");
        if (startDate != null) {
            ((DateEdit)this.getView().getControl("enddate_filter")).setMinDate(startDate);
        } else {
            ((DateEdit)this.getView().getControl("enddate_filter")).setMinDate(TcDateUtils.stringToDate((String)"1900-01-01", (String)"yyyy-MM-dd"));
        }
    }

    private void setMaxDateForStartDate() {
        Date endDate = (Date)this.getModel().getValue("enddate_filter");
        if (endDate != null) {
            ((DateEdit)this.getView().getControl("startdate_filter")).setMaxDate(endDate);
        } else {
            ((DateEdit)this.getView().getControl("startdate_filter")).setMaxDate(TcDateUtils.stringToDate((String)"2999-12-31", (String)"yyyy-MM-dd"));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String fieldKey = evt.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"protecttype_filter")) {
            showParameter.getTreeFilterParameter().getQFilters().add(new QFilter("longnumber", "like", (Object)"TRADE.01FOREX%"));
        } else if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)"org_filter")) {
            String appId = this.getView().getFormShowParameter().getAppId();
            List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)comIdList));
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        queryParam.getFilter().addFilterItem("fields", this.getAllFields());
        if (customParams.containsKey("detail") && customParams.containsKey("isfar")) {
            boolean isfar = (Boolean)customParams.get("isfar");
            queryParam.getCustomParam().put("isfar", isfar);
        }
        if (customParams.containsKey("queryDetail")) {
            queryParam.getCustomParam().put("queryDetail", customParams.get("queryDetail"));
        }
        if (customParams.containsKey("isgroupnode")) {
            queryParam.getCustomParam().put("isgroupnode", customParams.get("isgroupnode"));
        }
        queryParam.getCustomParam().put("formid", formShowParameter.getFormId());
        String appId = FormMetadataCache.getFormConfig((String)formShowParameter.getFormId()).getAppId();
        queryParam.getCustomParam().put("appid", appId);
    }

    private List<String> getAllFields() {
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        return this.getFieldKeys(reportList.getColumns());
    }

    private List<String> getFieldKeys(List<AbstractReportColumn> columns) {
        ArrayList<String> list = new ArrayList<String>(8);
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                list.add(((ReportColumn)column).getFieldKey());
                continue;
            }
            list.addAll(this.getFieldKeys(((ReportColumnGroup)column).getChildren()));
        }
        return list;
    }

    public boolean verifyQuery(ReportQueryParam param) {
        FilterInfo filters = param.getFilter();
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("coamtcurrency_filter").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u7ea6\u91d1\u989d\u62a5\u544a\u5e01\u79cd\u3002", (String)"ForexPlDetailFilterRpt_0", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("plcurrency_filter").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u635f\u76ca\u62a5\u544a\u5e01\u79cd\u3002", (String)"ForexPlDetailFilterRpt_1", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("fquote_filter").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5916\u6c47\u62a5\u4ef7\u3002", (String)"ForexPlDetailFilterRpt_2", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("enddate_filter").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u622a\u6b62\u65e5\u671f\u3002", (String)"ForexPlDetailFilterRpt_3", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("enddate_filter").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u622a\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForexPlDetailFilterRpt_4", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private void setPlCurrencyByOrg(Long orgId) {
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        this.getModel().setValue("plcurrency_filter", (Object)localCurrencyId);
    }

    private void protectTypeFilterChanged() {
        DynamicObjectCollection protectType = (DynamicObjectCollection)this.getModel().getValue("protecttype_filter");
        boolean isShow = false;
        Set collect = protectType.stream().filter(s -> ProductTypeEnum.FOREXSWAPS.getValue().equals(s.getDynamicObject("fbasedataid").getString("number"))).collect(Collectors.toSet());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)protectType) || EmptyUtil.isNoEmpty((DynamicObjectCollection)protectType) && collect.size() > 0) {
            isShow = true;
        }
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"swaps_filter"});
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if ("billno".equals(evt.getFieldName())) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            showParameter.setPkId((Object)evt.getRowData().getLong("id"));
            int protecttypeid = evt.getRowData().getInt("protecttypeid");
            String formId = protecttypeid == 1 ? "tm_forex" : (protecttypeid == 2 ? "tm_forex_forward" : (protecttypeid == 3 ? "tm_forex_swaps" : "tm_forex_options"));
            showParameter.setFormId(formId);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private void orgFilterChanged() {
        DynamicObjectCollection org = this.getModel().getDataEntity().getDynamicObjectCollection("filter_org");
        if (org.size() == 1) {
            this.setPlCurrencyByOrg(((DynamicObject)org.get(0)).getDynamicObject("fbasedataid").getLong("id"));
        }
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("fquote_filter".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            String formid = "md_forexquote";
            billShowParameter.setFormId(formid);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }
}

