/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.report.structdeposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;

public class StructDepositReportDataListPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String TM_STRUCTDEPOSIT = "billno,org,org.name,org.number,currency,currency.number,structtype,bizdate,billstatus,amount";
    private static final String TBO_PLINFO = "tradebill.number,plcurrency,plcurrency.number,floatplamt,type,entrys.bizdate,entrys.plamt";
    private Map<String, String> ORG_MAP = new HashMap<String, String>(16);
    private Map<String, String> CUR_MAP = new HashMap<String, String>(16);
    private Map<String, Long> CUR_ID_MAP = new HashMap<String, Long>(16);
    private String CUPAIR = "";
    private ForexQuoteInfo FQUOTE_INFO = null;
    private final LinkedHashSet<String> tipPairs = new LinkedHashSet(16);

    private String getCountFlag() {
        return ResManager.loadKDString((String)"\u5c0f\u8ba1", (String)"StructDepositReportDataListPlugin_0", (String)"tmc-tm-report", (Object[])new Object[0]);
    }

    private String getTotalFlag() {
        return ResManager.loadKDString((String)"\u603b\u8ba1", (String)"StructDepositReportDataListPlugin_1", (String)"tmc-tm-report", (Object[])new Object[0]);
    }

    public DataSet queryDataSet(ReportQueryParam queryParam) {
        return null;
    }

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        List orgIds = this.getQueryOrgIds(reportQueryParam);
        Map orgMap = TmcDataServiceHelper.loadFromCache((Object[])orgIds.toArray(), (String)"bos_org");
        Collection<DynamicObject> orgColl = orgMap.values();
        DynamicObjectCollection tradCurColl = (DynamicObjectCollection)this.getFilterValue("filter_tradcurrency", reportQueryParam);
        Object structString = this.getFilterValue("filter_structtype", reportQueryParam);
        String[] structArray = EmptyUtil.isNoEmpty((Object)structString) ? structString.toString().replaceFirst(",", "").split(",") : new String[]{"break", "total"};
        DynamicObject conCurrency = (DynamicObject)this.getFilterValue("filter_contcurrency", reportQueryParam);
        DynamicObject plCurrency = (DynamicObject)this.getFilterValue("filter_plcurrency", reportQueryParam);
        DynamicObject forexQuote = (DynamicObject)this.getFilterValue("filter_forexquote", reportQueryParam);
        String dimension = (String)this.getFilterValue("filter_dimension", reportQueryParam);
        BigDecimal curUnit = this.getAmtUnit((String)this.getFilterValue("filter_currencyunit", reportQueryParam));
        String timeSection = (String)this.getFilterValue("filter_timesection", reportQueryParam);
        QFilter structFilter = this.buildStructFilter(orgIds, tradCurColl, structArray);
        DataSet structBills = QueryServiceHelper.queryDataSet((String)"tm_structdeposit_key", (String)"tm_structdeposit", (String)TM_STRUCTDEPOSIT, (QFilter[])new QFilter[]{structFilter}, (String)"org.id,currency.id,structtype");
        DataSet structBills2 = structBills.copy();
        HashSet<String> billnos = new HashSet<String>(16);
        for (Row structBill : structBills) {
            billnos.add(structBill.getString("billno"));
        }
        QFilter billnoFilter = new QFilter("tradebill.number", "in", billnos);
        DataSet plbills = QueryServiceHelper.queryDataSet((String)"tbo_plinfo_key", (String)"tbo_plinfo", (String)TBO_PLINFO, (QFilter[])new QFilter[]{billnoFilter}, (String)"tradebill");
        DataSet allBills = structBills2.join(plbills, JoinType.LEFT).on("billno", "tradebill.number").select("billno,org,org.name,org.number,currency,currency.number,structtype,bizdate,billstatus,amount,tradebill.number,plcurrency,plcurrency.number,floatplamt,type,entrys.bizdate,entrys.plamt".split(",")).finish();
        Date currentDate = TcDateUtils.getCurrentDate();
        Date firstDayOfWeek = TcDateUtils.getFirstDayOfWeek((Date)currentDate);
        Date lastDayOfWeek = TcDateUtils.getNextWeekMonday((Date)currentDate);
        Date firstDayOfMonth = TcDateUtils.getFirstDayOfCurMonth();
        Date lastDayOfMonth = TcDateUtils.getLastDayOfCurMonth();
        Date firstDayOfYear = TcDateUtils.getFirstDayOfCurYear();
        Date lastDayOfYear = TcDateUtils.getLastDayOfCurYear();
        DataSet DBills = allBills.copy().filter("billstatus = 'D'");
        DataSet DEBills = allBills.copy().filter("billstatus = 'D'or billstatus = 'E'");
        DataSet weekBills = this.filterStructDataBills(DEBills, firstDayOfWeek, lastDayOfWeek);
        DataSet monBills = this.filterStructDataBills(DEBills, firstDayOfMonth, lastDayOfMonth);
        DataSet yearBills = this.filterStructDataBills(DEBills, firstDayOfYear, lastDayOfYear);
        DataSet floatBills = DBills.copy().filter("type != 'AC'");
        DataSet interBills = DBills.copy().filter("type = 'AC'");
        DataSet weekPlBills = this.filterPlDataBills(allBills, firstDayOfWeek, lastDayOfWeek);
        DataSet monPlBills = this.filterPlDataBills(allBills, firstDayOfMonth, lastDayOfMonth);
        DataSet plCountBills = this.filterPlDataBills(allBills, firstDayOfYear, lastDayOfYear);
        ArrayList<DynamicObject> tradCurList = new ArrayList<DynamicObject>(16);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)tradCurColl)) {
            DataSet allBillsCopy = allBills.copy();
            ArrayList<Long> curIds = new ArrayList<Long>(16);
            for (Row row : allBillsCopy) {
                if (curIds.contains(row.getLong("currency"))) continue;
                curIds.add(row.getLong("currency"));
            }
            curIds.forEach(c -> tradCurList.add(BusinessDataServiceHelper.loadSingleFromCache((Object)c, (String)"bd_currency")));
        } else {
            tradCurColl.forEach(t -> tradCurList.add((DynamicObject)t));
        }
        Map<String, BigDecimal> map = this.initMap(dimension, orgColl, tradCurList, structArray);
        Map<String, BigDecimal> DSumMap = this.buildSumAmtReportMap(map, DBills.copy(), conCurrency, dimension, "amount", forexQuote);
        Map<String, BigDecimal> weekSumMap = this.buildSumAmtReportMap(map, weekBills.copy(), conCurrency, dimension, "amount", forexQuote);
        Map<String, BigDecimal> monSumMap = this.buildSumAmtReportMap(map, monBills.copy(), conCurrency, dimension, "amount", forexQuote);
        Map<String, BigDecimal> yearSumMap = this.buildSumAmtReportMap(map, yearBills.copy(), conCurrency, dimension, "amount", forexQuote);
        Map<String, BigDecimal> floatPlSumMap = this.buildSumAmtReportMap(map, floatBills.copy(), plCurrency, dimension, "floatplamt", forexQuote);
        Map<String, BigDecimal> weekPlSumMap = this.buildSumAmtReportMap(map, weekPlBills.copy(), plCurrency, dimension, "entrys.plamt", forexQuote);
        Map<String, BigDecimal> monPlSumMap = this.buildSumAmtReportMap(map, monPlBills.copy(), plCurrency, dimension, "entrys.plamt", forexQuote);
        Map<String, BigDecimal> yearPlSumMap = this.buildSumAmtReportMap(map, plCountBills.copy(), plCurrency, dimension, "entrys.plamt", forexQuote);
        Map<String, BigDecimal> interPlSumMap = this.buildSumAmtReportMap(map, interBills.copy(), plCurrency, dimension, "floatplamt", forexQuote);
        if (!EmptyUtil.isEmpty(this.tipPairs)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u201c%1$s\u201d\u5728\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"ForwRateAgreeListRpt_0", (String)"tmc-tm-report", (Object[])new Object[0]), String.join((CharSequence)"\u3001", this.tipPairs), forexQuote.getString("number")));
        }
        Map<String, BigDecimal> DSumOriginalMap = null;
        Map<String, BigDecimal> weekSumOriginalMap = null;
        Map<String, BigDecimal> monSumOriginalMap = null;
        Map<String, BigDecimal> yearSumOriginalMap = null;
        Map<String, BigDecimal> floatPlSumOriginalMap = null;
        Map<String, BigDecimal> weekPlSumOriginalMap = null;
        Map<String, BigDecimal> monPlSumOriginalMap = null;
        Map<String, BigDecimal> yearPlOriginalMap = null;
        Map<String, BigDecimal> interPlSumOriginalMap = null;
        if (!dimension.equals("org")) {
            DSumOriginalMap = this.buildSumAmtOriginalMap(map, DBills.copy(), dimension, "amount");
            weekSumOriginalMap = this.buildSumAmtOriginalMap(map, weekBills.copy(), dimension, "amount");
            monSumOriginalMap = this.buildSumAmtOriginalMap(map, monBills.copy(), dimension, "amount");
            yearSumOriginalMap = this.buildSumAmtOriginalMap(map, yearBills.copy(), dimension, "amount");
            floatPlSumOriginalMap = this.buildSumAmtOriginalMap(map, floatBills.copy(), dimension, "floatplamt");
            weekPlSumOriginalMap = this.buildSumAmtOriginalMap(map, weekPlBills.copy(), dimension, "entrys.plamt");
            monPlSumOriginalMap = this.buildSumAmtOriginalMap(map, monPlBills.copy(), dimension, "entrys.plamt");
            yearPlOriginalMap = this.buildSumAmtOriginalMap(map, plCountBills.copy(), dimension, "entrys.plamt");
            interPlSumOriginalMap = this.buildSumAmtOriginalMap(map, interBills.copy(), dimension, "floatplamt");
        }
        return this.buildFinalData(map.keySet(), DSumMap, weekSumMap, monSumMap, yearSumMap, floatPlSumMap, weekPlSumMap, monPlSumMap, yearPlSumMap, interPlSumMap, DSumOriginalMap, weekSumOriginalMap, monSumOriginalMap, yearSumOriginalMap, floatPlSumOriginalMap, weekPlSumOriginalMap, monPlSumOriginalMap, yearPlOriginalMap, interPlSumOriginalMap, curUnit, conCurrency, plCurrency, dimension, timeSection);
    }

    private DataSet filterStructDataBills(DataSet forexDataBills, Date firstDay, Date lastDay) {
        return forexDataBills.copy().filter("to_char(bizdate, 'yyyyMMdd') >= " + TcDateUtils.formatString((Date)firstDay, (String)"yyyyMMdd") + " and to_char(bizdate, 'yyyyMMdd') <= " + TcDateUtils.formatString((Date)lastDay, (String)"yyyyMMdd"));
    }

    private DataSet filterPlDataBills(DataSet plDataBills, Date firstDay, Date lastDay) {
        return plDataBills.copy().filter("to_char(entrys.bizdate, 'yyyyMMdd') >= " + TcDateUtils.formatString((Date)firstDay, (String)"yyyyMMdd") + " and to_char(entrys.bizdate, 'yyyyMMdd') <= " + TcDateUtils.formatString((Date)lastDay, (String)"yyyyMMdd"));
    }

    private Map<String, BigDecimal> buildSumAmtOriginalMap(Map<String, BigDecimal> map, DataSet Bills, String dimension, String amtField) {
        LinkedHashMap<String, BigDecimal> sumMap = new LinkedHashMap<String, BigDecimal>(map);
        for (Row row : Bills) {
            String tradCurrencyNumber = row.getString("currency.number");
            String key = this.getKey(row, dimension);
            BigDecimal amt = sumMap.get(key) == null ? BigDecimal.ZERO : (BigDecimal)sumMap.get(key);
            BigDecimal rowAmt = row.getBigDecimal(amtField) == null ? BigDecimal.ZERO : row.getBigDecimal(amtField);
            sumMap.put(key, amt.add(rowAmt));
            if (!dimension.equals("org_currency_type")) continue;
            String countKey = row.getString("org.number") + "/" + tradCurrencyNumber + this.getCountFlag();
            BigDecimal countAmt = sumMap.get(countKey) == null ? BigDecimal.ZERO : (BigDecimal)sumMap.get(countKey);
            sumMap.put(countKey, countAmt.add(rowAmt));
        }
        return sumMap;
    }

    private Map<String, BigDecimal> buildSumAmtReportMap(Map<String, BigDecimal> map, DataSet Bills, DynamicObject currency, String dimension, String amtField, DynamicObject forexQuote) {
        LinkedHashMap<String, BigDecimal> sumMap = new LinkedHashMap<String, BigDecimal>(map);
        for (Row row : Bills) {
            String tradCurrencyNumber = row.getString("currency.number");
            String key = this.getKey(row, dimension);
            BigDecimal amt = sumMap.get(key) == null ? BigDecimal.ZERO : (BigDecimal)sumMap.get(key);
            BigDecimal rowAmt = row.getBigDecimal(amtField) == null ? BigDecimal.ZERO : row.getBigDecimal(amtField);
            BigDecimal calRowAmt = BigDecimal.ZERO;
            if (EmptyUtil.isNoEmpty((String)tradCurrencyNumber)) {
                if (currency.getString("number").equals(tradCurrencyNumber)) {
                    calRowAmt = rowAmt;
                } else {
                    String cuPair = tradCurrencyNumber + "/" + currency.getString("number");
                    calRowAmt = this.calForexAmt(rowAmt, cuPair, forexQuote, this.tipPairs);
                }
                sumMap.put(key, amt.add(calRowAmt));
                sumMap.put(this.getTotalFlag(), ((BigDecimal)sumMap.get(this.getTotalFlag())).add(calRowAmt));
            }
            switch (dimension) {
                case "org_currency": {
                    String countKey = row.getString("org.number") + this.getCountFlag();
                    BigDecimal countAmt = (BigDecimal)sumMap.get(countKey);
                    sumMap.put(countKey, countAmt.add(calRowAmt));
                    break;
                }
                case "org_currency_type": {
                    String countKey = row.getString("org.number") + this.getCountFlag();
                    BigDecimal countAmt = sumMap.get(countKey) == null ? BigDecimal.ZERO : (BigDecimal)sumMap.get(countKey);
                    sumMap.put(countKey, countAmt.add(calRowAmt));
                    countKey = row.getString("org.number") + "/" + tradCurrencyNumber + this.getCountFlag();
                    countAmt = sumMap.get(countKey) == null ? BigDecimal.ZERO : (BigDecimal)sumMap.get(countKey);
                    sumMap.put(countKey, countAmt.add(calRowAmt));
                }
            }
        }
        return sumMap;
    }

    private DataSet buildFinalData(Set<String> keySet, Map<String, BigDecimal> DSumMap, Map<String, BigDecimal> weekSumMap, Map<String, BigDecimal> monSumMap, Map<String, BigDecimal> yearSumMap, Map<String, BigDecimal> floatPlSumMap, Map<String, BigDecimal> weekPlSumMap, Map<String, BigDecimal> monPlSumMap, Map<String, BigDecimal> yearPlSumMap, Map<String, BigDecimal> interPlSumMap, Map<String, BigDecimal> DSumOriginalMap, Map<String, BigDecimal> weekSumOriginalMap, Map<String, BigDecimal> monSumOriginalMap, Map<String, BigDecimal> yearSumOriginalMap, Map<String, BigDecimal> floatPlSumOriginalMap, Map<String, BigDecimal> weekPlSumOriginalMap, Map<String, BigDecimal> monPlSumOriginalMap, Map<String, BigDecimal> yearPlOriginalMap, Map<String, BigDecimal> interPlSumOriginalMap, BigDecimal amtUnit, DynamicObject coCurrency, DynamicObject plCurrency, String dimension, String timeSection) {
        RowMeta rowMeta = new RowMeta(this.getField(keySet).toArray(new Field[0]));
        ArrayList<Object[]> valueList = new ArrayList<Object[]>(keySet.size());
        String[] time = timeSection.replaceFirst(",", "").split(",");
        Set timeSet = Arrays.stream(time).collect(Collectors.toSet());
        for (String key : keySet) {
            Object[] valueArray = new Object[31];
            String[] dimensionArray = key.split("/");
            if (dimensionArray[0].contains(this.getCountFlag())) {
                String orgNumber = dimensionArray[0].replace(this.getCountFlag(), "");
                valueArray[0] = this.ORG_MAP.get(orgNumber) + this.getCountFlag();
            } else if (!dimensionArray[0].contains(this.getTotalFlag())) {
                valueArray[0] = this.ORG_MAP.get(dimensionArray[0]);
            } else if (dimensionArray[0].contains(this.getTotalFlag())) {
                valueArray[0] = this.getTotalFlag();
            }
            if (dimensionArray.length > 1) {
                if (dimensionArray[1].contains(this.getCountFlag())) {
                    String curNumber = dimensionArray[1].replace(this.getCountFlag(), "");
                    valueArray[1] = this.CUR_MAP.get(curNumber) + this.getCountFlag();
                    valueArray[27] = this.CUR_ID_MAP.get(curNumber);
                } else {
                    valueArray[1] = this.CUR_MAP.get(dimensionArray[1]);
                    valueArray[27] = this.CUR_ID_MAP.get(dimensionArray[1]);
                }
            }
            if (dimensionArray.length > 2) {
                valueArray[2] = dimensionArray[2];
            }
            valueArray[4] = DSumMap.get(key).divide(amtUnit, 4);
            valueArray[6] = weekSumMap.get(key).divide(amtUnit, 4);
            valueArray[8] = monSumMap.get(key).divide(amtUnit, 4);
            valueArray[10] = yearSumMap.get(key).divide(amtUnit, 4);
            valueArray[12] = floatPlSumMap.get(key).divide(amtUnit, 4);
            valueArray[14] = weekPlSumMap.get(key).divide(amtUnit, 4);
            valueArray[16] = this.calTotalPlAmount(valueArray[12], valueArray[14]);
            valueArray[18] = monPlSumMap.get(key).divide(amtUnit, 4);
            valueArray[20] = this.calTotalPlAmount(valueArray[12], valueArray[18]);
            valueArray[22] = yearPlSumMap.get(key).divide(amtUnit, 4);
            valueArray[24] = this.calTotalPlAmount(valueArray[12], valueArray[22]);
            valueArray[26] = interPlSumMap.get(key).divide(amtUnit, 4);
            if (!dimension.equals("org")) {
                valueArray[3] = DSumOriginalMap.get(key).divide(amtUnit, 4);
                valueArray[5] = weekSumOriginalMap.get(key).divide(amtUnit, 4);
                valueArray[7] = monSumOriginalMap.get(key).divide(amtUnit, 4);
                valueArray[9] = yearSumOriginalMap.get(key).divide(amtUnit, 4);
                valueArray[11] = floatPlSumOriginalMap.get(key).divide(amtUnit, 4);
                valueArray[13] = weekPlSumOriginalMap.get(key).divide(amtUnit, 4);
                valueArray[15] = this.calTotalPlAmount(valueArray[11], valueArray[13]);
                valueArray[17] = monPlSumOriginalMap.get(key).divide(amtUnit, 4);
                valueArray[19] = this.calTotalPlAmount(valueArray[11], valueArray[17]);
                valueArray[21] = yearPlOriginalMap.get(key).divide(amtUnit, 4);
                valueArray[23] = this.calTotalPlAmount(valueArray[11], valueArray[21]);
                valueArray[25] = interPlSumOriginalMap.get(key).divide(amtUnit, 4);
            }
            valueArray[28] = coCurrency.getPkValue();
            valueArray[29] = plCurrency.getPkValue();
            if (dimensionArray[0].contains(this.getCountFlag()) || dimensionArray[0].contains(this.getTotalFlag()) || dimensionArray.length > 1 && dimensionArray[1].contains(this.getCountFlag())) {
                valueArray[30] = 1;
            }
            boolean isAdd = true;
            boolean week = timeSet.contains("week");
            if (new BigDecimal(String.valueOf(valueArray[6])).compareTo(BigDecimal.ZERO) == 0 && new BigDecimal(String.valueOf(valueArray[14])).compareTo(BigDecimal.ZERO) == 0) {
                week = false;
            }
            boolean mouth = timeSet.contains("mon");
            if (new BigDecimal(String.valueOf(valueArray[8])).compareTo(BigDecimal.ZERO) == 0 && new BigDecimal(String.valueOf(valueArray[18])).compareTo(BigDecimal.ZERO) == 0) {
                mouth = false;
            }
            boolean year = timeSet.contains("year");
            if (new BigDecimal(String.valueOf(valueArray[10])).compareTo(BigDecimal.ZERO) == 0 && new BigDecimal(String.valueOf(valueArray[22])).compareTo(BigDecimal.ZERO) == 0) {
                year = false;
            }
            if (!(new BigDecimal(String.valueOf(valueArray[4])).compareTo(BigDecimal.ZERO) != 0 || new BigDecimal(String.valueOf(valueArray[12])).compareTo(BigDecimal.ZERO) != 0 || new BigDecimal(String.valueOf(valueArray[26])).compareTo(BigDecimal.ZERO) != 0 || week || mouth || year)) {
                isAdd = false;
            }
            if (!isAdd) continue;
            valueList.add(valueArray);
        }
        Algo algo = Algo.create((String)"");
        return algo.createDataSet(valueList.iterator(), rowMeta);
    }

    private List<Field> getField(Set<String> keySet) {
        ArrayList<Field> field = new ArrayList<Field>(keySet.size());
        field.add(new Field("org", (DataType)DataType.StringType));
        field.add(new Field("tradcurrency", (DataType)DataType.StringType));
        field.add(new Field("structtype", (DataType)DataType.StringType));
        field.add(new Field("nowpos_original", (DataType)DataType.BigDecimalType));
        field.add(new Field("nowpos_report", (DataType)DataType.BigDecimalType));
        field.add(new Field("weekpos_original", (DataType)DataType.BigDecimalType));
        field.add(new Field("weekpos_report", (DataType)DataType.BigDecimalType));
        field.add(new Field("monpos_original", (DataType)DataType.BigDecimalType));
        field.add(new Field("monpos_report", (DataType)DataType.BigDecimalType));
        field.add(new Field("yearpos_original", (DataType)DataType.BigDecimalType));
        field.add(new Field("yearpos_report", (DataType)DataType.BigDecimalType));
        field.add(new Field("nowfloatpl_original", (DataType)DataType.BigDecimalType));
        field.add(new Field("nowfloatpl_report", (DataType)DataType.BigDecimalType));
        field.add(new Field("weekpl_original", (DataType)DataType.BigDecimalType));
        field.add(new Field("weekpl_report", (DataType)DataType.BigDecimalType));
        field.add(new Field("weeksumpl_original", (DataType)DataType.BigDecimalType));
        field.add(new Field("weeksumpl_report", (DataType)DataType.BigDecimalType));
        field.add(new Field("monpl_original", (DataType)DataType.BigDecimalType));
        field.add(new Field("monpl_report", (DataType)DataType.BigDecimalType));
        field.add(new Field("monsumpl_original", (DataType)DataType.BigDecimalType));
        field.add(new Field("monsumpl_report", (DataType)DataType.BigDecimalType));
        field.add(new Field("yearpl_original", (DataType)DataType.BigDecimalType));
        field.add(new Field("yearpl_report", (DataType)DataType.BigDecimalType));
        field.add(new Field("yearsumpl_original", (DataType)DataType.BigDecimalType));
        field.add(new Field("yearsumpl_report", (DataType)DataType.BigDecimalType));
        field.add(new Field("nowinterest_original", (DataType)DataType.BigDecimalType));
        field.add(new Field("nowinterest_report", (DataType)DataType.BigDecimalType));
        field.add(new Field("originalcurrency", (DataType)DataType.LongType));
        field.add(new Field("contcurrency", (DataType)DataType.LongType));
        field.add(new Field("plcurrency", (DataType)DataType.LongType));
        field.add(new Field("countrow", (DataType)DataType.IntegerType));
        return field;
    }

    private Object calTotalPlAmount(Object floatPl, Object addPlAmt) {
        BigDecimal floatPlAmt = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty((Object)floatPl)) {
            floatPlAmt = new BigDecimal(String.valueOf(floatPl));
        }
        BigDecimal tempAmt = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty((Object)addPlAmt)) {
            tempAmt = new BigDecimal(String.valueOf(addPlAmt));
        }
        return floatPlAmt.add(tempAmt);
    }

    private String getKey(Row row, String dimension) {
        switch (dimension) {
            case "org_currency": {
                return row.getString("org.number") + "/" + row.getString("currency.number");
            }
            case "org_currency_type": {
                return row.getString("org.number") + "/" + row.getString("currency.number") + "/" + row.getString("structtype");
            }
        }
        return row.getString("org.number");
    }

    private BigDecimal calForexAmt(BigDecimal rowAmt, String cuPair, DynamicObject fQuote, Set<String> tipPairs) {
        BigDecimal forexAmt = BigDecimal.ZERO;
        if (!cuPair.equals(this.CUPAIR)) {
            this.CUPAIR = cuPair;
            this.FQUOTE_INFO = MarketDataServiceHelper.getForexQuoteInfoWithoutThrow((Long)((Long)fQuote.getPkValue()), (String)this.CUPAIR, null, null);
        }
        if (this.FQUOTE_INFO == null) {
            tipPairs.add(cuPair);
        } else if (this.FQUOTE_INFO.getFxquote().equals(this.CUPAIR)) {
            forexAmt = rowAmt.multiply(this.FQUOTE_INFO.getBuyPrice());
        } else if (EmptyUtil.isNoEmpty((BigDecimal)this.FQUOTE_INFO.getSellPrice())) {
            forexAmt = rowAmt.divide(this.FQUOTE_INFO.getSellPrice(), 10, 4);
        }
        return forexAmt;
    }

    private Map<String, BigDecimal> initMap(String dimension, Collection<DynamicObject> orgColl, List<DynamicObject> tradCurList, String[] structArray) {
        LinkedHashMap<String, BigDecimal> map = new LinkedHashMap<String, BigDecimal>(16);
        switch (dimension) {
            case "org_currency": {
                orgColl.stream().sorted(Comparator.comparing(a -> a.getString("number"))).forEach(s -> {
                    tradCurList.stream().sorted(Comparator.comparing(t -> t.getString("number"))).forEach(t -> {
                        map.put(s.getString("number") + "/" + t.getString("number"), BigDecimal.ZERO);
                        this.CUR_MAP.put(t.getString("number"), t.getString("name"));
                        this.CUR_ID_MAP.put(t.getString("number"), t.getLong("id"));
                    });
                    map.put(s.getString("number") + this.getCountFlag(), BigDecimal.ZERO);
                    this.ORG_MAP.put(s.getString("number"), s.getString("name"));
                });
                map.put(this.getTotalFlag(), BigDecimal.ZERO);
                return map;
            }
            case "org_currency_type": {
                orgColl.stream().sorted(Comparator.comparing(a -> a.getString("number"))).forEach(s -> {
                    tradCurList.stream().sorted(Comparator.comparing(a -> a.getString("number"))).forEach(t -> {
                        if (EmptyUtil.isNoEmpty((Object[])structArray)) {
                            Arrays.stream(structArray).sorted(Comparator.comparing(a -> a)).forEach(bizType -> map.put(s.getString("number") + "/" + t.getString("number") + "/" + bizType, BigDecimal.ZERO));
                        }
                        map.put(s.getString("number") + "/" + t.getString("number") + this.getCountFlag(), BigDecimal.ZERO);
                        this.CUR_MAP.put(t.getString("number"), t.getString("name"));
                        this.CUR_ID_MAP.put(t.getString("number"), t.getLong("id"));
                    });
                    map.put(s.getString("number") + this.getCountFlag(), BigDecimal.ZERO);
                    this.ORG_MAP.put(s.getString("number"), s.getString("name"));
                });
                map.put(this.getTotalFlag(), BigDecimal.ZERO);
                return map;
            }
        }
        orgColl.stream().sorted(Comparator.comparing(a -> a.getString("number"))).forEach(s -> {
            map.put(s.getString("number"), BigDecimal.ZERO);
            this.ORG_MAP.put(s.getString("number"), s.getString("name"));
        });
        map.put(this.getTotalFlag(), BigDecimal.ZERO);
        return map;
    }

    private QFilter buildStructFilter(List<Long> orgIds, DynamicObjectCollection tradCurColl, String[] structArray) {
        QFilter qFilter = new QFilter("protecttype.id", "=", (Object)Long.parseLong(ProductTypeEnum.STRUCTDEPOSIT.getId()));
        qFilter.and("org", "in", orgIds);
        HashSet tradCurIds = new HashSet(16);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)tradCurColl)) {
            tradCurColl.forEach(t -> tradCurIds.add(t.getLong("id")));
            qFilter.and(new QFilter("currency", "in", tradCurIds));
        }
        qFilter.and(new QFilter("structtype", "in", Arrays.asList(structArray)));
        return qFilter;
    }

    private BigDecimal getAmtUnit(String amtunit_filter) {
        switch (amtunit_filter) {
            case "Thousand": {
                return Constants.ONE_THOUSAND;
            }
            case "TenThousand": {
                return Constants.TEN_THOUSAND;
            }
            case "Million": {
                return new BigDecimal("1000000");
            }
            case "HundredMillion": {
                return Constants.ONE_HUNDRED_MILLION;
            }
        }
        return BigDecimal.ONE;
    }

    private Object getFilterValue(String filterName, ReportQueryParam reportQueryParam) {
        FilterInfo filters = reportQueryParam.getFilter();
        FilterItemInfo FilterInfo2 = filters.getFilterItem(filterName);
        return FilterInfo2.getValue();
    }
}

