/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.report.structdeposit;

import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class StructDepositReportFormListPlugin
extends AbstractReportFormPlugin {
    public void registerListener(EventObject e) {
        BasedataEdit forexquote = (BasedataEdit)this.getView().getControl("filter_forexquote");
        Optional.ofNullable(forexquote).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        long orgId = RequestContext.get().getOrgId();
        this.getModel().setValue("filter_org", (Object)new Object[]{orgId});
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        this.getModel().setValue("filter_plcurrency", (Object)localCurrencyId);
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filters = queryParam.getFilter();
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("filter_contcurrency").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u7ea6\u91d1\u989d\u62a5\u544a\u5e01\u79cd", (String)"StructDepositReportFormListPlugin_0", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("filter_plcurrency").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u635f\u76ca\u62a5\u544a\u5e01\u79cd", (String)"StructDepositReportFormListPlugin_1", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("filter_forexquote").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5916\u6c47\u62a5\u4ef7\u6765\u6e90", (String)"StructDepositReportFormListPlugin_2", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("filter_timesection").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u533a\u95f4", (String)"StructDepositReportFormListPlugin_3", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam param) {
        String dimension = (String)this.getModel().getValue("filter_dimension");
        this.initQueryColumn(dimension);
        super.beforeQuery(param);
    }

    private void initQueryColumn(String dimension) {
        ReportList listTable = (ReportList)this.getView().getControl("reportlistap");
        List columns = listTable.getColumns();
        switch (dimension) {
            case "org": {
                columns.removeIf(columm -> {
                    if (columm instanceof ReportColumn) {
                        ReportColumn reportColumn = (ReportColumn)columm;
                        return reportColumn.getFieldKey().equals("tradcurrency") || reportColumn.getFieldKey().equals("structtype");
                    }
                    return false;
                });
                break;
            }
            case "org_currency": {
                columns.removeIf(columm -> {
                    if (columm instanceof ReportColumn) {
                        ReportColumn reportColumn = (ReportColumn)columm;
                        return reportColumn.getFieldKey().equals("structtype");
                    }
                    return false;
                });
            }
        }
        String timeSectionFilter = (String)this.getModel().getValue("filter_timesection");
        String[] timeSection = timeSectionFilter.replaceFirst(",", "").split(",");
        HashSet<String> hideColumns = new HashSet<String>();
        hideColumns.add("group_weekpl");
        hideColumns.add("group_weekposition");
        hideColumns.add("group_weeksumpl");
        hideColumns.add("group_monpl");
        hideColumns.add("group_monposition");
        hideColumns.add("group_monsumpl");
        hideColumns.add("group_yearpl");
        hideColumns.add("group_yearposition");
        hideColumns.add("group_yearsumpl");
        for (String section : timeSection) {
            hideColumns.remove("group_" + section + "pl");
            hideColumns.remove("group_" + section + "position");
            hideColumns.remove("group_" + section + "sumpl");
        }
        columns.removeIf(columm -> {
            if (columm instanceof ReportColumnGroup) {
                ReportColumnGroup reportColumn = (ReportColumnGroup)columm;
                return hideColumns.contains(reportColumn.getFieldKey());
            }
            return false;
        });
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("filter_forexquote".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            String formid = "md_forexquote";
            billShowParameter.setFormId(formid);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }
}

