/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.report.swap;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.report.data.AbstractTmcTreeReportDataPlugin;
import kd.tmc.tbo.report.helper.ReportHelper;

public class SwapReportDataPlugin
extends AbstractTmcTreeReportDataPlugin {
    private static final String TM_RATESWAP = "id,billno,org,org.name orgtext,org.number,bizdate,billstatus,currency paycurrency,currency.number paycurrencynumber,currency.name paycurrencytext,amount conamtpay_original,reccurrency reccurrency,reccurrency.number reccurrencynumber,reccurrency.name reccurrencytext, recamount conamtrec_original";
    private static final String TM_CASHFLOW = "id,billid,billno,cfdirection,cfispay,cfbizrecordid bizrecordid";
    private static final String TM_BUSINESS_BILL = "bizdate,billstatus,cashflow_pay,cashflow_rec";
    private static final String PL_INFO = "id,org,tradebill.id as tradeid,bizrecord as bizrecordid,entrys.biztype,entrys.bizbillplcurrency bizbillplcurrency,entrys.bizbillplcurrency.number bizbillplcurrencynumber, entrys.plamt,entrys.bizdate,swapdir";
    private static final String PL_HISTORY_INFO = "plbill,updatedate,floatplamt,plcurrency as currency,plcurrency.number as plcurrencyNumber";
    public static final String SUFFIX_TEXT = "text";
    private String dimensions;
    private String[] dimensionArr;
    private String showType;
    private String swapType;
    private List<String> groups;
    private final List<Long> currencyIds = new ArrayList<Long>();
    private final List<Object[]> rateList = new ArrayList<Object[]>();
    private final List<Long> plCurrencyIds = new ArrayList<Long>();
    private final List<Object[]> plRateList = new ArrayList<Object[]>();
    private final LinkedHashSet<String> tipPairs = new LinkedHashSet(16);

    public DataSet queryDataSet(ReportQueryParam reportQueryParam) {
        Map paramMap = this.transQueryParam(reportQueryParam);
        List orgIds = this.getQueryOrgIds(reportQueryParam);
        this.dimensions = (String)this.getFilterValue("filter_dimension", reportQueryParam);
        this.showType = (String)this.getFilterValue("filter_showttype", reportQueryParam);
        this.swapType = (String)this.getFilterValue("filter_swaptype", reportQueryParam);
        this.dimensionArr = this.dimensions.split("_");
        this.groups = this.buildGroup(this.dimensionArr);
        DataSet swapBills = this.querySwapTradeBills(paramMap, orgIds);
        swapBills = this.exchangeRateConversion(paramMap, swapBills);
        swapBills = this.buildHistoryAmt(paramMap, swapBills);
        DataSet plDataSet = this.queryPlInfoData(paramMap, swapBills);
        plDataSet = this.plExchangeRateConversion(paramMap, plDataSet);
        String[] swapBillNames = swapBills.getRowMeta().getFieldNames();
        DataSet allBills = swapBills.leftJoin(plDataSet).on("id", "tradeid").select(swapBillNames, this.getPlFields()).finish();
        Date startDate = (Date)paramMap.get("filter_startdate");
        DataSet bills = startDate != null ? allBills.filter("to_char(bizdate, 'yyyyMMdd') >=" + TcDateUtils.formatString((Date)startDate, (String)"yyyyMMdd")) : allBills;
        String unit = (String)paramMap.get("filter_currencyunit");
        List<String> amountFields = this.getAmountFields(this.groups);
        if ("rateswap".equals(this.swapType)) {
            amountFields.add("floatpl_original");
            amountFields.add("pl_original");
            amountFields.add("totalpl_original");
            amountFields.add("floatpl_end_original");
        }
        List<String> endAmountFields = amountFields.stream().filter(e -> e.contains("_end_")).collect(Collectors.toList());
        List<String> notendAmountFields = amountFields.stream().filter(e -> !e.contains("_end_")).collect(Collectors.toList());
        DataSet allDataSet = this.sumDataSet(bills, notendAmountFields, unit, false);
        DataSet endAllDataSet = this.sumDataSet(allBills, endAmountFields, unit, true);
        JoinDataSet joinDataSet = endAllDataSet.leftJoin(allDataSet);
        for (String group : this.groups) {
            joinDataSet.on(group, group);
        }
        String[] fields = ReportHelper.concat(allDataSet.getRowMeta().getFieldNames(), endAmountFields.toArray(new String[0]));
        DataSet finish = joinDataSet.select(fields).finish();
        finish = this.filterDataSet(finish);
        return finish;
    }

    private DataSet filterDataSet(DataSet dataSet) {
        StringBuilder sb = new StringBuilder();
        boolean contaiPaycurrency = this.groups.stream().anyMatch(e -> e.contains("paycurrency"));
        boolean contaiReccurrency = this.groups.stream().anyMatch(e -> e.contains("reccurrency"));
        if (contaiPaycurrency) {
            sb.append("conamtpay_report != 0 and conamtpay_report != null or hisamtpay_end_report != 0 and hisamtpay_end_report != null or ");
        }
        if (contaiReccurrency) {
            sb.append("conamtrec_report != 0 and conamtrec_report != null or hisamtrec_end_report != 0 and hisamtrec_end_report != null or ");
        }
        if (!contaiPaycurrency && !contaiReccurrency) {
            sb.append("conamtpay_report != 0 and conamtpay_report != null or hisamtpay_end_report != 0 and hisamtpay_end_report != null or ");
            sb.append("conamtrec_report != 0 and conamtrec_report != null or hisamtrec_end_report != 0 and hisamtrec_end_report != null or ");
        }
        sb.append("floatpl_end_report != 0 and floatpl_end_report != null");
        dataSet = dataSet.filter(sb.toString());
        return dataSet;
    }

    public List<String> sumAmountFields() {
        ArrayList<String> field = new ArrayList<String>(10);
        field.add("conamtpay_report");
        field.add("conamtrec_report");
        field.add("hisamtpay_report");
        field.add("hisamtrec_report");
        field.add("floatpl_report");
        field.add("pl_report");
        field.add("totalpl_report");
        field.add("hisamtpay_end_report");
        field.add("hisamtrec_end_report");
        field.add("floatpl_end_report");
        return field;
    }

    public String sumNameField() {
        String field = this.dimensionArr[0];
        if (this.isText(field)) {
            return this.dimensionArr[0];
        }
        return field + SUFFIX_TEXT;
    }

    public List<String> groupFields() {
        return Arrays.stream(this.dimensionArr).collect(Collectors.toList());
    }

    protected boolean isNeedDimCurrency() {
        return false;
    }

    protected boolean isNeedCurrencyUnit() {
        return false;
    }

    protected boolean isText(String field) {
        return false;
    }

    protected boolean isNeedOrgTree() {
        return "org".equals(this.dimensions) && "step".equals(this.showType);
    }

    protected DataSet addSumRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        boolean showTotal = (Boolean)paramMap.get("filter_total");
        if (showTotal) {
            bizDs = super.addSumRowDataSet(bizDs, paramMap);
        }
        DynamicObject conCurrency = (DynamicObject)paramMap.get("filter_contcurrency");
        DynamicObject plCurrency = (DynamicObject)paramMap.get("filter_plcurrency");
        bizDs = bizDs.addFields(new String[]{String.valueOf(plCurrency.getLong("id")), String.valueOf(conCurrency.getLong("id"))}, new String[]{"plcurrency", "contcurrency"});
        return bizDs;
    }

    protected DataSet addSubRowDataSet(DataSet bizDs, Map<String, Object> paramMap) {
        boolean showTotal = (Boolean)paramMap.get("filter_total");
        int dimensionLength = this.dimensionArr.length;
        if (!showTotal || dimensionLength < 2) {
            return bizDs;
        }
        DataSet subTotalDs = bizDs.copy();
        String[] orderBy = this.getOrderBy(paramMap);
        for (int i = 0; i < dimensionLength - 1; ++i) {
            List<String> groups = this.getSubGroups(this.dimensionArr, i);
            subTotalDs = this.addSubTotalDataSet(subTotalDs, groups, this.getAmountFields(groups), this.isText(this.dimensionArr[0]) ? this.dimensionArr[0] : this.dimensionArr[0] + SUFFIX_TEXT);
            bizDs = bizDs.union(subTotalDs).orderBy(this.getSubOrderBy(orderBy, i));
        }
        return bizDs.updateFields(new String[]{"rowid", "pid"}, new String[]{"cast(rowid as String)", "cast(pid as String)"}).updateFields(new String[]{"rowid", "pid", "isgroupnode"}, new String[]{this.uniqueRow, "'0'", "'0'"});
    }

    private DataSet plExchangeRateConversion(Map<String, Object> paramMap, DataSet plInfoData) {
        DynamicObject currency = (DynamicObject)paramMap.get("filter_plcurrency");
        DynamicObject forexQuote = (DynamicObject)paramMap.get("filter_forexquote");
        Date startDate = (Date)paramMap.get("filter_startdate");
        Date enddate = (Date)paramMap.get("filter_enddate");
        String dateRangeStr = this.getDateRangeStr("entrys.bizdate", startDate, enddate);
        DataSet exchgRateDataSet = ReportHelper.calRateDataSet(this.plCurrencyIds, this.plRateList, plInfoData, forexQuote, currency, Arrays.asList("currency", "bizbillplcurrency"), Arrays.asList("plcurrencyNumber", "bizbillplcurrencynumber"), enddate, this.tipPairs);
        if (!EmptyUtil.isEmpty(this.tipPairs)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u201c%1$s\u201d\u5728\u5916\u6c47\u62a5\u4ef7\u201c%2$s\u201d\u4e2d\u672a\u8bbe\u7f6e\u62a5\u4ef7\u65b9\u5f0f\uff0c\u8bf7\u5148\u8bbe\u7f6e\u3002", (String)"ForwRateAgreeListRpt_0", (String)"tmc-tm-report", (Object[])new Object[0]), String.join((CharSequence)"\u3001", this.tipPairs), forexQuote.getString("number")));
        }
        String[] plInfoNames = plInfoData.getRowMeta().getFieldNames();
        DataSet plDataSet = plInfoData.leftJoin(exchgRateDataSet.distinct()).on("currency", "currency").select(plInfoNames, new String[]{"rate"}).finish();
        plDataSet = plDataSet.addFields(new String[]{"floatplamt", "floatplamt*rate", "case when " + dateRangeStr + " then entrys.plamt else 0 end pl_original"}, new String[]{"floatpl_original", "floatpl_report", "pl_original"});
        plDataSet = plDataSet.leftJoin(exchgRateDataSet.distinct()).on("bizbillplcurrency", "currency").select(plDataSet.getRowMeta().getFieldNames(), new String[]{"rate as plexrate"}).finish();
        plDataSet = plDataSet.addFields(new String[]{"pl_original*plexrate"}, new String[]{"pl_report"});
        GroupbyDataSet groupbyDataSet = plDataSet.groupBy(new String[]{"id", "tradeid", "bizrecordid", "org"});
        groupbyDataSet.max("floatpl_original");
        groupbyDataSet.max("floatpl_report");
        groupbyDataSet.sum("pl_original");
        groupbyDataSet.sum("pl_report");
        DataSet allDataSet = groupbyDataSet.finish();
        allDataSet = allDataSet.addFields(new String[]{"floatpl_original + pl_original", "floatpl_report + pl_report"}, new String[]{"totalpl_original", "totalpl_report"});
        return allDataSet;
    }

    private String getDateRangeStr(String field, Date startDate, Date enddate) {
        StringBuilder sb = new StringBuilder();
        String enddateStr = TcDateUtils.formatString((Date)enddate, (String)"yyyyMMdd");
        if (startDate != null) {
            String startDateStr = TcDateUtils.formatString((Date)startDate, (String)"yyyyMMdd");
            sb.append("to_char(").append(field).append(", 'yyyyMMdd') >= ").append(startDateStr).append(" and to_char(").append(field).append(", 'yyyyMMdd') <= ").append(enddateStr);
        } else {
            sb.append("to_char(").append(field).append(", 'yyyyMMdd') <= ").append(enddateStr);
        }
        return sb.toString();
    }

    private DataSet queryPlInfoData(Map<String, Object> paramMap, DataSet dataset) {
        DataSet dataDataCopy = dataset.copy();
        HashSet<Long> tradeIds = new HashSet<Long>(16);
        HashSet<Long> bizRecordIds = new HashSet<Long>(16);
        for (Row row : dataDataCopy) {
            tradeIds.add(row.getLong("id"));
            BigDecimal hisamtpay = row.getBigDecimal("hisamtpay_original");
            BigDecimal hisamtrec = row.getBigDecimal("hisamtrec_original");
            if (EmptyUtil.isEmpty((BigDecimal)hisamtpay) && EmptyUtil.isEmpty((BigDecimal)hisamtrec)) continue;
            bizRecordIds.add(row.getLong("bizrecordid"));
        }
        QFilter qFilter = new QFilter("tradebill.id", "in", tradeIds);
        qFilter.and(new QFilter("bizrecord", "!=", (Object)0L).or(QFilter.isNotNull((String)"bizrecord")));
        DataSet plDataSet = QueryServiceHelper.queryDataSet((String)"tbo_plinfo_data", (String)"tbo_plinfo", (String)PL_INFO, (QFilter[])qFilter.toArray(), null);
        QFilter plFilter = new QFilter("bizrecord", "in", bizRecordIds);
        Date endDate = (Date)paramMap.get("filter_enddate");
        plFilter.and("updatedate", "<=", (Object)endDate);
        String[] fieldNames = plDataSet.getRowMeta().getFieldNames();
        DataSet plHistoryDataSet = QueryServiceHelper.queryDataSet((String)"tbo_plinfo_history_data", (String)"tbo_plinfo_history", (String)PL_HISTORY_INFO, (QFilter[])plFilter.toArray(), (String)"plbill,updatedate");
        DataSet plHDataSet = plHistoryDataSet.groupBy(new String[]{"plbill"}).maxP("updatedate", "floatplamt").maxP("updatedate", "currency").maxP("updatedate", "plcurrencyNumber").finish();
        return plDataSet.leftJoin(plHDataSet).on("id", "plbill").select(fieldNames, new String[]{"floatplamt", "currency", "plcurrencyNumber"}).finish();
    }

    private DataSet exchangeRateConversion(Map<String, Object> paramMap, DataSet swapBills) {
        DynamicObject contcurrency = (DynamicObject)paramMap.get("filter_contcurrency");
        DynamicObject forexquote = (DynamicObject)paramMap.get("filter_forexquote");
        Date endDate = (Date)paramMap.get("filter_enddate");
        DataSet exchgRateDataSet = ReportHelper.calRateDataSet(this.currencyIds, this.rateList, swapBills, forexquote, contcurrency, Arrays.asList("paycurrency", "reccurrency"), Arrays.asList("paycurrencynumber", "reccurrencynumber"), endDate, this.tipPairs);
        if (exchgRateDataSet != null) {
            String[] swapBillFieldNames = swapBills.getRowMeta().getFieldNames();
            swapBills = swapBills.leftJoin(exchgRateDataSet).on("paycurrency", "currency").select(swapBillFieldNames, new String[]{"rate payrate"}).finish();
            swapBills = swapBills.addFields(new String[]{"conamtpay_original*payrate"}, new String[]{"conamtpay_report"});
            swapBillFieldNames = swapBills.getRowMeta().getFieldNames();
            swapBills = swapBills.leftJoin(exchgRateDataSet).on("reccurrency", "currency").select(swapBillFieldNames, new String[]{"rate recrate"}).finish();
            swapBills = swapBills.addFields(new String[]{"conamtrec_original*recrate"}, new String[]{"conamtrec_report"});
        }
        return swapBills;
    }

    private DataSet buildHistoryAmt(Map<String, Object> paramMap, DataSet swapBills) {
        Date endDate = (Date)paramMap.get("filter_enddate");
        Set<Long> swapIds = ReportHelper.getDataSetIds(swapBills, "id");
        QFilter payFilter = new QFilter("billid", "in", swapIds);
        payFilter.and("cfdirection", "=", (Object)"buy");
        DataSet payCashFlows = QueryServiceHelper.queryDataSet((String)"tm_cashflow_pay_data", (String)"tm_cashflow", (String)TM_CASHFLOW, (QFilter[])payFilter.toArray(), null);
        payCashFlows = payCashFlows.updateField("billno", "cast(billno as long)");
        DataSet payLastCashFlows = payCashFlows.groupBy(new String[]{"billid", "bizrecordid"}).maxP("billno", "id").maxP("billno", "cfispay").finish();
        DataSet payedLastCashFlows = payLastCashFlows.copy().filter("cfispay=true");
        Set<Long> payedLastCashFlowIds = ReportHelper.getDataSetIds(payedLastCashFlows, "id");
        QFilter payBusinessFilter = new QFilter("cashflow_pay", "in", payedLastCashFlowIds);
        DataSet payBusinessBills = QueryServiceHelper.queryDataSet((String)"tm_businessbill_pay_data", (String)"tm_businessbill", (String)TM_BUSINESS_BILL, (QFilter[])payBusinessFilter.toArray(), null);
        QFilter recFilter = new QFilter("billid", "in", swapIds);
        recFilter.and("cfdirection", "=", (Object)"sell");
        DataSet recCashFlows = QueryServiceHelper.queryDataSet((String)"tm_cashflow_pay_data", (String)"tm_cashflow", (String)TM_CASHFLOW, (QFilter[])recFilter.toArray(), null);
        recCashFlows = recCashFlows.updateField("billno", "cast(billno as long)");
        DataSet recLastCashFlows = recCashFlows.groupBy(new String[]{"billid", "bizrecordid"}).maxP("billno", "id").maxP("billno", "cfispay").finish();
        DataSet recPayedLastCashFlows = recLastCashFlows.copy().filter("cfispay=true");
        Set<Long> recPayedLastCashFlowIds = ReportHelper.getDataSetIds(recPayedLastCashFlows, "id");
        QFilter recBusinessFilter = new QFilter("cashflow_rec", "in", recPayedLastCashFlowIds);
        DataSet recBusinessBills = QueryServiceHelper.queryDataSet((String)"tm_businessbill_rec_data", (String)"tm_businessbill", (String)TM_BUSINESS_BILL, (QFilter[])recBusinessFilter.toArray(), null);
        String[] cashFlowFieldNames = payLastCashFlows.getRowMeta().getFieldNames();
        DataSet payDataset = payLastCashFlows.leftJoin(payBusinessBills).on("id", "cashflow_pay").select(cashFlowFieldNames, new String[]{"bizdate", "billstatus"}).finish();
        DataSet recDataset = recLastCashFlows.leftJoin(recBusinessBills).on("id", "cashflow_rec").select(cashFlowFieldNames, new String[]{"bizdate", "billstatus"}).finish();
        payDataset = payDataset.addField(String.format("case when cfispay=true and billstatus in ('C','F','I') and to_char(bizdate, 'yyyyMMdd') <= %s then true else false end", TcDateUtils.formatString((Date)endDate, (String)"yyyyMMdd")), "isend");
        recDataset = recDataset.addField(String.format("case when cfispay=true and billstatus in ('C','F','I') and to_char(bizdate, 'yyyyMMdd') <= %s then true else false end", TcDateUtils.formatString((Date)endDate, (String)"yyyyMMdd")), "isend");
        String[] swapBillFieldNames = swapBills.getRowMeta().getFieldNames();
        swapBills = swapBills.leftJoin(payDataset).on("id", "billid").select(swapBillFieldNames, new String[]{"isend ispayend", "bizrecordid"}).finish();
        swapBillFieldNames = swapBills.getRowMeta().getFieldNames();
        DataSet finish = swapBills.leftJoin(recDataset).on("id", "billid").select(swapBillFieldNames, new String[]{"isend isrecend"}).finish();
        finish = finish.addFields(new String[]{"case when ispayend=false then conamtpay_original else 0 end", "case when ispayend=false then conamtpay_report else 0 end", "case when isrecend=false then conamtrec_original else 0 end", "case when isrecend=false then conamtrec_report else 0 end"}, new String[]{"hisamtpay_original", "hisamtpay_report", "hisamtrec_original", "hisamtrec_report"});
        return finish;
    }

    private DataSet querySwapTradeBills(Map<String, Object> paramMap, List<Long> orgIds) {
        DynamicObjectCollection payCurrency = (DynamicObjectCollection)paramMap.get("filter_paycurrency");
        DynamicObjectCollection chargeCurrency = (DynamicObjectCollection)paramMap.get("filter_reccurrency");
        Date endDate = (Date)paramMap.get("filter_enddate");
        String selectFields = String.join((CharSequence)",", this.getSelectFields());
        String allSelectFields = "";
        allSelectFields = EmptyUtil.isEmpty((String)selectFields) ? TM_RATESWAP : selectFields + "," + TM_RATESWAP;
        QFilter swapFilter = this.buildSwapFilter(this.swapType, orgIds, payCurrency, chargeCurrency, endDate);
        return QueryServiceHelper.queryDataSet((String)"tm_rateswap_key", (String)"tm_rateswap", (String)allSelectFields, (QFilter[])new QFilter[]{swapFilter}, null);
    }

    private DataSet sumDataSet(DataSet bills, List<String> fields, String amtUnit, boolean isAddFields) {
        if (isAddFields) {
            bills = bills.addFields((String[])fields.stream().map(e -> e.replaceAll("end_", "")).toArray(String[]::new), fields.toArray(new String[0]));
        }
        GroupbyDataSet groupbyDataSet = bills.groupBy(this.groups.toArray(new String[0]));
        ArrayList<String> amountUnitExprs = new ArrayList<String>(fields.size());
        for (String amountField : fields) {
            groupbyDataSet.sum(amountField);
            amountUnitExprs.add(String.format(amountField + "/%s", amtUnit));
        }
        DataSet allDataSet = groupbyDataSet.finish();
        allDataSet = allDataSet.updateFields(fields.toArray(new String[0]), amountUnitExprs.toArray(new String[0]));
        return allDataSet;
    }

    protected List<String> getSelectFields() {
        ArrayList<String> list = new ArrayList<String>(10);
        List<String> noSelectFileds = Arrays.asList("org", "paycurrency", "reccurrency");
        for (String dimension : this.dimensionArr) {
            if (noSelectFileds.contains(dimension)) continue;
            if (this.isText(dimension)) {
                list.add(dimension);
                continue;
            }
            list.add(dimension);
            list.add(dimension + ".name " + dimension + SUFFIX_TEXT);
        }
        return list;
    }

    private String[] getOrderBy(Map<String, Object> paramMap) {
        return this.dimensionArr;
    }

    private String[] getSubOrderBy(String[] dimensions, int level) {
        if (dimensions.length < level) {
            return dimensions;
        }
        String[] orders = new String[dimensions.length - level - 1];
        System.arraycopy(dimensions, 0, orders, 0, dimensions.length - level - 1);
        return orders;
    }

    protected List<String> buildGroup(String[] dimensions) {
        ArrayList<String> list = new ArrayList<String>();
        for (String dimension : dimensions) {
            if (this.isText(dimension)) {
                list.add(dimension);
                continue;
            }
            list.add(dimension);
            list.add(dimension + SUFFIX_TEXT);
        }
        return list;
    }

    private List<String> getSubGroups(String[] dimensions, int level) {
        ArrayList<String> groups = new ArrayList<String>(6);
        List<String> subGroups = Arrays.asList(dimensions).subList(0, dimensions.length - level - 1);
        groups.addAll(subGroups);
        for (int i = 0; i < subGroups.size(); ++i) {
            String group = subGroups.get(i);
            if (i == 0 || this.isText(group)) continue;
            groups.add(group + SUFFIX_TEXT);
        }
        return groups;
    }

    private QFilter buildSwapFilter(String swapType, List<Long> orgIds, DynamicObjectCollection paycurrency, DynamicObjectCollection chargecurrency, Date endDate) {
        QFilter qFilter = new QFilter("protecttype.id", "=", (Object)Long.valueOf(ProductTypeEnum.SWAP.getId()));
        if ("rateswap".equals(swapType)) {
            qFilter.and("rateswaptype", "=", (Object)"rate");
        } else {
            qFilter.and("rateswaptype", "=", (Object)"currency");
        }
        qFilter.and("org", "in", orgIds);
        HashSet payCurIds = new HashSet(16);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)paycurrency)) {
            paycurrency.forEach(t -> payCurIds.add(t.getLong("id")));
            qFilter.and(new QFilter("currency", "in", payCurIds));
        }
        HashSet chargeCurIds = new HashSet(16);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)chargecurrency)) {
            chargecurrency.forEach(t -> chargeCurIds.add(t.getLong("id")));
            qFilter.and(new QFilter("reccurrency", "in", chargeCurIds));
        }
        if (endDate != null) {
            qFilter.and(new QFilter("bizdate", "<=", (Object)endDate));
        }
        qFilter.and("billstatus", "in", (Object)new String[]{TcBillStatusEnum.SURVIVAL.getValue(), TcBillStatusEnum.FINISH.getValue()});
        return qFilter;
    }

    private Object getFilterValue(String filterName, ReportQueryParam reportQueryParam) {
        FilterInfo filters = reportQueryParam.getFilter();
        FilterItemInfo filterInfo = filters.getFilterItem(filterName);
        return filterInfo.getValue();
    }

    private String[] getPlFields() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("floatpl_original");
        list.add("floatpl_report");
        list.add("pl_original");
        list.add("pl_report");
        list.add("totalpl_original");
        list.add("totalpl_report");
        return list.toArray(new String[0]);
    }

    private List<String> getAmountFields(List<String> groups) {
        ArrayList<String> list = new ArrayList<String>();
        boolean contaiPaycurrency = groups.stream().anyMatch(e -> e.contains("paycurrency"));
        boolean contaiReccurrency = groups.stream().anyMatch(e -> e.contains("reccurrency"));
        if (contaiPaycurrency) {
            list.add("conamtpay_original");
            list.add("hisamtpay_original");
            list.add("hisamtpay_end_original");
        }
        if (contaiReccurrency) {
            list.add("conamtrec_original");
            list.add("hisamtrec_original");
            list.add("hisamtrec_end_original");
        }
        list.add("conamtpay_report");
        list.add("conamtrec_report");
        list.add("hisamtpay_report");
        list.add("hisamtrec_report");
        list.add("hisamtpay_end_report");
        list.add("hisamtrec_end_report");
        list.add("floatpl_report");
        list.add("pl_report");
        list.add("totalpl_report");
        list.add("floatpl_end_report");
        return list;
    }
}

