/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.report.swap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tbo.common.enums.DateRangeEnum;
import kd.tmc.tbo.common.enums.SwapReportDimensionEnum;
import kd.tmc.tbo.report.helper.ReportHelper;

public class SwapReportFormPlugin
extends AbstractReportFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String curswaptype = (String)this.getModel().getValue("filter_swaptype");
        List<String> dimensionEnum = this.getDimensionEnum(curswaptype);
        this.resetComboItems(dimensionEnum, SwapReportDimensionEnum.getAllEnumValues(), "filter_dimension", this.getView());
    }

    public void afterSetModelValue(DynamicObject scheme) {
        ReportHelper.setDateFilterAfterSchemeLoad(this.getView(), scheme, "filter_daterange", "filter_startdate", "filter_enddate");
    }

    private void resetComboItems(List<String> comboItems, List<String> allComboItems, String propName, IReportView view) {
        DataEntityPropertyCollection properties = view.getModel().getDataEntity().getDynamicObjectType().getProperties();
        Optional<IDataEntityProperty> optional = properties.stream().filter(v -> v.getName().equals(propName)).findFirst();
        if (!optional.isPresent()) {
            return;
        }
        ComboProp comboProp = (ComboProp)optional.get();
        List valueMapItems = comboProp.getComboItems();
        ArrayList<ComboItem> comboItemList = new ArrayList<ComboItem>(8);
        for (ValueMapItem valueMapItem : valueMapItems) {
            String value = valueMapItem.getValue();
            if (!allComboItems.contains(value)) {
                comboItemList.add(new ComboItem(valueMapItem.getName(), value));
            }
            if (!comboItems.contains(value)) continue;
            comboItemList.add(new ComboItem(valueMapItem.getName(), value));
        }
        ((ComboEdit)view.getControl(propName)).setComboItems(comboItemList);
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(true);
    }

    public void registerListener(EventObject e) {
        BasedataEdit forexquote = (BasedataEdit)this.getView().getControl("filter_forexquote");
        Optional.ofNullable(forexquote).ifPresent(c -> c.addBeforeF7ViewDetailListener(this::beforeF7ViewDetail));
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        super.initDefaultQueryParam(queryParam);
        String appId = this.getView().getFormShowParameter().getAppId();
        long orgId = RequestContext.get().getOrgId();
        List comIdList = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)this.getModel().getDataEntityType().getName(), (String)"47150e89000000ac");
        if (comIdList.contains(orgId)) {
            this.getModel().setValue("filter_org", (Object)new Object[]{orgId});
            Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)orgId);
            Long localCurrencyId = (Long)result.get("baseCurrencyID");
            this.getModel().setValue("filter_plcurrency", (Object)localCurrencyId);
        }
        this.setMinDateForEndDate();
        this.setMaxDateForStartDate();
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filters = queryParam.getFilter();
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("filter_contcurrency").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5408\u7ea6\u91d1\u989d\u62a5\u544a\u5e01\u79cd", (String)"SwapReportFormPlugin_0", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("filter_plcurrency").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u635f\u76ca\u62a5\u544a\u5e01\u79cd", (String)"SwapReportFormPlugin_1", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("filter_forexquote").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5916\u6c47\u62a5\u4ef7\u6765\u6e90", (String)"SwapReportFormPlugin_2", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("filter_daterange").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u533a\u95f4", (String)"SwapReportFormPlugin_3", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        Date endDate = (Date)filters.getFilterItem("filter_enddate").getValue();
        Date startDate = (Date)filters.getFilterItem("filter_startdate").getValue();
        if (EmptyUtil.isEmpty((Object)endDate)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u622a\u6b62\u65e5\u671f", (String)"ForexPlCountFilterRpt_10", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (!EmptyUtil.isEmpty((Object)startDate) && startDate.compareTo(endDate) > 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u8d85\u8fc7\u622a\u6b62\u65e5\u671f\u3002", (String)"ForexPlCountFilterRpt_11", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        if (EmptyUtil.isEmpty((Object)filters.getFilterItem("filter_dimension").getValue())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u7ef4\u5ea6", (String)"SwapReportFormPlugin_4", (String)"tmc-tm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "filter_swaptype": {
                String curswaptype = (String)this.getModel().getValue("filter_swaptype");
                List<String> dimensionEnum = this.getDimensionEnum(curswaptype);
                this.resetComboItems(dimensionEnum, SwapReportDimensionEnum.getAllEnumValues(), "filter_dimension", this.getView());
                this.getModel().setValue("filter_dimension", (Object)SwapReportDimensionEnum.ORG.getValue());
                break;
            }
            case "filter_daterange": {
                this.daterangeChanged();
                break;
            }
            case "filter_startdate": {
                this.setMinDateForEndDate();
                break;
            }
            case "filter_enddate": {
                this.setMaxDateForStartDate();
            }
        }
    }

    private void setMinDateForEndDate() {
        Date startDate = (Date)this.getModel().getValue("filter_startdate");
        if (startDate != null) {
            ((DateEdit)this.getView().getControl("filter_enddate")).setMinDate(startDate);
        } else {
            ((DateEdit)this.getView().getControl("filter_enddate")).setMinDate(TcDateUtils.stringToDate((String)"1900-01-01", (String)"yyyy-MM-dd"));
        }
    }

    private void setMaxDateForStartDate() {
        Date endDate = (Date)this.getModel().getValue("filter_enddate");
        if (endDate != null) {
            ((DateEdit)this.getView().getControl("filter_startdate")).setMaxDate(endDate);
        } else {
            ((DateEdit)this.getView().getControl("filter_startdate")).setMaxDate(TcDateUtils.stringToDate((String)"2999-12-31", (String)"yyyy-MM-dd"));
        }
    }

    protected List<String> getDimensionEnum(String curswaptype) {
        ArrayList<String> dimensionEnums = new ArrayList<String>();
        if (curswaptype.equals("rateswap")) {
            dimensionEnums.add(SwapReportDimensionEnum.ORG.getValue());
            dimensionEnums.add(SwapReportDimensionEnum.ORG_PAYCURRENCY.getValue());
            dimensionEnums.add(SwapReportDimensionEnum.PAYCURRENCY.getValue());
        } else if (curswaptype.equals("curswap")) {
            dimensionEnums.add(SwapReportDimensionEnum.ORG.getValue());
            dimensionEnums.add(SwapReportDimensionEnum.ORG_PAYCURRENCY.getValue());
            dimensionEnums.add(SwapReportDimensionEnum.ORG_PAYCURRENCY_CHARGECURRENCY.getValue());
            dimensionEnums.add(SwapReportDimensionEnum.PAYCURRENCY.getValue());
            dimensionEnums.add(SwapReportDimensionEnum.PAYCURRENCY_CHARGECURRENCY.getValue());
        }
        return dimensionEnums;
    }

    private Date getStartDate(String daterange) {
        DateRangeEnum dateRangeEnum = DateRangeEnum.getEnumByValue((String)daterange);
        if (daterange != null) {
            return dateRangeEnum.getDate();
        }
        return null;
    }

    private void daterangeChanged() {
        Date currentDate = TcDateUtils.getCurrentDate();
        this.getModel().setValue("filter_enddate", (Object)currentDate);
        if (DateRangeEnum.WEEK.getValue().equals(this.getModel().getValue("filter_daterange"))) {
            this.getModel().setValue("filter_startdate", (Object)TcDateUtils.getFirstDayOfWeek((Date)currentDate));
        } else if (DateRangeEnum.MONTH.getValue().equals(this.getModel().getValue("filter_daterange"))) {
            this.getModel().setValue("filter_startdate", (Object)TcDateUtils.getFirstDayOfMonth((Date)currentDate));
        } else if (DateRangeEnum.YEAR.getValue().equals(this.getModel().getValue("filter_daterange"))) {
            this.getModel().setValue("filter_startdate", (Object)TcDateUtils.getFirstYearDate((Date)currentDate));
        } else {
            this.getModel().setValue("filter_startdate", null);
        }
    }

    private void beforeF7ViewDetail(BeforeF7ViewDetailEvent event) {
        Object pkId = event.getPkId();
        BasedataEdit source = (BasedataEdit)event.getSource();
        String key = source.getKey();
        if ("filter_forexquote".equals(key)) {
            event.setCancel(true);
            BillShowParameter billShowParameter = new BillShowParameter();
            String formid = "md_forexquote";
            billShowParameter.setFormId(formid);
            billShowParameter.setPkId(pkId);
            billShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            billShowParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)billShowParameter);
        }
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        String dimensions = (String)this.getModel().getValue("filter_dimension");
        String swapType = (String)this.getModel().getValue("filter_swaptype");
        String[] dimensionArr = dimensions.split("_");
        List<String> hideColumns = this.getHideColumns(dimensionArr);
        List<String> hideGroupColumns = this.getHideGroupColumns(swapType, dimensionArr);
        List columns = event.getColumns();
        columns.removeIf(columm -> {
            ReportColumn reportColumn;
            String fieldKey;
            if (columm instanceof ReportColumn && (hideColumns.contains(fieldKey = (reportColumn = (ReportColumn)columm).getFieldKey()) || hideGroupColumns.contains(fieldKey))) {
                return true;
            }
            if (columm instanceof ReportColumnGroup) {
                ReportColumnGroup reportColumnGroup = (ReportColumnGroup)columm;
                fieldKey = reportColumnGroup.getFieldKey();
                if (hideColumns.contains(fieldKey) || hideGroupColumns.contains(fieldKey)) {
                    return true;
                }
                List children = reportColumnGroup.getChildren();
                children.removeIf(e -> {
                    if (e instanceof ReportColumn) {
                        ReportColumn reportColumn = (ReportColumn)e;
                        String field = reportColumn.getFieldKey();
                        return hideColumns.contains(field) || hideGroupColumns.contains(field);
                    }
                    return false;
                });
            }
            return false;
        });
    }

    private List<String> getListFields() {
        ArrayList<String> list = new ArrayList<String>(16);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        List columns = reportList.getColumns();
        for (AbstractReportColumn column : columns) {
            if (column instanceof ReportColumn) {
                String fieldKey = ((ReportColumn)column).getFieldKey();
                list.add(fieldKey);
            }
            if (!(column instanceof ReportColumnGroup)) continue;
            ReportColumnGroup columnGroup = (ReportColumnGroup)column;
            String fieldKey = columnGroup.getFieldKey();
            list.add(fieldKey);
            List children = columnGroup.getChildren();
            for (AbstractReportColumn child : children) {
                if (!(child instanceof ReportColumn)) continue;
                String field = ((ReportColumn)child).getFieldKey();
                list.add(field);
            }
        }
        return list;
    }

    protected List<String> getHideColumns(String[] dimensionArr) {
        List<String> listFields = this.getListFields();
        List<String> allFields = this.getAllFields();
        ArrayList<String> hideColumns = new ArrayList<String>();
        for (String field : listFields) {
            if (allFields.contains(field)) continue;
            hideColumns.add(field);
        }
        ArrayList<String> dimensions = new ArrayList<String>(16);
        List dimensionList = Arrays.stream(dimensionArr).collect(Collectors.toList());
        for (String dimension : dimensionList) {
            if (this.isText(dimension)) {
                dimensions.add(dimension);
                continue;
            }
            dimensions.add(dimension + "text");
        }
        hideColumns.removeAll(dimensions);
        return hideColumns;
    }

    protected boolean isText(String field) {
        return false;
    }

    private List<String> getAllFields() {
        ArrayList<String> list = new ArrayList<String>(40);
        list.add("sumlevel");
        list.add("paycurrency");
        list.add("reccurrency");
        list.add("plcurrency");
        list.add("contcurrency");
        list.add("countrow");
        list.add("group_conamtpay");
        list.add("conamtpay_original");
        list.add("conamtpay_report");
        list.add("group_conamtrec");
        list.add("conamtrec_original");
        list.add("conamtrec_report");
        list.add("group_hisamtpay");
        list.add("hisamtpay_original");
        list.add("hisamtpay_report");
        list.add("group_hisamtpay_end");
        list.add("hisamtpay_end_original");
        list.add("hisamtpay_end_report");
        list.add("group_hisamtrec");
        list.add("hisamtrec_original");
        list.add("hisamtrec_report");
        list.add("group_hisamtrec_end");
        list.add("hisamtrec_end_original");
        list.add("hisamtrec_end_report");
        list.add("group_floatpl");
        list.add("floatpl_original");
        list.add("floatpl_report");
        list.add("group_floatpl_end");
        list.add("floatpl_end_original");
        list.add("floatpl_end_report");
        list.add("group_pl");
        list.add("pl_original");
        list.add("pl_report");
        list.add("group_totalpl");
        list.add("totalpl_original");
        list.add("totalpl_report");
        return list;
    }

    protected List<String> getHideGroupColumns(String swapType, String[] dimensionArr) {
        ArrayList<String> hideColumns = new ArrayList<String>(10);
        boolean paycurrency = Arrays.stream(dimensionArr).anyMatch(e -> e.contains("paycurrency"));
        boolean reccurrency = Arrays.stream(dimensionArr).anyMatch(e -> e.contains("reccurrency"));
        if (!paycurrency) {
            hideColumns.add("group_conamtpay");
            hideColumns.add("conamtpay_original");
            hideColumns.add("conamtpay_report");
            hideColumns.add("group_hisamtpay");
            hideColumns.add("hisamtpay_original");
            hideColumns.add("hisamtpay_report");
            hideColumns.add("group_hisamtpay_end");
            hideColumns.add("hisamtpay_end_original");
            hideColumns.add("hisamtpay_end_report");
        }
        if (!reccurrency) {
            hideColumns.add("group_conamtrec");
            hideColumns.add("conamtrec_original");
            hideColumns.add("conamtrec_report");
            hideColumns.add("group_hisamtrec");
            hideColumns.add("hisamtrec_original");
            hideColumns.add("hisamtrec_report");
            hideColumns.add("group_hisamtrec_end");
            hideColumns.add("hisamtrec_end_original");
            hideColumns.add("hisamtrec_end_report");
        }
        if (!paycurrency && !reccurrency) {
            hideColumns.remove("group_conamtpay");
            hideColumns.remove("conamtpay_report");
            hideColumns.remove("group_hisamtpay");
            hideColumns.remove("hisamtpay_report");
            hideColumns.remove("group_hisamtpay_end");
            hideColumns.remove("hisamtpay_end_report");
            hideColumns.remove("group_conamtrec");
            hideColumns.remove("conamtrec_report");
            hideColumns.remove("group_hisamtrec");
            hideColumns.remove("hisamtrec_report");
            hideColumns.remove("group_hisamtrec_end");
            hideColumns.remove("hisamtrec_end_report");
        }
        if ("curswap".equals(swapType)) {
            hideColumns.add("floatpl_original");
            hideColumns.add("floatpl_end_original");
            hideColumns.add("pl_original");
            hideColumns.add("totalpl_original");
        } else if (!paycurrency && !reccurrency) {
            hideColumns.add("floatpl_original");
            hideColumns.add("floatpl_end_original");
            hideColumns.add("pl_original");
            hideColumns.add("totalpl_original");
        }
        return hideColumns;
    }
}

