/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.formplugin.pnl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateListColumnsListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ExRateDirEnum;
import kd.tmc.fbp.common.enums.PlCalcMethodEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TmcAppEnum;
import kd.tmc.fbp.common.enums.UseExRateEnum;
import kd.tmc.fbp.common.helper.TmcParameterHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.OptionsBizHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.model.ModelAgent;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tbo.common.constant.ParamKeyConst;
import kd.tmc.tbo.common.helper.PlInfoCalculateHelper;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;

public class PlForexEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
CreateListColumnsListener {
    private static Log logger = LogFactory.getLog(PlForexEdit.class);
    private static final String[] MARKET_INFO_PANELS = new String[]{"flexcalccfg", "flexmarket", "fp_option", "flexdetail"};

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("historybilllist");
        if (billList != null) {
            billList.addCreateListColumnsListener((CreateListColumnsListener)this);
        }
    }

    public void createListColumns(BeforeCreateListColumnsArgs arg0) {
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        String number = tradeType.getString("number");
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
            DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("buycurrency");
            DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
            DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("localcurrency");
            if (buyCurrency == null || buyCurrency.getString("number").equals(localCurrency.getString("number")) || sellCurrency == null || sellCurrency.getString("number").equals(localCurrency.getString("number")) || !PlCalcMethodEnum.EXCHANGE_RATE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod")) || !"deliverable".equals(tradeBill.getString("deliveryway"))) {
                List columns = arg0.getListColumns();
                columns.removeIf(c -> "voucher_pl".equals(c.getListFieldKey()));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (!this.validateProductType()) {
            return;
        }
        BasedataEdit plcurrency = (BasedataEdit)this.getView().getControl("plcurrency");
        if (plcurrency != null) {
            plcurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        Date bizDate;
        super.afterBindData(e);
        if (!this.validateProductType()) {
            return;
        }
        boolean b = false;
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("bizrestamt")) && this.isNotHistoryBill()) {
            Date updateDate = (Date)this.getModel().getValue("updatedate");
            Date currentDate = DateUtils.getCurrentDate();
            boolean dataChanged = this.getModel().getDataChanged();
            if (updateDate == null) {
                this.setUpdateDate(currentDate);
                b = true;
            } else if (currentDate.compareTo(updateDate) != 0 || EmptyUtil.isEmpty((Object)this.getModel().getValue("floatplamt")) && EmptyUtil.isEmpty((Object)this.getModel().getValue("floatpllocalamt")) && EmptyUtil.isEmpty((Object)this.getModel().getValue("voucher_pl"))) {
                this.getModel().setValue("updatedate", null);
                this.setUpdateDate(currentDate);
                b = true;
            }
            this.getModel().setDataChanged(dataChanged);
        }
        if (!b) {
            this.enableBizRestAmt(false);
        }
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("srcbizbill"))) {
            DynamicObject bizBill = QueryServiceHelper.queryOne((String)"tm_businessbill", (String)"bizdate", (QFilter[])new QFilter("id", "=", this.getModel().getValue("srcbizbill")).toArray());
            bizDate = bizBill.getDate("bizdate");
        } else {
            DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            bizDate = tradeBill.getDate("bizdate");
        }
        if (bizDate != null) {
            ((DateEdit)this.getView().getControl("updatedate")).setMinDate(bizDate);
        }
        this.setFiledHiddenOrShow();
        this.setVisible_byPlCalcMethod();
        this.setVisible_voucherPl();
        this.setVisible_spotExRate();
    }

    private void enableBizRestAmt(boolean callByUpdateDateChangeEvt) {
        DynamicObject bizRecord;
        String formId = this.getView().getFormShowParameter().getFormId();
        if (!("tbo_pl_h_forexoption_l".equals(formId) || "tbo_plinfo_h_forexfwd_l".equals(formId) || "tbo_plinfo_forexoption_l".equals(formId) || "tbo_plinfo_forexfwd_l".equals(formId))) {
            return;
        }
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        Object bizRecordId = this.getModel().getValue("bizrecord");
        Date updateDate = (Date)this.getModel().getValue("updatedate");
        BigDecimal bizRestAmt = (BigDecimal)this.getModel().getValue("bizrestamt");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrys");
        boolean enableBizRestAmt = false;
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        String number = tradeType.getString("number");
        String swapType = tradeBill.getString("swaptype");
        String swapDir = (String)this.getModel().getValue("swapdir");
        if (!(ProductTypeEnum.FOREXSPOT.getValue().equals(number) || ProductTypeEnum.FOREXSWAPS.getValue().equals(number) && (ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(swapType) || ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(swapType) && "isnear".equals(swapDir)) || TcBillStatusEnum.FINISH.getValue().equals(tradeBill.get("billstatus")) || EmptyUtil.isAnyoneEmpty((Object[])new Object[]{bizRecordId, updateDate, entryEntity}) || bizRestAmt.compareTo(BigDecimal.ZERO) <= 0)) {
            enableBizRestAmt = entryEntity.stream().filter(o -> o.getDate("bizdate") != null && o.getDate("bizdate").compareTo(updateDate) > 0).findAny().isPresent();
        }
        if (enableBizRestAmt) {
            this.getView().setEnable(Boolean.TRUE, new String[]{"bizrestamt"});
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u65e5\u671f\u540e\u5b58\u5728\u751f\u547d\u5468\u671f\u64cd\u4f5c\uff0c\u672a\u4ea4\u5272\u91d1\u989d\u53ef\u80fd\u9519\u8bef\uff0c\u53ef\u624b\u5de5\u4fee\u6539\u66f4\u65b0\u3002", (String)"PlForexEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{"bizrestamt"});
        }
        if (callByUpdateDateChangeEvt && (bizRecord = QueryServiceHelper.queryOne((String)"tm_bizrecord", (String)"restamt", (QFilter[])new QFilter("id", "=", bizRecordId).toArray())).getBigDecimal("restamt").compareTo(bizRestAmt) != 0) {
            this.getModel().setValue("bizrestamt", (Object)bizRecord.getBigDecimal("restamt"));
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "bizrestamt": {
                if (EmptyUtil.isEmpty((Object)e.getValue())) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PlForexEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[]{((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"bizrestamt")).getDisplayName().getLocaleValue()}));
                    this.getView().updateView("bizrestamt");
                    return;
                }
                BigDecimal bizRestAmt = new BigDecimal((String)e.getValue());
                if (bizRestAmt.compareTo(BigDecimal.ZERO) <= 0) {
                    e.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u4ea4\u5272\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PlForexEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    this.getView().updateView("bizrestamt");
                    return;
                }
                BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
                if (bizRestAmt.compareTo(amount) <= 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u4ea4\u5272\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u57fa\u51c6\u5e01\u79cd\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PlForexEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                this.getView().updateView("bizrestamt");
                break;
            }
            case "spotexrate": {
                if (!EmptyUtil.isEmpty((Object)e.getValue()) && new BigDecimal((String)e.getValue()).compareTo(BigDecimal.ZERO) > 0) break;
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"PlForexEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[]{((IDataEntityProperty)this.getModel().getDataEntity().getDataEntityType().getProperties().get((Object)"spotexrate")).getDisplayName().getLocaleValue()}));
                this.getView().updateView("spotexrate");
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (!this.validateProductType()) {
            return;
        }
        String keyname = e.getProperty().getName();
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        String number = tradeType.getString("number");
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        switch (keyname) {
            case "plcurrency": {
                if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number) || ProductTypeEnum.FOREXSWAPS.getValue().equals(number)) {
                    this.calFloatPlAmtByReferExRate();
                } else if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
                    if (PlCalcMethodEnum.EXCHANGE_RATE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) {
                        this.calFloatPl_ForexOption_byExRate(tradeBill);
                    }
                    if (PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) {
                        this.updateReferPremium();
                    }
                }
                this.setFiledHiddenOrShow();
                this.setVisible_spotExRate();
                break;
            }
            case "referexrate": {
                if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number) || ProductTypeEnum.FOREXSWAPS.getValue().equals(number)) {
                    DynamicObject forexQuote = (DynamicObject)this.getModel().getValue("forexquote");
                    if (!EmptyUtil.isNoEmpty((DynamicObject)forexQuote)) break;
                    Map result = PlInfoCalculateHelper.calFloatPlAmt_Forex((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)tradeBill, (boolean)true, (BigDecimal)((BigDecimal)this.getModel().getValue("spotexrate")));
                    this.getModel().setValue("floatplamt", result.get("floatplamt"));
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"spotexrate", result.get("spotexrate"));
                    break;
                }
                if (!ProductTypeEnum.FOREXOPTION.getValue().equals(number) || !PlCalcMethodEnum.EXCHANGE_RATE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) break;
                Map result = PlInfoCalculateHelper.calFloatPl_ForexOption_byExRate((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)tradeBill, (boolean)true, (BigDecimal)((BigDecimal)this.getModel().getValue("spotexrate")));
                this.getModel().setValue("floatplamt", result.get("floatplamt"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"spotexrate", result.get("spotexrate"));
                break;
            }
            case "forexquote": {
                this.fq_changedEvent();
                if (!ProductTypeEnum.FOREXOPTION.getValue().equals(number) || !PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) break;
                this.updateReferPremium();
                break;
            }
            case "updatedate": {
                String traceId = RequestContext.get().getTraceId();
                if (ParamKeyConst.SKIP_PROPERTY_CHANGED_EVENT.equals(this.getView().getPageCache().get(traceId))) break;
                try {
                    this.enableBizRestAmt(true);
                    this.fq_changedEvent();
                    if (!ProductTypeEnum.FOREXOPTION.getValue().equals(number) || !PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) break;
                    this.updateReferPremium();
                    break;
                }
                catch (Exception ex) {
                    if (EmptyUtil.isNoEmpty((String)traceId)) {
                        this.getView().getPageCache().put(traceId, ParamKeyConst.SKIP_PROPERTY_CHANGED_EVENT);
                        this.getModel().setValue("updatedate", e.getChangeSet()[0].getOldValue());
                        this.getView().showErrorNotification(ex.getMessage());
                        logger.error((Throwable)ex);
                        break;
                    }
                    throw ex;
                }
            }
            case "spotrate": 
            case "forwrate": 
            case "currencyrate": 
            case "pricecurrencyrate": 
            case "volatility": {
                this.updateReferPremium();
                break;
            }
            case "referpremium": {
                this.calFloatPl_ForexOption();
                break;
            }
            case "buy_local_exrate": 
            case "sell_local_exrate": {
                this.updateVoucherPl();
                break;
            }
            case "plcalcmethod": {
                this.setVisible_byPlCalcMethod();
                this.setVisible_spotExRate();
                if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
                    if (PlCalcMethodEnum.EXCHANGE_RATE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) {
                        this.calFloatPl_ForexOption_byExRate(tradeBill);
                        this.updateVoucherPl();
                    } else if (PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) {
                        this.getModel().setValue("voucher_pl", (Object)BigDecimal.ZERO);
                        this.calFloatPl_ForexOption();
                    }
                }
                this.setVisible_voucherPl();
                BillList historyBillList = (BillList)this.getControl("historybilllist");
                if (historyBillList == null) break;
                historyBillList.addSetFilterListener(evt -> {
                    QFilter sourceIdFilter = new QFilter("plbill", "=", this.getModel().getDataEntity().getPkValue());
                    evt.getQFilters().add(sourceIdFilter);
                });
                historyBillList.refreshData();
                break;
            }
            case "bizrestamt": {
                this.bizRestAmt_changeEvt(number);
                break;
            }
            case "spotexrate": {
                BigDecimal spotExRate = (BigDecimal)this.getModel().getValue("spotexrate");
                if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number) || ProductTypeEnum.FOREXSWAPS.getValue().equals(number)) {
                    Map result = PlInfoCalculateHelper.calFloatPlAmt_Forex((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)tradeBill, (boolean)true, (BigDecimal)spotExRate);
                    this.getModel().setValue("floatplamt", result.get("floatplamt"));
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"spotexrate", result.get("spotexrate"));
                    break;
                }
                if (!ProductTypeEnum.FOREXOPTION.getValue().equals(number)) break;
                if (PlCalcMethodEnum.EXCHANGE_RATE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) {
                    Map result = PlInfoCalculateHelper.calFloatPl_ForexOption_byExRate((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)tradeBill, (boolean)true, (BigDecimal)spotExRate);
                    this.getModel().setValue("floatplamt", result.get("floatplamt"));
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"spotexrate", result.get("spotexrate"));
                }
                if (!PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) break;
                BigDecimal floatPlAmt = PlInfoCalculateHelper.calFloatPl_ForexOption_byReferPremium((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)tradeBill, (boolean)true);
                this.getModel().setValue("floatplamt", (Object)floatPlAmt);
            }
        }
    }

    private void bizRestAmt_changeEvt(String number) {
        DynamicObject standardCurrency;
        DynamicObject buyCurrency;
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        String fxQuote = tradeBill.getString("fxquote");
        BigDecimal bizRestAmt = (BigDecimal)this.getModel().getValue("bizrestamt");
        BigDecimal exRate = (BigDecimal)this.getModel().getValue("exrate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{fxQuote, exRate, buyCurrency = (DynamicObject)this.getModel().getValue("buycurrency"), standardCurrency = (DynamicObject)this.getModel().getValue("standardcurrency")})) {
            BigDecimal priceCurrencyAmt = standardCurrency.getString("number").equals(fxQuote.split("/")[0]) ? bizRestAmt.multiply(exRate) : bizRestAmt.divide(exRate, 6, 4);
            if (standardCurrency.getString("number").equals(buyCurrency.getString("number"))) {
                this.getModel().setValue("buyamount", (Object)bizRestAmt);
                this.getModel().setValue("sellamount", (Object)priceCurrencyAmt);
            } else {
                this.getModel().setValue("buyamount", (Object)priceCurrencyAmt);
                this.getModel().setValue("sellamount", (Object)bizRestAmt);
            }
        }
        if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number) || ProductTypeEnum.FOREXSWAPS.getValue().equals(number)) {
            this.calFloatPlAmtByReferExRate();
            this.updateVoucherPl();
        } else if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
            if (PlCalcMethodEnum.EXCHANGE_RATE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) {
                this.calFloatPl_ForexOption_byExRate(tradeBill);
                this.updateVoucherPl();
            }
            if (PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) {
                this.updateReferPremium();
            }
        }
    }

    private void setUpdateDate(Date currentDate) {
        try {
            this.getModel().setValue("updatedate", (Object)currentDate);
        }
        catch (Exception exception) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"issuedate", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"fxquotetype", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"referexrate", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"fxquote_local", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exrate_local", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buy_local_fq", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buy_local_exrate", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sell_local_fq", null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sell_local_exrate", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"floatplamt", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"floatpllocalamt", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"voucher_pl", (Object)BigDecimal.ZERO);
            this.getView().showErrorNotification(exception.getMessage());
            logger.error((Throwable)exception);
        }
    }

    private void setVisible_byPlCalcMethod() {
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        this.getView().setVisible(Boolean.valueOf("american".equals(tradeBill.getString("optiontype"))), new String[]{"spotrate"});
        this.getView().setVisible(Boolean.valueOf("european".equals(tradeBill.getString("optiontype"))), new String[]{"forwrate"});
    }

    private void updateReferPremium() {
        BigDecimal volatility;
        BigDecimal priceCurrencyRate;
        BigDecimal currencyRate;
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        BigDecimal exRate = "american".equals(tradeBill.getString("optiontype")) ? (BigDecimal)this.getModel().getValue("spotrate") : (BigDecimal)this.getModel().getValue("forwrate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exRate, currencyRate = (BigDecimal)this.getModel().getValue("currencyrate"), priceCurrencyRate = (BigDecimal)this.getModel().getValue("pricecurrencyrate"), volatility = (BigDecimal)this.getModel().getValue("volatility")})) {
            BigDecimal referPremium = OptionsBizHelper.getReferPremiumOption((ModelAgent)new ModelAgent((Object)tradeBill), (BigDecimal)exRate, (DynamicObject)this.getModel().getDataEntity(), (BigDecimal[])new BigDecimal[]{volatility, currencyRate, priceCurrencyRate});
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"referpremium", (Object)referPremium);
        }
        this.calFloatPl_ForexOption();
    }

    private void fq_changedEvent_forexOption() {
        logger.info("PlForexEdit.fq_changedEvent_forexOption");
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject forexQuote = (DynamicObject)this.getModel().getValue("forexquote");
        Date updateDate = (Date)this.getModel().getValue("updatedate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{tradeBill, forexQuote, updateDate})) {
            ForexQuoteInfo fqInfo;
            Long fqId = forexQuote.getLong("id");
            String useExRate = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"useexrate");
            String exRateDir = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"exratedir");
            Date Dm = UseExRateEnum.FORWARD.getValue().equals(useExRate) ? tradeBill.getDate("adjustsettledate") : null;
            String pair = tradeBill.getString("pair");
            String fxQuote = tradeBill.getString("fxquote");
            if (!fxQuote.equals((fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)updateDate, (Date)Dm)).getFxquote())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u4ef7\u6765\u6e90\u7684\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u4e0e\u4ea4\u6613\u5355\u636e\u7684\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u62a5\u4ef7\u6765\u6e90\u3002", (String)"PlForexEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue("issuedate", (Object)fqInfo.getIssuetime());
            this.getModel().setValue("fxquotetype", (Object)fqInfo.getFxquote());
            BigDecimal referExRate = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? PlInfoCalculateHelper.getReferExRate_ForexOptions((ForexQuoteInfo)fqInfo, (DynamicObject)tradeBill) : fqInfo.getMiddleprice();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"referexrate", (Object)referExRate);
            if (PlCalcMethodEnum.EXCHANGE_RATE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) {
                this.calFloatPl_ForexOption_byExRate(tradeBill);
                DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("buycurrency");
                DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
                DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("localcurrency");
                if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCurrency, sellCurrency, localCurrency}) && buyCurrency.getLong("id") != localCurrency.getLong("id") && sellCurrency.getLong("id") != localCurrency.getLong("id") && "deliverable".equals(tradeBill.getString("deliveryway"))) {
                    this.setBuySellForexQuoteInfo(localCurrency, fqId, Dm, exRateDir);
                }
            } else if (PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"forwrate", (Object)referExRate);
                ForexQuoteInfo spotFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)updateDate, null);
                BigDecimal spotRate = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? PlInfoCalculateHelper.getReferExRate_ForexOptions((ForexQuoteInfo)spotFqInfo, (DynamicObject)tradeBill) : spotFqInfo.getMiddleprice();
                this.getModel().setValue("spotrate", (Object)spotRate);
            }
        }
    }

    private void calFloatPl_ForexOption_byExRate(DynamicObject tradeBill) {
        Map result = PlInfoCalculateHelper.calFloatPl_ForexOption_byExRate((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)tradeBill, (boolean)true, null);
        this.getModel().setValue("floatplamt", result.get("floatplamt"));
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"spotexrate", result.get("spotexrate"));
    }

    private void calFloatPlAmtByReferExRate() {
        DynamicObject forexquote = (DynamicObject)this.getModel().getValue("forexquote");
        if (EmptyUtil.isNoEmpty((DynamicObject)forexquote)) {
            DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            Map result = PlInfoCalculateHelper.calFloatPlAmt_Forex((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)tradeBill, (boolean)true, null);
            this.getModel().setValue("floatplamt", result.get("floatplamt"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"spotexrate", result.get("spotexrate"));
        }
    }

    private void calFloatPl_ForexOption() {
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        if (PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) {
            BigDecimal floatPlAmt = PlInfoCalculateHelper.calFloatPl_ForexOption_byReferPremium((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)tradeBill, (boolean)true);
            this.getModel().setValue("floatplamt", (Object)floatPlAmt);
        } else if (PlCalcMethodEnum.EXCHANGE_RATE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod"))) {
            Map result = PlInfoCalculateHelper.calFloatPl_ForexOption_byExRate((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)tradeBill, (boolean)true, null);
            this.getModel().setValue("floatplamt", result.get("floatplamt"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"spotexrate", result.get("spotexrate"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        boolean b;
        super.beforeDoOperation(args);
        if (!this.validateProductType()) {
            return;
        }
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("refreshfq".equals(operateKey) && !(b = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"tradebill", "updatedate", "forexquote"}))) {
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (!this.validateProductType()) {
            return;
        }
        String operateKey = args.getOperateKey();
        if ("refreshfq".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.fq_changedEvent();
        }
    }

    private void fq_changedEvent() {
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        String number = tradeType.getString("number");
        if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number)) {
            this.fq_changedEvent_forexForward();
        } else if (ProductTypeEnum.FOREXSWAPS.getValue().equals(number)) {
            DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            String swapType = tradeBill.getString("swaptype");
            String swapDir = (String)this.getModel().getValue("swapdir");
            if (ForexSwapsTypeEnum.FWDTOFWD.getValue().equals(swapType) || ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(swapType) && "isfar".equals(swapDir)) {
                this.fq_changedEvent_forexForward();
            }
        } else if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
            this.fq_changedEvent_forexOption();
        }
    }

    private void fq_changedEvent_forexForward() {
        logger.info("PlForexEdit.fq_changedEvent_forexForward");
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject forexQuote = (DynamicObject)this.getModel().getValue("forexquote");
        Date updateDate = (Date)this.getModel().getValue("updatedate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{tradeBill, forexQuote, updateDate})) {
            ForexQuoteInfo fqInfo;
            String fxquote;
            Long fqId = forexQuote.getLong("id");
            String useExRate = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"useexrate");
            String exRateDir = TmcParameterHelper.getAppStringParameter((String)TmcAppEnum.TM.getId(), (long)tradeBill.getDynamicObject("org").getLong("id"), (String)"exratedir");
            Date Dm = UseExRateEnum.FORWARD.getValue().equals(useExRate) ? PlInfoCalculateHelper.getDeyDateForReferExRate((DynamicObject)this.getModel().getDataEntity()) : null;
            String pair = tradeBill.getString("pair");
            String fxQuote = tradeBill.getString("fxquote");
            if (!fxQuote.equals(fxquote = (fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)updateDate, (Date)Dm)).getFxquote())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u4ef7\u6765\u6e90\u7684\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u4e0e\u4ea4\u6613\u5355\u636e\u7684\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u62a5\u4ef7\u6765\u6e90\u3002", (String)"PlForexEdit_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue("issuedate", (Object)fqInfo.getIssuetime());
            this.getModel().setValue("fxquotetype", (Object)fqInfo.getFxquote());
            BigDecimal exRate = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir) ? PlInfoCalculateHelper.getReferExRate((ForexQuoteInfo)fqInfo, (DynamicObject)tradeBill, (DynamicObject)this.getModel().getDataEntity()) : fqInfo.getMiddleprice();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"referexrate", (Object)exRate);
            Map result = PlInfoCalculateHelper.calFloatPlAmt_Forex((DynamicObject)this.getModel().getDataEntity(), (DynamicObject)tradeBill, (boolean)true, null);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"spotexrate", result.get("spotexrate"));
            this.getModel().setValue("floatplamt", result.get("floatplamt"));
            DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("buycurrency");
            DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
            DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("localcurrency");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCurrency, sellCurrency, localCurrency}) && buyCurrency.getLong("id") != localCurrency.getLong("id") && sellCurrency.getLong("id") != localCurrency.getLong("id") && "deliverable".equals(tradeBill.getString("deliveryway"))) {
                this.setBuySellForexQuoteInfo(localCurrency, fqId, Dm, exRateDir);
            }
        }
    }

    private void setBuySellForexQuoteInfo(DynamicObject localCurrency, Long fqId, Date Dm, String exRateDir) {
        logger.info("PlForexEdit.setBuySellForexQuoteInfo");
        DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("buycurrency");
        DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
        String buyCurrencyNumber = buyCurrency.getString("number");
        String sellCurrencyNumber = sellCurrency.getString("number");
        ForexQuoteInfo buyCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)(buyCurrencyNumber + "/" + localCurrency.getString("number")), (Date)((Date)this.getModel().getValue("updatedate")), (Date)Dm);
        String buyCurFxQuote = buyCurFqInfo.getFxquote();
        boolean isUseBuyOrSellPrice = ExRateDirEnum.BUY_OR_SELL_PRICE.getValue().equals(exRateDir);
        BigDecimal buyExRate = buyCurrencyNumber.equals(buyCurFxQuote.split("/")[0]) ? (isUseBuyOrSellPrice ? buyCurFqInfo.getBuyPrice() : buyCurFqInfo.getMiddleprice()) : (isUseBuyOrSellPrice ? buyCurFqInfo.getSellPrice() : buyCurFqInfo.getMiddleprice());
        ForexQuoteInfo sellCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)(sellCurrencyNumber + "/" + localCurrency.getString("number")), (Date)((Date)this.getModel().getValue("updatedate")), (Date)Dm);
        String sellCurFxQuote = sellCurFqInfo.getFxquote();
        BigDecimal sellExRate = sellCurrencyNumber.equals(sellCurFxQuote.split("/")[0]) ? (isUseBuyOrSellPrice ? sellCurFqInfo.getBuyPrice() : sellCurFqInfo.getMiddleprice()) : (isUseBuyOrSellPrice ? sellCurFqInfo.getSellPrice() : sellCurFqInfo.getMiddleprice());
        this.getModel().setValue("buy_local_fq", (Object)buyCurFxQuote);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buy_local_exrate", (Object)buyExRate);
        this.getModel().setValue("sell_local_fq", (Object)sellCurFxQuote);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sell_local_exrate", (Object)sellExRate);
        this.updateVoucherPl();
    }

    private void updateVoucherPl() {
        logger.info("PlForexEdit.updateVoucherPl");
        DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("buycurrency");
        DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
        BigDecimal buyAmt = (BigDecimal)this.getModel().getValue("buyamount");
        BigDecimal sellAmt = (BigDecimal)this.getModel().getValue("sellamount");
        String buyCurFxQuote = (String)this.getModel().getValue("buy_local_fq");
        String sellCurFxQuote = (String)this.getModel().getValue("sell_local_fq");
        BigDecimal buyExRate = (BigDecimal)this.getModel().getValue("buy_local_exrate");
        BigDecimal sellExRate = (BigDecimal)this.getModel().getValue("sell_local_exrate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCurrency, sellCurrency, buyAmt, sellAmt, buyCurFxQuote, sellCurFxQuote, buyExRate, sellExRate})) {
            logger.info("\u66f4\u65b0\u201c\u8bb0\u8d26\u635f\u76ca\u201d\u6761\u4ef6\u4e0d\u8db3");
            return;
        }
        String buyCurrencyNumber = buyCurrency.getString("number");
        String sellCurrencyNumber = sellCurrency.getString("number");
        BigDecimal buyExAmt = buyCurrencyNumber.equals(buyCurFxQuote.split("/")[0]) ? buyAmt.multiply(buyExRate) : buyAmt.divide(buyExRate, 10, 4);
        BigDecimal sellExAmt = sellCurrencyNumber.equals(sellCurFxQuote.split("/")[0]) ? sellAmt.multiply(sellExRate) : sellAmt.divide(sellExRate, 10, 4);
        this.getModel().setValue("voucher_pl", (Object)buyExAmt.subtract(sellExAmt));
    }

    private void setFiledHiddenOrShow() {
        DynamicObject bizRecord;
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        String number = tradeType.getString("number");
        if (ProductTypeEnum.FOREXSPOT.getValue().equals(number)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"type", "fp_marketinfo"});
        }
        if (ProductTypeEnum.FOREXFORWARD.getValue().equals(number) && (bizRecord = PlInfoCalculateHelper.getBizBillBizRecord((DynamicObject)this.getModel().getDataEntity())).getBigDecimal("restamt").compareTo(BigDecimal.ZERO) == 0 && this.isNotHistoryBill()) {
            this.getView().setVisible(Boolean.valueOf(false), MARKET_INFO_PANELS);
        }
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        if (ProductTypeEnum.FOREXSWAPS.getValue().equals(number)) {
            String swapType = tradeBill.getString("swaptype");
            String swapDir = (String)this.getModel().getValue("swapdir");
            switch (swapType) {
                case "SpotToSpot": {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"fp_marketinfo"});
                    break;
                }
                case "SpotToFwd": {
                    DynamicObject bizRecord2;
                    if ("isnear".equals(swapDir)) {
                        this.getView().setVisible(Boolean.valueOf(false), new String[]{"fp_marketinfo"});
                    }
                    if (!"isfar".equals(swapDir) || (bizRecord2 = PlInfoCalculateHelper.getBizBillBizRecord((DynamicObject)this.getModel().getDataEntity())).getBigDecimal("restamt").compareTo(BigDecimal.ZERO) != 0 || !this.isNotHistoryBill()) break;
                    this.getView().setVisible(Boolean.valueOf(false), MARKET_INFO_PANELS);
                    break;
                }
                case "FwdToFwd": {
                    DynamicObject bizRecord3 = PlInfoCalculateHelper.getBizBillBizRecord((DynamicObject)this.getModel().getDataEntity());
                    if (bizRecord3.getBigDecimal("restamt").compareTo(BigDecimal.ZERO) != 0 || !this.isNotHistoryBill()) break;
                    this.getView().setVisible(Boolean.valueOf(false), MARKET_INFO_PANELS);
                }
            }
        }
    }

    private boolean isNotHistoryBill() {
        return "tbo_plinfo".equals(this.getView().getEntityId());
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject tradeBill;
        String fxquote;
        if (!this.validateProductType()) {
            return;
        }
        String fieldKey = evt.getProperty().getName();
        if ("plcurrency".equals(fieldKey) && !"".equals(fxquote = (tradeBill = (DynamicObject)this.getModel().getValue("tradebill")).getString("fxquote"))) {
            String[] fxquotes = fxquote.split("/");
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("number", "=", (Object)fxquotes[0]);
            qFilter.or("number", "=", (Object)fxquotes[1]);
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private boolean validateProductType() {
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        String number = tradeType.getString("number");
        return ProductTypeEnum.FOREXSPOT.getValue().equals(number) || ProductTypeEnum.FOREXFORWARD.getValue().equals(number) || ProductTypeEnum.FOREXSWAPS.getValue().equals(number) || ProductTypeEnum.FOREXOPTION.getValue().equals(number);
    }

    private void setVisible_voucherPl() {
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        String number = tradeType.getString("number");
        if (ProductTypeEnum.FOREXOPTION.getValue().equals(number)) {
            DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("buycurrency");
            DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
            DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("localcurrency");
            if (buyCurrency != null && !buyCurrency.getString("number").equals(localCurrency.getString("number")) && sellCurrency != null && !sellCurrency.getString("number").equals(localCurrency.getString("number")) && PlCalcMethodEnum.EXCHANGE_RATE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod")) && "deliverable".equals(tradeBill.getString("deliveryway"))) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"voucher_pl"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"voucher_pl"});
            }
        }
    }

    private void setVisible_spotExRate() {
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        DynamicObject currency = tradeBill.getDynamicObject("currency");
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        String number = tradeType.getString("number");
        boolean isShow = plCurrency != null && plCurrency.getString("number").equals(currency.getString("number")) && (!ProductTypeEnum.FOREXOPTION.getValue().equals(number) || !PlCalcMethodEnum.CURRENT_VALUE_NETTING.getValue().equals(this.getModel().getValue("plcalcmethod")));
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"spotexrate"});
        if (!isShow && EmptyUtil.isNoEmpty((Object)this.getModel().getValue("spotexrate"))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"spotexrate", (Object)BigDecimal.ZERO);
        }
    }
}

