/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.formplugin.pnl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tbo.common.model.OpConfirmDialogInfo;
import kd.tmc.tbo.formplugin.common.helper.Validator;
import kd.tmc.tbo.formplugin.pnl.common.PlProvisionHelper;
import kd.tmc.tm.common.enums.ForexSwapsTypeEnum;

public class PlInfoProvisionList
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(PlInfoProvisionList.class);
    private static final String VALIDATE_FLAG = "validateFlag";
    private static final String TRADE_VALIDATE_FINISHED = "tradeValidateFinished";
    private static final String VALIDATE_FINISHED = "validateFinished";
    private static final String AUTO_GEN_PL_DIALOG = "autoGenPlDialog";
    private static final String AUTO_GEN_PL_DIALOG_OPEN_BY_BATCH_PROVISION = "autoGenPlDialogOpenByBatchProvision";
    private static final String PL_PROVISION_DATE_FORM = "plProvisionDateForm";
    private static final String PL_PROVISION_DATE_FORM_OPEN_BY_BATCH_PROVISION = "plProvisionDateFormOpenByBatchProvision";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (operateKey = formOperate.getOperateKey()) {
            case "singleprovision": 
            case "batchprovision": {
                AbstractOperate op = (AbstractOperate)args.getSource();
                String validateFlag = null;
                if (op.getOption().containsVariable(VALIDATE_FLAG)) {
                    validateFlag = op.getOption().getVariableValue(VALIDATE_FLAG);
                }
                if (EmptyUtil.isEmpty(validateFlag)) {
                    args.setCancel(true);
                    this.validateBeforeProvision123(operateKey);
                    break;
                }
                if (TRADE_VALIDATE_FINISHED.equals(validateFlag)) {
                    String provisionDateStr = op.getOption().getVariableValue("provisionDate");
                    Date provisionDate = DateUtils.stringToDate((String)provisionDateStr, (String)"yyyy-MM-dd");
                    Set<Object> noPlDataIds = this.validateBeforeProvision5(provisionDate);
                    if (!EmptyUtil.isNoEmpty(noPlDataIds)) break;
                    args.setCancel(true);
                    this.getView().getPageCache().put("provisionDate", provisionDateStr);
                    String callBackId = "singleprovision".equals(operateKey) ? AUTO_GEN_PL_DIALOG : AUTO_GEN_PL_DIALOG_OPEN_BY_BATCH_PROVISION;
                    DynamicObjectCollection plBills = QueryServiceHelper.query((String)"tbo_plinfo", (String)"billno,tradebill.number", (QFilter[])new QFilter("id", "in", noPlDataIds).toArray());
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("tbo_op_confirm_dialog");
                    String tipText = ResManager.loadKDString((String)"\u4e0b\u5217\u635f\u76ca\u5355\u6ca1\u6709\u751f\u6210 %s \u65e5\u7684\u6d6e\u52a8\u635f\u76ca\uff0c\u662f\u5426\u81ea\u52a8\u751f\u6210\uff1f", (String)"PlInfoProvisionList_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{provisionDateStr});
                    ArrayList<String[]> columns = new ArrayList<String[]>(1);
                    columns.add(new String[]{"billNo", ResManager.loadKDString((String)"\u635f\u76ca\u5355\u53f7", (String)"PlInfoProvisionList_1", (String)"tmc-tm-formplugin", (Object[])new Object[0])});
                    columns.add(new String[]{"tradeNo", ResManager.loadKDString((String)"\u4ea4\u6613\u53f7", (String)"PlInfoProvisionList_2", (String)"tmc-tm-formplugin", (Object[])new Object[0])});
                    ArrayList data = new ArrayList(8);
                    for (DynamicObject plBill : plBills) {
                        HashMap<String, String> rowMap = new HashMap<String, String>(1);
                        rowMap.put("billNo", plBill.getString("billno"));
                        rowMap.put("tradeNo", plBill.getString("tradebill.number"));
                        data.add(rowMap);
                    }
                    OpConfirmDialogInfo dialogInfo = new OpConfirmDialogInfo(tipText, columns, data);
                    showParameter.setCustomParam("dialogInfo", (Object)dialogInfo);
                    showParameter.setCaption(ResManager.loadKDString((String)"\u64cd\u4f5c\u786e\u8ba4", (String)"PlInfoProvisionList_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    showParameter.getOpenStyle().setShowType(ShowType.Modal);
                    showParameter.setStatus(OperationStatus.VIEW);
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, callBackId);
                    showParameter.setCloseCallBack(closeCallBack);
                    this.getView().showForm(showParameter);
                    break;
                }
                if (VALIDATE_FINISHED.equals(validateFlag)) break;
                throw new KDBizException("unKnown validateFlag : " + validateFlag);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        DynamicObject[] plBills;
        Date provisionDate;
        String provisionDateStr;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        AbstractOperate op = (AbstractOperate)afterDoOperationEventArgs.getSource();
        OperationResult opResult = afterDoOperationEventArgs.getOperationResult();
        if ("singleprovision".equals(operateKey) && opResult.isSuccess()) {
            provisionDateStr = op.getOption().getVariableValue("provisionDate");
            provisionDate = DateUtils.stringToDate((String)provisionDateStr, (String)"yyyy-MM-dd");
            plBills = this.queryHistoryFloatPlBills(provisionDate);
            ArrayList<DynamicObject> plProvisionBills = new ArrayList<DynamicObject>(1);
            ArrayList<String> tipRows = new ArrayList<String>(1);
            for (DynamicObject plBill : plBills) {
                int precision;
                DynamicObject currency = plBill.getDynamicObject("localcurrency");
                BigDecimal amount = plBill.getBigDecimal("floatplamt");
                BigDecimal newAmount = amount.setScale(precision = currency.getInt("amtprecision"), RoundingMode.HALF_UP);
                if (newAmount.compareTo(BigDecimal.ZERO) == 0) {
                    DynamicObject pl = plBill.getDynamicObject("plbill");
                    if (pl == null || tipRows.size() >= 100) continue;
                    tipRows.add(ResManager.loadKDString((String)"\u635f\u76ca\u5355%s\u7684\u6d6e\u52a8\u635f\u76ca\u4e3a0\uff0c\u65e0\u6cd5\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"PlInfoProvisionList_4", (String)"tmc-tm-formplugin", (Object[])new Object[]{pl.getString("billno")}));
                    continue;
                }
                DynamicObject plProvisionBill = PlProvisionHelper.buildPlProvisionBill(provisionDate, new DynamicObject[]{plBill});
                plProvisionBills.add(plProvisionBill);
            }
            if (tipRows.size() > 0) {
                this.getView().showTipNotification(String.join((CharSequence)"\n", tipRows));
            }
            if (plProvisionBills.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])plProvisionBills.toArray(new DynamicObject[0]));
                SaveServiceHelper.save((DynamicObject[])plBills);
            }
            if (plProvisionBills.size() == 1) {
                BillShowParameter param = new BillShowParameter();
                param.setFormId("tbo_pl_provision");
                param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                param.setPkId(((DynamicObject)plProvisionBills.get(0)).get("id"));
                this.getView().showForm((FormShowParameter)param);
            } else if (plProvisionBills.size() > 1) {
                Object[] ids = plProvisionBills.stream().map(o -> o.get("id")).toArray();
                ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"tbo_pl_provision", (boolean)true, (int)0, (boolean)false);
                parameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)ids));
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
        if ("batchprovision".equals(operateKey) && opResult.isSuccess()) {
            provisionDateStr = op.getOption().getVariableValue("provisionDate");
            provisionDate = DateUtils.stringToDate((String)provisionDateStr, (String)"yyyy-MM-dd");
            plBills = this.queryHistoryFloatPlBills(provisionDate);
            DynamicObject plProvisionBill = PlProvisionHelper.buildPlProvisionBill(provisionDate, plBills);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plProvisionBill});
            SaveServiceHelper.save((DynamicObject[])plBills);
            BillShowParameter param = new BillShowParameter();
            param.setFormId("tbo_pl_provision");
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setPkId(plProvisionBill.get("id"));
            this.getView().showForm((FormShowParameter)param);
        }
        if ("traceplprovision".equals(operateKey) && opResult.isSuccess()) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"PlInfoProvisionList_5", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection plInfoHistoryCol = QueryServiceHelper.query((String)"tbo_plinfo_history", (String)"id,org", (QFilter[])new QFilter("plbill", "=", selectedRows.get(0).getPrimaryKeyValue()).toArray());
            Object[] ids = plInfoHistoryCol.stream().map(o -> o.get("id")).toArray();
            if (EmptyUtil.isEmpty((Object[])ids) || !QueryServiceHelper.exists((String)"tbo_pl_provision", (QFilter[])new QFilter("entryentity.plinfo", "in", (Object)ids).toArray())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u635f\u76ca\u5355\u5c1a\u672a\u8fdb\u884c\u635f\u76ca\u8ba1\u63d0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PlInfoProvisionList_6", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"tbo_pl_provision", (boolean)true, (int)0, (boolean)false);
            parameter.getListFilterParameter().getQFilters().add(new QFilter("entryentity.plinfo", "in", (Object)ids));
            parameter.getCustomParams().put("orgId", ((DynamicObject)plInfoHistoryCol.get(0)).getString("org"));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private DynamicObject[] queryHistoryFloatPlBills(Date provisionDate) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        Object[] plBills = BusinessDataServiceHelper.load((String)"tbo_plinfo_history", (String)"plbill,billno,org,buycurrency,sellcurrency,plcurrency,localcurrency,tradebill,tradetype,floatplamt,voucher_pl,floatpllocalamt,provision,plprovisioninfo,plprovisioncurrency,plprovisionamt,plcalcmethod", (QFilter[])new QFilter("plbill", "in", selectedRows.stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toSet())).and("updatedate", "=", (Object)provisionDate).toArray());
        if (EmptyUtil.isEmpty((Object[])plBills)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u635f\u76ca\u8ba1\u63d0\uff0c\u6839\u636e\u6240\u9009\u6570\u636e\u548c\u8ba1\u63d0\u65e5\u672a\u67e5\u8be2\u5230\u6d6e\u52a8\u635f\u76ca\u6570\u636e\u3002", (String)"PlInfoProvisionList_7", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        return plBills;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ((PL_PROVISION_DATE_FORM.equals(actionId) || PL_PROVISION_DATE_FORM_OPEN_BY_BATCH_PROVISION.equals(actionId)) && closedCallBackEvent.getReturnData() != null) {
            Date provisionDate = (Date)closedCallBackEvent.getReturnData();
            this.validateBeforeProvision4(provisionDate);
            OperateOption option = OperateOption.create();
            option.setVariableValue("provisionDate", DateUtils.formatString((Date)provisionDate, (String)"yyyy-MM-dd"));
            option.setVariableValue(VALIDATE_FLAG, TRADE_VALIDATE_FINISHED);
            this.getView().invokeOperation(StringUtils.equals((CharSequence)PL_PROVISION_DATE_FORM, (CharSequence)actionId) ? "singleprovision" : "batchprovision", option);
        }
        if ((StringUtils.equals((CharSequence)AUTO_GEN_PL_DIALOG, (CharSequence)actionId) || StringUtils.equals((CharSequence)AUTO_GEN_PL_DIALOG_OPEN_BY_BATCH_PROVISION, (CharSequence)actionId)) && closedCallBackEvent.getReturnData() != null) {
            this.autoGenPl();
            OperateOption option = OperateOption.create();
            String provisionDateStr = this.getView().getPageCache().get("provisionDate");
            option.setVariableValue("provisionDate", provisionDateStr);
            option.setVariableValue(VALIDATE_FLAG, VALIDATE_FINISHED);
            this.getView().invokeOperation(StringUtils.equals((CharSequence)AUTO_GEN_PL_DIALOG, (CharSequence)actionId) ? "singleprovision" : "batchprovision", option);
        }
    }

    private void autoGenPl() {
        String provisionDateStr = this.getView().getPageCache().get("provisionDate");
        Date provisionDate = DateUtils.stringToDate((String)provisionDateStr, (String)"yyyy-MM-dd");
        Set<Object> noPlDataIds = this.validateBeforeProvision5(provisionDate);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"tbo_plinfo");
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])noPlDataIds.toArray(), (DynamicObjectType)entityType);
        OperateOption op = OperateOption.create();
        op.setVariableValue("updatedate", provisionDateStr);
        OperationResult result = OperationServiceHelper.executeOperate((String)"calculate", (String)"tbo_plinfo", (DynamicObject[])bills, (OperateOption)op);
        if (!result.isSuccess()) {
            StringBuilder strBuilder = new StringBuilder();
            if (result.getValidateResult() != null && result.getValidateResult().getValidateErrors() != null) {
                for (ValidateResult validateError : result.getValidateResult().getValidateErrors()) {
                    for (OperateErrorInfo operateErrorInfo : validateError.getAllErrorInfo()) {
                        strBuilder.append(operateErrorInfo.getMessage());
                        strBuilder.append("\n");
                    }
                }
            }
            if (strBuilder.length() == 0) {
                strBuilder.append(result.getMessage());
            }
            throw new KDBizException(strBuilder.toString());
        }
    }

    private void validateBeforeProvision4(Date provisionDate) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        DynamicObjectCollection selectPlBills = QueryServiceHelper.query((String)"tbo_plinfo", (String)"billno,tradebizdate", (QFilter[])new QFilter("id", "in", selectedRows.stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toSet())).and(QFilter.isNotNull((String)"tradebizdate")).toArray(), (String)"tradebizdate asc", (int)1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)selectPlBills)) {
            Date bizDate = ((DynamicObject)selectPlBills.get(0)).getDate("tradebizdate");
            logger.info("validateBeforeProvision\uff1a\u4ea4\u6613\u65e5\u6700\u5c0f\u7684\u635f\u76ca\u5355\u53f7={}\uff0c\u4ea4\u6613\u65e5={}", new Object[]{((DynamicObject)selectPlBills.get(0)).getString("billno"), bizDate});
            if (provisionDate.compareTo(bizDate) < 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u63d0\u65e5\u5c0f\u4e8e\u9009\u5b9a\u4ea4\u6613\u7684\u4ea4\u6613\u65e5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PlInfoProvisionList_8", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
        }
        if (QueryServiceHelper.exists((String)"tbo_pl_provision", (QFilter[])new QFilter("provisiondate", "=", (Object)provisionDate).and("entryentity.plinfo.plbill", "in", selectedRows.stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toSet())).toArray())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u5b9a\u7684\u4ea4\u6613\u5728\u8be5\u65e5\u671f\u5df2\u53d1\u751f\u8fc7\u635f\u76ca\u8ba1\u63d0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PlInfoProvisionList_9", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }

    private Set<Object> validateBeforeProvision5(Date provisionDate) {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        DynamicObjectCollection bills = QueryServiceHelper.query((String)"tbo_plinfo_history", (String)"plbill,plbill.billno,updatedate", (QFilter[])new QFilter("plbill", "in", selectedRows.stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toSet())).and("updatedate", "=", (Object)provisionDate).toArray());
        Set plBillIds = bills.stream().map(o -> o.getLong("plbill")).collect(Collectors.toSet());
        Set<Object> noPlDataIds = selectedRows.stream().filter(o -> !plBillIds.contains(o.getPrimaryKeyValue())).map(o -> o.getPrimaryKeyValue()).collect(Collectors.toSet());
        return noPlDataIds;
    }

    private void validateBeforeProvision123(String op) {
        if (this.getSelectedRows().size() <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PlInfoProvisionList_10", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        if ("singleprovision".equals(op) && this.getSelectedRows().size() > 100) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4ea4\u6613\u7b14\u6570\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PlInfoProvisionList_11", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        if ("batchprovision".equals(op) && this.getSelectedRows().size() > 500) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4ea4\u6613\u7b14\u6570\u8d85\u51fa\u9650\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PlInfoProvisionList_11", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        DynamicObject[] selectPlBills = BusinessDataServiceHelper.load((String)"tbo_plinfo", (String)"billno,tradebill,plcurrency,localcurrency,tradetype,swapdir,bizrestamt", (QFilter[])new QFilter("id", "in", selectedRows.stream().map(o -> o.getPrimaryKeyValue()).collect(Collectors.toSet())).toArray());
        Validator.validate(selectPlBills, "billno", "tradebill", "tradetype", "plcurrency", "localcurrency", "org");
        for (DynamicObject selectPlBill : selectPlBills) {
            DynamicObject tradeType = selectPlBill.getDynamicObject("tradetype");
            if ((ProductTypeEnum.FOREXFORWARD.getId().equals(tradeType.getString("id")) || ProductTypeEnum.FOREXSWAPS.getId().equals(tradeType.getString("id")) || ProductTypeEnum.FOREXOPTION.getId().equals(tradeType.getString("id"))) && selectPlBill.getBigDecimal("bizrestamt").compareTo(BigDecimal.ZERO) == 0) {
                logger.info("validateBeforeProvision\uff1a\u672a\u4ea4\u5272\u91d1\u989d\u4e3a0\uff0c\u635f\u76ca\u5355={}", (Object)selectPlBill.getString("billno"));
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4ea4\u6613\u4e2d\u5b58\u5728\u5916\u6c47\u5373\u671f/\u5916\u6c47\u6389\u671f\u8fd1\u7aef\uff08\u8fdc\u7aef\uff09\u4e3a\u5373\u671f/\u672a\u4ea4\u5272\u91d1\u989d\u4e3a0/\u975e\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\uff0c\u65e0\u9700\u8fdb\u884c\u635f\u76ca\u8ba1\u63d0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PlInfoProvisionList_12", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            DynamicObject tradeBill = selectPlBill.getDynamicObject("tradebill");
            if (!TcBillStatusEnum.SURVIVAL.getValue().equals(tradeBill.get("billstatus"))) {
                logger.info("validateBeforeProvision\uff1a\u975e\u5b58\u7eed\u72b6\u6001\uff0c\u635f\u76ca\u5355={}", (Object)selectPlBill.getString("billno"));
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4ea4\u6613\u4e2d\u5b58\u5728\u5916\u6c47\u5373\u671f/\u5916\u6c47\u6389\u671f\u8fd1\u7aef\uff08\u8fdc\u7aef\uff09\u4e3a\u5373\u671f/\u672a\u4ea4\u5272\u91d1\u989d\u4e3a0/\u975e\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\uff0c\u65e0\u9700\u8fdb\u884c\u635f\u76ca\u8ba1\u63d0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PlInfoProvisionList_12", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            if (ProductTypeEnum.FOREXSPOT.getId().equals(tradeType.getString("id")) || ProductTypeEnum.FOREXSWAPS.getId().equals(tradeType.getString("id")) && ForexSwapsTypeEnum.SPOTTOSPOT.getValue().equals(tradeBill.get("swaptype")) || ProductTypeEnum.FOREXSWAPS.getId().equals(tradeType.getString("id")) && ForexSwapsTypeEnum.SPOTTOFWD.getValue().equals(tradeBill.get("swaptype")) && "isnear".equals(selectPlBill.get("swapdir"))) {
                logger.info("validateBeforeProvision\uff1a\u975e\u201c\u5916\u6c47\u5373\u671f\u201d\u4e14\u5b58\u7eed\u72b6\u6001\uff0c\u635f\u76ca\u5355={}\uff0c\u4ea7\u54c1\u7c7b\u578b={}\uff0c\u6389\u671f\u7c7b\u578b={}\uff0c\u8fd1\u8fdc\u7aef={}", new Object[]{selectPlBill.getString("billno"), tradeType.get("name"), tradeBill.get("swaptype"), selectPlBill.get("swapdir")});
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u4ea4\u6613\u4e2d\u5b58\u5728\u5916\u6c47\u5373\u671f/\u5916\u6c47\u6389\u671f\u8fd1\u7aef\uff08\u8fdc\u7aef\uff09\u4e3a\u5373\u671f/\u672a\u4ea4\u5272\u91d1\u989d\u4e3a0/\u975e\u5b58\u7eed\u72b6\u6001\u7684\u4ea4\u6613\uff0c\u65e0\u9700\u8fdb\u884c\u635f\u76ca\u8ba1\u63d0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PlInfoProvisionList_12", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            if (!ProductTypeEnum.STRUCTDEPOSIT.getId().equals(tradeType.getString("id"))) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u6784\u6027\u5b58\u6b3e\u5f53\u524d\u4e0d\u652f\u6301\u635f\u76ca\u8ba1\u63d0\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PlInfoProvisionList_13", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        if ("batchprovision".equals(op) && selectPlBills.length > 0) {
            String billNo = selectPlBills[0].getString("billno");
            long orgId = selectPlBills[0].getDynamicObject("tradebill").getDynamicObject("org").getLong("id");
            String orgName = selectPlBills[0].getDynamicObject("tradebill").getDynamicObject("org").getString("name");
            long plCurrencyId = selectPlBills[0].getDynamicObject("plcurrency").getLong("id");
            String plCurrencyName = selectPlBills[0].getDynamicObject("plcurrency").getString("name");
            long localCurrencyId = selectPlBills[0].getDynamicObject("localcurrency").getLong("id");
            String localCurrencyName = selectPlBills[0].getDynamicObject("localcurrency").getString("name");
            logger.info("validateBeforeProvision\uff1a\u7b2c\u4e00\u884c\u635f\u76ca\u5355\u7684\u5355\u636e\u7f16\u53f7={}\uff0c\u7ec4\u7ec7={}\uff0c\u635f\u76ca\u5e01\u79cd={}\uff0c\u672c\u4f4d\u5e01={}", new Object[]{billNo, orgId + "/" + orgName, plCurrencyId + "/" + plCurrencyName, localCurrencyId + "/" + localCurrencyName});
            for (DynamicObject selectPlBill : selectPlBills) {
                long tempOrgId = selectPlBill.getDynamicObject("tradebill").getDynamicObject("org").getLong("id");
                long tempPlCurrencyId = selectPlBill.getDynamicObject("plcurrency").getLong("id");
                long tempLocalCurrencyId = selectPlBills[0].getDynamicObject("localcurrency").getLong("id");
                if (orgId == tempOrgId && plCurrencyId == tempPlCurrencyId && localCurrencyId == tempLocalCurrencyId) continue;
                String tempBillNo = selectPlBill.getString("billno");
                String tempOrgName = selectPlBill.getDynamicObject("tradebill").getDynamicObject("org").getString("name");
                String tempPlCurrencyName = selectPlBill.getDynamicObject("plcurrency").getString("name");
                String tempLocalCurrencyName = selectPlBills[0].getDynamicObject("localcurrency").getString("name");
                logger.warn("validateBeforeProvision\uff1a\u4e0d\u4e00\u81f4\u7684\u635f\u76ca\u5355\u7684\u5355\u636e\u7f16\u53f7={}\uff0c\u7ec4\u7ec7={}\uff0c\u635f\u76ca\u5e01\u79cd={}\uff0c\u672c\u4f4d\u5e01={}", new Object[]{tempBillNo, tempOrgId + "/" + tempOrgName, tempPlCurrencyId + "/" + tempPlCurrencyName, tempLocalCurrencyId + "/" + tempLocalCurrencyName});
                throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u4ea4\u6613\u7684\u4ea4\u6613\u4e3b\u4f53\u6216\u635f\u76ca\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"PlInfoProvisionList_14", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tbo_select_date_dialog");
        String caption = "singleprovision".equals(op) ? ResManager.loadKDString((String)"\u635f\u76ca\u8ba1\u63d0-\u9010\u7b14\u8ba1\u63d0", (String)"PlInfoProvisionList_15", (String)"tmc-tm-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u635f\u76ca\u8ba1\u63d0-\u5408\u5e76\u8ba1\u63d0", (String)"PlInfoProvisionList_16", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
        showParameter.setCaption(caption);
        showParameter.setCustomParam("date_title", (Object)ResManager.loadKDString((String)"\u8ba1\u63d0\u65e5", (String)"PlInfoProvisionList_17", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.EDIT);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "singleprovision".equals(op) ? PL_PROVISION_DATE_FORM : PL_PROVISION_DATE_FORM_OPEN_BY_BATCH_PROVISION);
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }
}

