/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tbo.formplugin.pnl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.YieldTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tbo.common.constant.ParamKeyConst;
import kd.tmc.tbo.common.helper.PlInfoCalculateHelper;
import kd.tmc.tm.common.helper.RateSwapPlHelper;

public class PlRateSwapEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        if (this.isNotExecute()) {
            return;
        }
        super.registerListener(e);
        BasedataEdit plcurrency = (BasedataEdit)this.getView().getControl("plcurrency");
        if (plcurrency != null) {
            plcurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        QFilter filter;
        DynamicObject rateSwap;
        DynamicObject tradebill;
        if (this.isNotExecute()) {
            return;
        }
        String fieldKey = evt.getProperty().getName();
        if ("plcurrency".equals(fieldKey) && (tradebill = (DynamicObject)this.getModel().getValue("tradebill")) != null && (rateSwap = QueryServiceHelper.queryOne((String)"tm_rateswap", (String)"currency.number,reccurrency.number", (QFilter[])(filter = new QFilter("id", "=", tradebill.getPkValue())).toArray())) != null) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("number", "=", (Object)rateSwap.getString("currency.number"));
            qFilter.or("number", "=", (Object)rateSwap.getString("reccurrency.number"));
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void afterBindData(EventObject e) {
        if (this.isNotExecute()) {
            return;
        }
        super.afterBindData(e);
        this.setFiledHidenOrShow();
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"referexrate"});
        if (this.isNotHistoryBill() && this.needCalFloatPl()) {
            this.setUpdateDateRange();
            this.setDefaultValues();
            try {
                this.forexQuoteChange();
            }
            catch (Exception ex) {
                this.getView().showErrorNotification(ex.getMessage());
            }
            this.setFloatplamt();
        }
        this.getModel().setDataChanged(false);
    }

    private boolean needCalFloatPl() {
        DynamicObject trade = (DynamicObject)this.getModel().getValue("tradebill");
        String swapType = (String)this.getModel().getValue("swaptype");
        QFilter filter = new QFilter("id", "=", trade.getPkValue());
        DynamicObject tradeBill = QueryServiceHelper.queryOne((String)"tm_rateswap", (String)"billstatus,isbuysettle", (QFilter[])filter.toArray());
        String billstatus = tradeBill.getString("billstatus");
        boolean isbuysettle = tradeBill.getBoolean("isbuysettle");
        String billStatus = trade.getString("billstatus");
        if ("E".equals(billStatus)) {
            return false;
        }
        return !"currency".equals(swapType) || !TcBillStatusEnum.AUDIT.getValue().equals(billstatus) || !isbuysettle;
    }

    private void setFloatplamt() {
        Date updateDate = (Date)this.getModel().getValue("updatedate");
        if (!EmptyUtil.isEmpty((Object)updateDate)) {
            DynamicObject bill = (DynamicObject)this.getModel().getValue("tradebill");
            if (EmptyUtil.isEmpty((DynamicObject)bill)) {
                return;
            }
            DynamicObject tradeBill = TmcDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)"tm_rateswap");
            DynamicObject plInfo = this.getModel().getDataEntity();
            BigDecimal payfloatplamt = RateSwapPlHelper.calPayFloatPlAmt((DynamicObject)plInfo, (DynamicObject)tradeBill);
            BigDecimal recfloatplamt = RateSwapPlHelper.calRecFloatPlAmt((DynamicObject)plInfo, (DynamicObject)tradeBill);
            this.getModel().setValue("payfloatplamt", (Object)payfloatplamt);
            this.getModel().setValue("recfloatplamt", (Object)recfloatplamt);
            this.getModel().setValue("floatplamt", (Object)payfloatplamt.add(recfloatplamt));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyname;
        if (this.isNotExecute()) {
            return;
        }
        super.propertyChanged(e);
        switch (keyname = e.getProperty().getName()) {
            case "forexquote": 
            case "plcurrency": {
                if (!this.needCalFloatPl()) break;
                this.forexQuoteChange();
                this.setFloatplamt();
                break;
            }
            case "updatedate": {
                if (!this.needCalFloatPl()) break;
                String traceId = RequestContext.get().getTraceId();
                if (ParamKeyConst.SKIP_PROPERTY_CHANGED_EVENT.equals(this.getView().getPageCache().get(traceId))) break;
                try {
                    this.forexQuoteChange();
                }
                catch (Exception ex) {
                    if (EmptyUtil.isNoEmpty((String)traceId)) {
                        this.getView().getPageCache().put(traceId, ParamKeyConst.SKIP_PROPERTY_CHANGED_EVENT);
                        this.getModel().setValue("updatedate", e.getChangeSet()[0].getOldValue());
                        this.getView().showErrorNotification(ex.getMessage());
                    }
                    throw ex;
                }
                this.setFloatplamt();
                break;
            }
            case "referexrate": {
                DynamicObject tradeBill = TmcDataServiceHelper.loadSingle((Object)((DynamicObject)this.getModel().getValue("tradebill")).getPkValue(), (String)"tm_rateswap");
                DynamicObject plInfo = this.getModel().getDataEntity();
                BigDecimal payfloatplamt = RateSwapPlHelper.calPayFloatPlAmt((DynamicObject)plInfo, (DynamicObject)tradeBill);
                BigDecimal recfloatplamt = RateSwapPlHelper.calRecFloatPlAmt((DynamicObject)plInfo, (DynamicObject)tradeBill);
                this.getModel().setValue("payfloatplamt", (Object)payfloatplamt);
                this.getModel().setValue("recfloatplamt", (Object)recfloatplamt);
                this.getModel().setValue("floatplamt", (Object)payfloatplamt.add(recfloatplamt));
                break;
            }
            case "payfloatplamt": 
            case "recfloatplamt": {
                BigDecimal pay = (BigDecimal)this.getModel().getValue("payfloatplamt");
                BigDecimal rec = (BigDecimal)this.getModel().getValue("recfloatplamt");
                pay = pay == null ? BigDecimal.ZERO : pay;
                rec = rec == null ? BigDecimal.ZERO : rec;
                this.getModel().setValue("floatplamt", (Object)pay.add(rec));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (this.isNotExecute()) {
            return;
        }
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("refreshfq".equals(operateKey)) {
            DynamicObject forexquote = (DynamicObject)this.getModel().getValue("forexquote");
            Date updateDate = (Date)this.getModel().getValue("updatedate");
            String swapType = (String)this.getModel().getValue("swaptype");
            DynamicObject localCurr = (DynamicObject)this.getModel().getValue("localcurrency");
            DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
            if (EmptyUtil.isEmpty((Object)updateDate)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u66f4\u65b0\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlRateSwapEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if ((!"rate".equals(swapType) || plCurrency.getLong("id") != localCurr.getLong("id")) && EmptyUtil.isEmpty((DynamicObject)forexquote)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5916\u6c47\u62a5\u4ef7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PlRateSwapEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        if (this.isNotExecute()) {
            return;
        }
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("refreshfq".equals(operateKey) && args.getOperationResult().isSuccess()) {
            this.forexQuoteChange();
            this.setFloatplamt();
        }
    }

    private void setDefaultValues() {
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        if (EmptyUtil.isEmpty((DynamicObject)tradeBill)) {
            return;
        }
        QFilter filter = new QFilter("id", "=", tradeBill.getPkValue());
        Long priceRule = (tradeBill = QueryServiceHelper.queryOne((String)"tm_rateswap", (String)"pricerule,market,recmarket", (QFilter[])filter.toArray())).getLong("pricerule");
        if (EmptyUtil.isNoEmpty((Long)priceRule)) {
            long market = tradeBill.getLong("market");
            long recMarket = tradeBill.getLong("recmarket");
            DynamicObject priceRuleInfo = TmcDataServiceHelper.loadSingle((Object)priceRule, (String)"md_pricerule");
            for (DynamicObject row : priceRuleInfo.getDynamicObjectCollection("yield")) {
                DynamicObject rowMarket = row.getDynamicObject("market");
                if (!EmptyUtil.isEmpty((Long)market) && rowMarket != null && YieldTypeEnum.disc.getValue().equals(row.getString("type")) && market == rowMarket.getLong("id")) {
                    this.getModel().setValue("payyields", row.get("yields"));
                }
                if (EmptyUtil.isEmpty((Long)recMarket) || rowMarket == null || !YieldTypeEnum.disc.getValue().equals(row.getString("type")) || recMarket != rowMarket.getLong("id")) continue;
                this.getModel().setValue("recyields", row.get("yields"));
            }
        }
    }

    private void setUpdateDateRange() {
        this.getModel().setValue("updatedate", (Object)DateUtils.getCurrentDate());
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        if (EmptyUtil.isEmpty((DynamicObject)tradeBill)) {
            return;
        }
        Date bizDate = tradeBill.getDate("bizdate");
        if (bizDate != null) {
            DateEdit updateDate = (DateEdit)this.getView().getControl("updatedate");
            updateDate.setMinDate(bizDate);
        }
    }

    private void setFiledHidenOrShow() {
        String swapType = (String)this.getModel().getValue("swaptype");
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        if (EmptyUtil.isEmpty((DynamicObject)tradeBill)) {
            return;
        }
        QFilter filter = new QFilter("id", "=", tradeBill.getPkValue());
        tradeBill = QueryServiceHelper.queryOne((String)"tm_rateswap", (String)"pricerule,billstatus,isbuysettle,market,recmarket", (QFilter[])filter.toArray());
        String billstatus = tradeBill.getString("billstatus");
        boolean isbuysettle = tradeBill.getBoolean("isbuysettle");
        if ("currency".equals(swapType) && TcBillStatusEnum.AUDIT.getValue().equals(billstatus) && isbuysettle) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fp_marketinfo"});
        }
        if ("rate".equals(swapType)) {
            DynamicObject localcurrency;
            DynamicObject plcurrency = (DynamicObject)this.getModel().getValue("plcurrency");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plcurrency, localcurrency = (DynamicObject)this.getModel().getValue("localcurrency")})) {
                return;
            }
            this.getView().setVisible(Boolean.valueOf(plcurrency.getLong("id") != localcurrency.getLong("id")), new String[]{"forexquote", "issuedate", "fxquote_local", "exrate_local"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fxquotetype", "referexrate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"fxquotetype", "forexquote", "issuedate", "fxquote_local", "exrate_local", "referexrate"});
        }
    }

    protected void forexQuoteChange() {
        Date updateDate;
        DynamicObject forexquote = (DynamicObject)this.getModel().getValue("forexquote");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{forexquote, updateDate = (Date)this.getModel().getValue("updatedate")})) {
            DynamicObject plCurrency;
            DynamicObject localCurr;
            DynamicObject sellCurr;
            Long fqId = forexquote.getLong("id");
            DynamicObject buyCurr = (DynamicObject)this.getModel().getValue("buycurrency");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCurr, sellCurr = (DynamicObject)this.getModel().getValue("sellcurrency"), localCurr = (DynamicObject)this.getModel().getValue("localcurrency"), plCurrency = (DynamicObject)this.getModel().getValue("plcurrency")})) {
                return;
            }
            String buyCurrNumber = buyCurr.getString("number");
            String sellCurrNumber = sellCurr.getString("number");
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            String swapType = (String)this.getModel().getValue("swaptype");
            if ("currency".equals(swapType)) {
                ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)(buyCurrNumber + "/" + sellCurrNumber), (Date)updateDate, null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"fxquotetype", (Object)forexQuoteInfo.getFxquote());
                DynamicObject sellCurrency = plCurrency.getLong("id") == buyCurr.getLong("id") ? sellCurr : buyCurr;
                BigDecimal exrate = PlInfoCalculateHelper.getRateByParam((DynamicObject)org, (DynamicObject)sellCurrency, (DynamicObject)plCurrency, (ForexQuoteInfo)forexQuoteInfo);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"referexrate", (Object)exrate);
                if (plCurrency.getLong("id") == localCurr.getLong("id")) {
                    TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"fxquote_local", "exrate_local", "floatpllocalamt"});
                }
                Date issuetime = forexQuoteInfo.getIssuetime();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"issuedate", (Object)issuetime);
            } else {
                ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)(plCurrency.getString("number") + "/" + localCurr.getString("number")), (Date)updateDate, null);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"issuedate", (Object)forexQuoteInfo.getIssuetime());
            }
            if ("rate".equals(swapType) && plCurrency.getLong("id") == localCurr.getLong("id")) {
                TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"forexquote", "fxquote_local", "issuedate", "exrate_local", "floatpllocalamt"});
            }
        }
    }

    private boolean isNotExecute() {
        DynamicObject tradeType = (DynamicObject)this.getModel().getValue("tradetype");
        if (tradeType == null) {
            return false;
        }
        String number = tradeType.getString("number");
        return !ProductTypeEnum.SWAP.getValue().equals(number);
    }

    private boolean isNotHistoryBill() {
        return !"tbo_plinfo_history".equals(this.getModel().getDataEntityType().getName());
    }
}

