/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.common.helper.ForexHelper;

public class BizBillEdit
extends AbstractTmcBillEdit {
    protected String getSrcEntityType() {
        DynamicObject productType = ((DynamicObject)this.getModel().getValue("tradebill")).getDynamicObject("protecttype");
        String entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
        return entityType;
    }

    protected void initSwapDir() {
        String operate = (String)this.getModel().getValue("operate");
        boolean isForexSwap = false;
        boolean isSwapFar = false;
        if (BusinessBillHelper.isSwapNear((String)operate).booleanValue()) {
            this.getModel().setValue("swapdir", (Object)"isnear");
            isForexSwap = true;
        }
        if (BusinessBillHelper.isSwapFar((String)operate).booleanValue()) {
            isSwapFar = true;
            this.getModel().setValue("swapdir", (Object)"isfar");
            isForexSwap = true;
            DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
            String biztype = tradebill.getString("biztype");
            if ("buy".equals(biztype)) {
                this.getModel().setValue("swapbiztype_src", (Object)"sell");
            } else if ("sell".equals(biztype)) {
                this.getModel().setValue("swapbiztype_src", (Object)"buy");
            } else {
                this.getModel().setValue("swapbiztype_src", (Object)"diff");
            }
        }
        if (!isForexSwap) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"swapdir"});
        }
        this.getView().setVisible(Boolean.valueOf(isSwapFar), new String[]{"swapbiztype_src"});
        this.getView().setVisible(Boolean.valueOf(!isSwapFar), new String[]{"biztype_src"});
    }

    protected boolean isSameFx(DynamicObject tradebill) {
        String pair = tradebill.getString("pair");
        String fxquote = tradebill.getString("fxquote");
        return !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, fxquote}) && pair.equals(fxquote);
    }

    protected void initControl_PL() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)tradebill.getDynamicObject("org").getLong("id"));
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        boolean isShow = plCurrency != null && plCurrency.getLong("id") != localCurrencyId.longValue();
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"basefq", "baseexrate", "baseplamt"});
    }

    protected void setBaseInfo_PL(DynamicObject tradebill) {
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)tradebill.getDynamicObject("org").getLong("id"));
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        if (EmptyUtil.isEmpty((Long)localCurrencyId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5f53\u524d\u4ea4\u6613\u4e3b\u4f53\u7684\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u3002", (String)"BizBillEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject localCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)localCurrencyId, (String)"bd_currency");
        this.getModel().setValue("basecurrency", (Object)localCurrency);
        DynamicObject priceRule = this.dealVoucherPl(tradebill, localCurrency);
        this.setBaseInfo_PL(tradebill, priceRule);
    }

    protected void setBaseInfo_PL(DynamicObject tradebill, DynamicObject priceRule) {
        boolean isShow;
        DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
        if (EmptyUtil.isEmpty((DynamicObject)localCurrency)) {
            return;
        }
        Long localCurrencyId = localCurrency.getLong("id");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)plCurrency)) {
            return;
        }
        boolean bl = isShow = plCurrency.getLong("id") != localCurrencyId.longValue();
        if (isShow) {
            BigDecimal baseAmt;
            BigDecimal baseExrate;
            String pair = localCurrency.getString("number") + "/" + plCurrency.getString("number");
            if (priceRule == null) {
                priceRule = this.queryPriceRule(tradebill);
            }
            Long fqId = priceRule.getLong("forexquote.id");
            Date bizdate = (Date)this.getModel().getValue("bizdate");
            ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, null);
            this.getModel().setValue("basefq", (Object)fqInfo.getFxquote());
            BigDecimal amt_pl = (BigDecimal)this.getModel().getValue("plamt");
            if (plCurrency.getString("number").equals(fqInfo.getFxquote().split("/")[0])) {
                baseExrate = fqInfo.getBuyPrice();
                baseAmt = amt_pl.multiply(baseExrate);
            } else {
                baseExrate = fqInfo.getSellPrice();
                baseAmt = amt_pl.divide(baseExrate, 10, 4);
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseexrate", (Object)baseExrate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)baseAmt);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"basefq", (Object)"");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseexrate", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)BigDecimal.ZERO);
        }
    }

    protected DynamicObject dealVoucherPl(DynamicObject tradebill, DynamicObject localCurrency) {
        DynamicObject priceRule = null;
        if (this.isShowVoucherPlPanel(tradebill, localCurrency.getLong("id"))) {
            priceRule = this.queryPriceRule(tradebill);
            this.getModel().setValue("show_voucher_pl_panel", (Object)Boolean.TRUE);
            this.setVoucherPl(tradebill, priceRule, localCurrency);
        } else {
            this.getModel().setValue("show_voucher_pl_panel", (Object)Boolean.FALSE);
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("buy_local_fq"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buy_local_fq", (Object)"");
            }
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("buy_local_exrate"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buy_local_exrate", (Object)BigDecimal.ZERO);
            }
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("sell_local_fq"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sell_local_fq", (Object)"");
            }
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("sell_local_exrate"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sell_local_exrate", (Object)BigDecimal.ZERO);
            }
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("voucher_pl"))) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"voucher_pl", (Object)BigDecimal.ZERO);
            }
        }
        return priceRule;
    }

    protected DynamicObject queryPriceRule(DynamicObject tradebill) {
        if (tradebill.getDynamicObject("pricerule") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u6613%s\u672a\u8bbe\u7f6e\u5b9a\u4ef7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizBillEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[]{tradebill.getString("number")}));
        }
        return QueryServiceHelper.queryOne((String)"md_pricerule", (String)"forexquote.id,forexquote.issuetime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getDynamicObject("pricerule").getLong("id"))});
    }

    protected boolean isShowVoucherPlPanel(DynamicObject tradebill, Long localCurrencyId) {
        DynamicObject sellCurrency;
        if (!tradebill.containsProperty("protecttype") || !this.getModel().getDataEntity().containsProperty("exratecalmtd")) {
            return false;
        }
        DynamicObject protectType = tradebill.getDynamicObject("protecttype");
        String protectId = protectType.getString("id");
        if (ProductTypeEnum.SWAP.getId().equals(protectId)) {
            DynamicObject sellCurrency2;
            DynamicObject buyCurrency = tradebill.getDynamicObject("currency");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCurrency, sellCurrency2 = tradebill.getDynamicObject("reccurrency")})) {
                return false;
            }
            long buyCurrencyId = buyCurrency.getLong("id");
            long sellCurrencyId = sellCurrency2.getLong("id");
            String op = (String)this.getModel().getValue("operate");
            String swapType = tradebill.getString("rateswaptype");
            DynamicObjectCollection entrydetail = this.getModel().getEntryEntity("entrydetail");
            if (entrydetail.size() < 2) {
                return false;
            }
            return SwapTypeEnum.currency.getValue().equals(swapType) && buyCurrencyId != localCurrencyId && sellCurrencyId != localCurrencyId && (BizOperateEnum.interestpay.getValue().equals(op) || BizOperateEnum.capitalpay.getValue().equals(op));
        }
        DynamicObject buyCurrency = tradebill.getDynamicObject("currency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCurrency, sellCurrency = tradebill.getDynamicObject("sellcurrency")})) {
            return false;
        }
        long buyCurrencyId = buyCurrency.getLong("id");
        long sellCurrencyId = sellCurrency.getLong("id");
        String op = (String)this.getModel().getValue("operate");
        return !(!ProductTypeEnum.FOREXSPOT.getId().equals(protectId) && !ProductTypeEnum.FOREXFORWARD.getId().equals(protectId) && !ProductTypeEnum.FOREXSWAPS.getId().equals(protectId) && !ProductTypeEnum.FOREXOPTION.getId().equals(protectId) || buyCurrencyId == localCurrencyId || sellCurrencyId == localCurrencyId || !DeliveryWayEnum.deliverable.getValue().equals(tradebill.getString("deliveryway")) || !BizOperateEnum.expiredey.getValue().equals(op) && !BizOperateEnum.expiredey_n.getValue().equals(op) && !BizOperateEnum.expiredey_f.getValue().equals(op) && !BizOperateEnum.exercise.getValue().equals(op) && !BizOperateEnum.bdelivery.getValue().equals(op) && !BizOperateEnum.bdelivery_n.getValue().equals(op) && !BizOperateEnum.bdelivery_f.getValue().equals(op));
    }

    private void setVoucherPl(DynamicObject tradebill, DynamicObject priceRule, DynamicObject localCurrency) {
        BigDecimal sellExAmt;
        BigDecimal sellExRate;
        BigDecimal buyExAmt;
        BigDecimal buyExRate;
        DynamicObject sellCurrency;
        DynamicObject buyCurrency;
        BigDecimal sellAmt;
        BigDecimal buyAmt;
        DynamicObject protectType = tradebill.getDynamicObject("protecttype");
        String protectId = protectType.getString("id");
        if (ProductTypeEnum.SWAP.getId().equals(protectId)) {
            buyAmt = (BigDecimal)this.getModel().getValue("bizamt2");
            sellAmt = (BigDecimal)this.getModel().getValue("bizamt1");
            buyCurrency = tradebill.getDynamicObject("reccurrency");
            sellCurrency = tradebill.getDynamicObject("currency");
        } else {
            boolean flag = true;
            String op = (String)this.getModel().getValue("operate");
            String tradeType = tradebill.getString("tradetype");
            String dir = tradebill.getString("tradedirect");
            if (ProductTypeEnum.FOREXOPTION.getId().equals(protectId)) {
                if (OptionsTradeTypeEnum.call.getValue().equals(tradeType) && TradeDirectionEnum.sell.getValue().equals(dir) || OptionsTradeTypeEnum.put.getValue().equals(tradeType) && TradeDirectionEnum.buy.getValue().equals(dir)) {
                    flag = false;
                }
            } else if (op.indexOf("_f") < 0 && "sell".equals(dir) || op.indexOf("_f") > 0 && "buy".equals(dir)) {
                flag = false;
            }
            if (flag) {
                buyAmt = (BigDecimal)this.getModel().getValue("bizamt1");
                sellAmt = (BigDecimal)this.getModel().getValue("bizamt2");
                buyCurrency = tradebill.getDynamicObject("currency");
                sellCurrency = tradebill.getDynamicObject("sellcurrency");
            } else {
                buyAmt = (BigDecimal)this.getModel().getValue("bizamt2");
                sellAmt = (BigDecimal)this.getModel().getValue("bizamt1");
                buyCurrency = tradebill.getDynamicObject("sellcurrency");
                sellCurrency = tradebill.getDynamicObject("currency");
            }
        }
        int buyAmtPrecision = buyCurrency.getInt("amtprecision");
        buyAmt = buyAmt.setScale(buyAmtPrecision, 4);
        int sellAmtPrecision = sellCurrency.getInt("amtprecision");
        sellAmt = sellAmt.setScale(sellAmtPrecision, 4);
        String buyCurrencyNumber = buyCurrency.getString("number");
        String sellCurrencyNumber = sellCurrency.getString("number");
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        ForexQuoteInfo buyCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexquote.id"), (String)(buyCurrencyNumber + "/" + localCurrency.getString("number")), (Date)bizDate, null);
        String buyCurFxQuote = buyCurFqInfo.getFxquote();
        if (buyCurrencyNumber.equals(buyCurFxQuote.split("/")[0])) {
            buyExRate = buyCurFqInfo.getBuyPrice();
            buyExAmt = buyAmt.multiply(buyExRate);
        } else {
            buyExRate = buyCurFqInfo.getSellPrice();
            buyExAmt = buyAmt.divide(buyExRate, 10, 4);
        }
        ForexQuoteInfo sellCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexquote.id"), (String)(sellCurrencyNumber + "/" + localCurrency.getString("number")), (Date)bizDate, null);
        String sellCurFxQuote = sellCurFqInfo.getFxquote();
        if (sellCurrencyNumber.equals(sellCurFxQuote.split("/")[0])) {
            sellExRate = sellCurFqInfo.getBuyPrice();
            sellExAmt = sellAmt.multiply(sellExRate);
        } else {
            sellExRate = sellCurFqInfo.getSellPrice();
            sellExAmt = sellAmt.divide(sellExRate, 10, 4);
        }
        this.getModel().setValue("buy_local_fq", (Object)buyCurFxQuote);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"buy_local_exrate", (Object)buyExRate);
        this.getModel().setValue("sell_local_fq", (Object)sellCurFxQuote);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"sell_local_exrate", (Object)sellExRate);
        this.getModel().setValue("voucher_pl", (Object)buyExAmt.subtract(sellExAmt));
    }

    protected BigDecimal calBaseAmt_PL() {
        BigDecimal amt_pl;
        BigDecimal baseExrate = (BigDecimal)this.getModel().getValue("baseexrate");
        String baseFq = (String)this.getModel().getValue("basefq");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, baseFq, amt_pl = (BigDecimal)this.getModel().getValue("plamt"), baseExrate})) {
            return null;
        }
        BigDecimal baseAmt = plCurrency.getString("number").equals(baseFq.split("/")[0]) ? amt_pl.multiply(baseExrate) : amt_pl.divide(baseExrate, 10, 4);
        return baseAmt;
    }

    protected Date getDeyDate_ForexFwd() {
        Date dm = (Boolean)this.getModel().getValue("isdaterange") != false ? (Date)this.getModel().getValue("deydate_end") : (Date)this.getModel().getValue("deliverydate");
        return dm;
    }

    protected Date getDeyDateSrc_ForexFwd() {
        Date dm = (Date)this.getModel().getValue("enddate_src");
        if (EmptyUtil.isEmpty((Object)dm)) {
            dm = (Date)this.getModel().getValue("date_src");
        }
        return dm;
    }

    protected BigDecimal calAmt_PL(BigDecimal exrateA, BigDecimal exrateB) {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        BigDecimal amt = (BigDecimal)this.getModel().getValue("bizamt1");
        BigDecimal amt_pl = this.isSameFx(tradebill) ? exrateA.subtract(exrateB).multiply(amt) : (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exrateA, exrateB}) ? BigDecimal.ZERO : BigDecimal.ONE.divide(exrateA, 10, 4).subtract(BigDecimal.ONE.divide(exrateB, 10, 4)).multiply(amt));
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            amt_pl = amt_pl.negate();
        }
        return amt_pl;
    }

    protected BigDecimal dealPlAmt_PlCurrencyNotSrc(BigDecimal plAmt) {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject plCurrency = this.getPlCurrency();
        if (plCurrency.getLong("id") != tradebill.getDynamicObject("sellcurrency").getLong("id")) {
            Date bizdate = (Date)this.getModel().getValue("bizdate");
            ForexQuoteInfo info = BusinessBillHelper.getForexQuoteInfo((DynamicObject)tradebill, (Date)bizdate, null);
            plAmt = EmptyUtil.isEmpty((Object)info) ? BigDecimal.ZERO : (tradebill.getDynamicObject("sellcurrency").getString("number").equals(tradebill.getString("fxquote").split("/")[0]) ? plAmt.multiply(info.getBuyPrice()) : plAmt.divide(info.getSellPrice(), 10, 4));
        }
        return plAmt;
    }

    protected DynamicObject getPlCurrency() {
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)plCurrency)) {
            plCurrency = ForexHelper.getDefaultPlCurrency((DynamicObject)this.getModel().getDataEntity());
        }
        return plCurrency;
    }

    protected BigDecimal calPlAmtWithPlCurrency(BigDecimal exrateA, BigDecimal exrateB) {
        BigDecimal plAmt;
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject plCurrency = this.getPlCurrency();
        BigDecimal bizAmt1 = (BigDecimal)this.getModel().getValue("bizamt_detail", 0);
        if (this.isSameFx(tradebill)) {
            plAmt = exrateA.subtract(exrateB).multiply(bizAmt1);
            if (plCurrency.getLong("id") == tradebill.getDynamicObject("currency").getLong("id")) {
                plAmt = exrateA.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : plAmt.divide(exrateA, 10, 4);
            }
        } else {
            plAmt = EmptyUtil.isAnyoneEmpty((Object[])new Object[]{exrateA, exrateB}) ? BigDecimal.ZERO : BigDecimal.ONE.divide(exrateA, 10, 4).subtract(BigDecimal.ONE.divide(exrateB, 10, 4)).multiply(bizAmt1);
            if (plCurrency.getLong("id") == tradebill.getDynamicObject("currency").getLong("id")) {
                plAmt = plAmt.multiply(exrateA);
            }
        }
        if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
            plAmt = plAmt.negate();
        }
        return plAmt;
    }

    protected void initBizEntry_RateSwap(DynamicObject tradebill) {
        DynamicObjectCollection lifeCycleCards = this.getModel().getEntryEntity("entrybiz");
        lifeCycleCards.clear();
        DynamicObject lifeCycleCard = lifeCycleCards.addNew();
        lifeCycleCard.set("title_biz", (Object)ResManager.loadKDString((String)"\u539f\u5408\u7ea6", (String)"BizBillEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        lifeCycleCard.set("date_biz", (Object)tradebill.getDate("adjustedenddate"));
        lifeCycleCard.set("currency_biz", tradebill.get("currency"));
        lifeCycleCard.set("restamt_biz", tradebill.get("amount"));
        lifeCycleCard.set("reccurrency_biz", tradebill.get("reccurrency"));
        lifeCycleCard.set("recamt_biz", tradebill.get("recamount"));
        DynamicObject bizRecord = TmcDataServiceHelper.loadSingle((String)"tm_bizrecord", (String)"id", (QFilter[])new QFilter[]{new QFilter("tradebillid", "=", (Object)tradebill.getLong("id"))});
        lifeCycleCard.set("record_biz", (Object)bizRecord.getLong("id"));
        this.getModel().setValue("bizrecordid", (Object)bizRecord.getLong("id"));
    }

    protected boolean isBetween(Date bizDate, Date startDate, Date endDate, boolean isRightOpen) {
        return bizDate.compareTo(startDate) >= 0 && (isRightOpen && bizDate.compareTo(endDate) < 0 || !isRightOpen && bizDate.compareTo(endDate) <= 0);
    }

    protected String geConvertSrcEntityType() {
        ConvertOperationResult convertResult = this.getConvertResult();
        if (convertResult != null) {
            return convertResult.getSourceEntityNumber();
        }
        return null;
    }

    protected ConvertOperationResult getConvertResult() {
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
        String convertResultJson = pageCache.get("ConvertOperationResult");
        if (EmptyUtil.isNoEmpty((String)convertResultJson)) {
            return (ConvertOperationResult)SerializationUtils.fromJsonString((String)convertResultJson, ConvertOperationResult.class);
        }
        return null;
    }

    protected void spotRateChange() {
        BigDecimal restAmt2;
        BigDecimal bizAmt2;
        BigDecimal exRateSrc;
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        BigDecimal exRate = exRateSrc = (BigDecimal)this.getModel().getValue("exrate_src");
        String op = (String)this.getModel().getValue("operate");
        if (BizOperateEnum.bdelivery.getValue().equals(op) || BizOperateEnum.bdelivery_f.getValue().equals(op) || BizOperateEnum.bdelivery_n.getValue().equals(op) || BizOperateEnum.defer.getValue().equals(op) || BizOperateEnum.maudate.getValue().equals(op) || BizOperateEnum.defer_f.getValue().equals(op) || BizOperateEnum.maudate_f.getValue().equals(op) || BizOperateEnum.defer_n.getValue().equals(op) || BizOperateEnum.maudate_n.getValue().equals(op)) {
            exRate = (BigDecimal)this.getModel().getValue("spotrate_dey");
        }
        BigDecimal restAmtSrc1 = (BigDecimal)this.getModel().getValue("restamt_src");
        BigDecimal bizAmt1 = (BigDecimal)this.getModel().getValue("bizamt_detail", 0);
        BigDecimal restAmt1 = restAmtSrc1.subtract(bizAmt1);
        if (this.isSameFx(tradebill)) {
            bizAmt2 = bizAmt1.multiply(exRate);
            restAmt2 = restAmt1.multiply(exRateSrc);
        } else {
            bizAmt2 = EmptyUtil.isEmpty((BigDecimal)exRate) ? BigDecimal.ZERO : bizAmt1.divide(exRate, 10, 4);
            restAmt2 = EmptyUtil.isEmpty((BigDecimal)exRateSrc) ? BigDecimal.ZERO : restAmt1.divide(exRateSrc, 10, 4);
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizamt_detail", (Object)bizAmt2, (int)1);
        this.getView().updateView("entrydetail");
        this.getModel().setValue("restamt_detail", (Object)restAmt2, 1);
        this.getModel().setValue("bizamt2", (Object)bizAmt2);
        this.getModel().setValue("restamt2", (Object)restAmt2);
    }
}

