/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.EntityOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.SettleInfoHelper;
import kd.tmc.tm.common.helper.TcAccountHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;
import org.apache.commons.lang3.StringUtils;

public class BusinessBillEdit
extends BizBillEdit
implements BeforeF7SelectListener,
TabSelectListener {
    private static final String BAR_UP_TRACE = "bar_uptrace";

    public void itemClick(ItemClickEvent evt) {
        if (BAR_UP_TRACE.equals(evt.getItemKey())) {
            DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            DynamicObject protectType = (DynamicObject)this.getModel().getValue("protecttype");
            if (tradeBill == null || protectType == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0a\u67e5\u4ea4\u6613\u5355\uff0c\u65e0\u6570\u636e\u3002", (String)"BusinessBillEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return;
            }
            Object tradeId = tradeBill.getPkValue();
            Long protectTypeId = (Long)protectType.getPkValue();
            ProductTypeEnum productType = ProductTypeEnum.getEnumById((String)protectTypeId.toString());
            String tradeEntity = productType.getEntity();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(tradeEntity);
            showParameter.setPkId(tradeId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void registerListener(EventObject e) {
        Tab tabap;
        BasedataEdit settleCurrency;
        BasedataEdit currency_pl;
        BasedataEdit recBankAcct;
        super.registerListener(e);
        BasedataEdit payBankAcct = (BasedataEdit)this.getView().getControl("paybankacct");
        if (EmptyUtil.isNoEmpty((Object)payBankAcct)) {
            payBankAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (EmptyUtil.isNoEmpty((Object)(recBankAcct = (BasedataEdit)this.getView().getControl("recbankacct")))) {
            recBankAcct.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (EmptyUtil.isNoEmpty((Object)(currency_pl = (BasedataEdit)this.getView().getControl("plcurrency")))) {
            currency_pl.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (EmptyUtil.isNoEmpty((Object)(settleCurrency = (BasedataEdit)this.getView().getControl("settlecurrency")))) {
            settleCurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((tabap = (Tab)this.getView().getControl("tabap")) != null) {
            tabap.addTabSelectListener((TabSelectListener)this);
        }
    }

    public void tabSelected(TabSelectEvent e) {
        if (e.getTabKey().equals("tabsettle")) {
            String billStatus = (String)this.getModel().getValue("billstatus");
            if (!EmptyUtil.isEmpty((String)billStatus) && !TcBillStatusEnum.SAVE.getValue().equals(billStatus)) {
                return;
            }
            Map<String, Boolean> result = this.getSettlePanelVisible();
            Boolean isPay = result.get("isPay");
            Boolean isRec = result.get("isRec");
            DynamicObject paySettleType = (DynamicObject)this.getModel().getValue("paysettletype");
            DynamicObject payBankAcct = (DynamicObject)this.getModel().getValue("paybankacct");
            DynamicObject payCurrency = (DynamicObject)this.getModel().getValue("paycurrency");
            DynamicObject recSettleType = (DynamicObject)this.getModel().getValue("recsettletype");
            DynamicObject recBankAcct = (DynamicObject)this.getModel().getValue("recbankacct");
            DynamicObject recCurrency = (DynamicObject)this.getModel().getValue("reccurrency");
            DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            DynamicObject cp = tradeBill.getDynamicObject("counterparty");
            DynamicObject org = tradeBill.getDynamicObject("org");
            if (isPay.booleanValue() && isRec.booleanValue()) {
                DynamicObject config;
                if (EmptyUtil.isNoEmpty((DynamicObject)payCurrency) && EmptyUtil.isEmpty((DynamicObject)paySettleType) && EmptyUtil.isEmpty((DynamicObject)payBankAcct) && EmptyUtil.isNoEmpty((DynamicObject)(config = SettleInfoHelper.getSettleConfig((DynamicObject)org, (DynamicObject)cp, (DynamicObject)payCurrency)))) {
                    this.getModel().setValue("paysettletype", config.get("settletype"));
                    this.getModel().setValue("paybankacct", config.get("bankaccount"));
                    this.getModel().setValue("paybank", config.getDynamicObject("bankaccount").get("bank"));
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)recCurrency) && EmptyUtil.isEmpty((DynamicObject)recSettleType) && EmptyUtil.isEmpty((DynamicObject)recBankAcct) && EmptyUtil.isNoEmpty((DynamicObject)(config = SettleInfoHelper.getSettleConfig((DynamicObject)org, (DynamicObject)cp, (DynamicObject)recCurrency)))) {
                    this.getModel().setValue("recsettletype", config.get("settletype"));
                    this.getModel().setValue("recbankacct", config.get("bankaccount"));
                    this.getModel().setValue("recbank", config.getDynamicObject("bankaccount").get("bank"));
                }
            } else if (isPay.booleanValue()) {
                DynamicObject config;
                if (EmptyUtil.isNoEmpty((DynamicObject)payCurrency) && EmptyUtil.isEmpty((DynamicObject)paySettleType) && EmptyUtil.isEmpty((DynamicObject)payBankAcct) && EmptyUtil.isNoEmpty((DynamicObject)(config = SettleInfoHelper.getSettleConfig((DynamicObject)org, (DynamicObject)cp, (DynamicObject)payCurrency)))) {
                    this.getModel().setValue("paysettletype", config.get("settletype"));
                    this.getModel().setValue("paybankacct", config.get("bankaccount"));
                    this.getModel().setValue("paybank", config.getDynamicObject("bankaccount").get("bank"));
                }
                this.getModel().setValue("recsettletype", null);
                this.getModel().setValue("recbankacct", null);
                this.getModel().setValue("recbank", null);
                this.getModel().setValue("opprecbankacct", null);
                this.getModel().setValue("opprecbank", null);
            } else if (isRec.booleanValue()) {
                DynamicObject config;
                if (EmptyUtil.isNoEmpty((DynamicObject)recCurrency) && EmptyUtil.isEmpty((DynamicObject)recSettleType) && EmptyUtil.isEmpty((DynamicObject)recBankAcct) && EmptyUtil.isNoEmpty((DynamicObject)(config = SettleInfoHelper.getSettleConfig((DynamicObject)org, (DynamicObject)cp, (DynamicObject)recCurrency)))) {
                    this.getModel().setValue("recsettletype", config.get("settletype"));
                    this.getModel().setValue("recbankacct", config.get("bankaccount"));
                    this.getModel().setValue("recbank", config.getDynamicObject("bankaccount").get("bank"));
                }
                this.getModel().setValue("paysettletype", null);
                this.getModel().setValue("paybankacct", null);
                this.getModel().setValue("paybank", null);
                this.getModel().setValue("opppaybankacct", null);
                this.getModel().setValue("opppaybank", null);
            } else {
                this.getModel().setValue("paysettletype", null);
                this.getModel().setValue("paybankacct", null);
                this.getModel().setValue("paybank", null);
                this.getModel().setValue("opppaybankacct", null);
                this.getModel().setValue("opppaybank", null);
                this.getModel().setValue("recsettletype", null);
                this.getModel().setValue("recbankacct", null);
                this.getModel().setValue("recbank", null);
                this.getModel().setValue("opprecbankacct", null);
                this.getModel().setValue("opprecbank", null);
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if (("baseexrate".equals(key) || "buy_local_exrate".equals(key) || "sell_local_exrate".equals(key)) && (EmptyUtil.isEmpty((Object)e.getValue()) || BigDecimal.ZERO.compareTo(new BigDecimal((String)e.getValue())) >= 0)) {
            e.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6570\u503c\u3002", (String)"BizBillEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[]{2000}));
            this.getView().updateView(key);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        switch (propName) {
            case "paybankacct": {
                DynamicObject payBankAcct = (DynamicObject)this.getModel().getValue("paybankacct");
                if (EmptyUtil.isNoEmpty((DynamicObject)payBankAcct)) {
                    this.getModel().setValue("paybank", (Object)payBankAcct.getDynamicObject("bank").getLong("id"));
                    break;
                }
                this.getModel().setValue("paybank", null);
                break;
            }
            case "recbankacct": {
                DynamicObject recBankAcct = (DynamicObject)this.getModel().getValue("recbankacct");
                if (EmptyUtil.isNoEmpty((DynamicObject)recBankAcct)) {
                    this.getModel().setValue("recbank", (Object)recBankAcct.getDynamicObject("bank").getLong("id"));
                    break;
                }
                this.getModel().setValue("recbank", null);
                break;
            }
            case "plamt": 
            case "settleamount": {
                this.setSettleInfo();
                break;
            }
            case "exratecalmtd": {
                this.setTabSettleVisible();
                break;
            }
            case "paysettletype": {
                this.getModel().setValue("paybankacct", null);
                this.getModel().setValue("paybank", null);
                break;
            }
            case "recsettletype": {
                this.getModel().setValue("recbankacct", null);
                this.getModel().setValue("recbank", null);
                break;
            }
            case "buy_local_exrate": 
            case "sell_local_exrate": {
                this.calcVoucherPl(tradebill);
                break;
            }
            case "bizamt1": 
            case "bizamt2": {
                DynamicObject protectType = tradebill.getDynamicObject("protecttype");
                if (!ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id")) && !ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id")) && !ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id")) && !ProductTypeEnum.FOREXOPTION.getId().equals(protectType.getString("id")) && !ProductTypeEnum.SWAP.getId().equals(protectType.getString("id"))) break;
                this.calcVoucherPl(tradebill);
                break;
            }
            case "bizdate": {
                if (this.getModel().getValue("basecurrency") != null) {
                    this.dealVoucherPl(tradebill, (DynamicObject)this.getModel().getValue("basecurrency"));
                }
                if (!EmptyUtil.isNoEmpty((Object)this.getModel().getValue("basefq"))) break;
                this.setBaseInfo_PL(tradebill, this.queryPriceRule(tradebill));
                break;
            }
            case "plcurrency": {
                this.setSettleInfo();
                DynamicObject protectType = tradebill.getDynamicObject("protecttype");
                if (!ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id")) && !ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id")) && !ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id")) && !ProductTypeEnum.FOREXOPTION.getId().equals(protectType.getString("id"))) break;
                this.initControl_PL();
                DynamicObject priceRule = this.queryPriceRule(tradebill);
                if (this.getModel().getValue("basecurrency") != null && this.getModel().getValue("plcurrency") != null) {
                    this.reSet("execexrate");
                }
                this.setBaseInfo_PL(tradebill, priceRule);
            }
        }
    }

    public void reSet(String prop) {
        Object v = this.getModel().getValue(prop);
        if (EmptyUtil.isNoEmpty((Object)v)) {
            if (v instanceof String) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)prop, (Object)"");
            } else if (v instanceof BigDecimal) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)prop, (Object)BigDecimal.ZERO);
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)prop, null);
            }
            this.getModel().setValue(prop, v);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        DynamicObject rightCurrency;
        DynamicObject leftCurrency;
        String protectTypeId;
        DynamicObject protectType;
        DynamicObject tradeBill;
        String name = event.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
        if ("paybankacct".equals(name) || "recbankacct".equals(name)) {
            QFilter qFilter = TcAccountHelper.getAccountBankFilterByOrg((Long)((DynamicObject)this.getModel().getValue("org")).getLong("id"));
            qFilter.and(new QFilter("acctstatus", "=", (Object)"normal"));
            qFilter.and(new QFilter("finorgtype", "!=", (Object)"1"));
            DynamicObject currency = null;
            DynamicObject settletype = null;
            if ("paybankacct".equals(name)) {
                currency = (DynamicObject)this.getModel().getValue("paycurrency");
                settletype = this.getModel().getDataEntity().getDynamicObject("paysettletype");
            }
            if ("recbankacct".equals(name)) {
                currency = (DynamicObject)this.getModel().getValue("reccurrency");
                settletype = this.getModel().getDataEntity().getDynamicObject("recsettletype");
            }
            if (currency != null) {
                qFilter = qFilter.and(new QFilter("currency.fbasedataid", "=", currency.getPkValue()));
            }
            if (settletype != null) {
                QFilter qFilter1 = new QFilter("settlementtype.fbasedataid.id", "=", settletype.getPkValue());
                QFilter qFilter2 = new QFilter("settlementtype.fbasedataid.id", "is null", null);
                qFilter = qFilter.and(qFilter1.or(qFilter2));
            }
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
        if ("plcurrency".equals(name)) {
            tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            if (tradeBill == null) {
                return;
            }
            protectType = tradeBill.getDynamicObject("protecttype");
            String string = protectTypeId = protectType != null ? protectType.getString("id") : "";
            if ((ProductTypeEnum.FOREXFORWARD.getId().equals(protectTypeId) || ProductTypeEnum.FOREXSWAPS.getId().equals(protectTypeId) || ProductTypeEnum.FOREXOPTION.getId().equals(protectTypeId) || ProductTypeEnum.FOREXSPOT.getId().equals(protectTypeId)) && tradeBill.get("currency") != null && tradeBill.get("sellcurrency") != null) {
                leftCurrency = tradeBill.getDynamicObject("currency");
                rightCurrency = tradeBill.getDynamicObject("sellcurrency");
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)new Object[]{leftCurrency.getPkValue(), rightCurrency.getPkValue()}));
            }
            if (ProductTypeEnum.SWAP.getId().equals(protectTypeId) && tradeBill.get("currency") != null && tradeBill.get("reccurrency") != null) {
                DynamicObject currency = tradeBill.getDynamicObject("currency");
                DynamicObject recCurrency = tradeBill.getDynamicObject("reccurrency");
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)new Object[]{currency.getPkValue(), recCurrency.getPkValue()}));
            }
        }
        if ("settlecurrency".equals(name)) {
            tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            if (tradeBill == null) {
                return;
            }
            protectType = tradeBill.getDynamicObject("protecttype");
            String string = protectTypeId = protectType != null ? protectType.getString("id") : "";
            if (ProductTypeEnum.FOREXOPTION.getId().equals(protectTypeId) && !BizOperateEnum.flat.getValue().equals(this.getModel().getValue("operate")) && tradeBill.get("currency") != null && tradeBill.get("sellcurrency") != null) {
                leftCurrency = tradeBill.getDynamicObject("currency");
                rightCurrency = tradeBill.getDynamicObject("sellcurrency");
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)new Object[]{leftCurrency.getPkValue(), rightCurrency.getPkValue()}));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof EntityOperate) {
            EntityOperate operate = (EntityOperate)args.getSource();
            DynamicObject tradbill = (DynamicObject)this.getModel().getValue("tradebill");
            DynamicObject productType = tradbill.getDynamicObject("protecttype");
            String entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
            operate.getOption().setVariableValue("srcEntityType", entityType);
        }
    }

    private void calcVoucherPl(DynamicObject tradebill) {
        DynamicObject sellCurrency;
        DynamicObject buyCurrency;
        BigDecimal sellAmt;
        BigDecimal buyAmt;
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{this.getModel().getValue("buy_local_exrate"), this.getModel().getValue("sell_local_exrate"), this.getModel().getValue("sell_local_fq"), this.getModel().getValue("sell_local_fq")})) {
            return;
        }
        DynamicObject protectType = tradebill.getDynamicObject("protecttype");
        String protectId = protectType.getString("id");
        if (ProductTypeEnum.SWAP.getId().equals(protectId)) {
            buyAmt = (BigDecimal)this.getModel().getValue("bizamt2");
            sellAmt = (BigDecimal)this.getModel().getValue("bizamt1");
            buyCurrency = tradebill.getDynamicObject("reccurrency");
            sellCurrency = tradebill.getDynamicObject("currency");
        } else {
            boolean flag = true;
            String op = (String)this.getModel().getValue("operate");
            String tradeType = tradebill.getString("tradetype");
            String dir = tradebill.getString("tradedirect");
            if (ProductTypeEnum.FOREXOPTION.getId().equals(protectId)) {
                if (OptionsTradeTypeEnum.call.getValue().equals(tradeType) && TradeDirectionEnum.sell.getValue().equals(dir) || OptionsTradeTypeEnum.put.getValue().equals(tradeType) && TradeDirectionEnum.buy.getValue().equals(dir)) {
                    flag = false;
                }
            } else if (op.indexOf("_f") < 0 && "sell".equals(dir) || op.indexOf("_f") > 0 && "buy".equals(dir)) {
                flag = false;
            }
            if (flag) {
                buyAmt = (BigDecimal)this.getModel().getValue("bizamt1");
                sellAmt = (BigDecimal)this.getModel().getValue("bizamt2");
                buyCurrency = tradebill.getDynamicObject("currency");
                sellCurrency = tradebill.getDynamicObject("sellcurrency");
            } else {
                buyAmt = (BigDecimal)this.getModel().getValue("bizamt2");
                sellAmt = (BigDecimal)this.getModel().getValue("bizamt1");
                buyCurrency = tradebill.getDynamicObject("sellcurrency");
                sellCurrency = tradebill.getDynamicObject("currency");
            }
        }
        String buyCurrencyNumber = buyCurrency.getString("number");
        String sellCurrencyNumber = sellCurrency.getString("number");
        String buyCurFxQuote = (String)this.getModel().getValue("buy_local_fq");
        BigDecimal buyExRate = (BigDecimal)this.getModel().getValue("buy_local_exrate");
        BigDecimal buyExAmt = buyCurrencyNumber.equals(buyCurFxQuote.split("/")[0]) ? buyAmt.multiply(buyExRate) : buyAmt.divide(buyExRate, 10, 4);
        String sellCurFxQuote = (String)this.getModel().getValue("sell_local_fq");
        BigDecimal sellExRate = (BigDecimal)this.getModel().getValue("sell_local_exrate");
        BigDecimal sellExAmt = sellCurrencyNumber.equals(sellCurFxQuote.split("/")[0]) ? sellAmt.multiply(sellExRate) : sellAmt.divide(sellExRate, 10, 4);
        this.getModel().setValue("voucher_pl", (Object)buyExAmt.subtract(sellExAmt));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        if (EmptyUtil.isEmpty((DynamicObject)tradeBill)) {
            return;
        }
        this.getModel().setValue("protecttype", tradeBill.get("protecttype"));
        this.getModel().setDataChanged(false);
    }

    private void setSettleInfo() {
        DynamicObject sellCurrency;
        DynamicObject buyCurrency;
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject protectType = tradebill.getDynamicObject("protecttype");
        String bizop = (String)this.getModel().getValue("operate");
        String dir = tradebill.getString("tradedirect");
        if (TradeDirectionEnum.buy.getValue().equals(dir)) {
            buyCurrency = tradebill.getDynamicObject("currency");
            sellCurrency = tradebill.getDynamicObject("sellcurrency");
        } else {
            buyCurrency = tradebill.getDynamicObject("sellcurrency");
            sellCurrency = tradebill.getDynamicObject("currency");
        }
        if (ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id"))) {
            if (BizOperateEnum.expiredey.getValue().equals(bizop)) {
                this.getModel().setValue("reccurrency", (Object)buyCurrency);
                this.getModel().setValue("paycurrency", (Object)sellCurrency);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelrec", "panelpay"});
            }
            if (BizOperateEnum.flat.getValue().equals(bizop)) {
                this.setSetttleInfoByPl();
            }
        }
        if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
            String deliveryWay = tradebill.getString("deliveryway");
            if (BizOperateEnum.expiredey.getValue().equals(bizop)) {
                if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                    this.getModel().setValue("reccurrency", (Object)buyCurrency);
                    this.getModel().setValue("paycurrency", (Object)sellCurrency);
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelrec", "panelpay"});
                }
                if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                    this.setSetttleInfoByPl();
                }
            }
            if (BizOperateEnum.flat.getValue().equals(bizop) || BizOperateEnum.defer.getValue().equals(bizop) || BizOperateEnum.maudate.getValue().equals(bizop)) {
                this.setSetttleInfoByPl();
            }
            if (BizOperateEnum.bdelivery.getValue().equals(bizop)) {
                this.getModel().setValue("reccurrency", (Object)buyCurrency);
                this.getModel().setValue("paycurrency", (Object)sellCurrency);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelrec", "panelpay"});
            }
        }
        if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) {
            if (BizOperateEnum.expiredey_n.getValue().equals(bizop) || BizOperateEnum.bdelivery_n.getValue().equals(bizop)) {
                this.getModel().setValue("reccurrency", (Object)buyCurrency);
                this.getModel().setValue("paycurrency", (Object)sellCurrency);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelrec", "panelpay"});
            }
            if (BizOperateEnum.expiredey_f.getValue().equals(bizop) || BizOperateEnum.bdelivery_f.getValue().equals(bizop)) {
                this.getModel().setValue("reccurrency", (Object)sellCurrency);
                this.getModel().setValue("paycurrency", (Object)buyCurrency);
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelrec", "panelpay"});
            }
            if (BizOperateEnum.flat_f.getValue().equals(bizop) || BizOperateEnum.flat_n.getValue().equals(bizop) || BizOperateEnum.defer_f.getValue().equals(bizop) || BizOperateEnum.defer_n.getValue().equals(bizop) || BizOperateEnum.maudate_f.getValue().equals(bizop) || BizOperateEnum.maudate_n.getValue().equals(bizop)) {
                this.setSetttleInfoByPl();
            }
        }
        if (ProductTypeEnum.FOREXOPTION.getId().equals(protectType.getString("id")) && BizOperateEnum.exercise.getValue().equals(bizop)) {
            this.setSetttleInfoBySettleAmt();
        }
        if (ProductTypeEnum.SWAP.getId().equals(protectType.getString("id"))) {
            if (BizOperateEnum.interestpay.getValue().equals(bizop)) {
                Long cashflow_rec;
                Long cashflow_pay = (Long)this.getModel().getValue("cashflow_pay");
                if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{cashflow_pay, cashflow_rec = (Long)this.getModel().getValue("cashflow_rec")})) {
                    String rateswapType = tradebill.getString("rateswaptype");
                    if (SwapTypeEnum.rate.getValue().equals(rateswapType)) {
                        BigDecimal settleAmt = (BigDecimal)this.getModel().getValue("settleamount");
                        if (BigDecimal.ZERO.compareTo(settleAmt) < 0) {
                            this.getModel().setValue("reccurrency", (Object)tradebill.getDynamicObject("reccurrency"));
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabsettle", "panelrec"});
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelpay"});
                        } else if (BigDecimal.ZERO.compareTo(settleAmt) > 0) {
                            this.getModel().setValue("paycurrency", (Object)tradebill.getDynamicObject("currency"));
                            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabsettle", "panelpay"});
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelrec"});
                        } else {
                            this.getView().setVisible(Boolean.valueOf(false), new String[]{"tabsettle"});
                        }
                    }
                    if (SwapTypeEnum.currency.getValue().equals(rateswapType)) {
                        this.getModel().setValue("reccurrency", (Object)tradebill.getDynamicObject("reccurrency"));
                        this.getModel().setValue("paycurrency", (Object)tradebill.getDynamicObject("currency"));
                        this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabsettle", "panelpay", "panelrec"});
                    }
                } else if (EmptyUtil.isNoEmpty((Long)cashflow_pay)) {
                    this.getModel().setValue("paycurrency", (Object)tradebill.getDynamicObject("currency"));
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabsettle", "panelpay"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelrec"});
                } else if (EmptyUtil.isNoEmpty((Long)cashflow_rec)) {
                    this.getModel().setValue("reccurrency", (Object)tradebill.getDynamicObject("reccurrency"));
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabsettle", "panelrec"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelpay"});
                }
            }
            if (BizOperateEnum.capitalpay.getValue().equals(bizop)) {
                this.getModel().setValue("paycurrency", (Object)tradebill.getDynamicObject("currency"));
                this.getModel().setValue("reccurrency", (Object)tradebill.getDynamicObject("reccurrency"));
            }
        }
        if (ProductTypeEnum.FORWRATEAGREE.getId().equals(protectType.getString("id")) && BizOperateEnum.interestpay.getValue().equals(bizop)) {
            DynamicObject plInfo = TmcDataServiceHelper.loadSingle((String)"tbo_plinfo", (String)"plcurrency", (QFilter[])new QFilter[]{new QFilter("tradebill", "=", (Object)tradebill.getLong("id"))});
            this.getModel().setValue("plcurrency", (Object)plInfo.getDynamicObject("plcurrency"));
            DynamicObjectCollection entrydetails = this.getModel().getEntryEntity("entrydetail");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrydetails)) {
                DynamicObject entrydetail = (DynamicObject)entrydetails.get(0);
                String direct = entrydetail.getString("direct_detail");
                DynamicObject plcurrency = plInfo.getDynamicObject("plcurrency");
                if ("pay".equals(direct)) {
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelpay"});
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelrec"});
                    this.getModel().setValue("paycurrency", (Object)plcurrency);
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelpay"});
                    this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelrec"});
                    this.getModel().setValue("reccurrency", (Object)plcurrency);
                }
            }
        }
    }

    private void setSetttleInfoByPl() {
        BigDecimal plAmt = (BigDecimal)this.getModel().getValue("plamt");
        if (BigDecimal.ZERO.compareTo(plAmt) < 0) {
            this.getModel().setValue("reccurrency", this.getModel().getValue("plcurrency"));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelrec"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelpay"});
        } else if (BigDecimal.ZERO.compareTo(plAmt) > 0) {
            this.getModel().setValue("paycurrency", this.getModel().getValue("plcurrency"));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelrec"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelpay"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelrec", "panelpay"});
        }
    }

    private void setSetttleInfoBySettleAmt() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        String deliveryWay = tradebill.getString("deliveryway");
        BigDecimal settleAmount = (BigDecimal)this.getModel().getValue("settleamount");
        if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) || DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && BigDecimal.ZERO.compareTo(settleAmount) < 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelrec"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelrec"});
        }
        if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) || DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && BigDecimal.ZERO.compareTo(settleAmount) > 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"panelpay"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"panelpay"});
        }
        if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
            if (BigDecimal.ZERO.compareTo(settleAmount) < 0) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reccurrency", (Object)this.getModel().getValue("plcurrency"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paycurrency", null);
            } else if (BigDecimal.ZERO.compareTo(settleAmount) > 0) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paycurrency", (Object)this.getModel().getValue("plcurrency"));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reccurrency", null);
            }
        }
    }

    public void afterBindData(EventObject e) {
        FieldEdit bizamtDetail;
        Map result;
        Long localCurrencyId;
        super.afterBindData(e);
        this.setTabSettleVisible();
        this.setSettleInfo();
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject protectType = tradeBill.getDynamicObject("protecttype");
        String protectNumber = protectType.getString("number");
        if ((ProductTypeEnum.FOREXSPOT.getValue().equals(protectNumber) || ProductTypeEnum.FOREXFORWARD.getValue().equals(protectNumber) || ProductTypeEnum.FOREXSWAPS.getValue().equals(protectNumber) || ProductTypeEnum.FOREXOPTION.getValue().equals(protectNumber)) && EmptyUtil.isEmpty((Object)this.getModel().getValue("fq"))) {
            this.getModel().setValue("fq", (Object)tradeBill.getString("fxquote"));
        }
        if ((OperationStatus.EDIT == this.getView().getFormShowParameter().getStatus() || OperationStatus.VIEW == this.getView().getFormShowParameter().getStatus()) && this.getModel().getValue("basecurrency") == null && EmptyUtil.isNoEmpty((Long)(localCurrencyId = (Long)(result = BaseDataServiceHelper.getBaseAccountingInfo((Long)tradeBill.getDynamicObject("org").getLong("id"))).get("baseCurrencyID")))) {
            DynamicObject localCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)localCurrencyId, (String)"bd_currency");
            this.getModel().setValue("basecurrency", (Object)localCurrency);
            this.getModel().setDataChanged(false);
        }
        if ((bizamtDetail = (FieldEdit)this.getView().getControl("bizamt_detail")) != null) {
            bizamtDetail.setMustInput(true);
        }
    }

    private void setTabSettleVisible() {
        String bizop = (String)this.getModel().getValue("operate");
        if (BizOperateEnum.defer.getValue().equals(bizop) || BizOperateEnum.maudate.getValue().equals(bizop) || BizOperateEnum.defer_n.getValue().equals(bizop) || BizOperateEnum.maudate_n.getValue().equals(bizop) || BizOperateEnum.defer_f.getValue().equals(bizop) || BizOperateEnum.maudate_f.getValue().equals(bizop)) {
            String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
            boolean isView = ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd);
            this.getView().setVisible(Boolean.valueOf(isView), new String[]{"tabsettle"});
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"tabsettle"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if ((StringUtils.equals((CharSequence)"save", (CharSequence)formOperate.getOperateKey()) || StringUtils.equals((CharSequence)"submit", (CharSequence)formOperate.getOperateKey())) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.getModel().setDataChanged(false);
        }
    }

    protected Map<String, Boolean> getSettlePanelVisible() {
        DynamicObjectCollection entrydetails;
        String deliveryWay;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        boolean isPay = true;
        boolean isRec = true;
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject protectType = tradebill.getDynamicObject("protecttype");
        String bizop = (String)this.getModel().getValue("operate");
        BigDecimal plAmt = (BigDecimal)this.getModel().getValue("plamt");
        if (ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id")) && BizOperateEnum.flat.getValue().equals(bizop)) {
            isPay = BigDecimal.ZERO.compareTo(plAmt) > 0;
            boolean bl = isRec = BigDecimal.ZERO.compareTo(plAmt) < 0;
        }
        if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
            deliveryWay = tradebill.getString("deliveryway");
            if (BizOperateEnum.expiredey.getValue().equals(bizop) && DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                isPay = BigDecimal.ZERO.compareTo(plAmt) > 0;
                boolean bl = isRec = BigDecimal.ZERO.compareTo(plAmt) < 0;
            }
            if (BizOperateEnum.flat.getValue().equals(bizop) || BizOperateEnum.defer.getValue().equals(bizop) || BizOperateEnum.maudate.getValue().equals(bizop)) {
                isPay = BigDecimal.ZERO.compareTo(plAmt) > 0;
                boolean bl = isRec = BigDecimal.ZERO.compareTo(plAmt) < 0;
            }
        }
        if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id")) && (BizOperateEnum.flat_f.getValue().equals(bizop) || BizOperateEnum.flat_n.getValue().equals(bizop) || BizOperateEnum.defer_f.getValue().equals(bizop) || BizOperateEnum.defer_n.getValue().equals(bizop) || BizOperateEnum.maudate_f.getValue().equals(bizop) || BizOperateEnum.maudate_n.getValue().equals(bizop))) {
            isPay = BigDecimal.ZERO.compareTo(plAmt) > 0;
            boolean bl = isRec = BigDecimal.ZERO.compareTo(plAmt) < 0;
        }
        if (ProductTypeEnum.FOREXOPTION.getId().equals(protectType.getString("id")) && BizOperateEnum.exercise.getValue().equals(bizop)) {
            deliveryWay = tradebill.getString("deliveryway");
            BigDecimal settleAmount = (BigDecimal)this.getModel().getValue("settleamount");
            isRec = DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) || DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && BigDecimal.ZERO.compareTo(settleAmount) < 0;
            boolean bl = isPay = DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) || DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && BigDecimal.ZERO.compareTo(settleAmount) > 0;
        }
        if (ProductTypeEnum.SWAP.getId().equals(protectType.getString("id")) && BizOperateEnum.interestpay.getValue().equals(bizop)) {
            Long cashflow_rec;
            Long cashflow_pay = (Long)this.getModel().getValue("cashflow_pay");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{cashflow_pay, cashflow_rec = (Long)this.getModel().getValue("cashflow_rec")})) {
                String rateswapType = tradebill.getString("rateswaptype");
                if (SwapTypeEnum.rate.getValue().equals(rateswapType)) {
                    BigDecimal settleAmt = (BigDecimal)this.getModel().getValue("settleamount");
                    isPay = BigDecimal.ZERO.compareTo(settleAmt) > 0;
                    isRec = BigDecimal.ZERO.compareTo(settleAmt) < 0;
                }
            } else if (EmptyUtil.isNoEmpty((Long)cashflow_pay)) {
                isPay = true;
                isRec = false;
            } else if (EmptyUtil.isNoEmpty((Long)cashflow_rec)) {
                isPay = false;
                isRec = true;
            }
        }
        if (ProductTypeEnum.FORWRATEAGREE.getId().equals(protectType.getString("id")) && BizOperateEnum.interestpay.getValue().equals(bizop) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(entrydetails = this.getModel().getEntryEntity("entrydetail")))) {
            DynamicObject entrydetail = (DynamicObject)entrydetails.get(0);
            String direct = entrydetail.getString("direct_detail");
            if ("pay".equals(direct)) {
                isPay = true;
                isRec = false;
            } else {
                isPay = false;
                isRec = true;
            }
        }
        result.put("isPay", isPay);
        result.put("isRec", isRec);
        return result;
    }

    @Override
    protected void initControl_PL() {
        boolean isShow = false;
        if (this.getModel().getValue("basecurrency") != null && this.getModel().getValue("plcurrency") != null) {
            DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
            Long localCurrencyId = localCurrency.getLong("id");
            DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
            if (plCurrency != null) {
                isShow = plCurrency.getLong("id") != localCurrencyId.longValue();
            }
        }
        this.getView().setVisible(Boolean.valueOf(isShow), new String[]{"basefq", "baseexrate", "baseplamt"});
        if (!isShow) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"basefq", (Object)"");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseexrate", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)BigDecimal.ZERO);
        }
    }
}

