/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeMenuParamEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;
import kd.tmc.tm.common.enums.BizOperateEnum;

public class BusinessBillList
extends AbstractTmcListPlugin
implements BeforeFilterF7SelectListener {
    private static final String[] PRODUCTS = new String[]{"01FOREXSPOT", "02FOREXFORWARD", "03FOREXSWAPS", "04FOREXOPTION", "01FORWRATEAGREE", "02SWAP", "01STRUCTDEPOSIT"};
    private static final String TBL_UP_TRACE = "tbluptrace";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getView().getControl("filtercontainerap");
        filterContainer.addBeforeF7SelectListener((BeforeFilterF7SelectListener)this);
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String orgId = null;
        if (EmptyUtil.isNoEmpty((Object)this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()))) {
            orgId = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()).getPageCache().get("org");
        }
        if (EmptyUtil.isNoEmpty(orgId)) {
            args.setMainOrgQFilter(new QFilter("id", "=", (Object)Long.valueOf(orgId)));
        }
    }

    public void itemClick(ItemClickEvent evt) {
        if (TBL_UP_TRACE.equals(evt.getItemKey())) {
            Long selectedId = this.getSelectedId();
            if (selectedId == null) {
                return;
            }
            DynamicObject selectObj = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"tm_businessbill");
            Object tradeId = selectObj.getDynamicObject("tradebill").getPkValue();
            Long protectTypeId = (Long)selectObj.getDynamicObject("protecttype").getPkValue();
            ProductTypeEnum productType = ProductTypeEnum.getEnumById((String)protectTypeId.toString());
            String tradeEntity = productType.getEntity();
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(tradeEntity);
            showParameter.setPkId(tradeId);
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operate = op.getOperateKey();
        op.getOption().setVariableValue("operate", operate);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        OperationResult opResult;
        super.afterDoOperation(args);
        if ((StringUtils.equals((CharSequence)"settle", (CharSequence)args.getOperateKey()) || StringUtils.equals((CharSequence)"unsettle", (CharSequence)args.getOperateKey()) || StringUtils.equals((CharSequence)"plconfirm", (CharSequence)args.getOperateKey()) || StringUtils.equals((CharSequence)"unplconfirm", (CharSequence)args.getOperateKey())) && (opResult = args.getOperationResult()) != null && opResult.isSuccess()) {
            ((BillList)this.getControl("billlistap")).refreshData();
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        Object billId = e.getParameter().getPkId();
        if (billId != null) {
            BillList billList = (BillList)this.getControl("billlistap");
            String entity = billList.getEntityId();
            DynamicObject info = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entity, (String)"id, billstatus, operate, tradebill.protecttype");
            String billStaus = info.getString("billstatus");
            if (TcBillStatusEnum.SETTLE_ING.getValue().equals(billStaus) || TcBillStatusEnum.SETTLE_DONE.getValue().equals(billStaus)) {
                e.getParameter().setBillStatus(BillOperationStatus.AUDIT);
            }
            BizOperateEnum operate = BizOperateEnum.valueOf((String)info.getString("operate"));
            String srcEntityType = TmcBotpHelper.getSourceBillEntityType((String)entity, (Long)info.getLong("id"));
            e.getParameter().setCaption(info.getDynamicObject("tradebill.protecttype").getString("name") + operate.getName());
            if (BizOperateEnum.pay == operate && "tm_structdeposit".equals(srcEntityType)) {
                e.getParameter().setCaption(ResManager.loadKDString((String)"%s\u5229\u606f/\u672c\u91d1\u6536\u53d6", (String)"BusinessBillList_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{info.getDynamicObject("tradebill.protecttype").getString("name")}));
            }
            if (EmptyUtil.isNoEmpty((String)info.getString("operate"))) {
                if (EmptyUtil.isNoEmpty((String)operate.getForm())) {
                    if (ProductTypeEnum.FORWRATEAGREE.getId().equals(info.getDynamicObject("tradebill.protecttype").getString("id"))) {
                        e.getParameter().setFormId("tm_bizbill_forw_pay");
                    } else {
                        e.getParameter().setFormId(operate.getForm());
                    }
                } else {
                    if (BizOperateEnum.expiredey == operate) {
                        if ("tm_forex".equals(srcEntityType)) {
                            e.getParameter().setFormId("tm_businessbill_forex_s");
                        } else {
                            e.getParameter().setFormId("tm_businessbill_forex_d");
                        }
                    }
                    if (BizOperateEnum.flat == operate) {
                        if ("tm_forex_options".equals(srcEntityType)) {
                            e.getParameter().setFormId("tm_businessbill_p");
                        } else {
                            e.getParameter().setFormId("tm_businessbill_forex_c");
                        }
                    }
                    if (BizOperateEnum.pay == operate) {
                        if ("tm_rateswap".equals(srcEntityType)) {
                            e.getParameter().setFormId("tm_bizbill_swap_pay");
                        } else {
                            e.getParameter().setFormId("tm_businessbill_pay");
                        }
                    }
                    if (BizOperateEnum.ratecfg == operate) {
                        if ("tm_rateswap".equals(srcEntityType)) {
                            e.getParameter().setFormId("tm_bizbill_swap_ratecfg");
                        } else {
                            e.getParameter().setFormId("tm_businessbill_rate");
                        }
                    }
                }
            }
        }
        super.beforeShowBill(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonBaseDataFilterColumn temp;
            if (!filterColumn.getFieldName().equals("protecttype.name")) continue;
            if (EmptyUtil.isEmpty((String)this.getView().getPageCache().get("inittype"))) {
                QFilter filter = new QFilter("longnumber", "like", (Object)"TRADE.01FOREX%");
                filter = filter.or(new QFilter("longnumber", "like", (Object)"TRADE.03RATE%").and(new QFilter("longnumber", "!=", (Object)"TRADE.03RATE.03RATEBOUND")));
                filter = filter.or(new QFilter("longnumber", "=", (Object)"TRADE.05STRUCT.01STRUCTDEPOSIT"));
                filter = filter.and(new QFilter("isbiznode", "=", (Object)Character.valueOf('1')));
                DynamicObject[] protectTypes = TmcDataServiceHelper.load((String)"tbd_tradetype", (String)"id", (QFilter[])new QFilter[]{filter});
                temp = (CommonBaseDataFilterColumn)filterColumn;
                List items = temp.getComboItems();
                items.clear();
                for (DynamicObject protectType : protectTypes) {
                    items.add(new ComboItem(new LocaleString(protectType.getString("name")), protectType.getString("id")));
                }
                if (this.getView().getFormShowParameter().getCustomParams().containsKey("productType")) {
                    String productType = (String)this.getView().getFormShowParameter().getCustomParams().get("productType");
                    if (ProductTypeMenuParamEnum.STRUCT.getValue().equals(productType)) {
                        temp.setDefaultValue(ProductTypeEnum.STRUCTDEPOSIT.getId());
                    }
                    if (ProductTypeMenuParamEnum.RATE.getValue().equals(productType)) {
                        temp.setDefaultValues(Arrays.asList(ProductTypeEnum.FORWRATEAGREE.getId(), ProductTypeEnum.SWAP.getId()));
                    }
                    if (ProductTypeMenuParamEnum.FOREX.getValue().equals(productType)) {
                        temp.setDefaultValues(Arrays.asList(ProductTypeEnum.FOREXSPOT.getId(), ProductTypeEnum.FOREXFORWARD.getId(), ProductTypeEnum.FOREXSWAPS.getId(), ProductTypeEnum.FOREXOPTION.getId()));
                    }
                }
                this.getView().getPageCache().put("inittype", SerializationUtils.toJsonString((Object)items));
                continue;
            }
            String inittype = this.getView().getPageCache().get("inittype");
            List data = SerializationUtils.fromJsonStringToList((String)inittype, ComboItem.class);
            temp = (CommonBaseDataFilterColumn)filterColumn;
            temp.getComboItems().clear();
            temp.getComboItems().addAll(data);
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.equals("protecttype.id")) {
            args.getQfilters().add(this.initProtectedTypeEvi());
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        e.setOrderBy("bizdate desc");
    }

    protected List<QFilter> addCustomFilterForFilterCol(String fieldName) {
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if ("protecttype.name".equals(fieldName)) {
            list.add(this.initProtectedTypeEvi());
        }
        return list;
    }

    protected QFilter initProtectedTypeEvi() {
        QFilter filter = new QFilter("isbiznode", "=", (Object)"1");
        filter = filter.and(new QFilter("number", "!=", (Object)"01RATEOPEN"));
        filter = filter.and(new QFilter("number", "!=", (Object)"02EXRATEOPEN"));
        return filter;
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        String fieldName = event.getFieldName();
        if ("protecttype.id".equals(fieldName) || "protecttype.number".equals(fieldName) || "protecttype.name".equals(fieldName)) {
            event.getQfilters().add(new QFilter("number", "in", (Object)PRODUCTS));
        }
    }
}

