/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.DateEdit;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class FlatBizBillEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.init_ForexOptions();
        this.initControl_ForexOptions();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        switch (propName) {
            case "bizdate": {
                Date bizdate = (Date)this.getModel().getValue("bizdate");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plsettledate", (Object)bizdate);
                this.calPlAmtValue();
                this.setControl_SettleDate_ForexOptions(tradebill);
                this.setBaseInfo_PL(tradebill);
                break;
            }
            case "bizamt1": 
            case "settleamount": 
            case "premium_pl": {
                this.calPlAmt();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "plamt": 
            case "baseexrate": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "plcurrency": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settlecurrency", (Object)this.getModel().getValue("plcurrency"));
                this.calPlAmtValue();
                this.setBaseInfo_PL(tradebill);
                if (TradeDirectionEnum.sell.getValue().equals(tradebill.getString("tradedirect"))) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paycurrency", (Object)this.getModel().getValue("plcurrency"));
                    break;
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reccurrency", (Object)this.getModel().getValue("plcurrency"));
                break;
            }
            case "settlecurrency": {
                this.getModel().setValue("plcurrency", this.getModel().getValue("settlecurrency"));
                break;
            }
            case "premium_pl_exrate": {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_pl", (Object)BusinessBillHelper.calPremium_PL((DynamicObject)this.getModel().getDataEntity()));
                this.calPlAmt();
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"baseplamt", (Object)this.calBaseAmt_PL());
            }
        }
    }

    private void init_ForexOptions() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
            Date expireDate = tradebill.getDate("adjexpiredate");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"expireddate", (Object)expireDate);
            Date curDate = TcDateUtils.getCurrentDate();
            Date bizdate = tradebill.getDate("bizdate");
            if (!curDate.before(bizdate) && !curDate.after(expireDate)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", (Object)curDate);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plsettledate", (Object)curDate);
            }
            DynamicObject premCurrency = tradebill.getDynamicObject("premiumcurrency");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premcurrency_src", (Object)premCurrency);
            BigDecimal premium = tradebill.getBigDecimal("premium");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_src", (Object)premium);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settlecurrency", (Object)premCurrency);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plcurrency", (Object)premCurrency);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"reccurrency", (Object)premCurrency);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"paycurrency", (Object)premCurrency);
            this.calPlAmtValue();
            this.setBaseInfo_PL(tradebill);
        }
    }

    private void initControl_ForexOptions() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        this.setControl_BizDate_ForexOptions(tradebill);
        this.setControl_SettleDate_ForexOptions(tradebill);
        this.initControl_PL();
    }

    private void setControl_BizDate_ForexOptions(DynamicObject tradebill) {
        DateEdit dateEdit = (DateEdit)this.getView().getControl("bizdate");
        Date bizdate = tradebill.getDate("bizdate");
        Date expireDate = tradebill.getDate("adjexpiredate");
        dateEdit.setMinDate(bizdate);
        dateEdit.setMaxDate(expireDate);
    }

    private void setControl_SettleDate_ForexOptions(DynamicObject tradebill) {
        DateEdit dateEdit = (DateEdit)this.getView().getControl("plsettledate");
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        Date adjustSettleDate = tradebill.getDate("adjustsettledate");
        dateEdit.setMinDate(bizdate);
        dateEdit.setMaxDate(adjustSettleDate);
    }

    private void calPlAmt() {
        DynamicObject premiumCur;
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, premiumCur = tradebill.getDynamicObject("premiumcurrency")})) {
            return;
        }
        Long plId = plCurrency.getLong("id");
        BigDecimal premium = !plId.equals(premiumCur.getLong("id")) ? (BigDecimal)this.getModel().getValue("premium_pl") : tradebill.getBigDecimal("premium");
        BigDecimal settleAmount = (BigDecimal)this.getModel().getValue("settleamount");
        BigDecimal firstAmount = (BigDecimal)this.getModel().getValue("bizamt1");
        BigDecimal buyAmt = tradebill.getBigDecimal("amount");
        BigDecimal pl = settleAmount.subtract(premium.multiply(firstAmount).divide(buyAmt, 10, 4));
        String tradeDirect = tradebill.getString("tradedirect");
        if (TradeDirectionEnum.sell.getValue().equals(tradeDirect)) {
            pl = pl.negate();
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plamt", (Object)pl);
    }

    private void calPlAmtValue() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        DynamicObject premiumCur = tradebill.getDynamicObject("premiumcurrency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{plCurrency, premiumCur})) {
            return;
        }
        Long plId = plCurrency.getLong("id");
        String tradeDirect = tradebill.getString("tradedirect");
        BigDecimal premium = tradebill.getBigDecimal("premium");
        if (!plId.equals(premiumCur.getLong("id"))) {
            DynamicObject priceRule = TmcDataServiceHelper.loadSingle((Object)tradebill.getDynamicObject("pricerule").getLong("id"), (String)"md_pricerule", (String)"forexquote.issuetime");
            Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            String quyfxQuote = plCurrency.getString("number").trim() + "/" + premiumCur.getString("number").trim();
            Date optDate = (Date)this.getModel().getValue("bizdate");
            ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)quyfxQuote, (Date)optDate, null);
            String fxquote = forexQuoteInfo.getFxquote();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_pl_fq", (Object)fxquote);
            if (quyfxQuote.equals(fxquote)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_pl_exrate", (Object)forexQuoteInfo.getSellPrice());
                premium = premium.divide(forexQuoteInfo.getSellPrice(), 10, 4);
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_pl_exrate", (Object)forexQuoteInfo.getBuyPrice());
                premium = premium.multiply(forexQuoteInfo.getBuyPrice());
            }
            DynamicObject premCurrency = (DynamicObject)this.getModel().getValue("premcurrency_src");
            if (premCurrency != null) {
                int precision = premCurrency.getInt("amtprecision");
                premium = premium.setScale(precision, RoundingMode.HALF_UP);
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_pl", (Object)premium);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_pl_fq", (Object)"");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_pl_exrate", (Object)BigDecimal.ZERO);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"premium_pl", (Object)BigDecimal.ZERO);
        }
        BigDecimal settleAmount = (BigDecimal)this.getModel().getValue("settleamount");
        BigDecimal firstAmount = (BigDecimal)this.getModel().getValue("bizamt1");
        BigDecimal buyAmt = tradebill.getBigDecimal("amount");
        BigDecimal pl = settleAmount.subtract(premium.multiply(firstAmount).divide(buyAmt, 10, 4));
        if (TradeDirectionEnum.sell.getValue().equals(tradeDirect)) {
            pl = pl.negate();
        }
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plamt", (Object)pl);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        switch (key) {
            case "settleamount": {
                if (!EmptyUtil.isNoEmpty((Object)value)) break;
                BigDecimal premium = new BigDecimal(String.valueOf(value));
                if (BigDecimal.ZERO.compareTo(premium) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e73\u4ed3\u4fe1\u606f\u4e2d\u7684\u671f\u6743\u8d39\u4e0d\u5141\u8bb8\u5c0f\u4e8e0\u3002", (String)"FlatBizBillEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                }
                this.getView().updateView("settleamount");
                break;
            }
            case "premium_pl_exrate": {
                BigDecimal v = EmptyUtil.isNoEmpty((Object)value) ? new BigDecimal(String.valueOf(value)) : BigDecimal.ZERO;
                if (BigDecimal.ZERO.compareTo(v) < 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5927\u4e8e0\u7684\u6570\u503c\u3002", (String)"BizBillEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[]{2000}));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        }
    }
}

