/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.DateEdit;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.common.helper.PlHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class ForexExpireDeyEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String srcEntityType = this.getSrcEntityType();
        if ("tm_forex".equals(srcEntityType)) {
            this.initDefault_Forex();
            this.initControl_Forex();
            this.controlPl_Forex();
        }
        if ("tm_forex_forward".equals(srcEntityType)) {
            this.initDefault_ForexFwd();
            this.initControl_ForexFwd();
        }
        if ("tm_forex_swaps".equals(srcEntityType)) {
            this.initDefault_ForexSwap();
            this.initControl_ForexSwap();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject protectType = tradebill.getDynamicObject("protecttype");
        String operate = (String)this.getModel().getValue("operate");
        switch (propName) {
            case "exrate_src": 
            case "execexrate": 
            case "bizamt1": {
                if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
                    this.setPlAmt_ForexFwd();
                }
                if (!ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id")) || !PlHelper.isNeedPl_ForexSwapExpireDey((Long)tradebill.getLong("id"), (String)operate).booleanValue()) break;
                this.setPlAmt_ForexFwd();
                break;
            }
            case "plamt": 
            case "baseexrate": {
                this.getModel().setValue("baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "bizdate": {
                BigDecimal exRate;
                Date bizDate = (Date)this.getModel().getValue("bizdate");
                if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
                    exRate = BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)bizDate, null, (boolean)false);
                    this.getModel().setValue("execexrate", (Object)exRate);
                }
                if (!ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id")) || !PlHelper.isNeedPl_ForexSwapExpireDey((Long)tradebill.getLong("id"), (String)operate).booleanValue()) break;
                exRate = BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)bizDate, null, (boolean)BusinessBillHelper.isSwapFar((String)operate));
                this.getModel().setValue("execexrate", (Object)exRate);
                break;
            }
            case "bizrecordid": {
                if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
                    this.setDefault_ForexFwd();
                    this.initControl_ForexFwd();
                }
                if (ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id"))) {
                    this.setDefault_Forex();
                    this.initControl_Forex();
                }
                if (!ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) break;
                this.setDefault_ForexSwap();
                this.initControl_ForexSwap();
            }
        }
    }

    private void setPlAmt_ForexFwd() {
        BigDecimal execExrate = (BigDecimal)this.getModel().getValue("execexrate");
        BigDecimal spotExrate = (BigDecimal)this.getModel().getValue("exrate_src");
        BigDecimal plAmt = this.calPlAmtWithPlCurrency(execExrate, spotExrate);
        String operate = (String)this.getModel().getValue("operate");
        if (BusinessBillHelper.isSwapFar((String)operate).booleanValue()) {
            plAmt = plAmt.negate();
        }
        this.getModel().setValue("plamt", (Object)plAmt);
    }

    private void initDefault_ForexFwd() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setDefault_ForexFwd();
        }
    }

    private void setDefault_ForexFwd() {
        boolean isDateRange;
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date curDate = TcDateUtils.getCurrentDate();
        Date endDateSrc = (Date)this.getModel().getValue("enddate_src");
        boolean bl = isDateRange = !EmptyUtil.isEmpty((Object)endDateSrc);
        if (isDateRange) {
            if (this.isBetween(curDate, (Date)this.getModel().getValue("bizdate_src"), endDateSrc, false)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", (Object)curDate);
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", null);
            }
            this.getModel().setValue("deliverydate", null);
        } else {
            Date maxDate = (Date)this.getModel().getValue("date_src");
            if (this.isBetween(curDate, (Date)this.getModel().getValue("bizdate_src"), maxDate, false)) {
                this.getModel().setValue("bizdate", (Object)curDate);
            } else {
                this.getModel().setValue("bizdate", null);
            }
            this.getModel().setValue("deliverydate", (Object)maxDate);
        }
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        BigDecimal exRate = BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)bizdate, null, (boolean)false);
        this.getModel().setValue("execexrate", (Object)exRate);
        if (DeliveryWayEnum.non_deliverable.getValue().equals(tradebill.get("deliveryway"))) {
            this.getModel().setValue("plcurrency", tradebill.get("settlecurrency"));
        } else {
            this.getModel().setValue("plcurrency", tradebill.get("sellcurrency"));
        }
        this.setPlAmt_ForexFwd();
        this.setBaseInfo_PL(tradebill);
    }

    private void initControl_ForexFwd() {
        this.setControl_BizDate_ForexFwd();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"plsettledate"});
        this.initControl_PL();
    }

    private void setControl_BizDate_ForexFwd() {
        DateEdit bizDateEdit = (DateEdit)this.getView().getControl("bizdate");
        DateEdit bedeyDateEdit = (DateEdit)this.getView().getControl("deliverydate");
        Date bizdate = (Date)this.getModel().getValue("bizdate_src");
        if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("enddate_src"))) {
            Date minDate = (Date)this.getModel().getValue("date_src");
            Date maxDate = (Date)this.getModel().getValue("enddate_src");
            bizDateEdit.setMinDate(bizdate);
            bizDateEdit.setMaxDate(maxDate);
            bedeyDateEdit.setMinDate(minDate);
        } else {
            Date maxDate = (Date)this.getModel().getValue("date_src");
            bizDateEdit.setMinDate(bizdate);
            bizDateEdit.setMaxDate(maxDate);
            bedeyDateEdit.setMinDate(maxDate);
        }
    }

    private void initControl_Forex() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date bizdate = (Date)this.getModel().getValue("bizdate_src");
        Date settledate = tradebill.getDate("settledate");
        DateEdit bizdateEdit = (DateEdit)this.getView().getControl("bizdate");
        bizdateEdit.setMinDate(bizdate);
        bizdateEdit.setMaxDate(settledate);
        DateEdit deyEdit = (DateEdit)this.getView().getControl("deliverydate");
        deyEdit.setMinDate(settledate);
    }

    private void controlPl_Forex() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)tradebill.getDynamicObject("org").getLong("id"));
        Long basecurrencyId = (Long)result.get("baseCurrencyID");
        DynamicObject buyCurrency = tradebill.getDynamicObject("currency");
        DynamicObject sellCurrency = tradebill.getDynamicObject("sellcurrency");
        long buyCurrencyId = buyCurrency.getLong("id");
        long sellCurrencyId = sellCurrency.getLong("id");
        if (basecurrencyId == buyCurrencyId || basecurrencyId == sellCurrencyId) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fp_pnl"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"isplconfirm"});
        }
    }

    private void initDefault_Forex() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setDefault_Forex();
        }
    }

    private void setDefault_Forex() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date settledate = tradebill.getDate("settledate");
        Date curDate = TcDateUtils.getCurrentDate();
        if (this.isBetween(curDate, (Date)this.getModel().getValue("bizdate_src"), settledate, false)) {
            this.getModel().setValue("bizdate", (Object)curDate);
        } else {
            this.getModel().setValue("bizdate", null);
        }
        this.getModel().setValue("deliverydate", (Object)tradebill.getDate("settledate"));
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)tradebill.getDynamicObject("org").getLong("id"));
        Long basecurrencyId = (Long)result.get("baseCurrencyID");
        DynamicObject buyCurrency = tradebill.getDynamicObject("currency");
        DynamicObject sellCurrency = tradebill.getDynamicObject("sellcurrency");
        long buyCurrencyId = buyCurrency.getLong("id");
        long sellCurrencyId = sellCurrency.getLong("id");
        if (basecurrencyId == buyCurrencyId || basecurrencyId == sellCurrencyId) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"fp_pnl"});
        }
        this.setBaseInfo_PL(tradebill);
    }

    private void initDefault_ForexSwap() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setDefault_ForexSwap();
        }
    }

    private void setDefault_ForexSwap() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date delveryDate = (Date)this.getModel().getValue("date_src");
        Date curDate = TcDateUtils.getCurrentDate();
        if (this.isBetween(curDate, (Date)this.getModel().getValue("bizdate_src"), delveryDate, false)) {
            this.getModel().setValue("bizdate", (Object)curDate);
        } else {
            this.getModel().setValue("bizdate", null);
        }
        this.getModel().setValue("deliverydate", (Object)delveryDate);
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        String operate = (String)this.getModel().getValue("operate");
        if (PlHelper.isNeedPl_ForexSwapExpireDey((Long)tradebill.getLong("id"), (String)operate).booleanValue()) {
            BigDecimal exRate = BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)bizdate, null, (boolean)BusinessBillHelper.isSwapFar((String)operate));
            this.getModel().setValue("execexrate", (Object)exRate);
            this.getModel().setValue("plcurrency", tradebill.get("sellcurrency"));
            this.setPlAmt_ForexFwd();
        }
        this.setBaseInfo_PL(tradebill);
    }

    private void initControl_ForexSwap() {
        this.setControl_BizDate_ForexSwap();
        Date adjSettleDate = (Date)this.getModel().getValue("date_src");
        DateEdit deyDateEdit = (DateEdit)this.getView().getControl("deliverydate");
        deyDateEdit.setMinDate(adjSettleDate);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"plsettledate"});
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        String op = (String)this.getModel().getValue("operate");
        Boolean isNeedPl = PlHelper.isNeedPl_ForexSwapExpireDey((Long)tradebill.getLong("id"), (String)op);
        if (isNeedPl.booleanValue()) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"fieldsetpanelap", "fieldsetpanelap2"});
        } else {
            DynamicObject localCurrency = (DynamicObject)this.getModel().getValue("basecurrency");
            if (localCurrency != null && this.isShowVoucherPlPanel(tradebill, localCurrency.getLong("id"))) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"isplconfirm", "fieldsetpanelap2"});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{"fp_pnl"});
            }
        }
        if (isNeedPl.booleanValue()) {
            this.initControl_PL();
        }
    }

    private void setControl_BizDate_ForexSwap() {
        Date delveryDate = (Date)this.getModel().getValue("date_src");
        Date bizDate = (Date)this.getModel().getValue("bizdate_src");
        DateEdit dateEdit = (DateEdit)this.getView().getControl("bizdate");
        dateEdit.setMinDate(bizDate);
        dateEdit.setMaxDate(delveryDate);
    }
}

