/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DecimalEdit;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class ForexFwdBeDeyEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String srcEntityType = this.getSrcEntityType();
        if ("tm_forex_forward".equals(srcEntityType)) {
            this.initDefault_ForexFwd();
            this.initControl_ForexFwd();
        }
        if ("tm_forex_swaps".equals(srcEntityType)) {
            this.initDefault_ForexSwap();
            this.initControl_ForexSwap();
        }
        this.setViewSettleDate();
        this.initSettleDate();
    }

    private void initDefault_ForexSwap() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setDefault();
        }
    }

    private void setDefault() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exratecalmtd", (Object)ExRateCalMethodEnum.SrcMinusFwdPips);
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date curDate = TcDateUtils.getCurrentDate();
        Date date_src = (Date)this.getModel().getValue("date_src");
        if (this.isBetween(curDate, (Date)this.getModel().getValue("bizdate_src"), date_src, true)) {
            if (this.getModel().getValue("bizdate") != null && ((Date)this.getModel().getValue("bizdate")).compareTo(curDate) == 0) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", null);
            }
            this.getModel().setValue("bizdate", (Object)curDate);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", null);
            this.getModel().setValue("spotrate_dey", this.getModel().getValue("exrate_src"));
        }
        this.setPlCurrency(tradebill);
        this.setAmt_PL();
        this.setBaseInfo_PL(tradebill);
    }

    private void initControl_ForexSwap() {
        this.setControl_BizDate_ForexSwap();
        this.setControl_DeyDate_ForexSwap();
        this.setControl_SettleDate_ForexSwap();
        this.setExecExRateTitle();
        ComboEdit comboEdit = (ComboEdit)this.getControl("exratecalmtd");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString(ExRateCalMethodEnum.SrcMinusFwdPips.getName()), ExRateCalMethodEnum.SrcMinusFwdPips.getValue()));
        data.add(new ComboItem(new LocaleString(ExRateCalMethodEnum.Rate.getName()), ExRateCalMethodEnum.Rate.getValue()));
        comboEdit.setComboItems(data);
        this.initControl_PL();
    }

    private void initDefault_ForexFwd() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setDefault();
        }
    }

    private void setExecExRateTitle() {
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        DecimalEdit exrateEdit = (DecimalEdit)this.getView().getControl("execexrate");
        if (ExRateCalMethodEnum.Rate.getValue().equals(exrateCalMtd)) {
            exrateEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e73\u4ed3\u8fdc\u671f\u6c47\u7387", (String)"FlatFwdExrate", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
        }
        if (ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(exrateCalMtd)) {
            exrateEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5373\u671f\u6c47\u7387", (String)"ForexFwdBeDeyEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
        }
    }

    private void setControl_BizDate_ForexSwap() {
        DateEdit dateEdit = (DateEdit)this.getView().getControl("bizdate");
        Date bizdate = (Date)this.getModel().getValue("bizdate_src");
        Date srcdate = (Date)this.getModel().getValue("date_src");
        dateEdit.setMinDate(bizdate);
        dateEdit.setMaxDate(TcDateUtils.getLastDay((Date)srcdate, (int)1));
    }

    private void setControl_DeyDate_ForexSwap() {
        DateEdit dateEdit = (DateEdit)this.getView().getControl("deliverydate");
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        Date deydate = (Date)this.getModel().getValue("date_src");
        dateEdit.setMinDate(bizdate);
        if (EmptyUtil.isNoEmpty((Object)deydate)) {
            dateEdit.setMaxDate(TcDateUtils.getLastDay((Date)deydate, (int)1));
        }
    }

    private void setControl_SettleDate_ForexSwap() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        DateEdit dateEdit = (DateEdit)this.getView().getControl("plsettledate");
        Date deydate = (Date)this.getModel().getValue("date_src");
        dateEdit.setMinDate(bizdate);
        dateEdit.setMaxDate(deydate);
    }

    private void setViewSettleDate() {
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        if (ExRateCalMethodEnum.Rate.getValue().equals(exrateCalMtd)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"plsettledate"});
        }
        if (ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(exrateCalMtd)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"plsettledate"});
        }
    }

    private void initControl_ForexFwd() {
        this.setExecExRateTitle();
        Date leftDate = (Date)this.getModel().getValue("date_src");
        leftDate = TcDateUtils.getLastDay((Date)leftDate, (int)1);
        DateEdit bizdateEdit = (DateEdit)this.getView().getControl("bizdate");
        bizdateEdit.setMinDate((Date)this.getModel().getValue("bizdate_src"));
        bizdateEdit.setMaxDate(leftDate);
        this.setControl_DeyDate_ForexFwd();
        this.setControl_SettleDate_ForexFwd();
        ComboEdit comboEdit = (ComboEdit)this.getControl("exratecalmtd");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString(ExRateCalMethodEnum.SrcMinusFwdPips.getName()), ExRateCalMethodEnum.SrcMinusFwdPips.getValue()));
        data.add(new ComboItem(new LocaleString(ExRateCalMethodEnum.Rate.getName()), ExRateCalMethodEnum.Rate.getValue()));
        comboEdit.setComboItems(data);
        this.initControl_PL();
    }

    private void setControl_SettleDate_ForexFwd() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        Date rightDate = this.getDeyDateSrc_ForexFwd();
        DateEdit settledateEdit = (DateEdit)this.getView().getControl("plsettledate");
        settledateEdit.setMinDate(bizdate);
        settledateEdit.setMaxDate(rightDate);
    }

    private void setControl_DeyDate_ForexFwd() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        Date leftDate = (Date)this.getModel().getValue("date_src");
        DateEdit bedeydateEdit = (DateEdit)this.getView().getControl("deliverydate");
        bedeydateEdit.setMinDate(bizdate);
        bedeydateEdit.setMaxDate(TcDateUtils.getLastDay((Date)leftDate, (int)1));
    }

    private void setBedeyExrate() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date bedeydate = (Date)this.getModel().getValue("deliverydate");
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        String operate = (String)this.getModel().getValue("operate");
        BigDecimal exRate = BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)bizdate, (Date)bedeydate, (boolean)BusinessBillHelper.isSwapFar((String)operate));
        this.getModel().setValue("spotrate_dey", (Object)exRate);
    }

    private void pipsChangedEvt() {
        BigDecimal pips;
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        if (ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(exrateCalMtd)) {
            BigDecimal fwdExrate = (BigDecimal)this.getModel().getValue("exrate_src");
            pips = (BigDecimal)this.getModel().getValue("pips");
            BigDecimal beDeyExrate = fwdExrate.subtract(pips.divide(Constants.TEN_THOUSAND, 10, 4));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"spotrate_dey", (Object)beDeyExrate);
        }
        if (ExRateCalMethodEnum.Rate.getValue().equals(exrateCalMtd)) {
            BigDecimal beDeyExrate = (BigDecimal)this.getModel().getValue("spotrate_dey");
            pips = (BigDecimal)this.getModel().getValue("pips");
            BigDecimal execExrate = beDeyExrate.add(pips.divide(Constants.TEN_THOUSAND, 10, 4));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"execexrate", (Object)execExrate);
        }
    }

    private void setPipsByExrate() {
        BigDecimal beDeyExrate;
        BigDecimal fwdRate;
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        if (ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(exrateCalMtd)) {
            fwdRate = (BigDecimal)this.getModel().getValue("exrate_src");
            beDeyExrate = (BigDecimal)this.getModel().getValue("spotrate_dey");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pips", (Object)fwdRate.subtract(beDeyExrate).multiply(Constants.TEN_THOUSAND));
        }
        if (ExRateCalMethodEnum.Rate.getValue().equals(exrateCalMtd)) {
            fwdRate = (BigDecimal)this.getModel().getValue("execexrate");
            beDeyExrate = (BigDecimal)this.getModel().getValue("spotrate_dey");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pips", (Object)fwdRate.subtract(beDeyExrate).multiply(Constants.TEN_THOUSAND));
        }
    }

    private void setExecExrateByDate() {
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        String operate = (String)this.getModel().getValue("operate");
        if (ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(exrateCalMtd)) {
            Date bedeydate = (Date)this.getModel().getValue("deliverydate");
            this.getModel().setValue("execexrate", (Object)BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)bizdate, null, (boolean)BusinessBillHelper.isSwapFar((String)operate)));
        }
        if (ExRateCalMethodEnum.Rate.getValue().equals(exrateCalMtd)) {
            this.getModel().setValue("execexrate", (Object)BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)bizdate, (Date)this.getDeyDateSrc_ForexFwd(), (BusinessBillHelper.isSwapFar((String)operate) == false ? 1 : 0) != 0));
        }
    }

    private void setAmt_PL() {
        BigDecimal amt_pl;
        BigDecimal exrate;
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject plCurrency = this.getPlCurrency();
        DynamicObject plCurrencySrc = tradebill.getDynamicObject("sellcurrency");
        String operate = (String)this.getModel().getValue("operate");
        if (ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(exrateCalMtd)) {
            BigDecimal beforeExrate = (BigDecimal)this.getModel().getValue("spotrate_dey");
            exrate = (BigDecimal)this.getModel().getValue("execexrate");
            amt_pl = this.calAmt_PL(exrate, beforeExrate);
            if (BusinessBillHelper.isSwapFar((String)operate).booleanValue()) {
                amt_pl = amt_pl.negate();
            }
            if (plCurrency.getLong("id") != plCurrencySrc.getLong("id")) {
                amt_pl = EmptyUtil.isEmpty((BigDecimal)exrate) ? BigDecimal.ZERO : (plCurrencySrc.getString("number").equals(tradebill.getString("fxquote").split("/")[0]) ? amt_pl.multiply(exrate) : amt_pl.divide(exrate, 10, 4));
            }
            this.getModel().setValue("plamt", (Object)amt_pl);
        }
        if (ExRateCalMethodEnum.Rate.getValue().equals(exrateCalMtd)) {
            BigDecimal fwdExrate = (BigDecimal)this.getModel().getValue("exrate_src");
            exrate = (BigDecimal)this.getModel().getValue("execexrate");
            amt_pl = this.calAmt_PL(exrate, fwdExrate);
            if (BusinessBillHelper.isSwapFar((String)operate).booleanValue()) {
                amt_pl = amt_pl.negate();
            }
            amt_pl = this.dealPlAmt_PlCurrencyNotSrc(amt_pl);
            this.getModel().setValue("plamt", (Object)amt_pl);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject protectType = tradebill.getDynamicObject("protecttype");
        switch (propName) {
            case "bizamt1": {
                this.setAmt_PL();
                break;
            }
            case "execexrate": 
            case "spotrate_dey": {
                this.setPipsByExrate();
                this.setAmt_PL();
                break;
            }
            case "pips": {
                this.pipsChangedEvt();
                this.spotRateChange();
                this.setAmt_PL();
                break;
            }
            case "deliverydate": {
                this.setBedeyExrate();
                if (!ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(exrateCalMtd)) break;
                this.setExecExrateByDate();
                break;
            }
            case "exratecalmtd": {
                this.setPlCurrency(tradebill);
                this.setViewSettleDate();
                this.initSettleDate();
                this.setExecExRateTitle();
                this.setBedeyExrate();
                this.setExecExrateByDate();
                this.setAmt_PL();
                break;
            }
            case "plamt": 
            case "baseexrate": {
                this.getModel().setValue("baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "bizrecordid": {
                this.clear();
                this.setDefault();
                if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) {
                    this.initControl_ForexSwap();
                }
                if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
                    this.initControl_ForexFwd();
                }
                this.initSettleDate();
                break;
            }
            case "bizdate": {
                if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
                    this.setControl_DeyDate_ForexFwd();
                    this.setControl_SettleDate_ForexFwd();
                }
                if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) {
                    this.setControl_DeyDate_ForexSwap();
                    this.setControl_SettleDate_ForexSwap();
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"deliverydate", (Object)this.getModel().getValue("bizdate"));
                this.initSettleDate();
                this.setBedeyExrate();
                this.setExecExrateByDate();
            }
        }
    }

    private void clear() {
        HashMap<String, BigDecimal> paramMap = new HashMap<String, BigDecimal>(3);
        paramMap.put("deliverydate", null);
        paramMap.put("plsettledate", null);
        paramMap.put("execexrate", BigDecimal.ZERO);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), paramMap);
    }

    private void initSettleDate() {
        if (ExRateCalMethodEnum.Rate.getValue().equals(this.getModel().getValue("exratecalmtd"))) {
            this.getModel().setValue("plsettledate", this.getModel().getValue("bizdate"));
        } else if (ExRateCalMethodEnum.SrcMinusFwdPips.getValue().equals(this.getModel().getValue("exratecalmtd"))) {
            this.getModel().setValue("plsettledate", null);
        }
    }

    private void setPlCurrency(DynamicObject tradebill) {
        if (DeliveryWayEnum.non_deliverable.getValue().equals(tradebill.get("deliveryway"))) {
            this.getModel().setValue("plcurrency", tradebill.get("settlecurrency"));
        } else {
            this.getModel().setValue("plcurrency", tradebill.get("sellcurrency"));
        }
    }
}

