/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ExRateCalMethodEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class ForexFwdBeforeEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String srcEntityType = this.getSrcEntityType();
        if ("tm_forex_forward".equals(srcEntityType)) {
            this.initDefault_ForexFwd();
            this.initControl_ForexFwd();
        }
        if ("tm_forex_swaps".equals(srcEntityType)) {
            this.initDefault_ForexSwap();
            this.initControl_ForexSwap();
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject protectType = tradebill.getDynamicObject("protecttype");
        switch (propName) {
            case "bizamt1": {
                this.setAmt_PL();
                break;
            }
            case "expireddate": {
                this.setAdjDate(propName, "deliverydate");
                break;
            }
            case "expired_start": {
                this.setAdjDate(propName, "deydate_start");
                break;
            }
            case "expired_end": {
                this.setAdjDate(propName, "deydate_end");
                break;
            }
            case "deliverydate": {
                if (((Boolean)this.getModel().getValue("isdaterange")).booleanValue()) break;
                this.setBeforeExrateByDate();
                break;
            }
            case "deydate_end": {
                if (!((Boolean)this.getModel().getValue("isdaterange")).booleanValue()) break;
                this.setBeforeExrateByDate();
                break;
            }
            case "exratecalmtd": {
                this.setPlCurrency(tradebill);
                this.setExecExRateTitle();
                this.setBeforeExrateByDate();
                this.setExecExrateByDate();
                this.setPipsByExRate();
                if (!ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(this.getModel().getValue("exratecalmtd"))) break;
                this.setBaseexratePl();
                break;
            }
            case "pips": {
                this.pipsChangedEvt();
                this.spotRateChange();
                this.setAmt_PL();
                break;
            }
            case "spotrate_dey": 
            case "execexrate": {
                this.setPipsByExRate();
                this.setAmt_PL();
                break;
            }
            case "plamt": 
            case "baseexrate": {
                this.getModel().setValue("baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "bizrecordid": {
                this.clear();
                if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) {
                    this.setDefault_ForexSwap();
                    this.initControl_ForexSwap();
                }
                if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
                    this.setDefault_ForexFwd();
                    this.initControl_ForexFwd();
                }
                this.setExecExrateByDate();
                break;
            }
            case "bizdate": {
                if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
                    this.setControl_ExpiredDate_ForexFwd();
                    this.setControl_SettleDate_ForexFwd();
                    this.getModel().setValue("expireddate", null);
                    this.getModel().setValue("expired_start", null);
                    this.getModel().setValue("expired_end", null);
                    this.getModel().setValue("plsettledate", this.getModel().getValue("bizdate"));
                }
                if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) {
                    this.setControl_ExpiredDate_ForexSwap();
                    this.setControl_SettleDate_ForexSwap();
                    this.getModel().setValue("expireddate", null);
                    this.getModel().setValue("plsettledate", this.getModel().getValue("bizdate"));
                }
                this.setBeforeExrateByDate();
                this.setExecExrateByDate();
                break;
            }
            case "isdaterange": {
                if (!ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) break;
                this.setControl_ExpiredDate_ForexFwd();
                if (((Boolean)this.getModel().getValue("isdaterange")).booleanValue()) {
                    this.getModel().setValue("expireddate", null);
                    break;
                }
                this.getModel().setValue("expired_start", null);
                this.getModel().setValue("expired_end", null);
            }
        }
    }

    private void clear() {
        HashMap<String, BigDecimal> paramMap = new HashMap<String, BigDecimal>(8);
        paramMap.put("expireddate", null);
        paramMap.put("expired_start", null);
        paramMap.put("expired_end", null);
        paramMap.put("deliverydate", null);
        paramMap.put("deydate_start", null);
        paramMap.put("deydate_end", null);
        paramMap.put("plsettledate", null);
        paramMap.put("execexrate", BigDecimal.ZERO);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), paramMap);
    }

    private void setPlCurrency(DynamicObject tradebill) {
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(this.getModel().getValue("exratecalmtd"))) {
            if (DeliveryWayEnum.non_deliverable.getValue().equals(tradebill.get("deliveryway"))) {
                this.getModel().setValue("plcurrency", tradebill.get("settlecurrency"));
            } else {
                this.getModel().setValue("plcurrency", tradebill.get("sellcurrency"));
            }
        } else {
            this.getModel().setValue("plcurrency", null);
        }
    }

    private void initDefault_ForexSwap() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setDefault_ForexSwap();
        }
    }

    private void setDefault_ForexSwap() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exratecalmtd", (Object)ExRateCalMethodEnum.SrcMinusSwapPips);
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date curDate = TcDateUtils.getCurrentDate();
        Date date_src = (Date)this.getModel().getValue("date_src");
        if (this.isBetween(curDate, (Date)this.getModel().getValue("bizdate_src"), date_src, true)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", (Object)curDate);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", null);
        }
        this.getModel().setValue("spotrate_dey", this.getModel().getValue("exrate_src"));
        this.setAmt_PL();
        this.setBaseInfo_PL(tradebill);
    }

    private void setControl_ExpiredDate_ForexSwap() {
        Date opdate = (Date)this.getModel().getValue("bizdate");
        Date srcdate = (Date)this.getModel().getValue("date_src");
        DateEdit dateEdit = (DateEdit)this.getView().getControl("expireddate");
        dateEdit.setMinDate(opdate);
        dateEdit.setMaxDate(TcDateUtils.getLastDay((Date)srcdate, (int)1));
    }

    private void setControl_SettleDate_ForexSwap() {
        Date opdate = (Date)this.getModel().getValue("bizdate");
        Date srcdate = (Date)this.getModel().getValue("date_src");
        DateEdit settleDateEdit = (DateEdit)this.getView().getControl("plsettledate");
        settleDateEdit.setMinDate(opdate);
        settleDateEdit.setMaxDate(srcdate);
    }

    private void setControl_BizDate_ForexSwap() {
        DateEdit dateEdit = (DateEdit)this.getView().getControl("bizdate");
        Date bizdate = (Date)this.getModel().getValue("bizdate_src");
        Date srcdate = (Date)this.getModel().getValue("date_src");
        dateEdit.setMinDate(bizdate);
        dateEdit.setMaxDate(TcDateUtils.getLastDay((Date)srcdate, (int)1));
    }

    private void initControl_ForexSwap() {
        this.setControl_BizDate_ForexSwap();
        this.setControl_ExpiredDate_ForexSwap();
        this.setControl_SettleDate_ForexSwap();
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"isdaterange"});
        this.setExecExRateTitle();
        ComboEdit comboEdit = (ComboEdit)this.getControl("exratecalmtd");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString(ExRateCalMethodEnum.SrcMinusSwapPips.getName()), ExRateCalMethodEnum.SrcMinusSwapPips.getValue()));
        data.add(new ComboItem(new LocaleString(ExRateCalMethodEnum.RatePlusFwdPips.getName()), ExRateCalMethodEnum.RatePlusFwdPips.getValue()));
        comboEdit.setComboItems(data);
        this.initControl_PL();
    }

    private void initControl_ForexFwd() {
        this.setExecExRateTitle();
        this.setControl_BizDate_ForexFwd();
        this.setControl_ExpiredDate_ForexFwd();
        this.setControl_SettleDate_ForexFwd();
        ComboEdit comboEdit = (ComboEdit)this.getControl("exratecalmtd");
        ArrayList<ComboItem> data = new ArrayList<ComboItem>();
        data.add(new ComboItem(new LocaleString(ExRateCalMethodEnum.SrcMinusSwapPips.getName()), ExRateCalMethodEnum.SrcMinusSwapPips.getValue()));
        data.add(new ComboItem(new LocaleString(ExRateCalMethodEnum.RatePlusFwdPips.getName()), ExRateCalMethodEnum.RatePlusFwdPips.getValue()));
        comboEdit.setComboItems(data);
        this.initControl_PL();
    }

    private void setControl_BizDate_ForexFwd() {
        DateEdit bizdateEdit = (DateEdit)this.getView().getControl("bizdate");
        bizdateEdit.setMinDate((Date)this.getModel().getValue("bizdate_src"));
        bizdateEdit.setMaxDate(TcDateUtils.getLastDay((Date)this.getDeyDateSrc_ForexFwd(), (int)1));
    }

    private void setExecExRateTitle() {
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        DecimalEdit exrateEdit = (DecimalEdit)this.getView().getControl("execexrate");
        if (ExRateCalMethodEnum.SrcMinusSwapPips.getValue().equals(exrateCalMtd)) {
            exrateEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u53c2\u8003\u63d0\u524d\u6c47\u7387", (String)"ForexFwdBeforeEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"plsettledate"});
        }
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) {
            exrateEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5e73\u4ed3\u8fdc\u671f\u6c47\u7387", (String)"FlatFwdExrate", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"fp_pnl", "plsettledate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"fp_pnl"});
            this.getModel().setValue("plsettledate", null);
            this.getModel().setValue("plamt", null);
            this.getModel().setValue("baseplamt", null);
            this.getModel().setValue("baseexrate", null);
        }
    }

    private void initDefault_ForexFwd() {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.setDefault_ForexFwd();
        }
    }

    private void setDefault_ForexFwd() {
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"exratecalmtd", (Object)ExRateCalMethodEnum.SrcMinusSwapPips);
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date bizdate = (Date)this.getModel().getValue("bizdate_src");
        Date deydate = this.getDeyDateSrc_ForexFwd();
        Date curdate = TcDateUtils.getCurrentDate();
        if (this.isBetween(curdate, bizdate, deydate, true)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", (Object)curdate);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizdate", null);
        }
        this.getModel().setValue("spotrate_dey", this.getModel().getValue("exrate_src"));
        this.setAmt_PL();
        this.setBaseInfo_PL(tradebill);
    }

    private void setBeforeExrateByDate() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        String operate = (String)this.getModel().getValue("operate");
        this.getModel().setValue("spotrate_dey", (Object)BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)bizdate, (Date)this.getDeyDate_ForexFwd(), (boolean)BusinessBillHelper.isSwapFar((String)operate)));
    }

    private void setExecExrateByDate() {
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) {
            DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
            Date bizdate = (Date)this.getModel().getValue("bizdate");
            String operate = (String)this.getModel().getValue("operate");
            this.getModel().setValue("execexrate", (Object)BusinessBillHelper.getExRate((DynamicObject)tradebill, (Date)bizdate, (Date)this.getDeyDateSrc_ForexFwd(), (BusinessBillHelper.isSwapFar((String)operate) == false ? 1 : 0) != 0));
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"execexrate", (Object)BigDecimal.ZERO);
        }
    }

    private void setPipsByExRate() {
        BigDecimal beforeExrate;
        BigDecimal fwdExrate;
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        if (ExRateCalMethodEnum.SrcMinusSwapPips.getValue().equals(exrateCalMtd)) {
            fwdExrate = (BigDecimal)this.getModel().getValue("exrate_src");
            beforeExrate = (BigDecimal)this.getModel().getValue("spotrate_dey");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pips", (Object)fwdExrate.subtract(beforeExrate).multiply(Constants.TEN_THOUSAND));
        }
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) {
            fwdExrate = (BigDecimal)this.getModel().getValue("execexrate");
            beforeExrate = (BigDecimal)this.getModel().getValue("spotrate_dey");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"pips", (Object)fwdExrate.subtract(beforeExrate).multiply(Constants.TEN_THOUSAND));
        }
    }

    private void pipsChangedEvt() {
        BigDecimal pips;
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        if (ExRateCalMethodEnum.SrcMinusSwapPips.getValue().equals(exrateCalMtd)) {
            BigDecimal fwdExrate = (BigDecimal)this.getModel().getValue("exrate_src");
            pips = (BigDecimal)this.getModel().getValue("pips");
            BigDecimal beforeExrate = fwdExrate.subtract(pips.divide(Constants.TEN_THOUSAND, 10, 4));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"spotrate_dey", (Object)beforeExrate);
        }
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) {
            BigDecimal beforeExrate = (BigDecimal)this.getModel().getValue("spotrate_dey");
            pips = (BigDecimal)this.getModel().getValue("pips");
            BigDecimal execExrate = beforeExrate.add(pips.divide(Constants.TEN_THOUSAND, 10, 4));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"execexrate", (Object)execExrate);
        }
    }

    private void setAmt_PL() {
        String exrateCalMtd = (String)this.getModel().getValue("exratecalmtd");
        if (EmptyUtil.isEmpty((String)exrateCalMtd)) {
            this.getModel().setValue("plamt", null);
            return;
        }
        if (ExRateCalMethodEnum.RatePlusFwdPips.getValue().equals(exrateCalMtd)) {
            BigDecimal execExrate = (BigDecimal)this.getModel().getValue("execexrate");
            BigDecimal fwdExrate = (BigDecimal)this.getModel().getValue("exrate_src");
            BigDecimal plAmt = this.calAmt_PL(execExrate, fwdExrate);
            String operate = (String)this.getModel().getValue("operate");
            if (BusinessBillHelper.isSwapFar((String)operate).booleanValue()) {
                plAmt = plAmt.negate();
            }
            plAmt = this.dealPlAmt_PlCurrencyNotSrc(plAmt);
            this.getModel().setValue("plamt", (Object)plAmt);
        }
    }

    private void setAdjDate(String dateProp, String adjDateProp) {
        Date date = (Date)this.getModel().getValue(dateProp);
        if (EmptyUtil.isNoEmpty((Object)date)) {
            DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
            DynamicObjectCollection wc = tradeBill.getDynamicObjectCollection("workcalendar");
            String adjMethod = tradeBill.getString("dateadjustmethod");
            Date adjDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)date, (AdjustMethodEnum)AdjustMethodEnum.valueOf((String)adjMethod));
            this.getModel().setValue(adjDateProp, (Object)adjDate);
        } else {
            this.getModel().setValue(adjDateProp, null);
        }
    }

    private void setControl_SettleDate_ForexFwd() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        Date rightdate = this.getDeyDateSrc_ForexFwd();
        DateEdit edit = (DateEdit)this.getView().getControl("plsettledate");
        edit.setMinDate(bizdate);
        edit.setMaxDate(rightdate);
    }

    private void setControl_ExpiredDate_ForexFwd() {
        Date bizdate = (Date)this.getModel().getValue("bizdate");
        Date rightdate = this.getDeyDateSrc_ForexFwd();
        boolean isDateRange = (Boolean)this.getModel().getValue("isdaterange");
        if (isDateRange) {
            DateRangeEdit edit = (DateRangeEdit)this.getView().getControl("expiredrange");
            edit.setMinDate(bizdate);
            if (EmptyUtil.isNoEmpty((Object)rightdate)) {
                edit.setMaxDate(TcDateUtils.getLastDay((Date)rightdate, (int)1));
            }
        } else {
            DateEdit edit = (DateEdit)this.getView().getControl("expireddate");
            edit.setMinDate(bizdate);
            if (EmptyUtil.isNoEmpty((Object)rightdate)) {
                edit.setMaxDate(TcDateUtils.getLastDay((Date)rightdate, (int)1));
            }
        }
    }

    private void setBaseexratePl() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject priceRule = BusinessDataServiceHelper.loadSingle((Object)tradebill.getDynamicObject("pricerule").get("id"), (String)tradebill.getDynamicObject("pricerule").getDataEntityType().getName());
        Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
        String fxQuote = (String)this.getModel().getValue("basefq");
        if (EmptyUtil.isNoEmpty((String)fxQuote)) {
            ForexQuoteInfo fxInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)fxQuote, (Date)((Date)this.getModel().getValue("bizdate")), null);
            DynamicObject currencyPl = (DynamicObject)this.getModel().getValue("plcurrency");
            if (currencyPl != null) {
                if (fxInfo.getFxquote().startsWith(currencyPl.getString("number"))) {
                    this.getModel().setValue("baseexrate", (Object)fxInfo.getBuyPrice());
                } else {
                    this.getModel().setValue("baseexrate", (Object)fxInfo.getSellPrice());
                }
            }
        }
    }
}

