/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.DateEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class PayBizBillEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String srcEntityType = this.getSrcEntityType();
        if ("tm_structdeposit".equals(srcEntityType)) {
            this.structDeposit_load();
            this.getView().setEnable(Boolean.FALSE, new String[]{"plcurrency"});
        }
        if ("tm_deposit".equals(srcEntityType) && OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            DynamicObject[] cashflow_deposit;
            DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
            QFilter filter_cashflow = new QFilter("billid", "=", tradebill.getPkValue());
            for (DynamicObject payInfo : cashflow_deposit = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"cftype,cfpaydate,cfcurrency,cfpayamount,cfispay,entrys.cfisratecfg", (QFilter[])new QFilter[]{filter_cashflow})) {
                if (payInfo.getBoolean("cfispay")) continue;
                this.getModel().setValue("srcbillid", payInfo.getPkValue());
                this.getModel().deleteEntryData("cashflow");
                this.addCashFlow(payInfo);
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        ((CardEntry)this.getView().getControl("entrybiz")).selectCard(Integer.valueOf(0));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "settlecurrency": {
                String srcEntityType = this.geConvertSrcEntityType();
                if ("tm_structdeposit".equals(srcEntityType)) break;
                this.settleCurrencyChangeEvn();
                break;
            }
            case "fxquote_c": 
            case "spotrate_c": {
                this.calSettleAmt();
                break;
            }
            case "cfpayamount": {
                DynamicObjectCollection cashFLow = this.getModel().getEntryEntity("cashflow");
                BigDecimal settleAmt = Constants.ZERO;
                for (DynamicObject cash : cashFLow) {
                    settleAmt = settleAmt.add(cash.getBigDecimal("cfpayamount"));
                }
                this.getModel().setValue("settleamount", (Object)settleAmt);
                break;
            }
            case "bizamt_detail": {
                this.calcSettlementAmount();
                break;
            }
            case "plamt": 
            case "baseexrate": {
                this.calFloatPlLocalAmt();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "save": 
            case "submit": {
                if (!afterDoOperationEventArgs.getOperationResult().isSuccess()) break;
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void calSettleAmt() {
        DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
        String fxquote = (String)this.getModel().getValue("fxquote_c");
        BigDecimal spotRate = (BigDecimal)this.getModel().getValue("spotrate_c");
        BigDecimal payAmount = (BigDecimal)this.getModel().getValue("cfpayamount");
        if (EmptyUtil.isNoEmpty((DynamicObject)settleCurrency) && EmptyUtil.isNoEmpty((String)fxquote) && EmptyUtil.isNoEmpty((BigDecimal)spotRate)) {
            if (settleCurrency.getString("number").equals(fxquote.split("/")[0])) {
                this.getModel().setValue("settleamount", (Object)payAmount.divide(spotRate, 6), 4);
            } else {
                this.getModel().setValue("settleamount", (Object)payAmount.multiply(spotRate));
            }
        } else {
            this.getModel().setValue("settleamount", (Object)payAmount);
        }
    }

    private void settleCurrencyChangeEvn() {
        String srcEntityType = this.getSrcEntityType();
        DynamicObject tradeCurrency = (DynamicObject)this.getModel().getValue("buycurrency_init");
        DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
        if ("tm_forwrateagree".equals(srcEntityType) && !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{tradeCurrency, settleCurrency}) && !tradeCurrency.getPkValue().equals(settleCurrency.getPkValue())) {
            this.setFxquote(settleCurrency.getString("number"), tradeCurrency.getString("number"));
        } else {
            this.getModel().setValue("fxquote_c", null);
            this.getModel().setValue("spotrate_c", (Object)Constants.ZERO);
        }
    }

    private void setFxquote(String basecurrency, String termcurrency) {
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        DynamicObject tradeBill = (DynamicObject)this.getModel().getValue("tradebill");
        DynamicObject priceRule = tradeBill.getDynamicObject("pricerule");
        priceRule = TmcDataServiceHelper.loadSingle((Object)priceRule.getLong("id"), (String)"md_pricerule");
        DynamicObject forexquote = priceRule.getDynamicObject("forexquote");
        if (EmptyUtil.isEmpty((DynamicObject)priceRule) || EmptyUtil.isEmpty((DynamicObject)forexquote) || EmptyUtil.isEmpty((String)basecurrency) || EmptyUtil.isEmpty((String)termcurrency) || EmptyUtil.isEmpty((Object)bizDate)) {
            return;
        }
        ForexQuoteInfo forexQuote = new ForexQuoteInfo();
        forexQuote.setFxquote(basecurrency + "/" + termcurrency);
        ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.querySpotForexQuote((IFormView)this.getView(), (Long)forexquote.getLong("id"), (ForexQuoteInfo)forexQuote);
        if (EmptyUtil.isNoEmpty((Object)forexQuoteInfo)) {
            String fxquote = forexQuoteInfo.getFxquote();
            BigDecimal middleprice = forexQuoteInfo.getMiddleprice();
            this.getModel().setValue("fxquote_c", (Object)fxquote);
            this.getModel().setValue("spotrate_c", (Object)middleprice);
        } else {
            this.getModel().setValue("fxquote_c", null);
            this.getModel().setValue("spotrate_c", null);
        }
    }

    protected void addCashFlow(DynamicObject cashflow) {
        int index = this.getModel().createNewEntryRow("cashflow");
        this.getModel().setValue("cftype", cashflow.get("cftype"), index);
        this.getModel().setValue("cfpaydate", cashflow.get("cfpaydate"), index);
        this.getModel().setValue("cfcurrency", cashflow.get("cfcurrency"), index);
        this.getModel().setValue("cfpayamount", cashflow.get("cfpayamount"), index);
    }

    protected void structDeposit_load() {
        DynamicObject sourceTradeBill = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)this.getModel().getValue("tradebill")).getPkValue(), (String)"tm_structdeposit");
        DynamicObject rateCfgInfo = this.getRateCfgInfo(sourceTradeBill);
        DynamicObject[] cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"billno,cfpayamount,cfpaydate,cfratefixdate", (QFilter[])new QFilter[]{new QFilter("billid", "=", sourceTradeBill.getPkValue())});
        DynamicObject cashFlow2 = this.get(cashFlows, "2");
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)((DynamicObject)sourceTradeBill.get("org")).getPkValue()));
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        boolean isSameCurrency = sourceTradeBill.getDynamicObject("currency").getLong("id") == localCurrencyId.longValue();
        DynamicObject row2 = this.structDeposit_dealControls(sourceTradeBill, rateCfgInfo, isSameCurrency, cashFlow2);
        this.getModel().setValue("structtype", sourceTradeBill.get("structtype"));
        this.getModel().setValue("term", EmptyUtil.isEmpty((Object)rateCfgInfo.getDate("redeemday")) ? sourceTradeBill.get("term") : TcDateUtils.getDiffYMD((Date)sourceTradeBill.getDate("bizdate"), (Date)rateCfgInfo.getDate("redeemday")));
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.getModel().setValue("bizdate", cashFlow2.get("cfpaydate"));
            this.getModel().setValue("redeemday", (Object)rateCfgInfo.getDate("redeemday"));
            row2.set("bizamt_detail", cashFlow2.get("cfpayamount"));
            this.getModel().setValue("plsettledate", cashFlow2.get("cfpaydate"));
            this.getModel().setValue("settlecurrency", sourceTradeBill.get("currency"));
            this.calcSettlementAmount();
            this.getModel().setValue("plcurrency", sourceTradeBill.get("currency"));
            this.getModel().setValue("basecurrency", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)localCurrencyId, (String)"bd_currency"));
            if (!isSameCurrency) {
                this.setValue_rate_fxQuote(sourceTradeBill, (DynamicObject)this.getModel().getValue("basecurrency"));
                this.calFloatPlLocalAmt();
            }
            this.getModel().setValue("reccurrency", sourceTradeBill.get("currency"));
        } else {
            row2.set("bizamt_detail", this.getModel().getValue("restamt2"));
        }
        this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty((Object)this.getModel().getValue("redeemday"))), new String[]{"redeemday"});
        this.getModel().setDataChanged(false);
    }

    private DynamicObject structDeposit_dealControls(DynamicObject sourceTradeBill, DynamicObject rateCfgInfo, boolean isSameCurrency, DynamicObject cashFlow2) {
        ((DateEdit)this.getView().getControl("bizdate")).setMinDate(((DynamicObject)cashFlow2.getDynamicObjectCollection("entrys").get(0)).getDate("cfratefixdate"));
        ((DateEdit)this.getView().getControl("bizdate")).setMaxDate(sourceTradeBill.getDate("settledate"));
        this.getView().setVisible(Boolean.valueOf(!isSameCurrency), new String[]{"basefq", "baseexrate", "baseplamt"});
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"plsettledate", "plamt"});
        this.structDeposit_buildCard(sourceTradeBill, rateCfgInfo);
        DynamicObject row2 = this.structDeposit_buildEntry(sourceTradeBill);
        return row2;
    }

    private DynamicObject structDeposit_buildEntry(DynamicObject sourceTradeBill) {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entrydetail");
        DynamicObject row1 = entryEntity.addNew();
        DynamicObject row2 = entryEntity.addNew();
        row1.set("rateorprincipal", (Object)"principal");
        row1.set("currency_detail", sourceTradeBill.get("currency"));
        row1.set("bizamt_detail", sourceTradeBill.get("amount"));
        row2.set("rateorprincipal", (Object)"rate");
        row2.set("currency_detail", sourceTradeBill.get("currency"));
        return row2;
    }

    private void structDeposit_buildCard(DynamicObject sourceTradeBill, DynamicObject rateCfgInfo) {
        DynamicObjectCollection lifeCycleCards = this.getModel().getEntryEntity("entrybiz");
        DynamicObject lifeCycleCard = lifeCycleCards.addNew();
        lifeCycleCard.set("title_biz", (Object)ResManager.loadKDString((String)"\u539f\u5408\u7ea6", (String)"PayBizBillEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        lifeCycleCard.set("date_biz", sourceTradeBill.get("settledate"));
        lifeCycleCard.set("exrate_biz", rateCfgInfo.get("rate"));
        lifeCycleCard.set("restamt_biz", sourceTradeBill.get("amount"));
        lifeCycleCard.set("currency_biz", sourceTradeBill.get("currency"));
        ((CardEntry)this.getView().getControl("entrybiz")).selectCard(Integer.valueOf(0));
    }

    private void setValue_rate_fxQuote(DynamicObject sourceTradeBill, DynamicObject bd_currency) {
        DynamicObject priceRule = sourceTradeBill.getDynamicObject("pricerule");
        if (EmptyUtil.isEmpty((DynamicObject)priceRule)) {
            return;
        }
        DynamicObject forexQuote = priceRule.getDynamicObject("forexquote");
        if (EmptyUtil.isEmpty((DynamicObject)forexQuote)) {
            return;
        }
        DynamicObject currency_pl = (DynamicObject)this.getModel().getValue("plcurrency");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{currency_pl, bd_currency})) {
            String fxQuote = currency_pl.get("number") + "/" + bd_currency.get("number");
            Date bizDate = (Date)this.getModel().getValue("bizdate");
            ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)forexQuote.getLong("id"), (String)fxQuote, (Date)bizDate, null);
            BigDecimal exRate = currency_pl.getString("number").equals(fqInfo.getFxquote().split("/")[0]) ? fqInfo.getBuyPrice() : fqInfo.getSellPrice();
            this.getModel().setValue("baseexrate", (Object)exRate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"basefq", (Object)fqInfo.getFxquote());
        }
    }

    private void calFloatPlLocalAmt() {
        DynamicObject currency_pl = (DynamicObject)this.getModel().getValue("plcurrency");
        if (currency_pl == null) {
            return;
        }
        BigDecimal rate = (BigDecimal)this.getModel().getValue("baseexrate");
        BigDecimal plAmt = (BigDecimal)this.getModel().getValue("plamt");
        String fxQuote = (String)this.getModel().getValue("basefq");
        BigDecimal plLocalAmt = currency_pl.getString("number").equals(fxQuote.split("/")[0]) ? plAmt.multiply(rate) : (BigDecimal.ZERO.compareTo(rate) == 0 ? BigDecimal.ZERO : plAmt.divide(rate, 10, 4));
        this.getModel().setValue("baseplamt", (Object)plLocalAmt);
    }

    private DynamicObject getRateCfgInfo(DynamicObject sourceTradeBill) {
        QFilter rateCfgFilter = new QFilter("tradebill", "=", sourceTradeBill.getPkValue()).and(new QFilter("operate", "=", (Object)"ratecfg"));
        DynamicObject[] result = TmcDataServiceHelper.load((String)"tm_businessbill", (String)"plsettledate,redeemday,rate", (QFilter[])new QFilter[]{rateCfgFilter});
        return result[0];
    }

    private void calcSettlementAmount() {
        DynamicObject row1 = (DynamicObject)this.getModel().getEntryEntity("entrydetail").get(0);
        DynamicObject row2 = (DynamicObject)this.getModel().getEntryEntity("entrydetail").get(1);
        this.getModel().setValue("settleamount", (Object)row1.getBigDecimal("bizamt_detail").add(row2.getBigDecimal("bizamt_detail")));
        this.getModel().setValue("plamt", row2.get("bizamt_detail"));
        this.getModel().setValue("restamt2", row2.get("bizamt_detail"));
    }

    private DynamicObject get(DynamicObject[] cashFlows, String billNo) {
        for (DynamicObject cashFlow : cashFlows) {
            if (!billNo.equals(cashFlow.get("billno"))) continue;
            return cashFlow;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u7f16\u53f7\u4e3a%s\u7684\u73b0\u91d1\u6d41\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"PayBizBillEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[]{billNo}));
    }
}

