/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.field.DateEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.bean.tc.FreqPeriodListBean;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.PayFrequeEnum;
import kd.tmc.fbp.common.helper.MarketDataHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.CashFlowTypeEnum;
import kd.tmc.tm.common.enums.ConfigPayTypeEnum;
import kd.tmc.tm.common.enums.RateSwapsPayTypeEnum;
import kd.tmc.tm.common.enums.RateTypeEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.PlHelper;
import kd.tmc.tm.common.helper.RateSwapHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class PaySwapBizBillEdit
extends BizBillEdit {
    private static final Log logger = LogFactory.getLog(PaySwapBizBillEdit.class);
    private static final String TRADEBILL_RATESWAP_PROPS = "org,pricerule,rateswaptype,startdate,adjustedenddate,currency,amount,refindex,ratemargin,payworkcalendar,basis,ratetype,market,payfrequency,paytype,valuedate,firstpaycopdate,penupaycopdate,stub,stubtype,dateadjustmethod,enddate,paydatetype,discount,reccurrency,recamount,recrefindex,recratemargin,recworkcalendar,recbasis,recratetype,recmarket,protecttype,recpayfrequency,recpaytype,recvaluedate,recfirstpaycopdate,recpenupaycopdate,recstub,recstubtype,recdateadjustmethod,recpaydatetype, recdiscount";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String srcEntityType = this.getSrcEntityType();
        if ("tm_rateswap".equals(srcEntityType)) {
            DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
            tradebill = TmcDataServiceHelper.loadSingle((String)"tm_rateswap", (String)TRADEBILL_RATESWAP_PROPS, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getLong("id"))});
            this.initBizEntry_RateSwap(tradebill);
            String op = (String)this.getModel().getValue("operate");
            if (BizOperateEnum.interestpay.getValue().equals(op)) {
                this.initInterestPay_RateSwap(tradebill);
                this.setControlVisible_InterestPay(tradebill);
                if (SwapTypeEnum.rate.getValue().equals(tradebill.getString("rateswaptype"))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"plcurrency"});
                }
            }
            if (BizOperateEnum.capitalpay.getValue().equals(op)) {
                this.initCapitalPay_RateSwap(tradebill);
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"period_pay", "period_rec", "totalrate_pay", "totalrate_rec", "settleamount"});
                this.getView().setEnable(Boolean.valueOf(false), 0, new String[]{"bizamt_detail"});
                this.getView().setEnable(Boolean.valueOf(false), 1, new String[]{"bizamt_detail"});
            }
            this.setControlBizDate_Swap(tradebill);
            this.initControl_PL();
        }
        this.getModel().setDataChanged(false);
    }

    private void setControlBizDate_Swap(DynamicObject tradebill) {
        DateEdit edit = (DateEdit)this.getView().getControl("bizdate");
        edit.setMinDate(tradebill.getDate("startdate"));
        edit.setMaxDate(tradebill.getDate("adjustedenddate"));
    }

    private void initInterestPay_RateSwap(DynamicObject tradebill) {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            Date curDate = TcDateUtils.getCurrentDate();
            if (curDate.before(tradebill.getDate("startdate")) || curDate.after(tradebill.getDate("adjustedenddate"))) {
                this.getModel().setValue("bizdate", null);
            } else {
                this.getModel().setValue("bizdate", (Object)curDate);
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plcurrency", (Object)tradebill.get("reccurrency"));
            Map data = RateSwapHelper.getCashFlowToInterestPay((Long)tradebill.getLong("id"));
            this.createEntryDetail(data, true, tradebill);
            boolean isRate = SwapTypeEnum.rate.getValue().equals(tradebill.getString("rateswaptype"));
            if (isRate && !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{data.get("buy"), data.get("sell")})) {
                BigDecimal buyAmt = ((DynamicObject)data.get("buy")).getBigDecimal("cfamount");
                BigDecimal sellAmt = ((DynamicObject)data.get("sell")).getBigDecimal("cfamount");
                this.getModel().setValue("settleamount", (Object)sellAmt.abs().subtract(buyAmt.abs()));
            }
            this.initPlInfo();
            this.setBaseInfo_PL(tradebill);
        } else {
            this.loadEntryDetail();
        }
    }

    private void initCapitalPay_RateSwap(DynamicObject tradebill) {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            Date curDate = TcDateUtils.getCurrentDate();
            if (curDate.before(tradebill.getDate("startdate")) || curDate.after(tradebill.getDate("adjustedenddate"))) {
                this.getModel().setValue("bizdate", null);
            } else {
                this.getModel().setValue("bizdate", (Object)curDate);
            }
            Map data = RateSwapHelper.getCashFlowToCapitalPay((Long)tradebill.getLong("id"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"plcurrency", (Object)tradebill.get("reccurrency"));
            this.createEntryDetail(data, false, tradebill);
            this.initPlInfo();
            this.setBaseInfo_PL(tradebill);
        } else {
            this.loadEntryDetail();
        }
    }

    private void createEntryDetail(Map<String, Object> data, boolean isInterestPay, DynamicObject tradebill) {
        Date adjEndate;
        Date adjStartdate;
        BigDecimal baseBasis;
        PayFrequeEnum freq;
        FreqPeriodListBean freqPeriodList;
        DynamicObjectCollection resetRows;
        BigDecimal useRate;
        boolean isFloat;
        int period;
        DynamicObject cashflow;
        int rowIndex;
        this.getModel().deleteEntryData("entrydetail");
        if (EmptyUtil.isNoEmpty((Object)data.get("buy"))) {
            rowIndex = this.getModel().createNewEntryRow("entrydetail");
            cashflow = (DynamicObject)data.get("buy");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"cashflow_pay", (Object)cashflow.getLong("id"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"direct_detail", (Object)"pay", (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currency_detail", (Object)cashflow.get("cfcurrency"), (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizamt_detail", (Object)cashflow.getBigDecimal("cfamount").abs(), (int)rowIndex);
            if (isInterestPay) {
                period = 0;
                isFloat = CashFlowTypeEnum.floatrate.getValue().equals(cashflow.getString("cftype"));
                useRate = BigDecimal.ONE;
                resetRows = cashflow.getDynamicObjectCollection("entrys");
                if (resetRows.size() == 1) {
                    useRate = ((DynamicObject)resetRows.get(0)).getBigDecimal("cfuserate");
                    period = ((DynamicObject)resetRows.get(0)).getInt("cfperioddays");
                } else {
                    freqPeriodList = RateSwapHelper.createFreqPeriodList((DynamicObject)tradebill, (boolean)true);
                    freq = freqPeriodList != null ? freqPeriodList.getFreqEnum() : null;
                    for (DynamicObject resetRow : resetRows) {
                        period += resetRow.getInt("cfperioddays");
                        if (isFloat) {
                            baseBasis = TradeBusinessHelper.getBaseBasis((Date)((Date)resetRow.get("cfadjstartdate")), (Date)((Date)resetRow.get("cfadjenddate")), (BasisEnum)BasisEnum.getEnum((String)tradebill.getString("basis")), (DynamicObject[])((DynamicObject[])tradebill.getDynamicObjectCollection("payworkcalendar").toArray((Object[])new DynamicObject[0])), null, (PayFrequeEnum)freq, (FreqPeriodListBean)freqPeriodList);
                            useRate = useRate.multiply(BigDecimal.ONE.add(resetRow.getBigDecimal("cfuserate").divide(Constants.ONE_HUNDRED, 10, 4).multiply(baseBasis)));
                            logger.info("buycasflow resetrow \u5f00\u59cb\u65e5\u671f{}\uff0c\u7ed3\u675f\u65e5\u671f{}, \u8ba1\u606f\u57fa\u51c6\u503c:{}", new Object[]{(Date)resetRow.get("cfadjstartdate"), (Date)resetRow.get("cfadjenddate"), baseBasis});
                            continue;
                        }
                        useRate = resetRow.getBigDecimal("cfuserate");
                    }
                    if (isFloat) {
                        if (freqPeriodList != null) {
                            adjStartdate = (Date)((DynamicObject)resetRows.get(0)).get("cfadjstartdate");
                            adjEndate = (Date)((DynamicObject)resetRows.get(resetRows.size() - 1)).get("cfadjenddate");
                            baseBasis = TradeBusinessHelper.getBaseBasis((Date)adjStartdate, (Date)adjEndate, (BasisEnum)BasisEnum.getEnum((String)tradebill.getString("basis")), (DynamicObject[])((DynamicObject[])tradebill.getDynamicObjectCollection("payworkcalendar").toArray((Object[])new DynamicObject[0])), null, (PayFrequeEnum)freq, (FreqPeriodListBean)freqPeriodList);
                            logger.info("buycasflow \u5f00\u59cb\u65e5\u671f{}\uff0c\u7ed3\u675f\u65e5\u671f{}, \u8ba1\u606f\u57fa\u51c6\u503c:{}", new Object[]{adjStartdate, adjEndate, baseBasis});
                            useRate = useRate.subtract(BigDecimal.ONE);
                            useRate = useRate.multiply(BigDecimal.ONE.divide(baseBasis, 10, 4));
                        } else {
                            useRate = useRate.subtract(BigDecimal.ONE);
                            int days = TradeBusinessHelper.getBasis_YearDay((int)0, (BasisEnum)BasisEnum.getEnum((String)tradebill.getString("basis")));
                            useRate = useRate.multiply(new BigDecimal(days)).divide(new BigDecimal(period), 10, 4);
                        }
                        useRate = useRate.multiply(Constants.ONE_HUNDRED);
                    }
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"period_pay", (Object)period);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"totalrate_pay", (Object)useRate);
            }
            this.getModel().setValue("bizamt1", (Object)cashflow.getBigDecimal("cfamount").abs());
            this.getModel().setValue("plsettledate", cashflow.get("cfpaydate"));
            this.getModel().setValue("settlecurrency", cashflow.get("cfcurrency"));
        }
        if (EmptyUtil.isNoEmpty((Object)data.get("sell"))) {
            rowIndex = this.getModel().createNewEntryRow("entrydetail");
            cashflow = (DynamicObject)data.get("sell");
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"cashflow_rec", (Object)cashflow.getLong("id"));
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"direct_detail", (Object)"rec", (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"currency_detail", (Object)cashflow.get("cfcurrency"), (int)rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"bizamt_detail", (Object)cashflow.getBigDecimal("cfamount").abs(), (int)rowIndex);
            if (isInterestPay) {
                period = 0;
                isFloat = CashFlowTypeEnum.floatrate.getValue().equals(cashflow.getString("cftype"));
                useRate = BigDecimal.ONE;
                resetRows = cashflow.getDynamicObjectCollection("entrys");
                if (resetRows.size() == 1) {
                    useRate = ((DynamicObject)resetRows.get(0)).getBigDecimal("cfuserate");
                    period = ((DynamicObject)resetRows.get(0)).getInt("cfperioddays");
                } else {
                    freqPeriodList = RateSwapHelper.createFreqPeriodList((DynamicObject)tradebill, (boolean)false);
                    freq = freqPeriodList != null ? freqPeriodList.getFreqEnum() : null;
                    for (DynamicObject resetRow : resetRows) {
                        period += resetRow.getInt("cfperioddays");
                        if (isFloat) {
                            baseBasis = TradeBusinessHelper.getBaseBasis((Date)((Date)resetRow.get("cfadjstartdate")), (Date)((Date)resetRow.get("cfadjenddate")), (BasisEnum)BasisEnum.getEnum((String)tradebill.getString("recbasis")), (DynamicObject[])((DynamicObject[])tradebill.getDynamicObjectCollection("recworkcalendar").toArray((Object[])new DynamicObject[0])), null, (PayFrequeEnum)freq, (FreqPeriodListBean)freqPeriodList);
                            useRate = useRate.multiply(BigDecimal.ONE.add(resetRow.getBigDecimal("cfuserate").divide(Constants.ONE_HUNDRED, 10, 4).multiply(baseBasis)));
                            logger.info("sellcashflow resetrow \u5f00\u59cb\u65e5\u671f{}\uff0c\u7ed3\u675f\u65e5\u671f{}, \u8ba1\u606f\u57fa\u51c6\u503c:{}", new Object[]{(Date)resetRow.get("cfadjstartdate"), (Date)resetRow.get("cfadjenddate"), baseBasis});
                            continue;
                        }
                        useRate = resetRow.getBigDecimal("cfuserate");
                    }
                    if (isFloat) {
                        if (freqPeriodList != null) {
                            adjStartdate = (Date)((DynamicObject)resetRows.get(0)).get("cfadjstartdate");
                            adjEndate = (Date)((DynamicObject)resetRows.get(resetRows.size() - 1)).get("cfadjenddate");
                            baseBasis = TradeBusinessHelper.getBaseBasis((Date)adjStartdate, (Date)adjEndate, (BasisEnum)BasisEnum.getEnum((String)tradebill.getString("recbasis")), (DynamicObject[])((DynamicObject[])tradebill.getDynamicObjectCollection("recworkcalendar").toArray((Object[])new DynamicObject[0])), null, (PayFrequeEnum)freq, (FreqPeriodListBean)freqPeriodList);
                            useRate = useRate.subtract(BigDecimal.ONE);
                            logger.info("sellcasflow \u5f00\u59cb\u65e5\u671f{}\uff0c\u7ed3\u675f\u65e5\u671f{}, \u8ba1\u606f\u57fa\u51c6\u503c:{}", new Object[]{adjStartdate, adjEndate, baseBasis});
                            useRate = useRate.multiply(BigDecimal.ONE.divide(baseBasis, 10, 4));
                        } else {
                            useRate = useRate.subtract(BigDecimal.ONE);
                            int days = TradeBusinessHelper.getBasis_YearDay((int)0, (BasisEnum)BasisEnum.getEnum((String)tradebill.getString("recbasis")));
                            useRate = useRate.multiply(new BigDecimal(days)).divide(new BigDecimal(period), 10, 4);
                        }
                        useRate = useRate.multiply(Constants.ONE_HUNDRED);
                    }
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"period_rec", (Object)period);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"totalrate_rec", (Object)useRate);
            }
            this.getModel().setValue("bizamt2", (Object)cashflow.getBigDecimal("cfamount").abs());
            this.getModel().setValue("plsettledate", cashflow.get("cfpaydate"));
            this.getModel().setValue("settlecurrency", cashflow.get("cfcurrency"));
        }
    }

    private void setControlVisible_InterestPay(DynamicObject tradebill) {
        boolean isPay = EmptyUtil.isNoEmpty((Object)this.getModel().getValue("cashflow_pay"));
        boolean isRec = EmptyUtil.isNoEmpty((Object)this.getModel().getValue("cashflow_rec"));
        this.getView().setVisible(Boolean.valueOf(isPay), new String[]{"totalrate_pay", "period_pay"});
        this.getView().setVisible(Boolean.valueOf(isRec), new String[]{"totalrate_rec", "period_rec"});
        boolean isRate = SwapTypeEnum.rate.getValue().equals(tradebill.getString("rateswaptype"));
        this.getView().setVisible(Boolean.valueOf(!isRate), new String[]{"execexrate", "fxquotetype"});
        this.getView().setVisible(Boolean.valueOf(isRate && isPay && isRec), new String[]{"settleamount"});
        boolean isPayFixRate = RateTypeEnum.rate_fixed.getValue().equals(tradebill.getString("ratetype"));
        boolean isRecFixRate = RateTypeEnum.rate_fixed.getValue().equals(tradebill.getString("recratetype"));
        this.getView().setEnable(Boolean.valueOf(!isPayFixRate), new String[]{"totalrate_pay"});
        this.getView().setEnable(Boolean.valueOf(!isRecFixRate), new String[]{"totalrate_rec"});
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"settleamount"});
        DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
        if (EmptyUtil.isEmpty((DynamicObject)plCurrency)) {
            return;
        }
        if (isPay && !isRec && plCurrency.getLong("id") == tradebill.getDynamicObject("currency").getLong("id") || !isPay && isRec && plCurrency.getLong("id") == tradebill.getDynamicObject("reccurrency").getLong("id")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"execexrate", "fxquotetype"});
        }
    }

    private void loadEntryDetail() {
        int rowIndex;
        DynamicObject cashflow;
        this.getModel().beginInit();
        Long cashflow_pay = (Long)this.getModel().getValue("cashflow_pay");
        Long cashflow_rec = (Long)this.getModel().getValue("cashflow_rec");
        this.getModel().deleteEntryData("entrydetail");
        if (EmptyUtil.isNoEmpty((Long)cashflow_pay)) {
            cashflow = TmcDataServiceHelper.loadSingle((Object)cashflow_pay, (String)"tm_cashflow");
            rowIndex = this.getModel().createNewEntryRow("entrydetail");
            this.getModel().setValue("direct_detail", (Object)"pay", rowIndex);
            this.getModel().setValue("currency_detail", cashflow.get("cfcurrency"), rowIndex);
            this.getModel().setValue("bizamt_detail", this.getModel().getValue("bizamt1"), rowIndex);
        }
        if (EmptyUtil.isNoEmpty((Long)cashflow_rec)) {
            cashflow = TmcDataServiceHelper.loadSingle((Object)cashflow_rec, (String)"tm_cashflow");
            rowIndex = this.getModel().createNewEntryRow("entrydetail");
            this.getModel().setValue("direct_detail", (Object)"rec", rowIndex);
            this.getModel().setValue("currency_detail", cashflow.get("cfcurrency"), rowIndex);
            this.getModel().setValue("bizamt_detail", this.getModel().getValue("bizamt2"), rowIndex);
        }
        this.getModel().endInit();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CardEntry grid = (CardEntry)this.getView().getControl("entrybiz");
        grid.selectCard(Integer.valueOf(0));
    }

    private void initPlInfo() {
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        String swapType = tradebill.getString("rateswaptype");
        Long cashflow_pay = (Long)this.getModel().getValue("cashflow_pay");
        Long cashflow_rec = (Long)this.getModel().getValue("cashflow_rec");
        if (SwapTypeEnum.rate.getValue().equals(swapType)) {
            this.getModel().setValue("plamt", (Object)PlHelper.calPlAmt_Rate_RateSwapForBusinessBill((DynamicObject)this.getModel().getDataEntity()));
        }
        if (SwapTypeEnum.currency.getValue().equals(swapType)) {
            boolean isPay = EmptyUtil.isNoEmpty((Long)cashflow_pay);
            boolean isRec = EmptyUtil.isNoEmpty((Long)cashflow_rec);
            DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
            if (EmptyUtil.isEmpty((DynamicObject)plCurrency)) {
                return;
            }
            if (!(isPay && !isRec && plCurrency.getLong("id") == tradebill.getDynamicObject("currency").getLong("id") || !isPay && isRec && plCurrency.getLong("id") != tradebill.getDynamicObject("currency").getLong("id"))) {
                tradebill = TmcDataServiceHelper.loadSingle((Object)tradebill.getPkValue(), (String)"tm_rateswap");
                DynamicObject temp = QueryServiceHelper.queryOne((String)"md_pricerule", (String)"forexquote.id,forexquote.issuetime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getDynamicObject("pricerule").getLong("id"))});
                Long fqId = temp.getLong("forexquote.id");
                DynamicObject payCurrency = tradebill.getDynamicObject("currency");
                DynamicObject recCurrency = tradebill.getDynamicObject("reccurrency");
                String pair = payCurrency.getString("number") + "/" + recCurrency.getString("number");
                Date bizdate = (Date)this.getModel().getValue("bizdate");
                ForexQuoteInfo fqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, null);
                String fxquote = fqInfo.getFxquote();
                BigDecimal rate = plCurrency.getString("number").equals(fxquote.split("/")[0]) ? fqInfo.getSellPrice() : fqInfo.getBuyPrice();
                this.getModel().setValue("fxquotetype", (Object)fxquote);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"execexrate", (Object)rate);
            }
            this.getModel().setValue("plamt", (Object)PlHelper.calPlAmt_Currency_RateSwapForBusinessBill((DynamicObject)this.getModel().getDataEntity()));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        String op = (String)this.getModel().getValue("operate");
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        String rateType = tradebill.getString("rateswaptype");
        switch (propName) {
            case "bizamt_detail": {
                int rowIndex = args.getChangeSet()[0].getRowIndex();
                String type = (String)this.getModel().getValue("direct_detail", rowIndex);
                if ("pay".equals(type)) {
                    this.getModel().setValue("bizamt1", this.getModel().getValue(propName, rowIndex));
                }
                if (!"rec".equals(type)) break;
                this.getModel().setValue("bizamt2", this.getModel().getValue(propName, rowIndex));
                break;
            }
            case "bizamt1": 
            case "bizamt2": {
                if (SwapTypeEnum.rate.getValue().equals(rateType)) {
                    DynamicObjectCollection entrys = this.getModel().getEntryEntity("entrydetail");
                    if (entrys.size() == 2) {
                        BigDecimal amt1 = (BigDecimal)this.getModel().getValue("bizamt1");
                        BigDecimal amt2 = (BigDecimal)this.getModel().getValue("bizamt2");
                        this.getModel().setValue("settleamount", (Object)amt2.abs().subtract(amt1.abs()));
                    }
                    this.getModel().setValue("plamt", (Object)PlHelper.calPlAmt_Rate_RateSwapForBusinessBill((DynamicObject)this.getModel().getDataEntity()));
                }
                if (!SwapTypeEnum.currency.getValue().equals(rateType)) break;
                this.getModel().setValue("plamt", (Object)PlHelper.calPlAmt_Currency_RateSwapForBusinessBill((DynamicObject)this.getModel().getDataEntity()));
                break;
            }
            case "settleamount": {
                if (!SwapTypeEnum.rate.getValue().equals(rateType)) break;
                this.getModel().setValue("plamt", this.getModel().getValue("settleamount"));
                break;
            }
            case "execexrate": {
                if (!SwapTypeEnum.currency.getValue().equals(rateType)) break;
                this.getModel().setValue("plamt", (Object)PlHelper.calPlAmt_Currency_RateSwapForBusinessBill((DynamicObject)this.getModel().getDataEntity()));
                break;
            }
            case "plamt": 
            case "baseexrate": {
                this.getModel().setValue("baseplamt", (Object)this.calBaseAmt_PL());
                break;
            }
            case "totalrate_pay": {
                if (!BizOperateEnum.interestpay.getValue().equals(op)) break;
                this.setAmtByTotalRate(true);
                break;
            }
            case "totalrate_rec": {
                if (!BizOperateEnum.interestpay.getValue().equals(op)) break;
                this.setAmtByTotalRate(false);
                break;
            }
            case "plsettledate": 
            case "bizdate": {
                if (BizOperateEnum.interestpay.getValue().equals(op)) {
                    this.setAmtByTotalRate(true);
                    this.setAmtByTotalRate(false);
                }
                this.initPlInfo();
                if (this.getModel().getValue("basecurrency") == null) break;
                this.setBaseInfo_PL(tradebill);
                break;
            }
            case "plcurrency": {
                this.initControl_PL();
                if (BizOperateEnum.interestpay.getValue().equals(op)) {
                    boolean isPay = EmptyUtil.isNoEmpty((Object)this.getModel().getValue("cashflow_pay"));
                    boolean isRec = EmptyUtil.isNoEmpty((Object)this.getModel().getValue("cashflow_rec"));
                    DynamicObject plCurrency = (DynamicObject)this.getModel().getValue("plcurrency");
                    if (isPay && !isRec && plCurrency != null && plCurrency.getLong("id") == tradebill.getDynamicObject("currency").getLong("id") || !isPay && isRec && plCurrency != null && plCurrency.getLong("id") == tradebill.getDynamicObject("reccurrency").getLong("id")) {
                        this.getView().setVisible(Boolean.FALSE, new String[]{"execexrate", "fxquotetype"});
                    } else {
                        this.getView().setVisible(Boolean.TRUE, new String[]{"execexrate", "fxquotetype"});
                    }
                }
                this.initPlInfo();
                if (this.getModel().getValue("basecurrency") == null) break;
                this.setBaseInfo_PL(tradebill);
            }
        }
    }

    private void setAmtByTotalRate(boolean isPay) {
        boolean isDiscount;
        Long cashflowId = (Long)(isPay ? this.getModel().getValue("cashflow_pay") : this.getModel().getValue("cashflow_rec"));
        if (EmptyUtil.isEmpty((Long)cashflowId)) {
            return;
        }
        DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
        tradebill = TmcDataServiceHelper.loadSingle((String)"tm_rateswap", (String)TRADEBILL_RATESWAP_PROPS, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getLong("id"))});
        BigDecimal amount = isPay ? tradebill.getBigDecimal("amount") : tradebill.getBigDecimal("recamount");
        BigDecimal totalRate = isPay ? (BigDecimal)this.getModel().getValue("totalrate_pay") : (BigDecimal)this.getModel().getValue("totalrate_rec");
        int period = isPay ? ((Integer)this.getModel().getValue("period_pay")).intValue() : ((Integer)this.getModel().getValue("period_rec")).intValue();
        String basis = isPay ? tradebill.getString("basis") : tradebill.getString("recbasis");
        BigDecimal amt = BigDecimal.ZERO;
        String paydateType = isPay ? tradebill.getString("paydatetype") : tradebill.getString("recpaydatetype");
        boolean bl = isDiscount = isPay ? tradebill.getBoolean("discount") : tradebill.getBoolean("recdiscount");
        if (ConfigPayTypeEnum.forward.getValue().equals(paydateType) && isDiscount) {
            Date settledate;
            Date referdate = (Date)this.getModel().getValue("bizdate");
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{referdate, settledate = (Date)this.getModel().getValue("plsettledate")})) {
                amt = BigDecimal.ZERO;
            } else {
                DynamicObject cashFlow = TmcDataServiceHelper.loadSingle((Object)cashflowId, (String)"tm_cashflow");
                Date paydate = cashFlow.getDate("cfpaydate");
                DynamicObject market = isPay ? tradebill.getDynamicObject("market") : tradebill.getDynamicObject("recmarket");
                BigDecimal df = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)referdate, (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)paydate).get(paydate);
                BigDecimal df_last = (BigDecimal)MarketDataHelper.getDiscfactor(null, (Date)referdate, (DynamicObject)tradebill.getDynamicObject("pricerule"), (Long)market.getLong("id"), (Date)settledate).get(settledate);
                amt = amt.multiply(df.divide(df_last, 10, 4));
            }
        } else {
            String payType = tradebill.getString(isPay ? "paytype" : "recpaytype");
            boolean isPayStage = RateSwapsPayTypeEnum.pay_stages.getValue().equals(payType);
            BasisEnum basisEnum = BasisEnum.getEnum((String)basis);
            if (isPayStage && BasisEnum.ICMA_Actual_actual == basisEnum) {
                BigDecimal baseBasis = this.getBasisICMA(isPay, cashflowId, tradebill, basisEnum);
                amt = amount.multiply(totalRate).divide(Constants.ONE_HUNDRED).multiply(baseBasis);
            } else {
                int days = TradeBusinessHelper.getBasis_YearDay((int)0, (BasisEnum)basisEnum);
                amt = amount.multiply(totalRate).divide(Constants.ONE_HUNDRED).multiply(new BigDecimal(period)).divide(new BigDecimal(days), 10, 4);
            }
        }
        String flag = isPay ? "pay" : "rec";
        DynamicObjectCollection detail = this.getModel().getEntryEntity("entrydetail");
        if (((DynamicObject)detail.get(0)).getString("direct_detail").equals(flag)) {
            this.getModel().setValue("bizamt_detail", (Object)amt, 0);
        } else {
            this.getModel().setValue("bizamt_detail", (Object)amt, 1);
        }
    }

    private BigDecimal getBasisICMA(boolean isPay, Long cashflowId, DynamicObject tradebill, BasisEnum basisEnum) {
        String cacheKey = "basis" + cashflowId;
        String basisCache = this.getPageCache().get(cacheKey);
        BigDecimal baseBasis = BigDecimal.ZERO;
        if (EmptyUtil.isNoEmpty((String)basisCache)) {
            baseBasis = new BigDecimal(basisCache);
            logger.info("getBasisICMA \u4ece\u7f13\u5b58\u83b7\u53d6, \u8ba1\u606f\u57fa\u51c6\u503c:{}", (Object)baseBasis);
        } else {
            FreqPeriodListBean freqPeriodList = RateSwapHelper.createFreqPeriodList((DynamicObject)tradebill, (boolean)isPay);
            if (freqPeriodList != null) {
                String cashflowProps = "id, entrys.cfadjstartdate, entrys.cfadjenddate";
                QFilter cashflowQF = new QFilter("id", "=", (Object)cashflowId);
                DataSet cfDS = QueryServiceHelper.queryDataSet((String)"alogokey-query-cashflow-with-id", (String)"tm_cashflow", (String)cashflowProps, (QFilter[])cashflowQF.toArray(), null);
                if ((cfDS = cfDS.groupBy(new String[]{"id"}).min("entrys.cfadjstartdate").max("entrys.cfadjenddate").finish()).hasNext()) {
                    Row cf = cfDS.next();
                    Date adjStartDate = cf.getDate("entrys.cfadjstartdate");
                    Date adjEndDate = cf.getDate("entrys.cfadjenddate");
                    cfDS.close();
                    baseBasis = TradeBusinessHelper.getBaseBasis((Date)adjStartDate, (Date)adjEndDate, (BasisEnum)basisEnum, (DynamicObject[])((DynamicObject[])tradebill.getDynamicObjectCollection(isPay ? "payworkcalendar" : "recworkcalendar").toArray((Object[])new DynamicObject[0])), null, (PayFrequeEnum)freqPeriodList.getFreqEnum(), (FreqPeriodListBean)freqPeriodList);
                    logger.info("getBasisICMA \u5f00\u59cb\u65e5\u671f{}\uff0c\u7ed3\u675f\u65e5\u671f{}, \u8ba1\u606f\u57fa\u51c6\u503c:{}", new Object[]{adjStartDate, adjEndDate, baseBasis});
                    this.getPageCache().put(cacheKey, baseBasis.toPlainString());
                }
            }
        }
        return baseBasis;
    }
}

