/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.HookTypeEnum;
import kd.tmc.tm.common.helper.StructDepositHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class RateCfgBizBillEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        String srcEntityType = this.getSrcEntityType();
        if ("tm_structdeposit".equals(srcEntityType)) {
            this.init_structDeposit();
        }
    }

    public void afterBindData(EventObject e) {
        String srcEntityType = this.getSrcEntityType();
        if ("tm_structdeposit".equals(srcEntityType)) {
            ((CardEntry)this.getView().getControl("entrybiz")).selectCard(Integer.valueOf(0));
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName = args.getProperty().getName();
        String srcEntityType = this.getSrcEntityType();
        switch (propName) {
            case "markprice": 
            case "days": {
                if (!"tm_structdeposit".equals(srcEntityType)) break;
                DynamicObject sourceTradeBill = this.getSourceTradeBill();
                this.calcRate(sourceTradeBill);
                break;
            }
            case "breakbarrier": {
                if (!"tm_structdeposit".equals(srcEntityType)) break;
                DynamicObject sourceTradeBill = this.getSourceTradeBill();
                this.setRedeemDay(sourceTradeBill);
                this.setControl_redeemDay_structDeposit(sourceTradeBill);
                if (((Boolean)this.getModel().getValue("breakbarrier")).booleanValue()) break;
                this.getModel().setValue("redeemday", null);
                break;
            }
            case "bizdate": {
                Date opDate = (Date)this.getModel().getValue("bizdate");
                if (!"tm_structdeposit".equals(srcEntityType) || opDate == null) break;
                DynamicObject sourceTradeBill = this.getSourceTradeBill();
                this.setMinAndMaxDate("redeemday", opDate, sourceTradeBill.getDate("settledate"));
                this.getModel().setValue("markprice", (Object)StructDepositHelper.getMarketMarkPrice((Object)sourceTradeBill, (boolean)false, (boolean)false, (Date)opDate));
            }
        }
    }

    private void init_structDeposit() {
        DynamicObject sourceTradeBill = this.getSourceTradeBill();
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            this.initValue_structDeposit(sourceTradeBill);
        }
        this.initValueFromTradeBill_structDeposit(sourceTradeBill);
        this.initControl_structDeposit(sourceTradeBill);
        this.getModel().setDataChanged(false);
    }

    private void initValueFromTradeBill_structDeposit(DynamicObject sourceTradeBill) {
        this.getModel().setValue("structtype", sourceTradeBill.get("structtype"));
        this.getModel().setValue("daytype", sourceTradeBill.get("daytype"));
        this.getModel().setValue("hookmark", sourceTradeBill.get("hookmark"));
        this.getModel().setValue("markpricetype", sourceTradeBill.get("markprice"));
        this.getModel().setValue("marktime", sourceTradeBill.get("marktime"));
        this.getModel().setValue("markzone", sourceTradeBill.get("markzone"));
    }

    private void initControl_structDeposit(DynamicObject sourceTradeBill) {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"markprice", "rate"});
        if (HookTypeEnum.referrate.getValue().equals(sourceTradeBill.get("hooktype"))) {
            ((FieldEdit)this.getView().getControl("markprice")).setCaption(new LocaleString(ResManager.loadKDString((String)"\u6807\u7684\u4ef7\u683c\uff08%\uff09", (String)"RateCfgBizBillEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
        }
        boolean isShowBreakBarrier = false;
        if ("break".equals(sourceTradeBill.get("structtype"))) {
            for (DynamicObject zoneRow : (DynamicObjectCollection)sourceTradeBill.get("zone")) {
                if (!zoneRow.getBoolean("obstacle")) continue;
                isShowBreakBarrier = true;
                break;
            }
        }
        this.getView().setVisible(Boolean.valueOf(isShowBreakBarrier), new String[]{"breakbarrier"});
        DateEdit bizDate = (DateEdit)this.getView().getControl("bizdate");
        bizDate.setMinDate(sourceTradeBill.getDate("firstobsdate"));
        if (sourceTradeBill.getDate("lastobsdate") != null) {
            bizDate.setMaxDate(sourceTradeBill.getDate("lastobsdate"));
        } else {
            bizDate.setMaxDate(sourceTradeBill.getDate("settledate"));
        }
        DynamicObjectCollection lifeCycleCards = this.getModel().getEntryEntity("entrybiz");
        DynamicObject lifeCycleCard = lifeCycleCards.addNew();
        lifeCycleCard.set("title_biz", (Object)ResManager.loadKDString((String)"\u539f\u5408\u7ea6", (String)"RateCfgBizBillEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        lifeCycleCard.set("date_biz", sourceTradeBill.get("settledate"));
        lifeCycleCard.set("currency_biz", sourceTradeBill.get("currency"));
        lifeCycleCard.set("restamt_biz", sourceTradeBill.get("amount"));
        this.setControl_redeemDay_structDeposit(sourceTradeBill);
    }

    private void setControl_redeemDay_structDeposit(DynamicObject sourceTradeBill) {
        Date opDate = (Date)this.getModel().getValue("bizdate");
        if ("auto_redeem".equals(sourceTradeBill.get("redeemtype")) && ((Boolean)this.getModel().getValue("breakbarrier")).booleanValue() && opDate != null) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"redeemday"});
            this.setMinAndMaxDate("redeemday", opDate, sourceTradeBill.getDate("settledate"));
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"redeemday"});
        }
    }

    private void initValue_structDeposit(DynamicObject sourceTradeBill) {
        this.setOpDate(sourceTradeBill);
        this.getModel().setValue("markprice", (Object)StructDepositHelper.getMarketMarkPrice((Object)sourceTradeBill, (boolean)false, (boolean)false, null));
        this.getModel().setValue("days", sourceTradeBill.get("predictmark"));
        this.calcRate(sourceTradeBill);
        if (sourceTradeBill.getDate("firstbreakdate") != null) {
            this.getModel().setValue("breakbarrier", (Object)Boolean.TRUE);
        }
        this.setRedeemDay(sourceTradeBill);
    }

    private void calcRate(DynamicObject sourceTradeBill) {
        BigDecimal rate = BigDecimal.ZERO;
        if ("break".equals(sourceTradeBill.get("structtype"))) {
            BigDecimal markPrice = (BigDecimal)this.getModel().getValue("markprice");
            for (DynamicObject zoneRow : (DynamicObjectCollection)sourceTradeBill.get("zone")) {
                BigDecimal priceY;
                BigDecimal priceX = zoneRow.getBigDecimal("pricex");
                DynamicObject bwSymbol = zoneRow.getDynamicObject("bwsymbol");
                String bwSymbol_number = bwSymbol.getString("number");
                if (priceX == null) {
                    priceX = BigDecimal.ZERO;
                }
                if ((priceY = zoneRow.getBigDecimal("pricey")) == null || BigDecimal.ZERO.compareTo(priceY) == 0) {
                    priceY = Constants.MAX_AMOUNT;
                }
                if (!("(x, y)".equals(bwSymbol_number) && markPrice.compareTo(priceX) > 0 && markPrice.compareTo(priceY) < 0 || "(x, y]".equals(bwSymbol_number) && markPrice.compareTo(priceX) > 0 && markPrice.compareTo(priceY) <= 0 || "[x, y)".equals(bwSymbol_number) && markPrice.compareTo(priceX) >= 0 && markPrice.compareTo(priceY) < 0) && (!"[x, y]".equals(bwSymbol_number) || markPrice.compareTo(priceX) < 0 || markPrice.compareTo(priceY) > 0)) continue;
                rate = zoneRow.getBigDecimal("rate");
                break;
            }
        } else {
            DynamicObjectCollection zone = (DynamicObjectCollection)sourceTradeBill.get("zone");
            BigDecimal M = new BigDecimal((Integer)this.getModel().getValue("days"));
            BigDecimal D = this.getD(sourceTradeBill);
            BigDecimal rate1 = ((DynamicObject)zone.get(0)).getBigDecimal("rate");
            BigDecimal rate2 = ((DynamicObject)zone.get(1)).getBigDecimal("rate");
            rate = rate2.multiply(M).divide(D, 18, 4).add(rate1.multiply(BigDecimal.ONE.subtract(M.divide(D, 18, 0)))).setScale(10, 4);
        }
        this.getModel().setValue("rate", (Object)rate);
    }

    private BigDecimal getD(DynamicObject sourceTradeBill) {
        Date intDate = sourceTradeBill.getDate("intdate");
        Date settleDate = sourceTradeBill.getDate("settledate");
        BigDecimal D = "work".equals(sourceTradeBill.get("daytype")) ? new BigDecimal(TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)sourceTradeBill.getDynamicObjectCollection("workcalendar"), (Date)intDate, (Date)settleDate)) : new BigDecimal(TcDateUtils.getDiffDays((Date)intDate, (Date)settleDate));
        return D;
    }

    private void setRedeemDay(DynamicObject sourceTradeBill) {
        Date opDate = (Date)this.getModel().getValue("bizdate");
        if ("auto_redeem".equals(sourceTradeBill.get("redeemtype")) && ((Boolean)this.getModel().getValue("breakbarrier")).booleanValue() && opDate != null) {
            int settleDelay = sourceTradeBill.getInt("settledelay");
            this.getModel().setValue("redeemday", (Object)TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)sourceTradeBill.getDynamicObjectCollection("workcalendar"), (Date)opDate, (int)settleDelay));
        }
    }

    private void setMinAndMaxDate(String key, Date minDate, Date maxDate) {
        DateEdit calcDate = (DateEdit)this.getView().getControl(key);
        calcDate.setMinDate(minDate);
        calcDate.setMaxDate(maxDate);
    }

    private void setOpDate(DynamicObject sourceTradeBill) {
        QFilter filterCashFlow = new QFilter("billid", "=", sourceTradeBill.getPkValue());
        DynamicObject[] cashFlows = TmcDataServiceHelper.load((String)"tm_cashflow", (String)"entrys.cfratefixdate", (QFilter[])new QFilter[]{filterCashFlow});
        Date date = cashFlows != null && cashFlows.length > 1 && cashFlows[1].get("entrys") != null && ((DynamicObjectCollection)cashFlows[1].get("entrys")).size() > 0 ? ((DynamicObject)((DynamicObjectCollection)cashFlows[1].get("entrys")).get(0)).getDate("cfratefixdate") : sourceTradeBill.getDate("firstbreakdate");
        if (date != null) {
            this.getModel().setValue("bizdate", (Object)date);
        } else {
            this.getModel().setValue("bizdate", (Object)new Date());
        }
    }

    private DynamicObject getSourceTradeBill() {
        return BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)this.getModel().getValue("tradebill")).getPkValue(), (String)"tm_structdeposit");
    }
}

