/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.business;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.QuotaFrequency;
import kd.tmc.tm.common.helper.RateSwapHelper;
import kd.tmc.tm.formplugin.business.BizBillEdit;

public class RateCfgSwapBizBillEdit
extends BizBillEdit {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String srcEntityType = this.getSrcEntityType();
        if ("tm_rateswap".equals(srcEntityType)) {
            DynamicObject tradebill = (DynamicObject)this.getModel().getValue("tradebill");
            tradebill = TmcDataServiceHelper.loadSingle((String)"tm_rateswap", (String)"adjustedenddate,currency,amount,refindex,ratemargin,rateresettype,ratequotafreq,reccurrency,recamount,recrefindex,recratemargin,recrateresettype,recratequotafreq", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getLong("id"))});
            this.initBizEntry_RateSwap(tradebill);
            if (OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                DynamicObject cashflow_rec;
                Map data = RateSwapHelper.getCashFlowToRateCfg((Long)tradebill.getLong("id"));
                DynamicObject cashflow_pay = (DynamicObject)data.get("buy");
                if (EmptyUtil.isNoEmpty((DynamicObject)cashflow_pay)) {
                    Date rateFixDate = cashflow_pay.getDate("cfratefixdate");
                    this.getModel().setValue("bizdate", (Object)rateFixDate);
                    this.getModel().setValue("plsettledate", (Object)rateFixDate);
                    this.getModel().setValue("cashflow_pay", (Object)cashflow_pay.getLong("id"));
                    this.getModel().setValue("ratefixdate_pay", (Object)rateFixDate);
                    this.getModel().setValue("referrate_pay", tradebill.get("refindex"));
                    this.getModel().setValue("ratemargin_pay", tradebill.get("ratemargin"));
                    if (QuotaFrequency.Day.getValue().equals(tradebill.getString("ratequotafreq"))) {
                        this.getModel().setValue("referratedate_pay", (Object)rateFixDate);
                    }
                }
                if (EmptyUtil.isNoEmpty((DynamicObject)(cashflow_rec = (DynamicObject)data.get("sell")))) {
                    Date rateFixDate = cashflow_rec.getDate("cfratefixdate");
                    this.getModel().setValue("bizdate", (Object)rateFixDate);
                    this.getModel().setValue("plsettledate", (Object)rateFixDate);
                    this.getModel().setValue("cashflow_rec", (Object)cashflow_rec.getLong("id"));
                    this.getModel().setValue("ratefixdate_rec", (Object)rateFixDate);
                    this.getModel().setValue("referrate_rec", tradebill.get("recrefindex"));
                    this.getModel().setValue("ratemargin_rec", tradebill.get("recratemargin"));
                    if (QuotaFrequency.Day.getValue().equals(tradebill.getString("recratequotafreq"))) {
                        this.getModel().setValue("referratedate_rec", (Object)rateFixDate);
                    }
                }
            }
            this.getModel().setDataChanged(false);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        CardEntry grid = (CardEntry)this.getView().getControl("entrybiz");
        grid.selectCard(Integer.valueOf(0));
        this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty((Object)this.getModel().getValue("cashflow_pay"))), new String[]{"rateswappay"});
        this.getView().setVisible(Boolean.valueOf(EmptyUtil.isNoEmpty((Object)this.getModel().getValue("cashflow_rec"))), new String[]{"rateswaprec"});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "bizdate": {
                this.getModel().setValue("ratefixdate_pay", this.getModel().getValue(propName));
                this.getModel().setValue("ratefixdate_rec", this.getModel().getValue(propName));
                break;
            }
            case "fixedrate_pay": 
            case "ratemargin_pay": {
                BigDecimal rateMarginPay = (BigDecimal)this.getModel().getValue("ratemargin_pay");
                BigDecimal fixedRatePay = (BigDecimal)this.getModel().getValue("fixedrate_pay");
                this.getModel().setValue("totalrate_pay", (Object)rateMarginPay.add(fixedRatePay));
                break;
            }
            case "fixedrate_rec": 
            case "ratemargin_rec": {
                BigDecimal rateMarginRec = (BigDecimal)this.getModel().getValue("ratemargin_rec");
                BigDecimal fixedRateRec = (BigDecimal)this.getModel().getValue("fixedrate_rec");
                this.getModel().setValue("totalrate_rec", (Object)rateMarginRec.add(fixedRateRec));
                break;
            }
            case "referratedate_pay": {
                DynamicObject refRatePay = (DynamicObject)this.getModel().getValue("referrate_pay");
                Date refRateDatePay = (Date)this.getModel().getValue("referratedate_pay");
                BigDecimal valuePay = MarketDataServiceHelper.referRate((String)refRatePay.getString("number"), (Date)refRateDatePay, (boolean)true);
                this.getModel().setValue("referratevalue_pay", (Object)valuePay);
                break;
            }
            case "referratedate_rec": {
                DynamicObject refRateRec = (DynamicObject)this.getModel().getValue("referrate_rec");
                Date refRateDateRec = (Date)this.getModel().getValue("referratedate_rec");
                BigDecimal valueRec = MarketDataServiceHelper.referRate((String)refRateRec.getString("number"), (Date)refRateDateRec, (boolean)true);
                this.getModel().setValue("referratevalue_rec", (Object)valueRec);
                break;
            }
            case "referratevalue_pay": {
                this.getModel().setValue("fixedrate_pay", this.getModel().getValue(propName));
                break;
            }
            case "referratevalue_rec": {
                this.getModel().setValue("fixedrate_rec", this.getModel().getValue(propName));
            }
        }
    }
}

