/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.cashflow.forex;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.builder.ICashFlowBuilder;
import kd.tmc.tm.business.service.builder.forex.ForexSellCashFlowBuilder;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.formplugin.cashflow.AbstractCashFlowPlugin;
import kd.tmc.tm.formplugin.cashflow.forex.ForexBuyCashFlowPlugin;

public class ForexSellCashFlowPlugin
extends AbstractCashFlowPlugin
implements ItemClickListener {
    @Override
    protected String getCashFlowTable() {
        return "sellcashflow";
    }

    @Override
    protected String getCashFlowTabName() {
        return "tabcashflow";
    }

    @Override
    protected ICashFlowBuilder getCashFlowBuilder() {
        return new ForexSellCashFlowBuilder();
    }

    @Override
    protected String getExtendPropName() {
        return "_s";
    }

    @Override
    protected QFilter getFilter() {
        return new QFilter("cfdirection", "=", (Object)TradeDirectionEnum.sell.getValue());
    }

    @Override
    protected boolean isCreateCashFlow() {
        boolean isGenerate = true;
        if (this.getModel().getProperty("settlecurrency") != null) {
            DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
            DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("currency");
            String deliverWay = (String)this.getModel().getValue("deliveryway");
            isGenerate = !DeliveryWayEnum.isNonDeliverable((String)deliverWay) || !EmptyUtil.isNoEmpty((DynamicObject)settleCurrency) || !EmptyUtil.isNoEmpty((DynamicObject)buyCurrency) || settleCurrency.getLong("id") != buyCurrency.getLong("id");
        }
        return isGenerate;
    }

    @Override
    protected List<String> getPropToBuildCashFlow() {
        String entityName;
        ArrayList<String> props = new ArrayList<String>();
        props.add("fxquote");
        props.add("amount");
        props.add("sellamount");
        props.add("deliveryway");
        props.add("spotrate");
        String deliverWay = (String)this.getModel().getValue("deliveryway");
        if (DeliveryWayEnum.isNonDeliverable((String)deliverWay)) {
            props.add("settlecurrency");
        }
        if ("tm_forex_forward".equals(entityName = this.getModel().getDataEntityType().getName())) {
            boolean isDateRange = (Boolean)this.getModel().getValue("isdaterange");
            if (isDateRange) {
                props.add("adjsettledate_end");
            } else {
                props.add("adjustsettledate");
            }
        }
        if ("tm_forex".equals(entityName)) {
            props.add("settledate");
        }
        return props;
    }

    @Override
    protected List<String> allCashFlowPlugin() {
        ArrayList<String> allCashFlowPlugin = new ArrayList<String>();
        allCashFlowPlugin.add(ForexSellCashFlowPlugin.class.getName());
        allCashFlowPlugin.add(ForexBuyCashFlowPlugin.class.getName());
        return allCashFlowPlugin;
    }
}

