/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.cashflow.rate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.builder.ICashFlowBuilder;
import kd.tmc.tm.business.service.builder.rate.ForwRateAgreeCashFlowBuiler;
import kd.tmc.tm.formplugin.cashflow.AbstractCashFlowPlugin;

public class ForwRateAgreeCashFlowPlugin
extends AbstractCashFlowPlugin {
    @Override
    protected String getCashFlowTable() {
        return "cashflow";
    }

    @Override
    protected String getCashFlowTabName() {
        return "tabcashflow";
    }

    @Override
    protected ICashFlowBuilder getCashFlowBuilder() {
        return new ForwRateAgreeCashFlowBuiler();
    }

    @Override
    protected String getExtendPropName() {
        return "";
    }

    @Override
    protected List<String> getPropToBuildCashFlow() {
        ArrayList<String> propList = new ArrayList<String>(10);
        propList.add("amount");
        propList.add("referindex");
        propList.add("pricerule");
        propList.add("adjustsettledate");
        propList.add("adjustenddate");
        propList.add("market");
        propList.add("contractrate");
        propList.add("basis");
        propList.add("payrule");
        return propList;
    }

    @Override
    protected boolean isCreateCashFlow() {
        return this.getModel().getDataEntity().getBigDecimal("amount").compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"calculate", (CharSequence)formOperate.getOperateKey()) && args.getOperationResult() != null && args.getOperationResult().isSuccess()) {
            this.bizCallCashFlowFresh();
            DynamicObjectCollection cashFlowList = this.getModel().getEntryEntity(this.getCashFlowTable());
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)cashFlowList)) {
                this.getModel().setValue("fraprice", ((DynamicObject)cashFlowList.get(1)).get("cfuserate"));
                this.getModel().setValue("pv", ((DynamicObject)cashFlowList.get(0)).get("cfpv"));
            }
        }
    }

    @Override
    protected List<String> allCashFlowPlugin() {
        return null;
    }
}

