/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.cashflow.structdeposit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.events.ItemClickListener;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.business.service.builder.ICashFlowBuilder;
import kd.tmc.tm.business.service.builder.structdeposit.StructDepositCashFlowBuilder;
import kd.tmc.tm.common.resource.TeBizResource;
import kd.tmc.tm.formplugin.cashflow.AbstractCashFlowPlugin;

public class StructDepositCashFlowPlugin
extends AbstractCashFlowPlugin
implements ItemClickListener {
    protected boolean isSaveCashFlowTable() {
        return true;
    }

    @Override
    protected String getCashFlowTable() {
        return "cashflow";
    }

    @Override
    protected String getCashFlowTabName() {
        return "tabcashflow";
    }

    @Override
    protected ICashFlowBuilder getCashFlowBuilder() {
        return new StructDepositCashFlowBuilder();
    }

    @Override
    protected List<String> getPropToBuildCashFlow() {
        ArrayList<String> props = new ArrayList<String>();
        props.add("currency");
        props.add("bizdate");
        props.add("intdate");
        props.add("settledate");
        props.add("adjustsettledate");
        props.add("market");
        props.add("pricerule");
        props.add("structtype");
        props.add("dateadjustmethod");
        props.add("basis");
        props.add("hookmark");
        props.add("obstacle");
        props.add("markprice");
        props.add("firstobsdate");
        return props;
    }

    protected List<String> propJustChangeEffect() {
        ArrayList<String> propList = new ArrayList<String>();
        propList.add("lastobsdate");
        propList.add("daytype");
        return propList;
    }

    @Override
    protected boolean isCreateCashFlow() {
        boolean isCreateCashFlow = true;
        StringBuilder propTip = new StringBuilder();
        DynamicObjectCollection colls = this.getModel().getEntryEntity("zone");
        for (DynamicObject zone : colls) {
            String propName;
            if (EmptyUtil.isEmpty((DynamicObject)zone.getDynamicObject("bwsymbol"))) {
                propName = this.getModel().getProperty("bwsymbol").getDisplayName().getLocaleValue();
                propTip.append(propName).append(" ; ");
            }
            if (EmptyUtil.isEmpty((BigDecimal)zone.getBigDecimal("rate"))) {
                propName = this.getModel().getProperty("rate").getDisplayName().getLocaleValue();
                propTip.append(propName).append(" ; ");
            }
            if (zone.getInt("seq") == colls.size() || !EmptyUtil.isEmpty((BigDecimal)zone.getBigDecimal("pricey"))) continue;
            propName = this.getModel().getProperty("pricey").getDisplayName().getLocaleValue();
            propTip.append(propName).append(" ; ");
        }
        if (propTip.length() > 0) {
            isCreateCashFlow = false;
            this.getView().showTipNotification(TeBizResource.propToBuildCashflowIsNull((String)propTip.toString().substring(0, propTip.toString().length() - 2)));
        }
        return isCreateCashFlow;
    }

    @Override
    protected List<String> allCashFlowPlugin() {
        ArrayList<String> allCashFlowPlugin = new ArrayList<String>();
        allCashFlowPlugin.add(StructDepositCashFlowPlugin.class.getName());
        return allCashFlowPlugin;
    }
}

