/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.exception.KDBizException;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.SettleTagEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.ForexOptionsHelper;
import org.apache.commons.lang.StringUtils;

public class BizBill2PayBillConvertPlugin
extends AbstractConvertPlugIn {
    private List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("id");
        sic.add("billno");
        sic.add("settleamount");
        sic.add("settlecurrency");
        sic.add("operate");
        sic.add("cashflow");
        sic.add("tradebill");
        sic.add("isrollsettle");
        sic.add("cfpayamount");
        sic.add("bizamt1");
        sic.add("bizamt2");
        sic.add("deliverydate");
        sic.add("plcurrency");
        sic.add("plamt");
        sic.add("plsettledate");
        sic.add("protecttype");
        sic.add("paycurrency");
        sic.add("cashflow_pay");
        sic.add("cashflow_rec");
        return sic;
    }

    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        super.beforeBuildRowCondition(e);
        if (!EmptyUtil.isNoEmpty((Object)this.getOption()) || !this.getOption().containsVariable("call_by_settle")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u80fd\u901a\u8fc7\u7ed3\u7b97\u751f\u6210\u4ed8\u6b3e\u5355\u3002", (String)"BizBill2PayBillConvertPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String descEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity)) {
            DynamicObject payBill = dataEntity.getDataEntity();
            List srcRows = (List)dataEntity.getValue("ConvertSource");
            Object srcId = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject bizBill = TmcDataServiceHelper.loadSingle((Object)srcId, (String)this.getSrcMainType().getName(), (String)StringUtils.join(this.getSelector(), (String)","));
            this.setSource(payBill, bizBill);
            this.dealPayData(payBill, bizBill);
            if (!EmptyUtil.isEmpty((Object)payBill.get("settletag"))) continue;
            payBill.set("settletag", (Object)SettleTagEnum.NON_PL.getValue());
        }
    }

    protected void setSource(DynamicObject payBill, DynamicObject bizBill) {
        payBill.set("sourcetype", (Object)"TM");
        payBill.set("sourcebillid", bizBill.getPkValue());
        payBill.set("sourcebilltype", (Object)"tm_businessbill");
    }

    private void dealPayData(DynamicObject payBill, DynamicObject bizBill) {
        BigDecimal amount = Constants.ZERO;
        DynamicObject productType = bizBill.getDynamicObject("protecttype");
        String entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
        String operate = bizBill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case bdelivery: 
            case bdelivery_n: 
            case bdelivery_f: {
                if (!"tm_forex_forward".equals(entityType) && !"tm_forex_swaps".equals(entityType)) break;
                if (this.getOption().containsVariable("onemorebill")) {
                    this.fillPayInfoWithPl(bizBill, payBill);
                    break;
                }
                this.fillPayInfoWithDey(bizBill, payBill);
                break;
            }
            case expiredey: 
            case expiredey_f: 
            case expiredey_n: {
                if ("tm_forex".equals(entityType) || "tm_forex_swaps".equals(entityType)) {
                    this.fillPayInfoWithDey(bizBill, payBill);
                }
                if (!"tm_forex_forward".equals(entityType)) break;
                DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
                String deliveryWay = tradeBill.getString("deliveryway");
                if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                    this.fillPayInfoWithDey(bizBill, payBill);
                }
                if (!DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) break;
                this.fillPayInfoWithPl(bizBill, payBill);
                break;
            }
            case flat_n: 
            case flat_f: {
                if (!"tm_forex_swaps".equals(entityType)) break;
                this.fillPayInfoWithPl(bizBill, payBill);
                break;
            }
            case exercise: {
                if ("tm_forex_options".equals(entityType)) {
                    DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
                    String deliveryWay = tradeBill.getString("deliveryway");
                    if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                        this.fillPayInfoWithDeyOption(bizBill, payBill);
                    } else {
                        this.fillPayInfoWithSettle(bizBill, payBill, bizBill.getDate("deliverydate"));
                    }
                }
                if (!"tm_ratebound".equals(entityType)) break;
                amount = this.getPayAmountBySettle(bizBill);
                this.addEntry(amount, bizBill, payBill);
                break;
            }
            case flat: {
                this.dealFlat(entityType, bizBill, payBill);
                break;
            }
            case defer: 
            case maudate: 
            case defer_n: 
            case defer_f: 
            case maudate_n: 
            case maudate_f: {
                if (!"tm_forex_forward".equals(entityType) && !"tm_forex_swaps".equals(entityType)) break;
                this.fillPayInfoWithPl(bizBill, payBill);
                break;
            }
            case pay: {
                this.dealPay(entityType, bizBill, payBill);
                break;
            }
            case interestpay: {
                if ("tm_rateswap".equals(entityType)) {
                    Long cashflow_rec;
                    Long cashflow_pay = bizBill.getLong("cashflow_pay");
                    if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{cashflow_pay, cashflow_rec = Long.valueOf(bizBill.getLong("cashflow_rec"))})) {
                        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
                        String rateswapType = tradeBill.getString("rateswaptype");
                        if (SwapTypeEnum.rate.getValue().equals(rateswapType)) {
                            amount = bizBill.getBigDecimal("settleamount").abs();
                        }
                        if (SwapTypeEnum.currency.getValue().equals(rateswapType)) {
                            amount = bizBill.getBigDecimal("bizamt1");
                        }
                    } else {
                        amount = bizBill.getBigDecimal("bizamt1");
                    }
                    DynamicObject currency = bizBill.getDynamicObject("paycurrency");
                    if (currency != null) {
                        amount = amount.setScale(currency.getInt("amtprecision"), 4);
                    }
                    this.setValue(payBill, currency, bizBill.getDate("plsettledate"), amount);
                    this.addEntry(amount, bizBill, payBill);
                }
                if (!"tm_forwrateagree".equals(entityType)) break;
                payBill.set("expectdate", bizBill.get("plsettledate"));
                this.dealPay(entityType, bizBill, payBill);
                break;
            }
            case capitalpay: {
                if (!"tm_rateswap".equals(entityType)) break;
                amount = bizBill.getBigDecimal("bizamt1");
                DynamicObject currency = bizBill.getDynamicObject("paycurrency");
                if (currency != null) {
                    amount = amount.setScale(currency.getInt("amtprecision"), 4);
                }
                this.setValue(payBill, currency, bizBill.getDate("plsettledate"), amount);
                this.addEntry(amount, bizBill, payBill);
                break;
            }
        }
    }

    protected void addEntry(BigDecimal amount, DynamicObject bizBill, DynamicObject payBill) {
        DynamicObjectCollection entrys = payBill.getDynamicObjectCollection("entry");
        if (entrys.size() <= 0) {
            entrys.addNew();
        }
        DynamicObject entry = (DynamicObject)entrys.get(0);
        entry.set("contractnumber", bizBill.get("billno"));
        entry.set("e_payableamt", (Object)amount);
        entry.set("e_actamt", (Object)amount);
    }

    protected void setValue(DynamicObject payBill, DynamicObject currency, Date expectdate, BigDecimal amount) {
        payBill.set("expectdate", (Object)expectdate);
        payBill.set("currency", (Object)currency);
        payBill.set("actpayamt", (Object)amount);
    }

    protected void dealPay(String entityType, DynamicObject bizBill, DynamicObject payBill) {
        BigDecimal amount = BigDecimal.ZERO;
        if ("tm_loan".equals(entityType)) {
            boolean isRollSettle = bizBill.getBoolean("isrollsettle");
            amount = isRollSettle ? this.getPayAmountBySettle(bizBill) : this.getPayAmount(bizBill);
        }
        if ("tm_deposit".equals(entityType)) {
            amount = this.getPayAmount(bizBill);
        }
        if ("tm_forwrateagree".equals(entityType)) {
            amount = this.getPayAmountBySettle(bizBill);
            DynamicObject currency = bizBill.getDynamicObject("settlecurrency");
            payBill.set("currency", (Object)currency);
        }
        this.addEntry(amount, bizBill, payBill);
    }

    protected void dealFlat(String entityType, DynamicObject bizBill, DynamicObject payBill) {
        if ("tm_forex_options".equals(entityType)) {
            this.fillPayInfoWithSettle(bizBill, payBill, bizBill.getDate("plsettledate"));
        }
        if ("tm_ratebound".equals(entityType)) {
            BigDecimal amount = this.getPayAmountBySettle(bizBill);
            this.addEntry(amount, bizBill, payBill);
        }
        if ("tm_forex".equals(entityType) || "tm_forex_forward".equals(entityType)) {
            this.fillPayInfoWithPl(bizBill, payBill);
        }
    }

    protected void fillPayInfoWithDey(DynamicObject bizBill, DynamicObject payBill) {
        BigDecimal amount;
        DynamicObject currency;
        Date expectdate = bizBill.getDate("deliverydate");
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        String dir = tradeBill.getString("tradedirect");
        if (TradeDirectionEnum.buy.getValue().equals(dir)) {
            currency = tradeBill.getDynamicObject("sellcurrency");
            amount = bizBill.getBigDecimal("bizamt2");
        } else {
            currency = tradeBill.getDynamicObject("currency");
            amount = bizBill.getBigDecimal("bizamt1");
        }
        String op = bizBill.getString("operate");
        if (op.indexOf("_f") > 0) {
            if (TradeDirectionEnum.buy.getValue().equals(dir)) {
                currency = tradeBill.getDynamicObject("currency");
                amount = bizBill.getBigDecimal("bizamt1");
            } else {
                currency = tradeBill.getDynamicObject("sellcurrency");
                amount = bizBill.getBigDecimal("bizamt2");
            }
        }
        amount = amount.abs();
        amount = amount.setScale(currency.getInt("amtprecision"), 4);
        this.setValue(payBill, currency, expectdate, amount);
        this.addEntry(amount, bizBill, payBill);
    }

    protected void fillPayInfoWithDeyOption(DynamicObject bizBill, DynamicObject payBill) {
        BigDecimal amount;
        DynamicObject currency;
        String tradeType;
        Date expectdate = bizBill.getDate("deliverydate");
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        String dir = tradeBill.getString("tradedirect");
        if (ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)(tradeType = tradeBill.getString("tradetype")))) {
            currency = tradeBill.getDynamicObject("sellcurrency");
            amount = bizBill.getBigDecimal("bizamt2");
        } else {
            currency = tradeBill.getDynamicObject("currency");
            amount = bizBill.getBigDecimal("bizamt1");
        }
        amount = amount.abs();
        amount = amount.setScale(currency.getInt("amtprecision"), 4);
        this.setValue(payBill, currency, expectdate, amount);
        this.addEntry(amount, bizBill, payBill);
    }

    protected void fillPayInfoWithPl(DynamicObject bizBill, DynamicObject payBill) {
        BigDecimal amount = bizBill.getBigDecimal("plamt");
        amount = amount.abs();
        DynamicObject currency = bizBill.getDynamicObject("plcurrency");
        amount = amount.setScale(currency.getInt("amtprecision"), 4);
        this.setValue(payBill, currency, bizBill.getDate("plsettledate"), amount);
        this.addEntry(amount, bizBill, payBill);
        payBill.set("settletag", (Object)SettleTagEnum.PL.getValue());
    }

    protected void fillPayInfoWithSettle(DynamicObject bizBill, DynamicObject payBill, Date expectdate) {
        BigDecimal amount = bizBill.getBigDecimal("settleamount");
        amount = amount.abs();
        DynamicObject currency = bizBill.getDynamicObject("settlecurrency");
        amount = amount.setScale(currency.getInt("amtprecision"), 4);
        this.setValue(payBill, currency, expectdate, amount);
        if (payBill.getDynamicObjectType().getProperties().containsKey((Object)"paymentchannel")) {
            payBill.set("paymentchannel", null);
        }
        this.addEntry(amount, bizBill, payBill);
    }

    private BigDecimal getPayAmount(DynamicObject bizBill) {
        BigDecimal amount = Constants.ZERO;
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        String dir = tradeBill.getString("tradedirect");
        amount = TradeDirectionEnum.buy.getValue().equals(dir) ? amount.add(bizBill.getBigDecimal("bizamt2")) : amount.add(bizBill.getBigDecimal("bizamt1"));
        return amount;
    }

    private BigDecimal getPayAmountBySettle(DynamicObject bizBill) {
        BigDecimal amount = bizBill.getBigDecimal("settleamount");
        return amount.negate();
    }
}

