/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.SwapTypeEnum;
import kd.tmc.tm.common.helper.ForexOptionsHelper;
import org.apache.commons.lang.StringUtils;

public class BizBill2RecBillConvertPlugin
extends AbstractConvertPlugIn {
    private List<String> getSelector() {
        ArrayList<String> sic = new ArrayList<String>(20);
        sic.add("id");
        sic.add("billno");
        sic.add("settleamount");
        sic.add("settlecurrency");
        sic.add("operate");
        sic.add("cashflow");
        sic.add("tradebill");
        sic.add("isrollsettle");
        sic.add("cfpayamount");
        sic.add("bizamt1");
        sic.add("bizamt2");
        sic.add("deliverydate");
        sic.add("plcurrency");
        sic.add("plamt");
        sic.add("plsettledate");
        sic.add("protecttype");
        sic.add("reccurrency");
        sic.add("cashflow_pay");
        sic.add("cashflow_rec");
        return sic;
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        String descEntity = this.getTgtMainType().getName();
        for (ExtendedDataEntity dataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(descEntity)) {
            DynamicObject recBill = dataEntity.getDataEntity();
            List srcRows = (List)dataEntity.getValue("ConvertSource");
            Object srcId = ((DynamicProperty)e.getFldProperties().get("id")).getValue(srcRows.get(0));
            DynamicObject bizBill = TmcDataServiceHelper.loadSingle((Object)srcId, (String)this.getSrcMainType().getName(), (String)StringUtils.join(this.getSelector(), (String)","));
            this.dealRecData(recBill, bizBill);
            recBill.set("sourcebillid", bizBill.getPkValue());
            recBill.set("sourcebilltype", (Object)"tm_businessbill");
        }
    }

    private void dealRecData(DynamicObject recBill, DynamicObject bizBill) {
        BigDecimal amount = Constants.ZERO;
        DynamicObject productType = bizBill.getDynamicObject("protecttype");
        String entityType = ProductTypeEnum.getEnumByValue((String)productType.getString("number")).getEntity();
        String operate = bizBill.getString("operate");
        BizOperateEnum bizOp = BizOperateEnum.valueOf((String)operate);
        switch (bizOp) {
            case bdelivery: 
            case bdelivery_n: 
            case bdelivery_f: {
                if (!"tm_forex_forward".equals(entityType) && !"tm_forex_swaps".equals(entityType)) break;
                if (this.getOption().containsVariable("onemorebill")) {
                    this.fillRecInfoWithPl(bizBill, recBill);
                    break;
                }
                this.fillRecInfoWithDey(bizBill, recBill);
                break;
            }
            case expiredey: 
            case expiredey_n: 
            case expiredey_f: {
                if ("tm_forex".equals(entityType) || "tm_forex_swaps".equals(entityType)) {
                    this.fillRecInfoWithDey(bizBill, recBill);
                }
                if (!"tm_forex_forward".equals(entityType)) break;
                DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
                String deliveryWay = tradeBill.getString("deliveryway");
                if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                    this.fillRecInfoWithDey(bizBill, recBill);
                }
                if (!DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) break;
                this.fillRecInfoWithPl(bizBill, recBill);
                break;
            }
            case flat_n: 
            case flat_f: {
                if (!"tm_forex_swaps".equals(entityType)) break;
                this.fillRecInfoWithPl(bizBill, recBill);
                break;
            }
            case exercise: {
                if ("tm_forex_options".equals(entityType)) {
                    DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
                    String deliveryWay = tradeBill.getString("deliveryway");
                    if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                        this.fillRecInfoWithDeyOption(bizBill, recBill);
                    } else {
                        this.fillRecInfoWithSettle(bizBill, recBill);
                    }
                }
                if (!"tm_ratebound".equals(entityType)) break;
                amount = this.getRecAmountBySettle(bizBill);
                this.addEntry(amount, bizBill, recBill);
                break;
            }
            case flat: {
                this.dealFlat(entityType, bizBill, recBill);
                break;
            }
            case defer: 
            case maudate: 
            case defer_n: 
            case defer_f: 
            case maudate_n: 
            case maudate_f: {
                if (!"tm_forex_forward".equals(entityType) && !"tm_forex_swaps".equals(entityType)) break;
                this.fillRecInfoWithPl(bizBill, recBill);
                break;
            }
            case pay: {
                this.dealPay(entityType, bizBill, recBill);
                break;
            }
            case interestpay: {
                if ("tm_rateswap".equals(entityType)) {
                    Long cashflow_rec;
                    Long cashflow_pay = bizBill.getLong("cashflow_pay");
                    if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{cashflow_pay, cashflow_rec = Long.valueOf(bizBill.getLong("cashflow_rec"))})) {
                        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
                        String rateswapType = tradeBill.getString("rateswaptype");
                        if (SwapTypeEnum.rate.getValue().equals(rateswapType)) {
                            amount = bizBill.getBigDecimal("settleamount").abs();
                        }
                        if (SwapTypeEnum.currency.getValue().equals(rateswapType)) {
                            amount = bizBill.getBigDecimal("bizamt2");
                        }
                    } else {
                        amount = bizBill.getBigDecimal("bizamt2");
                    }
                    DynamicObject currency = bizBill.getDynamicObject("reccurrency");
                    amount = amount.setScale(currency.getInt("amtprecision"), 4);
                    recBill.set("currency", (Object)currency);
                    recBill.set("actrecamt", (Object)amount);
                    this.addEntry(amount, bizBill, recBill);
                }
                if (!"tm_forwrateagree".equals(entityType)) break;
                this.dealPay(entityType, bizBill, recBill);
                break;
            }
            case capitalpay: {
                if (!"tm_rateswap".equals(entityType)) break;
                amount = bizBill.getBigDecimal("bizamt2");
                DynamicObject currency = bizBill.getDynamicObject("reccurrency");
                amount = amount.setScale(currency.getInt("amtprecision"), 4);
                recBill.set("currency", (Object)currency);
                recBill.set("actrecamt", (Object)amount);
                this.addEntry(amount, bizBill, recBill);
                break;
            }
        }
    }

    protected void addEntry(BigDecimal amount, DynamicObject bizBill, DynamicObject recBill) {
        DynamicObjectCollection entrys = recBill.getDynamicObjectCollection("entry");
        if (entrys.size() <= 0) {
            entrys.addNew();
        }
        DynamicObject entry = (DynamicObject)entrys.get(0);
        entry.set("e_corebillno", bizBill.get("billno"));
        entry.set("e_receivableamt", (Object)amount);
        entry.set("e_actamt", (Object)amount);
    }

    protected void fillRecInfoWithDey(DynamicObject bizBill, DynamicObject recBill) {
        BigDecimal amount;
        DynamicObject currency;
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        String dir = tradeBill.getString("tradedirect");
        if (TradeDirectionEnum.buy.getValue().equals(dir)) {
            currency = tradeBill.getDynamicObject("currency");
            amount = bizBill.getBigDecimal("bizamt1");
        } else {
            currency = tradeBill.getDynamicObject("sellcurrency");
            amount = bizBill.getBigDecimal("bizamt2");
        }
        String op = bizBill.getString("operate");
        if (op.indexOf("_f") > 0) {
            if (TradeDirectionEnum.buy.getValue().equals(dir)) {
                currency = tradeBill.getDynamicObject("sellcurrency");
                amount = bizBill.getBigDecimal("bizamt2");
            } else {
                currency = tradeBill.getDynamicObject("currency");
                amount = bizBill.getBigDecimal("bizamt1");
            }
        }
        amount = amount.abs();
        amount = amount.setScale(currency.getInt("amtprecision"), 4);
        recBill.set("currency", (Object)currency);
        recBill.set("actrecamt", (Object)amount);
        this.addEntry(amount, bizBill, recBill);
    }

    protected void fillRecInfoWithDeyOption(DynamicObject bizBill, DynamicObject recBill) {
        BigDecimal amount;
        DynamicObject currency;
        String tradeType;
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        String dir = tradeBill.getString("tradedirect");
        if (ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)(tradeType = tradeBill.getString("tradetype")))) {
            currency = tradeBill.getDynamicObject("currency");
            amount = bizBill.getBigDecimal("bizamt1");
        } else {
            currency = tradeBill.getDynamicObject("sellcurrency");
            amount = bizBill.getBigDecimal("bizamt2");
        }
        amount = amount.abs();
        amount = amount.setScale(currency.getInt("amtprecision"), 4);
        recBill.set("currency", (Object)currency);
        recBill.set("actrecamt", (Object)amount);
        this.addEntry(amount, bizBill, recBill);
    }

    protected void fillRecInfoWithPl(DynamicObject bizBill, DynamicObject recBill) {
        BigDecimal amount = bizBill.getBigDecimal("plamt");
        amount = amount.abs();
        DynamicObject currency = bizBill.getDynamicObject("plcurrency");
        if (currency != null) {
            amount = amount.setScale(currency.getInt("amtprecision"), 4);
        }
        recBill.set("currency", (Object)currency);
        recBill.set("actrecamt", (Object)amount);
        this.addEntry(amount, bizBill, recBill);
    }

    protected void fillRecInfoWithSettle(DynamicObject bizBill, DynamicObject recBill) {
        BigDecimal amount = bizBill.getBigDecimal("settleamount");
        amount = amount.abs();
        DynamicObject currency = bizBill.getDynamicObject("settlecurrency");
        amount = amount.setScale(currency.getInt("amtprecision"), 4);
        recBill.set("currency", (Object)currency);
        recBill.set("actrecamt", (Object)amount);
        this.addEntry(amount, bizBill, recBill);
    }

    protected void dealFlat(String entityType, DynamicObject bizBill, DynamicObject recBill) {
        if ("tm_forex_options".equals(entityType)) {
            this.fillRecInfoWithSettle(bizBill, recBill);
        }
        if ("tm_ratebound".equals(entityType)) {
            BigDecimal amount = this.getRecAmountBySettle(bizBill);
            this.addEntry(amount, bizBill, recBill);
        }
        if ("tm_forex".equals(entityType) || "tm_forex_forward".equals(entityType)) {
            this.fillRecInfoWithPl(bizBill, recBill);
        }
    }

    protected void dealPay(String entityType, DynamicObject bizBill, DynamicObject recBill) {
        BigDecimal amount = BigDecimal.ZERO;
        if ("tm_loan".equals(entityType)) {
            boolean isRollSettle = bizBill.getBoolean("isrollsettle");
            amount = isRollSettle ? this.getRecAmountBySettle(bizBill) : this.getRecAmount(bizBill);
        }
        if ("tm_deposit".equals(entityType)) {
            amount = this.getRecAmount(bizBill);
        }
        if ("tm_forwrateagree".equals(entityType)) {
            amount = this.getRecAmountBySettle(bizBill);
            DynamicObject currency = bizBill.getDynamicObject("settlecurrency");
            recBill.set("currency", (Object)currency);
        }
        if ("tm_structdeposit".equals(entityType)) {
            DynamicObject currency = bizBill.getDynamicObject("settlecurrency");
            recBill.set("currency", (Object)currency);
            amount = this.getRecAmountBySettle(bizBill);
            amount = amount.setScale(currency.getInt("amtprecision"), 4);
        }
        this.addEntry(amount, bizBill, recBill);
    }

    private BigDecimal getRecAmount(DynamicObject bizBill) {
        BigDecimal amount = Constants.ZERO;
        DynamicObject tradeBill = bizBill.getDynamicObject("tradebill");
        String dir = tradeBill.getString("tradedirect");
        amount = TradeDirectionEnum.buy.getValue().equals(dir) ? amount.add(bizBill.getBigDecimal("bizamt1")) : amount.add(bizBill.getBigDecimal("bizamt2"));
        return amount;
    }

    private BigDecimal getRecAmountBySettle(DynamicObject bizBill) {
        BigDecimal amount = bizBill.getBigDecimal("settleamount");
        return amount;
    }
}

