/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.convert;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.helper.SettleInfoHelper;

public class BizBillSettleInfoConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        DynamicObject dataEntity = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().getName())[0].getDataEntity();
        this.setCurrency(dataEntity);
        this.setOtherSettleInfo(dataEntity);
    }

    private void setCurrency(DynamicObject dataEntity) {
        DynamicObject sellCurrency;
        DynamicObject buyCurrency;
        DynamicObject tradeBill = dataEntity.getDynamicObject("tradebill");
        DynamicObject protectType = tradeBill.getDynamicObject("protecttype");
        String bizOp = dataEntity.getString("operate");
        String dir = tradeBill.getString("tradedirect");
        if (TradeDirectionEnum.buy.getValue().equals(dir)) {
            buyCurrency = tradeBill.getDynamicObject("currency");
            sellCurrency = tradeBill.getDynamicObject("sellcurrency");
        } else {
            buyCurrency = tradeBill.getDynamicObject("sellcurrency");
            sellCurrency = tradeBill.getDynamicObject("currency");
        }
        if (ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id"))) {
            if (BizOperateEnum.expiredey.getValue().equals(bizOp)) {
                dataEntity.set("reccurrency", (Object)buyCurrency);
                dataEntity.set("paycurrency", (Object)sellCurrency);
            }
            if (BizOperateEnum.flat.getValue().equals(bizOp)) {
                this.setCurrencyByPl(dataEntity);
            }
        }
        if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
            String deliveryWay = tradeBill.getString("deliveryway");
            if (BizOperateEnum.expiredey.getValue().equals(bizOp)) {
                if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
                    dataEntity.set("reccurrency", (Object)buyCurrency);
                    dataEntity.set("paycurrency", (Object)sellCurrency);
                }
                if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                    this.setCurrencyByPl(dataEntity);
                }
            }
            if (BizOperateEnum.flat.getValue().equals(bizOp) || BizOperateEnum.defer.getValue().equals(bizOp) || BizOperateEnum.maudate.getValue().equals(bizOp)) {
                this.setCurrencyByPl(dataEntity);
            }
            if (BizOperateEnum.bdelivery.getValue().equals(bizOp)) {
                dataEntity.set("reccurrency", (Object)buyCurrency);
                dataEntity.set("paycurrency", (Object)sellCurrency);
            }
        }
        if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id"))) {
            if (BizOperateEnum.expiredey_n.getValue().equals(bizOp) || BizOperateEnum.bdelivery_n.getValue().equals(bizOp)) {
                dataEntity.set("reccurrency", (Object)buyCurrency);
                dataEntity.set("paycurrency", (Object)sellCurrency);
            }
            if (BizOperateEnum.expiredey_f.getValue().equals(bizOp) || BizOperateEnum.bdelivery_f.getValue().equals(bizOp)) {
                dataEntity.set("reccurrency", (Object)sellCurrency);
                dataEntity.set("paycurrency", (Object)buyCurrency);
            }
            if (BizOperateEnum.flat_f.getValue().equals(bizOp) || BizOperateEnum.flat_n.getValue().equals(bizOp) || BizOperateEnum.defer_f.getValue().equals(bizOp) || BizOperateEnum.defer_n.getValue().equals(bizOp) || BizOperateEnum.maudate_f.getValue().equals(bizOp) || BizOperateEnum.maudate_n.getValue().equals(bizOp)) {
                this.setCurrencyByPl(dataEntity);
            }
        }
        if (ProductTypeEnum.FOREXOPTION.getId().equals(protectType.getString("id")) && BizOperateEnum.exercise.getValue().equals(bizOp)) {
            if ("buy".equals(tradeBill.getString("tradedirect"))) {
                dataEntity.set("paycurrency", (Object)tradeBill.getDynamicObject("sellcurrency"));
                dataEntity.set("reccurrency", (Object)tradeBill.getDynamicObject("currency"));
            } else {
                dataEntity.set("paycurrency", (Object)tradeBill.getDynamicObject("currency"));
                dataEntity.set("reccurrency", (Object)tradeBill.getDynamicObject("sellcurrency"));
            }
        }
    }

    private void setCurrencyByPl(DynamicObject dataEntity) {
        BigDecimal plAmt = dataEntity.getBigDecimal("plamt");
        if (BigDecimal.ZERO.compareTo(plAmt) < 0) {
            dataEntity.set("reccurrency", dataEntity.get("plcurrency"));
        } else if (BigDecimal.ZERO.compareTo(plAmt) > 0) {
            dataEntity.set("paycurrency", dataEntity.get("plcurrency"));
        }
    }

    public void setOtherSettleInfo(DynamicObject dataEntity) {
        DynamicObject config;
        Map<String, Boolean> result = this.getSettleFlag(dataEntity);
        Boolean isPay = result.get("isPay");
        Boolean isRec = result.get("isRec");
        DynamicObject payCurrency = dataEntity.getDynamicObject("paycurrency");
        DynamicObject recCurrency = dataEntity.getDynamicObject("reccurrency");
        DynamicObject tradeBill = dataEntity.getDynamicObject("tradebill");
        DynamicObject cp = tradeBill.getDynamicObject("counterparty");
        DynamicObject org = tradeBill.getDynamicObject("org");
        if (isPay.booleanValue() && payCurrency != null && EmptyUtil.isNoEmpty((DynamicObject)(config = SettleInfoHelper.getSettleConfig((DynamicObject)org, (DynamicObject)cp, (DynamicObject)payCurrency)))) {
            dataEntity.set("paysettletype", config.get("settletype"));
            dataEntity.set("paybankacct", config.get("bankaccount"));
            dataEntity.set("paybank", config.getDynamicObject("bankaccount").get("bank"));
        }
        if (isRec.booleanValue() && recCurrency != null && EmptyUtil.isNoEmpty((DynamicObject)(config = SettleInfoHelper.getSettleConfig((DynamicObject)org, (DynamicObject)cp, (DynamicObject)recCurrency)))) {
            dataEntity.set("recsettletype", config.get("settletype"));
            dataEntity.set("recbankacct", config.get("bankaccount"));
            dataEntity.set("recbank", config.getDynamicObject("bankaccount").get("bank"));
        }
    }

    protected Map<String, Boolean> getSettleFlag(DynamicObject dataEntity) {
        String deliveryWay;
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        boolean isPay = true;
        boolean isRec = true;
        DynamicObject tradeBill = dataEntity.getDynamicObject("tradebill");
        DynamicObject protectType = tradeBill.getDynamicObject("protecttype");
        String bizOp = dataEntity.getString("operate");
        BigDecimal plAmt = dataEntity.getBigDecimal("plamt");
        if (ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id")) && BizOperateEnum.flat.getValue().equals(bizOp)) {
            isPay = BigDecimal.ZERO.compareTo(plAmt) > 0;
            boolean bl = isRec = BigDecimal.ZERO.compareTo(plAmt) < 0;
        }
        if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
            deliveryWay = tradeBill.getString("deliveryway");
            if (BizOperateEnum.expiredey.getValue().equals(bizOp) && DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                isPay = BigDecimal.ZERO.compareTo(plAmt) > 0;
                boolean bl = isRec = BigDecimal.ZERO.compareTo(plAmt) < 0;
            }
            if (BizOperateEnum.flat.getValue().equals(bizOp) || BizOperateEnum.defer.getValue().equals(bizOp) || BizOperateEnum.maudate.getValue().equals(bizOp)) {
                isPay = BigDecimal.ZERO.compareTo(plAmt) > 0;
                boolean bl = isRec = BigDecimal.ZERO.compareTo(plAmt) < 0;
            }
        }
        if (ProductTypeEnum.FOREXSWAPS.getId().equals(protectType.getString("id")) && (BizOperateEnum.flat_f.getValue().equals(bizOp) || BizOperateEnum.flat_n.getValue().equals(bizOp) || BizOperateEnum.defer_f.getValue().equals(bizOp) || BizOperateEnum.defer_n.getValue().equals(bizOp) || BizOperateEnum.maudate_f.getValue().equals(bizOp) || BizOperateEnum.maudate_n.getValue().equals(bizOp))) {
            isPay = BigDecimal.ZERO.compareTo(plAmt) > 0;
            boolean bl = isRec = BigDecimal.ZERO.compareTo(plAmt) < 0;
        }
        if (ProductTypeEnum.FOREXOPTION.getId().equals(protectType.getString("id")) && BizOperateEnum.exercise.getValue().equals(bizOp)) {
            deliveryWay = tradeBill.getString("deliveryway");
            BigDecimal settleAmount = (BigDecimal)dataEntity.get("settleamount");
            isRec = DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) || DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && BigDecimal.ZERO.compareTo(settleAmount) < 0;
            isPay = DeliveryWayEnum.deliverable.getValue().equals(deliveryWay) || DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay) && BigDecimal.ZERO.compareTo(settleAmount) > 0;
        }
        result.put("isPay", isPay);
        result.put("isRec", isRec);
        return result;
    }
}

