/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.convert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.BizOperateEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.PlConfirmStatusEnum;
import kd.tmc.tm.common.helper.BusinessBillHelper;
import kd.tmc.tm.common.helper.ForexHelper;

public class BusinessBillConvertPlugin
extends AbstractConvertPlugIn {
    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        DynamicObject dataEntity = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().getName())[0].getDataEntity();
        DynamicObject org = dataEntity.getDynamicObject("org");
        if (ProductTypeEnum.FOREXSWAPS.getValue().equals(dataEntity.getDynamicObject("protecttype").getString("number"))) {
            this.convertOperateValForSwaps(dataEntity);
        }
        dataEntity.set("plcurrency", (Object)ForexHelper.getDefaultPlCurrency((DynamicObject)dataEntity));
        if (!QueryServiceHelper.exists((String)"tm_bizrecord", (Object)dataEntity.get("bizrecordid"))) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8be5\u4ea4\u6613\u5355\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u7f16\u8f91\u751f\u547d\u5468\u671f\u7533\u8bf7\u5355\u3002", (String)"BusinessBillConvertPlugin2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject bizRecord = BusinessDataServiceHelper.loadSingle((Object)dataEntity.get("bizrecordid"), (String)"tm_bizrecord", (String)"bizdate,enddate,exrate,restamt,swapdir,desc");
        if (dataEntity.getBigDecimal("bizamt1").compareTo(bizRecord.getBigDecimal("restamt")) > 0) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u8be5\u4ea4\u6613\u5355\u5bf9\u5e94\u7684\u751f\u547d\u5468\u671f\u9009\u62e9\u6846\u4e0b\u7684\u672a\u4ea4\u5272\u91d1\u989d\u5c0f\u4e8e\u7533\u8bf7\u7684\u91d1\u989d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"BusinessBillConvertPlugin1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        dataEntity.set("restamt1", (Object)bizRecord.getBigDecimal("restamt").subtract(dataEntity.getBigDecimal("bizamt1")));
        BigDecimal v = dataEntity.getBigDecimal("restamt1").multiply(dataEntity.getBigDecimal("bizamt2"));
        BigDecimal restAmt2 = v.divide(dataEntity.getBigDecimal("bizamt1"), 10, RoundingMode.HALF_UP);
        dataEntity.set("restamt2", (Object)restAmt2);
        BusinessBillHelper.buildOtherForPush((DynamicObject)dataEntity);
        DynamicObject tradeBill = dataEntity.getDynamicObject("tradebill");
        Map result = BaseDataServiceHelper.getBaseAccountingInfo((Long)tradeBill.getDynamicObject("org").getLong("id"));
        Long localCurrencyId = (Long)result.get("baseCurrencyID");
        if (EmptyUtil.isEmpty((Long)localCurrencyId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u5f53\u524d\u4ea4\u6613\u4e3b\u4f53\u7684\u6838\u7b97\u7ec4\u7ec7\u672c\u4f4d\u5e01\u3002", (String)"BizBillEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        DynamicObject localCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)localCurrencyId, (String)"bd_currency");
        dataEntity.set("basecurrency", (Object)localCurrency);
        this.dealVoucherPl(dataEntity, tradeBill, localCurrency);
        if (BusinessBillHelper.cannotPlConfirm((DynamicObject)dataEntity).booleanValue()) {
            dataEntity.set("isplconfirm", (Object)Boolean.FALSE);
            dataEntity.set("plconfirmstatus", (Object)PlConfirmStatusEnum.None.getValue());
        } else {
            Boolean isPlConfim = dataEntity.getBoolean("isplconfirm");
            dataEntity.set("plconfirmstatus", (Object)(isPlConfim != false ? PlConfirmStatusEnum.Confirmed.getValue() : PlConfirmStatusEnum.ToBeConfirmed.getValue()));
        }
        if (EmptyUtil.isNoEmpty((Object)dataEntity.get("plamt")) && EmptyUtil.isNoEmpty((Object)dataEntity.get("plcurrency"))) {
            BigDecimal plAmt = dataEntity.getBigDecimal("plamt");
            int amtPrecision = dataEntity.getDynamicObject("plcurrency").getInt("amtprecision");
            BigDecimal amt = plAmt.setScale(amtPrecision, RoundingMode.HALF_UP);
            dataEntity.set("plamt", (Object)amt);
        }
    }

    protected void dealVoucherPl(DynamicObject dataEntity, DynamicObject tradeBill, DynamicObject localCurrency) {
        if (this.isShowVoucherPlPanel(dataEntity, tradeBill, localCurrency.getLong("id"))) {
            DynamicObject priceRule = this.queryPriceRule(tradeBill);
            dataEntity.set("show_voucher_pl_panel", (Object)Boolean.TRUE);
            this.setVoucherPl(dataEntity, tradeBill, priceRule, localCurrency);
        }
    }

    protected DynamicObject queryPriceRule(DynamicObject tradebill) {
        if (tradebill.getDynamicObject("pricerule") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4ea4\u6613%s\u672a\u8bbe\u7f6e\u5b9a\u4ef7\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BizBillEdit_3", (String)"tmc-tm-formplugin", (Object[])new Object[]{tradebill.getString("number")}));
        }
        return QueryServiceHelper.queryOne((String)"md_pricerule", (String)"forexquote.id,forexquote.issuetime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)tradebill.getDynamicObject("pricerule").getLong("id"))});
    }

    protected boolean isShowVoucherPlPanel(DynamicObject dataEntity, DynamicObject tradeBill, Long localCurrencyId) {
        DynamicObject sellCurrency;
        DynamicObject buyCurrency = tradeBill.getDynamicObject("currency");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{buyCurrency, sellCurrency = tradeBill.getDynamicObject("sellcurrency")})) {
            return false;
        }
        long buyCurrencyId = buyCurrency.getLong("id");
        long sellCurrencyId = sellCurrency.getLong("id");
        String op = dataEntity.getString("operate");
        return buyCurrencyId != localCurrencyId && sellCurrencyId != localCurrencyId && DeliveryWayEnum.deliverable.getValue().equals(tradeBill.getString("deliveryway")) && (BizOperateEnum.expiredey.getValue().equals(op) || BizOperateEnum.expiredey_n.getValue().equals(op) || BizOperateEnum.expiredey_f.getValue().equals(op) || BizOperateEnum.exercise.getValue().equals(op) || BizOperateEnum.bdelivery.getValue().equals(op) || BizOperateEnum.bdelivery_n.getValue().equals(op) || BizOperateEnum.bdelivery_f.getValue().equals(op));
    }

    private void setVoucherPl(DynamicObject dataEntity, DynamicObject tradeBill, DynamicObject priceRule, DynamicObject localCurrency) {
        BigDecimal sellExAmt;
        BigDecimal sellExRate;
        BigDecimal buyExAmt;
        BigDecimal buyExRate;
        DynamicObject sellCurrency;
        DynamicObject buyCurrency;
        BigDecimal sellAmt;
        BigDecimal buyAmt;
        String op = dataEntity.getString("operate");
        boolean flag = true;
        String tradeType = tradeBill.getString("tradetype");
        String dir = tradeBill.getString("tradedirect");
        DynamicObject protectType = tradeBill.getDynamicObject("protecttype");
        String protectId = protectType.getString("id");
        if (ProductTypeEnum.FOREXOPTION.getId().equals(protectId)) {
            if (OptionsTradeTypeEnum.call.getValue().equals(tradeType) && TradeDirectionEnum.sell.getValue().equals(dir) || OptionsTradeTypeEnum.put.getValue().equals(tradeType) && TradeDirectionEnum.buy.getValue().equals(dir)) {
                flag = false;
            }
        } else if (op.indexOf("_f") < 0 && "sell".equals(dir) || op.indexOf("_f") > 0 && "buy".equals(dir)) {
            flag = false;
        }
        if (flag) {
            buyAmt = dataEntity.getBigDecimal("bizamt1");
            sellAmt = dataEntity.getBigDecimal("bizamt2");
            buyCurrency = tradeBill.getDynamicObject("currency");
            sellCurrency = tradeBill.getDynamicObject("sellcurrency");
        } else {
            buyAmt = dataEntity.getBigDecimal("bizamt2");
            sellAmt = dataEntity.getBigDecimal("bizamt1");
            buyCurrency = tradeBill.getDynamicObject("sellcurrency");
            sellCurrency = tradeBill.getDynamicObject("currency");
        }
        int buyAmtPrecision = buyCurrency.getInt("amtprecision");
        buyAmt = buyAmt.setScale(buyAmtPrecision, 4);
        int sellAmtPrecision = sellCurrency.getInt("amtprecision");
        sellAmt = sellAmt.setScale(sellAmtPrecision, 4);
        String buyCurrencyNumber = buyCurrency.getString("number");
        String sellCurrencyNumber = sellCurrency.getString("number");
        Date bizDate = dataEntity.getDate("bizdate");
        ForexQuoteInfo buyCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexquote.id"), (String)(buyCurrencyNumber + "/" + localCurrency.getString("number")), (Date)bizDate, null);
        String buyCurFxQuote = buyCurFqInfo.getFxquote();
        if (buyCurrencyNumber.equals(buyCurFxQuote.split("/")[0])) {
            buyExRate = buyCurFqInfo.getBuyPrice();
            buyExAmt = buyAmt.multiply(buyExRate);
        } else {
            buyExRate = buyCurFqInfo.getSellPrice();
            buyExAmt = buyAmt.divide(buyExRate, 10, 4);
        }
        ForexQuoteInfo sellCurFqInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)priceRule.getLong("forexquote.id"), (String)(sellCurrencyNumber + "/" + localCurrency.getString("number")), (Date)bizDate, null);
        String sellCurFxQuote = sellCurFqInfo.getFxquote();
        if (sellCurrencyNumber.equals(sellCurFxQuote.split("/")[0])) {
            sellExRate = sellCurFqInfo.getBuyPrice();
            sellExAmt = sellAmt.multiply(sellExRate);
        } else {
            sellExRate = sellCurFqInfo.getSellPrice();
            sellExAmt = sellAmt.divide(sellExRate, 10, 4);
        }
        dataEntity.set("buy_local_fq", (Object)buyCurFxQuote);
        dataEntity.set("buy_local_exrate", (Object)buyExRate);
        dataEntity.set("sell_local_fq", (Object)sellCurFxQuote);
        dataEntity.set("sell_local_exrate", (Object)sellExRate);
        dataEntity.set("voucher_pl", (Object)buyExAmt.subtract(sellExAmt));
    }

    private void convertOperateValForSwaps(DynamicObject dataEntity) {
        String operate = dataEntity.getString("operate");
        if ("spot".equals(dataEntity.get("swapdir"))) {
            if (BizOperateEnum.expiredey.getValue().equals(operate)) {
                dataEntity.set("operate", (Object)BizOperateEnum.expiredey_n.getValue());
            } else if (BizOperateEnum.bdelivery.getValue().equals(operate)) {
                dataEntity.set("operate", (Object)BizOperateEnum.bdelivery_n.getValue());
            } else if (BizOperateEnum.defer.getValue().equals(operate)) {
                dataEntity.set("operate", (Object)BizOperateEnum.defer_n.getValue());
            } else if (BizOperateEnum.flat.getValue().equals(operate)) {
                dataEntity.set("operate", (Object)BizOperateEnum.flat_n.getValue());
            } else if (BizOperateEnum.maudate.getValue().equals(operate)) {
                dataEntity.set("operate", (Object)BizOperateEnum.maudate_n.getValue());
            }
        } else if ("fwd".equals(dataEntity.get("swapdir"))) {
            if (BizOperateEnum.expiredey.getValue().equals(operate)) {
                dataEntity.set("operate", (Object)BizOperateEnum.expiredey_f.getValue());
            } else if (BizOperateEnum.bdelivery.getValue().equals(operate)) {
                dataEntity.set("operate", (Object)BizOperateEnum.bdelivery_f.getValue());
            } else if (BizOperateEnum.defer.getValue().equals(operate)) {
                dataEntity.set("operate", (Object)BizOperateEnum.defer_f.getValue());
            } else if (BizOperateEnum.flat.getValue().equals(operate)) {
                dataEntity.set("operate", (Object)BizOperateEnum.flat_f.getValue());
            } else if (BizOperateEnum.maudate.getValue().equals(operate)) {
                dataEntity.set("operate", (Object)BizOperateEnum.maudate_f.getValue());
            }
        }
    }
}

