/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forex;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.common.enums.CombReqNoteEnum;
import kd.tmc.tm.common.helper.ForexHelper;

public class ForexBsInfoEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener,
ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit market = (BasedataEdit)this.getView().getControl("market_bs");
        market.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        TextEdit tradeNum = (TextEdit)this.getView().getControl("pair");
        tradeNum.addButtonClickListener((ClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        DynamicObject currency;
        String key = evt.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"market_bs") && EmptyUtil.isNoEmpty((DynamicObject)(currency = (DynamicObject)this.getModel().getValue("currency_bs")))) {
            QFilter qFilter = new QFilter("currency.id", "=", currency.getPkValue());
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.buildEntryBS();
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setBiztype();
    }

    public void click(EventObject e) {
        if (((Control)e.getSource()).getKey().equals("pair")) {
            QFilter pairQFilterFromReqNote;
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_currency_tc", (boolean)true);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectPair"));
            showParameter.setShowTitle(false);
            showParameter.setCustomParam("billFormId", (Object)"bd_currency_tc");
            QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("pair"))) {
                DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("currency");
                DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
                if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("reqnoteno"))) {
                    qFilter.and("id", "in", (Object)new Long[]{buyCurrency.getLong("id"), sellCurrency.getLong("id")});
                }
                showParameter.setSelectedRows(new Object[]{buyCurrency.getLong("id"), sellCurrency.getLong("id")});
            } else if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("reqnoteno")) && (pairQFilterFromReqNote = this.getPairQFilterFromReqNote()) != null) {
                qFilter.and(pairQFilterFromReqNote);
            }
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    private QFilter getPairQFilterFromReqNote() {
        String entryRowIdProp;
        String buyCurrencyProp;
        String sellCurrencyProp;
        DynamicObject protectType = (DynamicObject)this.getModel().getValue("protecttype");
        if (protectType == null || !ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id")) && !ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
            return null;
        }
        Object sourceBillId = this.getModel().getValue("sourcebillid");
        String source = (String)this.getModel().getValue("source");
        DynamicObject sourceBill = null;
        String srcEntityNum = null;
        if ("combreqnote_spotinfo".equals(source)) {
            sellCurrencyProp = CombReqNoteEnum.SPOT.getEntryName() + "." + CombReqNoteEnum.SPOT.getEntrySellCurrName();
            buyCurrencyProp = CombReqNoteEnum.SPOT.getEntryName() + "." + CombReqNoteEnum.SPOT.getEntryBuyCurrName();
            entryRowIdProp = CombReqNoteEnum.SPOT.getEntryName() + ".id";
            srcEntityNum = "tm_combreqnote";
        } else if ("combreqnote_forwardinfo".equals(source)) {
            sellCurrencyProp = CombReqNoteEnum.FORWARD.getEntryName() + "." + CombReqNoteEnum.FORWARD.getEntrySellCurrName();
            buyCurrencyProp = CombReqNoteEnum.FORWARD.getEntryName() + "." + CombReqNoteEnum.FORWARD.getEntryBuyCurrName();
            entryRowIdProp = CombReqNoteEnum.FORWARD.getEntryName() + ".id";
            srcEntityNum = "tm_combreqnote";
        } else {
            if (ProductTypeEnum.FOREXSPOT.getId().equals(protectType.getString("id"))) {
                entryRowIdProp = "spotinfo.id";
                buyCurrencyProp = "spotinfo.spotcurrencytypein";
                sellCurrencyProp = "spotinfo.spotcurrencytypeout";
            } else {
                entryRowIdProp = "forwardinfo.id";
                buyCurrencyProp = "forwardinfo.currencytypein";
                sellCurrencyProp = "forwardinfo.currencytypeout";
            }
            srcEntityNum = "tm_reqnote";
        }
        sourceBill = QueryServiceHelper.queryOne((String)srcEntityNum, (String)(sellCurrencyProp + "," + buyCurrencyProp), (QFilter[])new QFilter[]{new QFilter(entryRowIdProp, "=", sourceBillId)});
        if (sourceBill != null && sourceBill.get(buyCurrencyProp) != null && sourceBill.get(sellCurrencyProp) != null) {
            return new QFilter("id", "in", (Object)new Object[]{sourceBill.get(buyCurrencyProp), sourceBill.get(sellCurrencyProp)});
        }
        return null;
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection data;
        super.closedCallBack(event);
        if (event.getActionId().equals("selectPair") && EmptyUtil.isNoEmpty((Object)(data = (ListSelectedRowCollection)event.getReturnData()))) {
            Object buyCurrencyId = data.get(0).getPrimaryKeyValue();
            Object sellCurrencyId = data.get(1).getPrimaryKeyValue();
            Set exCurrency = ForexHelper.getExCurrency((Long)((DynamicObject)this.getModel().getValue("org")).getLong("id"));
            if (EmptyUtil.isNoEmpty((Object)exCurrency)) {
                if (exCurrency.contains(buyCurrencyId) && exCurrency.contains(sellCurrencyId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u9009\u62e9\u9519\u8bef\uff08\u9009\u62e9\u7684\u4e24\u5e01\u79cd\u5747\u4e3a\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff09\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ForexBsInfoEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff0c\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"OrgWithoutExCurrencyConfig", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject buyCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)buyCurrencyId, (String)"bd_currency");
            DynamicObject sellCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)sellCurrencyId, (String)"bd_currency");
            String pair = buyCurrency.getString("number") + "/" + sellCurrency.getString("number");
            DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
            if (EmptyUtil.isNoEmpty((DynamicObject)priceRule)) {
                if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"PriceRuleWithoutFX", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
                MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, null, (Date)TcDateUtils.getCurrentDate());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9a\u4ef7\u89c4\u5219\u83b7\u53d6\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u3002", (String)"PriceRuleIsNull", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue("currency", buyCurrencyId);
            this.getModel().setValue("sellcurrency", sellCurrencyId);
            this.getModel().setValue("pair", (Object)pair);
        }
    }

    private void buildEntryBS() {
        String pair = (String)this.getModel().getValue("pair");
        String tradeDir = (String)this.getModel().getValue("tradedirect");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, tradeDir})) {
            if (this.getModel().getEntryRowCount("entry_bs") != 2) {
                this.getModel().deleteEntryData("entry_bs");
                this.getModel().batchCreateNewEntryRow("entry_bs", 2);
            }
            if (TradeDirectionEnum.buy.getValue().equals(tradeDir)) {
                this.getModel().setValue("direct_bs", (Object)"buy", 0);
                this.getModel().setValue("direct_bs", (Object)"sell", 1);
            } else {
                this.getModel().setValue("direct_bs", (Object)"sell", 0);
                this.getModel().setValue("direct_bs", (Object)"buy", 1);
            }
            this.getModel().setValue("currency_bs", this.getModel().getValue("currency"), 0);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)this.getModel().getValue("amount"), (int)0);
            this.getModel().setValue("market_bs", this.getModel().getValue("buymarket"), 0);
            this.getModel().setValue("currency_bs", this.getModel().getValue("sellcurrency"), 1);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)this.getModel().getValue("sellamount"), (int)1);
            this.getModel().setValue("market_bs", this.getModel().getValue("sellmarket"), 1);
        } else {
            this.getModel().deleteEntryData("entry_bs");
            if (EmptyUtil.isEmpty((String)pair)) {
                this.getModel().setValue("currency", null);
                this.getModel().setValue("amount", null);
                this.getModel().setValue("buymarket", null);
                this.getModel().setValue("sellcurrency", null);
                this.getModel().setValue("sellamount", null);
                this.getModel().setValue("sellmarket", null);
            }
        }
        this.getView().updateView("entry_bs");
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        Object newValue = args.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "tradedirect": 
            case "pair": {
                this.buildEntryBS();
                this.setBiztype();
                break;
            }
            case "amount_bs": {
                this.amoutBsChange(rowIndex, (BigDecimal)newValue);
                break;
            }
            case "spotrate": {
                this.setSecondAmt((BigDecimal)newValue);
                break;
            }
            case "market_bs": {
                if (rowIndex == 0) {
                    this.getModel().setValue("buymarket", newValue);
                    break;
                }
                this.getModel().setValue("sellmarket", newValue);
                break;
            }
            case "currency": {
                this.getModel().setValue("amount", null);
                this.getModel().setValue("buymarket", null);
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entry_bs"))) break;
                this.getModel().setValue("amount_bs", null, 0);
                break;
            }
            case "sellcurrency": {
                this.getModel().setValue("sellamount", null);
                this.getModel().setValue("sellmarket", null);
                if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entry_bs"))) break;
                this.getModel().setValue("amount_bs", null, 1);
                break;
            }
            case "amount": {
                this.getModel().setValue("bizrestamt", newValue);
            }
        }
    }

    private void amoutBsChange(int rowIndex, BigDecimal amountBs) {
        BigDecimal spotrate = (BigDecimal)this.getModel().getValue("spotrate");
        if (rowIndex == 0) {
            this.getModel().setValue("amount", (Object)amountBs);
            this.setSecondAmt(spotrate);
        } else {
            this.getModel().setValue("sellamount", (Object)amountBs);
            this.setFirstAmt(spotrate);
        }
    }

    private void setFirstAmt(BigDecimal spotRate) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entry_bs"))) {
            BigDecimal amtSecondRow = (BigDecimal)this.getModel().getValue("amount_bs", 1);
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{spotRate, amtSecondRow})) {
                return;
            }
            BigDecimal amtFirstRow = this.isSameFX() ? amtSecondRow.divide(spotRate, 6, 4) : amtSecondRow.multiply(spotRate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)amtFirstRow, (int)0);
            this.getModel().setValue("amount", (Object)amtFirstRow);
        }
    }

    private void setSecondAmt(BigDecimal spotRate) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)this.getModel().getEntryEntity("entry_bs"))) {
            BigDecimal amtFirstRow = (BigDecimal)this.getModel().getValue("amount_bs", 0);
            if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{amtFirstRow, spotRate})) {
                return;
            }
            BigDecimal amtSecondRow = this.isSameFX() ? amtFirstRow.multiply(spotRate) : amtFirstRow.divide(spotRate, 6, 4);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)amtSecondRow, (int)1);
            this.getModel().setValue("sellamount", (Object)amtSecondRow);
            this.getView().updateView("entry_bs");
        }
    }

    private void setBiztype() {
        QFilter filter_enable;
        String pair;
        String dir = (String)this.getModel().getValue("tradedirect");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dir, pair = (String)this.getModel().getValue("pair")})) {
            this.getModel().setValue("biztype", null);
            return;
        }
        DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        QFilter filter_org = new QFilter("org", "=", (Object)orgId);
        DynamicObject exCurrencyConfig = TmcDataServiceHelper.loadSingle((String)"tbd_excurrency", (String)"excurrency", (QFilter[])new QFilter[]{filter_org, filter_enable = new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (EmptyUtil.isEmpty((DynamicObject)exCurrencyConfig)) {
            this.getModel().setValue("biztype", null);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff0c\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"OrgWithoutExCurrencyConfig", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection exCurrencyCol = exCurrencyConfig.getDynamicObjectCollection("excurrency");
        boolean isContainSell = false;
        for (DynamicObject oneCurrency : exCurrencyCol) {
            if (sellCurrency.getLong("id") != oneCurrency.getDynamicObject("fbasedataid").getLong("id")) continue;
            isContainSell = true;
            break;
        }
        boolean isContainBuy = false;
        for (DynamicObject oneCurrency : exCurrencyCol) {
            if (currency.getLong("id") != oneCurrency.getDynamicObject("fbasedataid").getLong("id")) continue;
            isContainBuy = true;
            break;
        }
        if (isContainBuy && isContainSell) {
            this.getModel().setValue("biztype", (Object)"");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u9009\u62e9\u9519\u8bef\uff08\u9009\u62e9\u7684\u4e24\u5e01\u79cd\u5747\u4e3a\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff09\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ForexBsInfoEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (isContainSell && TradeDirectionEnum.buy.getValue().equals(dir) || isContainBuy && TradeDirectionEnum.sell.getValue().equals(dir)) {
            this.getModel().setValue("biztype", (Object)"buy");
        } else if (isContainSell && TradeDirectionEnum.sell.getValue().equals(dir) || isContainBuy && TradeDirectionEnum.buy.getValue().equals(dir)) {
            this.getModel().setValue("biztype", (Object)"sell");
        } else {
            this.getModel().setValue("biztype", (Object)"diff");
        }
    }

    private boolean isSameFX() {
        String pair = (String)this.getModel().getValue("pair");
        String fxquote = (String)this.getModel().getValue("fxquote");
        return !EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, fxquote}) && pair.equals(fxquote);
    }
}

