/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forex;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Container;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class ForexList
extends AbstractTmcListPlugin {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object type = this.getView().getFormShowParameter().getCustomParam("bos_call_source_type");
        if ("botp_track".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"treeview", "splitpanelap"});
            Container splitcontainerap = (Container)this.getControl("splitpanelap");
            if (splitcontainerap != null) {
                splitcontainerap.setCollapse(true);
                splitcontainerap.setCollapseable(false);
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        String orgId = null;
        if (EmptyUtil.isNoEmpty((Object)this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()))) {
            orgId = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId()).getPageCache().get("org");
        }
        if (EmptyUtil.isNoEmpty(orgId)) {
            args.setMainOrgQFilter(new QFilter("id", "=", (Object)Long.valueOf(orgId)));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("tracelife".equals(key)) {
            Long selectedId = this.getSelectedId();
            QFilter qFilter = new QFilter("tradebill", "=", (Object)selectedId);
            if (selectedId == null) {
                return;
            }
            if (!QueryServiceHelper.exists((String)"tm_businessbill", (QFilter[])new QFilter[]{qFilter})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0b\u67e5\u751f\u547d\u5468\u671f\u5355\uff0c\u65e0\u6570\u636e\u3002", (String)"ForexList_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(1500));
                return;
            }
            if (EmptyUtil.isNoEmpty((Long)selectedId)) {
                DynamicObject forexObj = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"tm_trade");
                ListShowParameter param = ShowFormHelper.createShowListForm((String)"tm_businessbill", (boolean)true, (int)0, (boolean)false);
                ListFilterParameter filterParameter = new ListFilterParameter();
                filterParameter.setFilter(qFilter);
                param.setListFilterParameter(filterParameter);
                this.getView().getPageCache().put("org", String.valueOf(forexObj.getDynamicObject("org").getLong("id")));
                this.getView().showForm((FormShowParameter)param);
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection data = super.getData(start, limit);
            if (EmptyUtil.isEmpty((DynamicObjectCollection)data) || !((DynamicObject)data.get(0)).containsProperty("billno")) {
                return data;
            }
            List billNos = data.stream().map(o -> o.getString("billno")).distinct().collect(Collectors.toList());
            HashMap<String, Integer> orderMap = new HashMap<String, Integer>(8);
            int seq = 0;
            for (String billNo : billNos) {
                orderMap.put(billNo, seq++);
            }
            data.sort((o1, o2) -> {
                String billNo2;
                String billNo1 = o1.getString("billno");
                if (billNo1.equals(billNo2 = o2.getString("billno"))) {
                    return 0;
                }
                return ((Integer)orderMap.get(billNo1)).compareTo((Integer)orderMap.get(billNo2));
            });
            return data;
        }
    }
}

