/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forex;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.ForexBizTypeEnum;
import kd.tmc.tm.common.enums.OptionTypeEnum;
import kd.tmc.tm.common.helper.ForexOptionsHelper;
import kd.tmc.tm.formplugin.forex.ForexSpotImportPlugin;

public class ForexOptionImportPlugin
extends ForexSpotImportPlugin {
    @Override
    public void afterImportData(ImportDataEventArgs e) {
        ArrayList<String> errorMsgList = new ArrayList<String>();
        this.validate(e, errorMsgList);
        this.validate_option(errorMsgList);
        this.dealErrorMsgList(errorMsgList);
        this.setValue_option();
        this.useCreditLimit();
    }

    @Override
    protected void dealForexQuoteInfo(String entityName, List<String> errorMsgList) {
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        String pair = (String)this.getModel().getValue("pair");
        Date settleDate = (Date)this.getModel().getValue("settledate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceRule, pair, settleDate})) {
            if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                errorMsgList.add(ResManager.loadResFormat((String)"\u5b9a\u4ef7\u89c4\u5219%s\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"ForexOptionImportPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{priceRule.get("number")}));
                return;
            }
            Date bizdate = (Date)this.getModel().getValue("bizdate");
            Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            ForexQuoteInfo info = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, (Date)settleDate);
            String forexQuote = info.getFxquote();
            this.getModel().setValue("fxquote", (Object)forexQuote);
        }
    }

    private void setValue_option() {
        this.getModel().setValue("bizrestamt", this.getModel().getValue("amount"));
        this.setValue_finAssetType();
        this.setValue_deliveryWay();
        this.setValue_settleDelay();
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("adjexpiredate"))) {
            Date adjExpireDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)((Date)this.getModel().getValue("adjustsettledate")), (int)(-((Integer)this.getModel().getValue("settledelay")).intValue()));
            this.getModel().setValue("adjexpiredate", (Object)adjExpireDate);
        }
        this.setTerm("settledate", "term");
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("optiontype"))) {
            this.getModel().setValue("optiontype", (Object)OptionTypeEnum.european.getValue());
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("premiumcurrency"))) {
            this.getModel().setValue("premiumcurrency", this.getCurrencyByNumber(((String)this.getModel().getValue("pair")).split("/")[1]).get("id"));
        }
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("premiumdate"))) {
            Date premiumDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)((Date)this.getModel().getValue("bizdate")), (int)((Integer)this.getModel().getValue("settledelay")));
            this.getModel().setValue("premiumdate", (Object)premiumDate);
        }
        this.setValue_currency();
        this.buildEntryBS();
        this.setBizType();
        this.calAmountBS(0);
    }

    private void setValue_currency() {
        String pair = (String)this.getModel().getValue("pair");
        String[] array = pair.split("/");
        DynamicObject leftCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)array[0])});
        DynamicObject rightCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)array[1])});
        this.getModel().setValue("currency", leftCurrency.get("id"));
        this.getModel().setValue("sellcurrency", rightCurrency.get("id"));
    }

    @Override
    protected void setValue_settleDelay() {
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        DynamicObjectCollection workCalendar = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        Date date = (Date)this.getModel().getValue("settledate");
        int diffWorkDays = Math.min(TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)workCalendar, (Date)bizDate, (Date)date), 2);
        this.getModel().setValue("settledelay", (Object)diffWorkDays);
    }

    private void calAmountBS(int rowIndex) {
        BigDecimal changeAmt;
        BigDecimal exchangeRate;
        String fxQuote;
        String pair = (String)this.getModel().getValue("pair");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, fxQuote = (String)this.getModel().getValue("fxquote"), exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate")}) && (changeAmt = (BigDecimal)this.getModel().getValue("amount_bs", rowIndex)) != null) {
            int setIndex = rowIndex == 0 ? 1 : 0;
            boolean equal = pair.equals(fxQuote);
            if (equal && rowIndex == 0 || !equal && rowIndex == 1) {
                BigDecimal calMultiply = changeAmt.multiply(exchangeRate);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)calMultiply, (int)setIndex);
            } else {
                BigDecimal calDivide = changeAmt.divide(exchangeRate, 6, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)calDivide, (int)setIndex);
            }
            this.getModel().setValue("amount", this.getModel().getValue("amount_bs", 0));
            this.getModel().setValue("sellamount", this.getModel().getValue("amount_bs", 1));
        }
    }

    private void setBizType() {
        String[] array;
        String dir = (String)this.getModel().getValue("tradedirect");
        String pair = (String)this.getModel().getValue("pair");
        String tradeType = (String)this.getModel().getValue("tradetype");
        Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        if (this.isUnitTest()) {
            return;
        }
        DynamicObject exCurrencyConfig = this.getExCurrency(orgId);
        DynamicObjectCollection exCurrencyCol = exCurrencyConfig.getDynamicObjectCollection("excurrency");
        Set numberSet = exCurrencyCol.stream().map(s -> s.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toSet());
        if (numberSet.contains((array = pair.split("/"))[0]) && ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)tradeType) || numberSet.contains(array[1]) && ForexOptionsHelper.callAndSellORPutAndBuy((String)dir, (String)tradeType)) {
            this.getModel().setValue("biztype", (Object)ForexBizTypeEnum.sell.getValue());
        } else if (numberSet.contains(array[0]) && ForexOptionsHelper.callAndSellORPutAndBuy((String)dir, (String)tradeType) || numberSet.contains(array[1]) && ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)tradeType)) {
            this.getModel().setValue("biztype", (Object)ForexBizTypeEnum.buy.getValue());
        } else {
            this.getModel().setValue("biztype", (Object)ForexBizTypeEnum.diff.getValue());
        }
    }

    private void buildEntryBS() {
        String dir = (String)this.getModel().getValue("tradedirect");
        String tradeType = (String)this.getModel().getValue("tradetype");
        this.getModel().deleteEntryData("entry_bs");
        this.getModel().batchCreateNewEntryRow("entry_bs", 2);
        if (ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)tradeType)) {
            this.getModel().setValue("direct_bs", (Object)TradeDirectionEnum.buy.getValue(), 0);
            this.getModel().setValue("direct_bs", (Object)TradeDirectionEnum.sell.getValue(), 1);
        } else {
            this.getModel().setValue("direct_bs", (Object)TradeDirectionEnum.sell.getValue(), 0);
            this.getModel().setValue("direct_bs", (Object)TradeDirectionEnum.buy.getValue(), 1);
        }
        this.getModel().setValue("currency_bs", this.getModel().getValue("currency"), 0);
        this.getModel().setValue("currency_bs", this.getModel().getValue("sellcurrency"), 1);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)this.getModel().getValue("amount"), (int)0);
    }

    private void validate_option(List<String> errorMsgList) {
        Date premiumDate;
        if (((Date)this.getModel().getValue("settledate")).before((Date)this.getModel().getValue("bizdate"))) {
            errorMsgList.add(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4ea4\u6613\u65e5\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexOptionImportPlugin_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        this.setValue_dateAdjustMethod();
        this.setAdjSettleDate("settledate", "adjustsettledate");
        Date adjExpireDate = (Date)this.getModel().getValue("adjexpiredate");
        if (EmptyUtil.isNoEmpty((Object)adjExpireDate) && (adjExpireDate.before((Date)this.getModel().getValue("bizdate")) || adjExpireDate.after((Date)this.getModel().getValue("adjustsettledate")))) {
            errorMsgList.add(ResManager.loadKDString((String)"\u5230\u671f\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4ea4\u6613\u65e5\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u8c03\u6574\u4ea4\u5272\u65e5\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexOptionImportPlugin_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isNoEmpty((Object)(premiumDate = (Date)this.getModel().getValue("premiumdate"))) && premiumDate.before((Date)this.getModel().getValue("bizdate"))) {
            errorMsgList.add(ResManager.loadKDString((String)"\u671f\u6743\u8d39\u652f\u4ed8\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4ea4\u6613\u65e5\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexOptionImportPlugin_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
    }
}

