/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forex;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.enums.ProductTypeEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.enums.ForexBizTypeEnum;

public class ForexSpotImportPlugin
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs args) {
        if ("contractname".equals(args.getProperty().getName()) && this.isUnitTest()) {
            this.afterImportData(null);
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        String entityName = this.getEntityName();
        ArrayList<String> errorMsgList = new ArrayList<String>();
        this.validate(e, errorMsgList);
        if ("tm_forex_forward".equals(entityName)) {
            this.validate_forward(errorMsgList);
        }
        this.dealErrorMsgList(errorMsgList);
        this.setValue();
        if ("tm_forex_forward".equals(entityName)) {
            this.setValue_forward();
        }
        this.useCreditLimit();
    }

    protected void dealErrorMsgList(List<String> errorMsgList) {
        if (EmptyUtil.isNoEmpty(errorMsgList)) {
            StringBuilder errorMsg = new StringBuilder();
            for (String msg : errorMsgList) {
                errorMsg.append(msg);
                errorMsg.append('\n');
            }
            if (!this.isUnitTest()) {
                throw new KDBizException(errorMsg.toString());
            }
        }
    }

    protected void validate(ImportDataEventArgs e, List<String> errorMsgList) {
        String entityName;
        String pair;
        String[] array;
        HasPermOrgResult result;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        DynamicObject counterParty = (DynamicObject)this.getModel().getValue("counterparty");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            errorMsgList.add(ResManager.loadResFormat((String)"\u4ea4\u6613\u4e3b\u4f53%s\u672a\u80fd\u5339\u914d\u5230\u8bb0\u5f55\u3002", (String)"ForexSpotImportPlugin_1", (String)"tmc-tm-formplugin", (Object[])new Object[]{this.getNumber(e, "org")}));
        }
        if (EmptyUtil.isEmpty((DynamicObject)counterParty)) {
            errorMsgList.add(ResManager.loadResFormat((String)"\u4ea4\u6613\u5bf9\u624b%s\u672a\u80fd\u5339\u914d\u5230\u8bb0\u5f55\u3002", (String)"ForexSpotImportPlugin_3", (String)"tmc-tm-formplugin", (Object[])new Object[]{this.getNumber(e, "counterparty")}));
        }
        if (EmptyUtil.isEmpty((DynamicObject)priceRule)) {
            errorMsgList.add(ResManager.loadResFormat((String)"\u5b9a\u4ef7\u89c4\u5219%s\u672a\u80fd\u5339\u914d\u5230\u8bb0\u5f55\u3002", (String)"ForexSpotImportPlugin_5", (String)"tmc-tm-formplugin", (Object[])new Object[]{this.getNumber(e, "pricerule")}));
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)org) && (result = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"08", (String)this.getView().getFormShowParameter().getAppId(), (String)this.getModel().getDataEntityType().getName(), (String)"47156aff000000ac")) != null && !result.hasAllOrgPerm() && result.getHasPermOrgs() != null && !result.getHasPermOrgs().contains(org.getLong("id"))) {
            errorMsgList.add(ResManager.loadResFormat((String)"%s\u65e0\u8be5\u4ea4\u6613\u4e3b\u4f53\u7684\u6743\u9650\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_6", (String)"tmc-tm-formplugin", (Object[])new Object[]{org.get("number")}));
        }
        if ((array = (pair = (String)this.getModel().getValue("pair")).split("/")).length != 2) {
            errorMsgList.add(ResManager.loadResFormat((String)"%s\u8d27\u5e01\u5bf9\u683c\u5f0f\u9519\u8bef\u3002", (String)"ForexSpotImportPlugin_7", (String)"tmc-tm-formplugin", (Object[])new Object[]{pair}));
            return;
        }
        boolean b = this.validateIsExistCurrency(array[0], errorMsgList);
        if (!this.validateIsExistCurrency(array[1], errorMsgList)) {
            return;
        }
        if (!b) {
            return;
        }
        boolean isCreditUse = this.isCreditUse();
        if (isCreditUse && EmptyUtil.isNoEmpty((DynamicObject)counterParty) && !"bd_finorginfo".equals(counterParty.get("partytype"))) {
            errorMsgList.add(ResManager.loadResFormat((String)"\u4ea4\u6613\u5bf9\u624b%s\u7684\u7c7b\u578b\u4e0d\u662f\u5408\u4f5c\u91d1\u878d\u673a\u6784\uff0c\u4ea4\u6613\u4e0d\u80fd\u5360\u7528\u6388\u4fe1\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_8", (String)"tmc-tm-formplugin", (Object[])new Object[]{counterParty.get("number")}));
        }
        if (isCreditUse && EmptyUtil.isEmpty((Object)this.getModel().getValue("creditvariety"))) {
            errorMsgList.add(ResManager.loadKDString((String)"\u4ea4\u6613\u5360\u7528\u6388\u4fe1=\u662f\uff0c\u6388\u4fe1\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_22", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        if (isCreditUse) {
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            DynamicObject creditUse = (DynamicObject)this.getModel().getValue("credituse");
            if (EmptyUtil.isNoEmpty((DynamicObject)creditUse)) {
                if (amount.compareTo((creditUse = BusinessDataServiceHelper.loadSingle((Object)creditUse.get("id"), (String)creditUse.getDynamicObjectType().getName(), (String)"avaramt")).getBigDecimal("avaramt")) > 0) {
                    errorMsgList.add(ResManager.loadResFormat((String)"\u5360\u7528\u6388\u4fe1%s\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_10", (String)"tmc-tm-formplugin", (Object[])new Object[]{creditUse.getString("number")}));
                }
            } else if (EmptyUtil.isEmpty((Object)this.getValue(e, "credituse"))) {
                errorMsgList.add(ResManager.loadKDString((String)"\u4ea4\u6613\u5360\u7528\u6388\u4fe1=\u662f\uff0c\u5360\u7528\u6388\u4fe1\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_23", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            } else {
                errorMsgList.add(ResManager.loadResFormat((String)"\u5360\u7528\u6388\u4fe1%s\u672a\u80fd\u5339\u914d\u5230\u8bb0\u5f55\u3002", (String)"ForexSpotImportPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[]{this.getNumber(e, "credituse")}));
            }
        }
        if ("tm_forex".equals(entityName = this.getEntityName())) {
            Date bizDate = (Date)this.getModel().getValue("bizdate");
            Date settleDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)((DynamicObjectCollection)this.getModel().getValue("workcalendar")), (Date)bizDate, (int)((Integer)this.getModel().getValue("settledelay")));
            this.getModel().setValue("settledate", (Object)settleDate);
        }
        this.dealForexQuoteInfo(entityName, errorMsgList);
    }

    protected boolean isUnitTest() {
        String contractName = (String)this.getModel().getValue("contractname");
        return EmptyUtil.isNoEmpty((String)contractName) && contractName.startsWith("just_for_unit_test");
    }

    private String getEntityName() {
        return this.getModel().getDataEntityType().getName();
    }

    private Object getNumber(ImportDataEventArgs e, String key) {
        if (e == null) {
            return ((DynamicObject)this.getModel().getValue(key)).get("number");
        }
        return ((JSONObject)e.getSourceData().get(key)).get((Object)"number");
    }

    private Object getValue(ImportDataEventArgs e, String key) {
        if (e == null) {
            return this.getModel().getValue(key);
        }
        return e.getSourceData().get(key);
    }

    protected boolean isCreditUse() {
        return (Boolean)this.getModel().getValue("iscredituse");
    }

    protected void dealForexQuoteInfo(String entityName, List<String> errorMsgList) {
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        if (EmptyUtil.isNoEmpty((DynamicObject)priceRule)) {
            DynamicObject forexQuote = priceRule.getDynamicObject("forexquote");
            if (EmptyUtil.isEmpty((DynamicObject)forexQuote)) {
                errorMsgList.add(ResManager.loadResFormat((String)"\u5b9a\u4ef7\u89c4\u5219%s\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"ForexSpotImportPlugin_12", (String)"tmc-tm-formplugin", (Object[])new Object[]{priceRule.get("number")}));
                return;
            }
            String pair = (String)this.getModel().getValue("pair");
            Date dm = "tm_forex_forward".equals(entityName) ? (((Boolean)this.getModel().getValue("isdaterange")).booleanValue() ? (Date)this.getModel().getValue("adjsettledate_end") : (Date)this.getModel().getValue("adjustsettledate")) : (Date)this.getModel().getValue("settledate");
            ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)((Long)forexQuote.get("id")), (String)pair, (Date)((Date)this.getModel().getValue("bizdate")), (Date)dm);
            this.getModel().setValue("fxquote", (Object)forexQuoteInfo.getFxquote());
        }
    }

    private void validate_forward(List<String> errorMsgList) {
        boolean isDateRange;
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        String pair = (String)this.getModel().getValue("pair");
        if (DeliveryWayEnum.non_deliverable.getValue().equals(this.getModel().getValue("deliveryway"))) {
            DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
            if (EmptyUtil.isEmpty((DynamicObject)settleCurrency)) {
                errorMsgList.add(ResManager.loadKDString((String)"\u4ea4\u5272\u65b9\u5f0f=\u65e0\u672c\u91d1\u4ea4\u5272\u65f6\uff0c\u7ed3\u7b97\u5e01\u5fc5\u5f55\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_24", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            } else {
                String settleCurrencyNumber = settleCurrency.getString("number");
                if (!pair.contains(settleCurrencyNumber)) {
                    errorMsgList.add(ResManager.loadResFormat((String)"\u7ed3\u7b97\u5e01%s\u4e0d\u662f\u8d27\u5e01\u5bf9\u4e2d\u7684\u5e01\u79cd\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_14", (String)"tmc-tm-formplugin", (Object[])new Object[]{settleCurrencyNumber}));
                }
            }
        }
        if (!(isDateRange = ((Boolean)this.getModel().getValue("isdaterange")).booleanValue())) {
            Date settleDate = (Date)this.getModel().getValue("settledate");
            if (EmptyUtil.isEmpty((Object)settleDate)) {
                errorMsgList.add(ResManager.loadKDString((String)"\u62e9\u671f=\u5426\u65f6\uff0c\u4ea4\u5272\u65e5\u5fc5\u5f55\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_25", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            } else if (bizDate.after(settleDate)) {
                errorMsgList.add(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4ea4\u6613\u65e5\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_16", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
        } else {
            Date settleDate_start = (Date)this.getModel().getValue("settledate_start");
            if (EmptyUtil.isEmpty((Object)settleDate_start)) {
                errorMsgList.add(ResManager.loadKDString((String)"\u62e9\u671f=\u662f\u65f6\uff0c\u4ea4\u5272\u65e5\u533a\u95f4.\u5f00\u59cb\u5fc5\u5f55\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_26", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            } else if (bizDate.after(settleDate_start)) {
                errorMsgList.add(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5.\u5f00\u59cb\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4ea4\u6613\u65e5\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_19", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            Date settleDate_end = (Date)this.getModel().getValue("settledate_end");
            if (EmptyUtil.isEmpty((Object)settleDate_end)) {
                errorMsgList.add(ResManager.loadKDString((String)"\u62e9\u671f=\u662f\u65f6\uff0c\u4ea4\u5272\u65e5\u533a\u95f4.\u7ed3\u675f\u5fc5\u5f55\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_27", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            } else if (bizDate.after(settleDate_end)) {
                errorMsgList.add(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5.\u7ed3\u675f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u4ea4\u6613\u65e5\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u4e0a\u4f20\u3002", (String)"ForexSpotImportPlugin_20", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    protected void setValue() {
        this.getModel().setValue("bizrestamt", this.getModel().getValue("amount"));
        this.setValue_finAssetType();
        this.setValue_deliveryWay();
        this.setValue_bizType();
        this.setValue_businessInfo();
    }

    private void setValue_forward() {
        String pair = (String)this.getModel().getValue("pair");
        this.setValue_settleDelay();
        DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
        if (EmptyUtil.isEmpty((DynamicObject)settleCurrency)) {
            this.getModel().setValue("settlecurrency", this.getCurrencyByNumber(pair.split("/")[1]).get("id"));
        }
        this.setValue_dateAdjustMethod();
        boolean isDateRange = (Boolean)this.getModel().getValue("isdaterange");
        if (!isDateRange) {
            this.setTerm("settledate", "term");
            this.setAdjSettleDate("settledate", "adjustsettledate");
        } else {
            this.setTerm("settledate_start", "term");
            this.setAdjSettleDate("settledate_start", "adjsettledate_start");
            this.setTerm("settledate_end", "term_end");
            this.setAdjSettleDate("settledate_end", "adjsettledate_end");
        }
    }

    protected void setValue_settleDelay() {
        DynamicObject protectType = (DynamicObject)this.getModel().getValue("protecttype");
        if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
            this.getModel().setValue("settledelay", (Object)2);
            return;
        }
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        DynamicObjectCollection workCalendar = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        boolean isDateRange = (Boolean)this.getModel().getValue("isdaterange");
        Date date = !isDateRange ? (Date)this.getModel().getValue("settledate") : (Date)this.getModel().getValue("settledate_start");
        int diffWorkDays = Math.min(TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)workCalendar, (Date)bizDate, (Date)date), 2);
        this.getModel().setValue("settledelay", (Object)diffWorkDays);
    }

    protected void setValue_dateAdjustMethod() {
        if (EmptyUtil.isEmpty((String)"dateadjustmethod")) {
            this.getModel().setValue("dateadjustmethod", (Object)AdjustMethodEnum.forward.getValue());
        }
    }

    private void setValue_businessInfo() {
        String pair = (String)this.getModel().getValue("pair");
        String[] array = pair.split("/");
        DynamicObject leftCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)array[0])});
        DynamicObject rightCurrency = QueryServiceHelper.queryOne((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)array[1])});
        this.getModel().setValue("currency", leftCurrency.get("id"));
        this.getModel().setValue("sellcurrency", rightCurrency.get("id"));
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        BigDecimal spotRate = (BigDecimal)this.getModel().getValue("spotrate");
        boolean isPairMatchForexQuote = pair.equals(this.getModel().getValue("fxquote"));
        if (isPairMatchForexQuote) {
            this.getModel().setValue("sellamount", (Object)amount.multiply(spotRate));
        } else {
            this.getModel().setValue("sellamount", (Object)amount.divide(spotRate, 10, 4));
        }
    }

    protected void setValue_bizType() {
        if (this.isUnitTest()) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String pair = (String)this.getModel().getValue("pair");
        String tradeDirect = (String)this.getModel().getValue("tradedirect");
        DynamicObject exCurrencyConfig = this.getExCurrency(org.get("id"));
        String[] array = pair.split("/");
        boolean isContainLeft = this.containCurrency(exCurrencyConfig, array[0]);
        boolean isContainRight = this.containCurrency(exCurrencyConfig, array[1]);
        if (isContainLeft && isContainRight) {
            this.getModel().setValue("biztype", (Object)"");
            throw new KDBizException(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u9009\u62e9\u9519\u8bef\uff08\u9009\u62e9\u7684\u4e24\u5e01\u79cd\u5747\u4e3a\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff09\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ForexBsInfoEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        if (isContainRight && TradeDirectionEnum.buy.getValue().equals(tradeDirect) || isContainLeft && TradeDirectionEnum.sell.getValue().equals(tradeDirect)) {
            this.getModel().setValue("biztype", (Object)ForexBizTypeEnum.buy.getValue());
        } else if (isContainRight && TradeDirectionEnum.sell.getValue().equals(tradeDirect) || isContainLeft && TradeDirectionEnum.buy.getValue().equals(tradeDirect)) {
            this.getModel().setValue("biztype", (Object)ForexBizTypeEnum.sell.getValue());
        } else {
            this.getModel().setValue("biztype", (Object)ForexBizTypeEnum.diff.getValue());
        }
    }

    protected boolean containCurrency(DynamicObject exCurrencyConfig, String currencyNumber) {
        DynamicObjectCollection exCurrencyCol = exCurrencyConfig.getDynamicObjectCollection("excurrency");
        for (DynamicObject oneCurrency : exCurrencyCol) {
            if (!currencyNumber.equals(oneCurrency.getDynamicObject("fbasedataid").getString("number"))) continue;
            return true;
        }
        return false;
    }

    protected DynamicObject getExCurrency(Object orgId) {
        QFilter filter_org = new QFilter("org", "=", orgId);
        QFilter filter_enable = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject exCurrencyConfig = TmcDataServiceHelper.loadSingle((String)"tbd_excurrency", (String)"excurrency", (QFilter[])new QFilter[]{filter_org, filter_enable});
        if (EmptyUtil.isEmpty((DynamicObject)exCurrencyConfig)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\u3002", (String)"ForexSpotImportPlugin_17", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
        }
        return exCurrencyConfig;
    }

    protected void setValue_deliveryWay() {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("deliveryway"))) {
            this.getModel().setValue("deliveryway", (Object)DeliveryWayEnum.deliverable.getValue());
        }
    }

    protected void setValue_finAssetType() {
        this.getModel().setValue("finassettype", (Object)"currentprofit");
    }

    protected void setAdjSettleDate(String dateProp, String adjDateProp) {
        Date settleDate = (Date)this.getModel().getValue(dateProp);
        DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        String dateAdjMtd = (String)this.getModel().getValue("dateadjustmethod");
        AdjustMethodEnum adjMtdEnum = AdjustMethodEnum.valueOf((String)dateAdjMtd);
        Date adjSettleDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)settleDate, (AdjustMethodEnum)adjMtdEnum);
        this.getModel().setValue(adjDateProp, (Object)adjSettleDate);
    }

    protected void setTerm(String dateProp, String termProp) {
        Date settleDate = (Date)this.getModel().getValue(dateProp);
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        Date offsetDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)bizDate, (int)2);
        DynamicObject protectType = (DynamicObject)this.getModel().getValue("protecttype");
        if (ProductTypeEnum.FOREXFORWARD.getId().equals(protectType.getString("id"))) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)2);
        } else if (!settleDate.after(offsetDate)) {
            int offset_new = TradeBusinessHelper.callSettleDelayDay((DynamicObjectCollection)wc, (Date)bizDate, (Date)settleDate);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)offset_new);
        } else {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"settledelay", (Object)2);
        }
        String term = TcDateUtils.getDiffYMD((Date)offsetDate, (Date)settleDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)termProp, (Object)term);
    }

    protected DynamicObject getCurrencyByNumber(String number) {
        return QueryServiceHelper.queryOne((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
    }

    private boolean validateIsExistCurrency(String number, List<String> errorMsgList) {
        if (!QueryServiceHelper.exists((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)})) {
            errorMsgList.add(ResManager.loadResFormat((String)"\u4e0d\u5b58\u5728\u8d27\u5e01\u5bf9\u7684\u5e01\u79cd%s\u3002", (String)"ForexSpotImportPlugin_21", (String)"tmc-tm-formplugin", (Object[])new Object[]{number}));
            return false;
        }
        return true;
    }

    protected void useCreditLimit() {
        if (this.isCreditUse()) {
            this.getModel().setValue("id", (Object)DBServiceHelper.genGlobalLongId());
            CreditLimitUseBean useBean = new CreditLimitUseBean();
            useBean.setPkId((Long)this.getModel().getValue("id"));
            String entityName = this.getModel().getDataEntityType().getName();
            useBean.setEntityName(entityName);
            useBean.setOrgId(Long.valueOf(((DynamicObject)this.getModel().getValue("org")).getLong("id")));
            DynamicObject counterparty = (DynamicObject)this.getModel().getValue("counterparty");
            QFilter qFilter = new QFilter("number", "=", (Object)counterparty.getString("number"));
            DynamicObject finOrg = TmcDataServiceHelper.loadSingle((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{qFilter});
            useBean.setFinOrgId(Long.valueOf(finOrg.getLong("id")));
            useBean.setCurrencyId(Long.valueOf(((DynamicObject)this.getModel().getValue("currency")).getLong("id")));
            useBean.setCreditTypeId(Long.valueOf(((DynamicObject)this.getModel().getValue("creditvariety")).getLong("id")));
            useBean.setPreOccupy(Boolean.valueOf(false));
            BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
            if ("tm_forex_swaps".equals(entityName)) {
                boolean near = (Boolean)this.getModel().getValue("nearend");
                boolean far = (Boolean)this.getModel().getValue("farend");
                if (near && far) {
                    amount = amount.add(amount);
                }
            }
            useBean.setMaxAmt(amount);
            useBean.setCreditRatio(Constants.ONE_HUNDRED);
            useBean.setBizAmt(amount);
            DynamicObject creditLimit = (DynamicObject)this.getModel().getValue("credituse");
            useBean.setCreditLimitId(Long.valueOf(creditLimit.getLong("id")));
            useBean.setCreditLimitNo(creditLimit.getString("number"));
            CreditLimitServiceHelper.autoUseCreditLimit((CreditLimitUseBean)useBean);
        }
    }
}

