/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forexward;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.formplugin.trade.AbstractTradeBillEdit;

public class ForexForwardEdit
extends AbstractTradeBillEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(ForexForwardEdit.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit settleCurrency = (BasedataEdit)this.getView().getControl("settlecurrency");
        settleCurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setControlByDeliveryWay();
        this.setTermTitle();
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW && this.getView().getFormShowParameter().getCustomParams().containsKey("iscopy") && ((Boolean)this.getView().getFormShowParameter().getCustomParam("iscopy")).booleanValue()) {
            this.dealForexQuoteInfo();
        }
    }

    private void setControlByDeliveryWay() {
        String deliveryWay = (String)this.getModel().getValue("deliveryway");
        boolean isNonDelivery = DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay);
        BasedataEdit edit = (BasedataEdit)this.getView().getControl("settlecurrency");
        edit.setMustInput(isNonDelivery);
        this.getView().setVisible(Boolean.valueOf(isNonDelivery), new String[]{"cfprincipal", "cfprincipal_s", "cfratefixdate", "cfratefixdate_s"});
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        String deliveryWay = (String)this.getModel().getValue("deliveryway");
        switch (propName) {
            case "bizdate": 
            case "pricerule": 
            case "tradedirect": 
            case "adjustsettledate": 
            case "adjsettledate_end": {
                this.dealForexQuoteInfo();
                break;
            }
            case "pair": {
                if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("sourcebillid"))) {
                    if ("buy".equals(this.getModel().getValue("tradedirect"))) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradedirect", (Object)"sell");
                    } else if ("sell".equals(this.getModel().getValue("tradedirect"))) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradedirect", (Object)"buy");
                    }
                }
                this.dealForexQuoteInfo();
                break;
            }
            case "sellcurrency": {
                if (!DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) break;
                this.getModel().setValue("settlecurrency", this.getModel().getValue(propName));
                break;
            }
            case "deliveryway": {
                if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
                    this.getModel().setValue("settlecurrency", this.getModel().getValue("sellcurrency"));
                } else {
                    this.getModel().setValue("settlecurrency", null);
                }
                this.setControlByDeliveryWay();
                break;
            }
            case "isdaterange": {
                this.setTermTitle();
            }
        }
    }

    private void setTermTitle() {
        boolean isDateRange = (Boolean)this.getModel().getValue("isdaterange");
        TextEdit edit = (TextEdit)this.getView().getControl("term");
        if (isDateRange) {
            edit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u77ed\u671f\u9650(ymd)", (String)"ForexForwardEdit_1", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
        } else {
            edit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u671f\u9650(ymd)", (String)"ForexForwardEdit_2", (String)"tmc-tm-formplugin", (Object[])new Object[0])));
        }
    }

    private void dealForexQuoteInfo() {
        boolean isDateRange;
        Date dm;
        String pair;
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceRule, pair = (String)this.getModel().getValue("pair"), dm = (isDateRange = ((Boolean)this.getModel().getValue("isdaterange")).booleanValue()) ? (Date)this.getModel().getValue("adjsettledate_end") : (Date)this.getModel().getValue("adjustsettledate")})) {
            if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"PriceRuleWithoutFX", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            Date bizdate = (Date)this.getModel().getValue("bizdate");
            Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            ForexQuoteInfo info = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, (Date)dm);
            String forexQuote = info.getFxquote();
            String dir = (String)this.getModel().getValue("tradedirect");
            BigDecimal exRate = TradeDirectionEnum.buy.getValue().equals(dir) && pair.equals(forexQuote) || TradeDirectionEnum.sell.getValue().equals(dir) && !pair.equals(forexQuote) ? info.getSellPrice() : info.getBuyPrice();
            this.getModel().setValue("fxquote", (Object)forexQuote);
            this.getModel().setValue("spotrate", (Object)exRate);
        } else {
            this.getModel().setValue("spotrate", null);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"settlecurrency")) {
            DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("currency");
            DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
            ArrayList<Long> ids = new ArrayList<Long>();
            if (EmptyUtil.isNoEmpty((DynamicObject)buyCurrency)) {
                ids.add(buyCurrency.getLong("id"));
            }
            if (EmptyUtil.isNoEmpty((DynamicObject)sellCurrency)) {
                ids.add(sellCurrency.getLong("id"));
            }
            QFilter qFilter = new QFilter("id", "in", ids);
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }
}

