/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forexward;

import java.util.Date;
import java.util.EventObject;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.DateRangeEdit;
import kd.tmc.fbp.common.enums.AdjustMethodEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.business.TradeBusinessHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.fbp.common.util.TermUtils;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class ForexFwardAdjustPlugin
extends AbstractTmcBillEdit {
    public void afterCreateNewData(EventObject e) {
        if (OperationStatus.ADDNEW.getValue() == this.getView().getFormShowParameter().getStatus().getValue()) {
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("reqnoteno"))) {
                return;
            }
            this.initDate();
        }
    }

    public void afterCopyData(EventObject e) {
        this.bizDate_changed();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initControl();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "isdaterange": {
                this.initDate();
                this.initControl();
                break;
            }
            case "bizdate": 
            case "workcalendar": 
            case "dateadjustmethod": {
                this.bizDate_changed();
                this.initControl();
                break;
            }
            case "settledate": {
                this.setTerm(propName, "term");
                this.setAdjDeliveryDate(propName, "adjustsettledate");
                break;
            }
            case "settledate_start": {
                this.setTerm(propName, "term");
                this.setAdjDeliveryDate(propName, "adjsettledate_start");
                break;
            }
            case "settledate_end": {
                this.setTerm(propName, "term_end");
                this.setAdjDeliveryDate(propName, "adjsettledate_end");
                break;
            }
            case "term": {
                if (((Boolean)this.getModel().getValue("isdaterange")).booleanValue()) {
                    this.setDeliveryDate("term", "settledate_start");
                    this.setAdjDeliveryDate("settledate_start", "adjsettledate_start");
                    break;
                }
                this.setDeliveryDate("term", "settledate");
                this.setAdjDeliveryDate("settledate", "adjustsettledate");
                break;
            }
            case "term_end": {
                this.setDeliveryDate(propName, "settledate_end");
                this.setAdjDeliveryDate("settledate_end", "adjsettledate_end");
            }
        }
    }

    private void bizDate_changed() {
        if (((Boolean)this.getModel().getValue("isdaterange")).booleanValue()) {
            this.setDeliveryDate("term", "settledate_start");
            this.setAdjDeliveryDate("settledate_start", "adjsettledate_start");
            this.setDeliveryDate("term_end", "settledate_end");
            this.setAdjDeliveryDate("settledate_end", "adjsettledate_end");
        } else {
            this.setDeliveryDate("term", "settledate");
            this.setAdjDeliveryDate("settledate", "adjustsettledate");
        }
    }

    private void initDate() {
        if (((Boolean)this.getModel().getValue("isdaterange")).booleanValue()) {
            this.setDeliveryDate("term", "settledate_start");
            this.setAdjDeliveryDate("settledate_start", "adjsettledate_start");
            this.setDeliveryDate("term_end", "settledate_end");
            this.setAdjDeliveryDate("settledate_end", "adjsettledate_end");
            this.getModel().setValue("settledate", null);
            this.getModel().setValue("adjustsettledate", null);
        } else {
            this.setDeliveryDate("term", "settledate");
            this.setAdjDeliveryDate("settledate", "adjustsettledate");
            this.getModel().setValue("settledate_start", null);
            this.getModel().setValue("settledate_end", null);
            this.getModel().setValue("adjsettledate_start", null);
            this.getModel().setValue("adjsettledate_end", null);
        }
    }

    private void initControl() {
        if (((Boolean)this.getModel().getValue("isdaterange")).booleanValue()) {
            this.setMinDate("settledaterange");
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"term_end"});
        } else {
            this.setMinDate("settledate");
        }
    }

    private void setMinDate(String dateProp) {
        Date date = (Date)this.getModel().getValue("bizdate");
        DynamicObjectCollection workCalendar = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        String dateAdjustMethod = (String)this.getModel().getValue("dateadjustmethod");
        AdjustMethodEnum adjustMethodEnum = EmptyUtil.isNoEmpty((String)dateAdjustMethod) ? AdjustMethodEnum.valueOf((String)dateAdjustMethod) : AdjustMethodEnum.forward;
        date = TradeBusinessHelper.callDelayAdjustSettleDate((DynamicObjectCollection)workCalendar, (Date)date, (int)2, (AdjustMethodEnum)adjustMethodEnum);
        date = TcDateUtils.getNextDay((Date)date, (int)1);
        if (this.getControl(dateProp) instanceof DateRangeEdit) {
            ((DateRangeEdit)this.getControl(dateProp)).setMinDate(date);
        } else {
            ((DateEdit)this.getControl(dateProp)).setMinDate(date);
        }
    }

    protected void verifyInput(String key, Object value, BeforeFieldPostBackEvent e) {
        switch (key) {
            case "term_end": {
                if (!TermUtils.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) {
                    e.setCancel(true);
                    this.getView().updateView(key);
                    return;
                }
                Date currentDate = TcDateUtils.getCurrentDate();
                if (TermUtils.getDateByTerm((String)((String)e.getValue()), (Date)currentDate).compareTo(TermUtils.getDateByTerm((String)((String)this.getModel().getValue("term")), (Date)currentDate)) >= 0) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u957f\u671f\u9650\u9700\u5927\u4e8e\u7b49\u4e8e\u77ed\u671f\u9650\u3002", (String)"ForexFwardAdjustPlugin_4", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                this.getView().updateView(key);
                e.setCancel(true);
                break;
            }
            case "term": {
                if (!TermUtils.isRightFormat((IDataModel)this.getModel(), (IFormView)this.getView(), (String)value.toString())) {
                    e.setCancel(true);
                    this.getView().updateView(key);
                    return;
                }
                if (((Boolean)this.getModel().getValue("isdaterange")).booleanValue()) {
                    Date currentDate = TcDateUtils.getCurrentDate();
                    if (TermUtils.getDateByTerm((String)((String)e.getValue()), (Date)currentDate).compareTo(TermUtils.getDateByTerm((String)((String)this.getModel().getValue("term_end")), (Date)currentDate)) > 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u77ed\u671f\u9650\u9700\u5c0f\u4e8e\u7b49\u4e8e\u957f\u671f\u9650\u3002", (String)"ForexFwardAdjustPlugin_3", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                        this.getView().updateView(key);
                        e.setCancel(true);
                    }
                }
                if (!"0d".equals(e.getValue())) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u9700\u5927\u4e8e\u7b49\u4e8e1d\u3002", (String)"ForexFwardAdjustPlugin_2", (String)"tmc-tm-formplugin", (Object[])new Object[]{this.getModel().getProperty(key).getDisplayName().getLocaleValue()}), Integer.valueOf(2000));
                this.getView().updateView(key);
                e.setCancel(true);
                break;
            }
            case "bizdate": {
                if (!EmptyUtil.isEmpty((Object)value)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SettleAdjustFarPlugin_3", (String)"tmc-tm-formplugin", (Object[])new Object[]{this.getModel().getProperty(key).getDisplayName().getLocaleValue()}), Integer.valueOf(2000));
                this.getView().updateView(key);
                e.setCancel(true);
                return;
            }
            case "settledate": {
                if (((Boolean)this.getModel().getValue("isdaterange")).booleanValue() || !EmptyUtil.isEmpty((Object)value)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SettleAdjustFarPlugin_3", (String)"tmc-tm-formplugin", (Object[])new Object[]{this.getModel().getProperty(key).getDisplayName().getLocaleValue()}), Integer.valueOf(2000));
                this.getView().updateView(key);
                e.setCancel(true);
                return;
            }
            case "settledaterange": {
                if (!((Boolean)this.getModel().getValue("isdaterange")).booleanValue() || !EmptyUtil.isEmpty((Object)value)) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u5272\u65e5\u533a\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ForexFwardAdjustPlugin_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
                this.getView().updateView(key);
                e.setCancel(true);
                return;
            }
        }
    }

    private void setDeliveryDate(String termProp, String dateProp) {
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        if (EmptyUtil.isEmpty((Object)bizDate)) {
            return;
        }
        DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        String term = (String)this.getModel().getValue(termProp);
        Date offsetDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)bizDate, (int)2);
        Date settleDate = TermUtils.getNextDateByBaseDate4ymd((String)term, (Date)offsetDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)dateProp, (Object)settleDate);
        if ("settledate_start".equals(dateProp) || "settledate_end".equals(dateProp)) {
            this.getView().updateView("settledaterange");
        }
    }

    private void setTerm(String dateProp, String termProp) {
        Date settleDate = (Date)this.getModel().getValue(dateProp);
        Date bizDate = (Date)this.getModel().getValue("bizdate");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{settleDate, bizDate})) {
            return;
        }
        DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        Date offsetDate = TradeBusinessHelper.callSettleDelayDate((DynamicObjectCollection)wc, (Date)bizDate, (int)2);
        String term = TcDateUtils.getDiffYMD((Date)offsetDate, (Date)settleDate);
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)termProp, (Object)term);
    }

    private void setAdjDeliveryDate(String dateProp, String adjDateProp) {
        Date settleDate = (Date)this.getModel().getValue(dateProp);
        DynamicObjectCollection wc = (DynamicObjectCollection)this.getModel().getValue("workcalendar");
        String dateAdjMtd = (String)this.getModel().getValue("dateadjustmethod");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dateAdjMtd, settleDate})) {
            this.getModel().setValue(adjDateProp, null);
            return;
        }
        AdjustMethodEnum adjMtdEnum = AdjustMethodEnum.valueOf((String)dateAdjMtd);
        Date adjSettleDate = TradeBusinessHelper.callAdjustSettleDate((DynamicObjectCollection)wc, (Date)settleDate, (AdjustMethodEnum)adjMtdEnum);
        this.getModel().setValue(adjDateProp, (Object)adjSettleDate);
    }
}

