/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.forxoption;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.helper.service.MarketDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.CombReqNoteEnum;
import kd.tmc.tm.common.enums.DeliveryWayEnum;
import kd.tmc.tm.common.helper.ForexHelper;
import kd.tmc.tm.common.helper.ForexOptionsHelper;
import kd.tmc.tm.formplugin.trade.AbstractTradeBillEdit;

public class ForexOptionsEdit
extends AbstractTradeBillEdit
implements BeforeF7SelectListener,
ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit pair = (TextEdit)this.getView().getControl("pair");
        pair.addButtonClickListener((ClickListener)this);
        BasedataEdit settleCurrency = (BasedataEdit)this.getView().getControl("settlecurrency");
        settleCurrency.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit market = (BasedataEdit)this.getView().getControl("market_bs");
        market.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.buildEntryBS();
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setSettleCurrencyMustInput();
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("sellamount"))) {
            this.calAmountBS(0);
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.setBiztype();
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        String propName = args.getProperty().getName();
        int rowIndex = args.getChangeSet()[0].getRowIndex();
        Object newValue = args.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "deliveryway": {
                this.setSettleCurrencyMustInput();
                if (!DeliveryWayEnum.non_deliverable.getValue().equals(this.getModel().getValue("deliveryway"))) break;
                this.getModel().setValue("settlecurrency", this.getModel().getValue("sellcurrency"));
                break;
            }
            case "pair": {
                if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("sourcebillid"))) {
                    if ("call".equals(this.getModel().getValue("tradetype"))) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradetype", (Object)"put");
                    } else if ("put".equals(this.getModel().getValue("tradetype"))) {
                        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tradetype", (Object)"call");
                    }
                }
                this.clearAmountBS();
                if (DeliveryWayEnum.non_deliverable.getValue().equals(this.getModel().getValue("deliveryway"))) {
                    this.getModel().setValue("settlecurrency", this.getModel().getValue("sellcurrency"));
                } else {
                    this.getModel().setValue("settlecurrency", null);
                }
                this.dealForexQuoteInfo();
                this.buildEntryBS();
                this.setBiztype();
                break;
            }
            case "tradetype": 
            case "tradedirect": {
                this.dealForexQuoteInfo();
                this.buildEntryBS();
                this.setBiztype();
                this.getModel().setDataChanged(true);
                break;
            }
            case "pricerule": 
            case "bizdate": 
            case "settledate": 
            case "adjustsettledate": {
                this.dealForexQuoteInfo();
                break;
            }
            case "sellcurrency": {
                this.setPremiumCurrency();
                break;
            }
            case "premiumcurrency": {
                this.getModel().setValue("premium", (Object)BigDecimal.ZERO);
                this.getModel().setValue("paybankacct", null);
                break;
            }
            case "currency_bs": {
                this.clearAmountBS();
                break;
            }
            case "amount_bs": {
                this.calAmountBS(rowIndex);
                break;
            }
            case "market_bs": {
                if (rowIndex == 0) {
                    this.getModel().setValue("buymarket", newValue);
                    break;
                }
                this.getModel().setValue("sellmarket", newValue);
                break;
            }
            case "exchangerate": {
                this.calAmountBS(0);
                break;
            }
            case "amount": {
                this.getModel().setValue("bizrestamt", newValue);
            }
        }
    }

    private void setSettleCurrencyMustInput() {
        String deliveryWay = (String)this.getModel().getValue("deliveryway");
        if (DeliveryWayEnum.deliverable.getValue().equals(deliveryWay)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)false, (String[])new String[]{"settlecurrency"});
        } else if (DeliveryWayEnum.non_deliverable.getValue().equals(deliveryWay)) {
            TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"settlecurrency"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "settlecurrency": {
                this.setSettleCurrencyFilter(evt);
                break;
            }
            case "market_bs": {
                this.setMarketFilter(evt);
            }
        }
    }

    private void setSettleCurrencyFilter(BeforeF7SelectEvent evt) {
        String currencyPair = (String)this.getModel().getValue("pair");
        if ("".equals(currencyPair)) {
            TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String)"pair");
            evt.setCancel(true);
        } else {
            List<String> pairs = Arrays.asList(currencyPair.split("/"));
            QFilter qFilter = new QFilter("number", "in", pairs);
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void setMarketFilter(BeforeF7SelectEvent evt) {
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency_bs");
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            QFilter qFilter = new QFilter("currency.id", "=", currency.getPkValue());
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(qFilter);
        }
    }

    private void dealForexQuoteInfo() {
        Date settleDate;
        String pair;
        DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{priceRule, pair = (String)this.getModel().getValue("pair"), settleDate = (Date)this.getModel().getValue("settledate")})) {
            if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"PriceRuleWithoutFX", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            Date bizdate = (Date)this.getModel().getValue("bizdate");
            Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
            ForexQuoteInfo info = MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, (Date)bizdate, (Date)settleDate);
            String forexQuote = info.getFxquote();
            this.getModel().setValue("fxquote", (Object)forexQuote);
            String dir = (String)this.getModel().getValue("tradedirect");
            String tradeType = (String)this.getModel().getValue("tradetype");
            if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dir, tradeType})) {
                BigDecimal exRate = pair.equals(forexQuote) && ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)tradeType) || !pair.equals(forexQuote) && ForexOptionsHelper.callAndSellORPutAndBuy((String)dir, (String)tradeType) ? info.getSellPrice() : info.getBuyPrice();
                this.getModel().setValue("exchangerate", (Object)exRate);
            }
        } else {
            this.getModel().setValue("fxquote", null);
            this.getModel().setValue("exchangerate", (Object)BigDecimal.ZERO);
        }
    }

    private void setBiztype() {
        String[] split;
        QFilter filter_enable;
        String tradeType;
        String pair;
        String dir = (String)this.getModel().getValue("tradedirect");
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{dir, pair = (String)this.getModel().getValue("pair"), tradeType = (String)this.getModel().getValue("tradetype")})) {
            this.getModel().setValue("biztype", null);
            return;
        }
        Long orgId = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        QFilter filter_org = new QFilter("org", "=", (Object)orgId);
        DynamicObject exCurrencyConfig = TmcDataServiceHelper.loadSingle((String)"tbd_excurrency", (String)"excurrency", (QFilter[])new QFilter[]{filter_org, filter_enable = new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (EmptyUtil.isEmpty((DynamicObject)exCurrencyConfig)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff0c\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"OrgWithoutExCurrencyConfig", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection exCurrencyCol = exCurrencyConfig.getDynamicObjectCollection("excurrency");
        Set numberSet = exCurrencyCol.stream().map(s -> s.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toSet());
        if (numberSet.contains((split = pair.split("/"))[0]) && numberSet.contains(split[1])) {
            this.getModel().setValue("biztype", (Object)"");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u9009\u62e9\u9519\u8bef\uff08\u9009\u62e9\u7684\u4e24\u5e01\u79cd\u5747\u4e3a\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff09\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ForexBsInfoEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (numberSet.contains(split[0]) && ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)tradeType) || numberSet.contains(split[1]) && ForexOptionsHelper.callAndSellORPutAndBuy((String)dir, (String)tradeType)) {
            this.getModel().setValue("biztype", (Object)"sell");
        } else if (numberSet.contains(split[0]) && ForexOptionsHelper.callAndSellORPutAndBuy((String)dir, (String)tradeType) || numberSet.contains(split[1]) && ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)tradeType)) {
            this.getModel().setValue("biztype", (Object)"buy");
        } else {
            this.getModel().setValue("biztype", (Object)"diff");
        }
    }

    private void setPremiumCurrency() {
        DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
        if (EmptyUtil.isNoEmpty((DynamicObject)sellCurrency)) {
            this.getModel().setValue("premiumcurrency", sellCurrency.getPkValue());
        }
    }

    private void buildEntryBS() {
        String pair = (String)this.getModel().getValue("pair");
        String dir = (String)this.getModel().getValue("tradedirect");
        String tradeType = (String)this.getModel().getValue("tradetype");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, dir, tradeType})) {
            this.getModel().deleteEntryData("entry_bs");
            this.getModel().batchCreateNewEntryRow("entry_bs", 2);
            if (ForexOptionsHelper.callAndBuyORPutAndsell((String)dir, (String)tradeType)) {
                this.getModel().setValue("direct_bs", (Object)"buy", 0);
                this.getModel().setValue("direct_bs", (Object)"sell", 1);
            } else {
                this.getModel().setValue("direct_bs", (Object)"sell", 0);
                this.getModel().setValue("direct_bs", (Object)"buy", 1);
            }
            this.getModel().setValue("currency_bs", this.getModel().getValue("currency"), 0);
            this.getModel().setValue("currency_bs", this.getModel().getValue("sellcurrency"), 1);
            this.getModel().setValue("market_bs", this.getModel().getValue("buymarket"), 0);
            this.getModel().setValue("market_bs", this.getModel().getValue("sellmarket"), 1);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)this.getModel().getValue("amount"), (int)0);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)this.getModel().getValue("sellamount"), (int)1);
        } else {
            this.getModel().deleteEntryData("entry_bs");
            if (EmptyUtil.isEmpty((String)pair)) {
                this.getModel().setValue("currency", null);
                this.getModel().setValue("sellcurrency", null);
                this.getModel().setValue("amount", (Object)BigDecimal.ZERO);
                this.getModel().setValue("sellamount", (Object)BigDecimal.ZERO);
                this.getModel().setValue("buymarket", null);
                this.getModel().setValue("sellmarket", null);
            }
        }
        this.getView().updateView("entry_bs");
        this.getModel().setDataChanged(false);
    }

    private void clearAmountBS() {
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entry_bs");
        if (entryEntity.size() > 1) {
            this.getModel().setValue("amount_bs", (Object)BigDecimal.ZERO, 0);
            this.getModel().setValue("amount_bs", (Object)BigDecimal.ZERO, 1);
        }
    }

    private void calAmountBS(int rowIndex) {
        BigDecimal changeAmt;
        BigDecimal exchangeRate;
        String fxquote;
        String pair = (String)this.getModel().getValue("pair");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{pair, fxquote = (String)this.getModel().getValue("fxquote"), exchangeRate = (BigDecimal)this.getModel().getValue("exchangerate")}) && (changeAmt = (BigDecimal)this.getModel().getValue("amount_bs", rowIndex)) != null) {
            int setIndex;
            int n = setIndex = rowIndex == 0 ? 1 : 0;
            if (pair.equals(fxquote) && rowIndex == 0 || !pair.equals(fxquote) && rowIndex == 1) {
                BigDecimal calMultiply = changeAmt.multiply(exchangeRate);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)calMultiply, (int)setIndex);
            } else {
                BigDecimal calDivide = changeAmt.divide(exchangeRate, 6, RoundingMode.HALF_UP);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount_bs", (Object)calDivide, (int)setIndex);
            }
            this.getModel().setValue("amount", this.getModel().getValue("amount_bs", 0));
            this.getModel().setValue("sellamount", this.getModel().getValue("amount_bs", 1));
            this.getView().updateView("entry_bs");
        }
    }

    public void click(EventObject e) {
        if (((Control)e.getSource()).getKey().equals("pair")) {
            ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)"bd_currency_tc", (boolean)true);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "selectPair"));
            showParameter.setShowTitle(false);
            showParameter.setCustomParam("billFormId", (Object)"bd_currency_tc");
            QFilter qFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            String noteno = (String)this.getModel().getValue("reqnoteno");
            if (EmptyUtil.isNoEmpty((Object)this.getModel().getValue("pair"))) {
                DynamicObject buyCurrency = (DynamicObject)this.getModel().getValue("currency");
                DynamicObject sellCurrency = (DynamicObject)this.getModel().getValue("sellcurrency");
                if (EmptyUtil.isNoEmpty((String)noteno)) {
                    qFilter.and("id", "in", (Object)new Long[]{buyCurrency.getLong("id"), sellCurrency.getLong("id")});
                }
                showParameter.setSelectedRows(new Object[]{buyCurrency.getLong("id"), sellCurrency.getLong("id")});
            } else if (EmptyUtil.isNoEmpty((String)noteno)) {
                DynamicObject sourceBill;
                Object sourceBillId = this.getModel().getValue("sourcebillid");
                String source = (String)this.getModel().getValue("source");
                String buyCurrencyProp = "optionsinfo.opcurrin";
                String sellCurrencyProp = "optionsinfo.opcurrout";
                String entryRowIdProp = "optionsinfo.id";
                String soureEntityNum = "tm_reqnote";
                if (source.startsWith("combreqnote")) {
                    buyCurrencyProp = CombReqNoteEnum.OPTIONS.getEntryName() + "." + CombReqNoteEnum.OPTIONS.getEntryBuyCurrName();
                    sellCurrencyProp = CombReqNoteEnum.OPTIONS.getEntryName() + "." + CombReqNoteEnum.OPTIONS.getEntrySellCurrName();
                    entryRowIdProp = CombReqNoteEnum.OPTIONS.getEntryName() + ".id";
                    soureEntityNum = "tm_combreqnote";
                }
                if ((sourceBill = QueryServiceHelper.queryOne((String)soureEntityNum, (String)(buyCurrencyProp + "," + sellCurrencyProp), (QFilter[])new QFilter("billno", "=", (Object)noteno).and(entryRowIdProp, "=", sourceBillId).toArray())) != null && sourceBill.get(buyCurrencyProp) != null && sourceBill.get(sellCurrencyProp) != null) {
                    qFilter.and("id", "in", (Object)new Object[]{sourceBill.get(buyCurrencyProp), sourceBill.get(sellCurrencyProp)});
                }
            }
            showParameter.getListFilterParameter().getQFilters().add(qFilter);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        ListSelectedRowCollection data;
        super.closedCallBack(event);
        if ("selectPair".equals(event.getActionId()) && EmptyUtil.isNoEmpty((Object)(data = (ListSelectedRowCollection)event.getReturnData()))) {
            Object buyCurrencyId = data.get(0).getPrimaryKeyValue();
            Object sellCurrencyId = data.get(1).getPrimaryKeyValue();
            Set exCurrency = ForexHelper.getExCurrency((Long)((DynamicObject)this.getModel().getValue("org")).getLong("id"));
            if (EmptyUtil.isNoEmpty((Object)exCurrency)) {
                if (exCurrency.contains(buyCurrencyId) && exCurrency.contains(sellCurrencyId)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d27\u5e01\u5bf9\u9009\u62e9\u9519\u8bef\uff08\u9009\u62e9\u7684\u4e24\u5e01\u79cd\u5747\u4e3a\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff09\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"ForexBsInfoEdit_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u6ca1\u6709\u914d\u7f6e\u5916\u6c47\u4ea4\u6613\u672c\u4f4d\u5e01\uff0c\u65e0\u6cd5\u83b7\u53d6\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"OrgWithoutExCurrencyConfig", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject buyCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)buyCurrencyId, (String)"bd_currency");
            DynamicObject sellCurrency = TmcDataServiceHelper.loadSingleFromCache((Object)sellCurrencyId, (String)"bd_currency");
            String pair = buyCurrency.getString("number") + "/" + sellCurrency.getString("number");
            DynamicObject priceRule = (DynamicObject)this.getModel().getValue("pricerule");
            if (EmptyUtil.isNoEmpty((DynamicObject)priceRule)) {
                if (EmptyUtil.isEmpty((DynamicObject)priceRule.getDynamicObject("forexquote"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u5b9a\u4ef7\u89c4\u5219\u6ca1\u6709\u8bbe\u7f6e\u5916\u6c47\u62a5\u4ef7\u3002", (String)"PriceRuleWithoutFX", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                    return;
                }
                Long fqId = priceRule.getDynamicObject("forexquote").getLong("id");
                MarketDataServiceHelper.getForexQuoteInfo((Long)fqId, (String)pair, null, (Date)TcDateUtils.getCurrentDate());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5b9a\u4ef7\u89c4\u5219\u83b7\u53d6\u5916\u6c47\u62a5\u4ef7\u65b9\u5f0f\u3002", (String)"PriceRuleIsNull", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            }
            this.getModel().setValue("currency", buyCurrencyId);
            this.getModel().setValue("sellcurrency", sellCurrencyId);
            this.getModel().setValue("calculatecurrency", sellCurrencyId);
            this.getModel().setValue("pair", (Object)pair);
        }
    }
}

