/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.home;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.Series;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ChartClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.chart.AbstractLineChartEdit;

public class AppHomeHistogramChartPlugin
extends AbstractLineChartEdit
implements ClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btn_set"});
        HistogramChart histogramChart = (HistogramChart)this.getControl("histogramchartap");
        histogramChart.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initQueryfieldsComboItems();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        super.drawChart();
    }

    private void initQueryfieldsComboItems() {
        Object[] homeSetting = TmcDataServiceHelper.load((String)"tm_apphome_setting", (String)"billno,billno", null, (String)"projectdefault desc");
        ArrayList<String> queryList = new ArrayList<String>();
        if (EmptyUtil.isNoEmpty((Object[])homeSetting)) {
            for (int i = 0; i < homeSetting.length; ++i) {
                Object row = homeSetting[i];
                queryList.add(row.getString("billno"));
            }
            this.getModel().setValue("queryfield", (Object)homeSetting[0].getString("billno"));
        }
        this.initComboItems("queryfield", queryList);
    }

    private void initComboItems(String propertyName, List<String> itemList) {
        ArrayList propertyItems = new ArrayList();
        itemList.forEach(item -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setId(item);
            comboItem.setValue(item);
            comboItem.setCaption(new LocaleString(item));
            propertyItems.add(comboItem);
        });
        ComboEdit property = (ComboEdit)this.getControl(propertyName);
        property.setComboItems(propertyItems);
    }

    public void click(EventObject e) {
        String key;
        switch (key = ((Control)e.getSource()).getKey()) {
            case "btn_set": {
                ListShowParameter showParameter = new ListShowParameter();
                showParameter.setBillFormId("tm_apphome_setting");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setShowTitle(false);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "btn_set"));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
            case "histogramchartap": {
                String nameX = ((ChartClickEvent)e).getName();
                Number valueY = ((ChartClickEvent)e).getValue();
                this.openResultList(nameX, valueY);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)"btn_set", (CharSequence)evt.getActionId())) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void openResultList(String nameX, Number valueY) {
        String json;
        if (nameX != null && valueY != null && EmptyUtil.isNoEmpty((String)(json = this.getPageCache().get("filterFieldValues")))) {
            Map filterFieldValues = (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            String entityName = (String)filterFieldValues.get(nameX);
            String qFilter = (String)filterFieldValues.get(nameX + "qFilter");
            ListShowParameter showParameter = new ListShowParameter();
            if (StringUtils.equals((CharSequence)entityName, (CharSequence)"tm_optioncomb") || StringUtils.equals((CharSequence)entityName, (CharSequence)"tm_lowrisk")) {
                showParameter.setBillFormId(entityName);
            } else {
                showParameter.setBillFormId(entityName + "_l");
            }
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setShowTitle(false);
            QFilter filter = (QFilter)SerializationUtils.deSerializeFromBase64((String)qFilter);
            showParameter.setCustomParam("billFormId", (Object)entityName);
            showParameter.getListFilterParameter().setFilter(filter);
            this.getView().showForm((FormShowParameter)showParameter);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        super.propertyChanged(args);
        super.drawChart();
    }

    protected String getXTitleName() {
        return "";
    }

    protected String getYTitleName() {
        return "";
    }

    protected String getChartCtlName() {
        return "histogramchartap";
    }

    protected String[] getXValue() {
        ArrayList<String> dem = new ArrayList<String>();
        String queryField = (String)this.getModel().getValue("queryfield");
        QFilter filter = new QFilter("billno", "=", (Object)queryField);
        DynamicObject tradeInfo = TmcDataServiceHelper.loadSingle((String)"tm_apphome_setting", (String)"id,projecttype", (QFilter[])new QFilter[]{filter});
        if (EmptyUtil.isNotBlank((Object)tradeInfo)) {
            DynamicObjectCollection entrys = tradeInfo.getDynamicObjectCollection("entry");
            for (DynamicObject data : entrys) {
                DynamicObject projectType = data.getDynamicObject("projecttype");
                dem.add(projectType.getString("name"));
            }
        }
        return dem.toArray(new String[dem.size()]);
    }

    protected List<Object> getSeriesValue() {
        ArrayList<Object> turnover = new ArrayList<Object>();
        ArrayList<Integer> v = new ArrayList<Integer>();
        String queryField = (String)this.getModel().getValue("queryfield");
        QFilter filter = new QFilter("billno", "=", (Object)queryField);
        DynamicObject tradeInfo = TmcDataServiceHelper.loadSingle((String)"tm_apphome_setting", (String)"id,entry.projecttype,entry.conditionnumber,entry.entity", (QFilter[])new QFilter[]{filter});
        if (EmptyUtil.isNotBlank((Object)tradeInfo)) {
            DynamicObjectCollection entrys = tradeInfo.getDynamicObjectCollection("entry");
            HashMap<String, String> filterFieldValues = new HashMap<String, String>();
            for (DynamicObject data : entrys) {
                QFilter qFilterOrg;
                Object[] load;
                this.getPageCache().put("filterFieldValues", null);
                String conditonJson = data.getString("conditionnumber");
                if (StringUtils.equals((CharSequence)"", (CharSequence)conditonJson)) {
                    v.add(0);
                    continue;
                }
                String entityName = data.getString("entity");
                MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)entityName);
                CRFormula formulaObj = this.deserialize(conditonJson);
                FilterCondition filterCondition = ((CRCondition)formulaObj).getFilterCondition();
                if (filterCondition == null || filterCondition.getFilterRow().size() <= 0) continue;
                DynamicObject projectType = data.getDynamicObject("projecttype");
                FilterBuilder filterBuilder = new FilterBuilder(mainType, filterCondition);
                filterBuilder.buildFilter();
                long userOrgId = RequestContext.get().getOrgId();
                QFilter qFilter = filterBuilder.getQFilter();
                QFilter qFilterType = new QFilter("protecttype", "=", (Object)projectType.getLong("id"));
                if (StringUtils.equals((CharSequence)entityName, (CharSequence)"tm_optioncomb") || StringUtils.equals((CharSequence)entityName, (CharSequence)"tm_lowrisk")) {
                    qFilterType = null;
                }
                if (EmptyUtil.isNoEmpty((Object[])(load = TmcDataServiceHelper.load((String)entityName, (String)"id", (QFilter[])new QFilter[]{qFilterType, qFilter, qFilterOrg = new QFilter("org.id", "=", (Object)userOrgId)})))) {
                    int count = load.length;
                    String name = projectType.getString("name");
                    filterFieldValues.put(name, entityName);
                    filterFieldValues.put(name + "qFilter", SerializationUtils.serializeToBase64((Object)qFilter));
                    v.add(count);
                    continue;
                }
                v.add(0);
            }
            this.getPageCache().put("filterFieldValues", JSON.toJSONString(filterFieldValues));
        }
        turnover.add(v.toArray(new Number[v.size()]));
        return turnover;
    }

    protected CRFormula deserialize(String json) {
        CRCondition conditionObj = null;
        conditionObj = StringUtils.isBlank((CharSequence)json) ? new CRCondition() : (CRCondition)SerializationUtils.fromJsonString((String)json, CRCondition.class);
        return conditionObj;
    }

    protected void initSeriesStyle(int index, Chart chart, Series series, String color) {
        super.initSeriesStyle(index, chart, series, color);
        chart.setMargin(Position.left, "10px");
        chart.setMargin(Position.right, "40px");
        chart.setMargin(Position.top, "30px");
        BarSeries barSeries = (BarSeries)series;
        barSeries.setItemColor("#45DAD1");
        barSeries.setBarWidth("25px");
    }

    protected void initXStyle(Axis axis) {
        super.initXStyle(axis);
        HashMap<String, Integer> axisLabel = new HashMap<String, Integer>();
        axisLabel.put("rotate", 30);
        axis.setPropValue("axisLabel", axisLabel);
    }
}

