/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.home;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import kd.tmc.tm.common.resource.TeBizResource;

public class AppHomeProjectSetEdit
extends AbstractTmcBillEdit {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"projectcondition"});
    }

    public void click(EventObject e) {
        String key;
        super.click(e);
        switch (key = ((Control)e.getSource()).getKey()) {
            case "projectcondition": {
                this.openConditionPage();
                break;
            }
        }
    }

    private void openConditionPage() {
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        DynamicObject row = this.getModel().getEntryRowEntity("entry", rowIndex);
        DynamicObject projectType = row.getDynamicObject("projecttype");
        if (EmptyUtil.isEmpty((DynamicObject)projectType)) {
            this.getView().showTipNotification(TeBizResource.noSetProjectType());
        } else {
            String conditionJson = (String)this.getModel().getValue("conditionnumber");
            QFilter filter = new QFilter("tradetype.id", "=", (Object)projectType.getLong("id"));
            Map setColl = TmcDataServiceHelper.loadFromCache((String)"tbd_tradeset", (QFilter[])filter.toArray());
            HashMap map = new HashMap();
            setColl.forEach((key, tradeSet) -> {
                if (EmptyUtil.isNoEmpty((DynamicObject)tradeSet) && !tradeSet.getDynamicObject("bill").getString("number").endsWith("_l")) {
                    map.put("number", tradeSet.getDynamicObject("bill").getString("number"));
                }
            });
            MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)((String)map.get("number")));
            String entityName = mainType.getName();
            this.getModel().setValue("entity", (Object)entityName);
            this.showConditionForm(conditionJson, entityName, "projectcondition");
        }
    }

    private void showConditionForm(String conditionJson, String entityNumber, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("tm_condition");
        showParameter.getCustomParams().put("formula", conditionJson);
        showParameter.getCustomParams().put("entitynumber", entityNumber);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String conditionJson;
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)"projectcondition", (CharSequence)evt.getActionId()) && StringUtils.isNotBlank((CharSequence)(conditionJson = (String)evt.getReturnData()))) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            this.getModel().setValue("conditionnumber", (Object)conditionJson);
            this.getModel().setValue("projectcondition", (Object)condition.getExprDesc());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection colls;
        AbstractOperate op;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate && "save".equalsIgnoreCase((op = (AbstractOperate)source).getOperateKey()) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(colls = this.getModel().getEntryEntity("entry")))) {
            for (int i = 0; i < colls.size(); ++i) {
                DynamicObject dynamicObject = ((DynamicObject)colls.get(i)).getDynamicObject("projecttype");
                if (!EmptyUtil.isEmpty((DynamicObject)dynamicObject)) continue;
                this.getView().showTipNotification(TeBizResource.noSetProjectType());
                args.setCancel(true);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String projectCondition;
        super.propertyChanged(args);
        String name = args.getProperty().getName();
        if (StringUtils.equals((CharSequence)name, (CharSequence)"projectcondition") && StringUtils.equals((CharSequence)"", (CharSequence)(projectCondition = (String)this.getModel().getValue("projectcondition")))) {
            this.getModel().setValue("conditionnumber", (Object)"");
        }
    }
}

