/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.optioncom;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.OptionsTradeTypeEnum;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.enums.TradeDirectionEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.chart.AbstractLineChartEdit;
import kd.tmc.tm.common.enums.OptionComAssetTypeEnum;

public abstract class AbstractOptionComChartPlugin
extends AbstractLineChartEdit {
    private List<String> demensions = new ArrayList<String>();
    private List<Object> turnoverList = new ArrayList<Object>();

    protected String getChartCtlName() {
        return "prolosschart";
    }

    protected String getXTitleName() {
        return ResManager.loadKDString((String)"\u6807\u7684\u4ef7\u683c", (String)"AbstractOptionComChartPlugin_0", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
    }

    protected String getYTitleName() {
        return ResManager.loadKDString((String)"\u635f\u76ca", (String)"AbstractOptionComChartPlugin_1", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
    }

    protected String getSeriesTitleName(int index) {
        return ResManager.loadKDString((String)"\u635f\u76ca\u56fe", (String)"AbstractOptionComChartPlugin_2", (String)"tmc-tm-formplugin", (Object[])new Object[0]);
    }

    protected String[] getXValue() {
        return this.demensions.toArray(new String[this.demensions.size()]);
    }

    protected List<Object> getSeriesValue() {
        return this.turnoverList;
    }

    protected void calXYdata() {
        BigDecimal initStrikePrice;
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entrys");
        DataEntityPropertyCollection props = entry.getDynamicCollectionItemPropertyType().getProperties();
        DynamicObjectCollection entrys = new DynamicObjectCollection();
        for (DynamicObject obj : entry) {
            DynamicObject tradeF7 = obj.getDynamicObject("tradeno");
            if (!EmptyUtil.isNoEmpty((DynamicObject)tradeF7) || props.containsKey((Object)"tradeno") && (!props.containsKey((Object)"tradeno") || TcBillStatusEnum.FINISH.getValue().equals(tradeF7.getString("billstatus")) || TcBillStatusEnum.SETTLE_DONE.getValue().equals(tradeF7.getString("billstatus")))) continue;
            entrys.add((Object)obj);
        }
        BigDecimal minStrikeprice = initStrikePrice = (BigDecimal)this.getModel().getValue("strikeprice", 0);
        BigDecimal maxStrikePrice = initStrikePrice;
        for (DynamicObject dynamicObject : entrys) {
            BigDecimal strikeprice = dynamicObject.getBigDecimal("strikeprice");
            if (strikeprice.compareTo(minStrikeprice) < 0) {
                minStrikeprice = strikeprice;
            }
            if (strikeprice.compareTo(maxStrikePrice) <= 0) continue;
            maxStrikePrice = strikeprice;
        }
        BigDecimal d = maxStrikePrice.subtract(minStrikeprice);
        if (EmptyUtil.isEmpty((BigDecimal)d)) {
            d = maxStrikePrice.divide(BigDecimal.valueOf(5L), 6, 4);
        }
        BigDecimal startStrikePrice = minStrikeprice.subtract(d);
        BigDecimal endStrikePrice = maxStrikePrice.add(d);
        d = d.divide(Constants.TEN);
        BigDecimal tempStrikePrice = startStrikePrice;
        ArrayList<BigDecimal> minuList = new ArrayList<BigDecimal>();
        do {
            BigDecimal sumProfitLoss = Constants.ZERO;
            for (DynamicObject dynamicObject : entrys) {
                BigDecimal calProfitLoss = this.calProfitLoss(dynamicObject, tempStrikePrice);
                sumProfitLoss = sumProfitLoss.add(calProfitLoss.multiply(this.getComTradeDirectFlag()));
            }
            this.demensions.add(tempStrikePrice.setScale(4, 4).toString());
            minuList.add(sumProfitLoss.setScale(4, 4));
        } while ((tempStrikePrice = tempStrikePrice.add(d)).compareTo(endStrikePrice) <= 0);
        this.turnoverList.add(minuList);
    }

    private BigDecimal calProfitLoss(DynamicObject dynamicObject, BigDecimal St) {
        BigDecimal K = dynamicObject.getBigDecimal("strikeprice");
        BigDecimal BM = dynamicObject.getBigDecimal("baseamount");
        BigDecimal A = OptionComAssetTypeEnum.forex.getValue().equals(this.getModel().getValue("assettype")) ? dynamicObject.getDynamicObject("tradeno").getBigDecimal("bizrestamt") : dynamicObject.getBigDecimal("nameamt");
        BigDecimal P = dynamicObject.getBigDecimal("premium");
        String optionType = dynamicObject.getString("optiontype");
        String tradeDirect = TradeDirectionEnum.buy.getValue();
        if (dynamicObject.getDataEntityType().getProperties().containsKey((Object)"tradedirect")) {
            tradeDirect = dynamicObject.getString("tradedirect");
        } else if (EmptyUtil.isNoEmpty((DynamicObject)dynamicObject.getDynamicObject("tradeno"))) {
            tradeDirect = dynamicObject.getDynamicObject("tradeno").getString("tradedirect");
        }
        if (EmptyUtil.isEmpty((String)tradeDirect)) {
            return Constants.ZERO;
        }
        BigDecimal St_K = St.subtract(K);
        if (OptionsTradeTypeEnum.put.getValue().equals(optionType)) {
            St_K = St_K.multiply(Constants._ONE);
        }
        BigDecimal St_K_MAX = St_K.compareTo(Constants.ZERO) > 0 ? St_K : Constants.ZERO;
        BigDecimal directFlag = TradeDirectionEnum.buy.getValue().equals(tradeDirect) ? Constants.ONE : Constants._ONE;
        BigDecimal P_A_BM = P.multiply(A.divide(BM, 10, RoundingMode.HALF_UP));
        return directFlag.multiply(St_K_MAX.multiply(A).subtract(P_A_BM));
    }

    protected BigDecimal getComTradeDirectFlag() {
        return Constants.ONE;
    }

    protected abstract boolean valiate();
}

