/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.optioncom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.TcBillStatusEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.common.util.TcDateUtils;
import kd.tmc.tm.common.enums.OptionComAssetTypeEnum;
import kd.tmc.tm.common.resource.TeBizResource;
import kd.tmc.tm.formplugin.trade.AbstractTradeBillEdit;

public class OptionComEditPlugin
extends AbstractTradeBillEdit
implements ClickListener,
TabSelectListener,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        TextEdit edit = (TextEdit)this.getView().getControl("asset");
        edit.addButtonClickListener((ClickListener)this);
        TextEdit tradeNum = (TextEdit)this.getView().getControl("tradenum");
        tradeNum.addButtonClickListener((ClickListener)this);
        Tab tabap = (Tab)this.getView().getControl("tabap");
        tabap.addTabSelectListener((TabSelectListener)this);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entrys");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid floatPlEntry = (EntryGrid)this.getView().getControl("entry_floatpl");
        floatPlEntry.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid plEntry = (EntryGrid)this.getView().getControl("entry_pl");
        plEntry.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void tabSelected(TabSelectEvent e) {
        String tabKey = e.getTabKey();
        this.buildTab(tabKey);
    }

    private void buildTab(String tab) {
        switch (tab) {
            case "cashflow_tab": {
                this.buildCashFlow();
                break;
            }
            case "plinfo_tab": {
                this.buildFloatPlInfo();
                this.buildPlInfo();
            }
        }
    }

    private void setDataChanged(boolean value) {
        if (!value) {
            this.getModel().setDataChanged(value);
        }
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propName;
        super.propertyChanged(args);
        switch (propName = args.getProperty().getName()) {
            case "assettype": {
                this.setDefaultVariety();
                break;
            }
            case "org": 
            case "asset": {
                this.getModel().deleteEntryData("entrys");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"addtrade", (CharSequence)formOperate.getOperateKey())) {
            this.addTrade(args);
        }
    }

    private void addTrade(BeforeDoOperationEventArgs args) {
        String assetType = (String)this.getModel().getValue("assettype");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (EmptyUtil.isEmpty((DynamicObject)org)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u6307\u5b9a\u4ea4\u6613\u4e3b\u4f53\u3002", (String)"OptionComEditPlugin_6", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return;
        }
        String asset = (String)this.getModel().getValue("asset");
        if (EmptyUtil.isEmpty((String)asset)) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6807\u7684\u3002", (String)"OptionComEditPlugin_7", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter orgFilter = new QFilter("org.id", "=", org.getPkValue());
        QFilter commonFilter1 = new QFilter("composeno", "=", (Object)" ").and(new QFilter("billstatus", "=", (Object)TcBillStatusEnum.SUBMIT.getValue())).and(new QFilter("composeaudit", "=", (Object)"1")).and(orgFilter);
        QFilter commonFilter2 = new QFilter("composeno", "=", (Object)" ").and(new QFilter("billstatus", "in", (Object)new String[]{TcBillStatusEnum.AUDIT.getValue(), TcBillStatusEnum.SURVIVAL.getValue()})).and(orgFilter);
        QFilter filter = null;
        if (OptionComAssetTypeEnum.forex.getValue().equals(assetType)) {
            QFilter currencyFilter = new QFilter("pair", "=", (Object)asset);
            filter = commonFilter1.and(currencyFilter).or(commonFilter2.and(currencyFilter));
            filter.and("source", "not like", (Object)"combreqnote_%");
        }
        this.showForm(assetType, true, filter, "tradenum" + assetType);
    }

    public void click(EventObject e) {
        String assetType = (String)this.getModel().getValue("assettype");
        if (EmptyUtil.isEmpty((String)assetType)) {
            this.getView().showTipNotification(TeBizResource.notSelectAssetType());
            return;
        }
        if (((FieldEdit)e.getSource()).getKey().equals("asset") && OptionComAssetTypeEnum.forex.getValue().equals(assetType)) {
            QFilter qFilter = new QFilter("enable", "=", (Object)"1");
            this.showForm("bd_currency_tc", true, qFilter, "asset" + assetType);
        }
    }

    private void showForm(String formId, boolean isMultiSelect, QFilter filter, String backFlag) {
        DynamicObjectCollection entryEntity;
        ListShowParameter showParameter = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, backFlag));
        showParameter.setShowTitle(false);
        showParameter.getListFilterParameter().setFilter(filter);
        showParameter.setCustomParam("billFormId", (Object)formId);
        showParameter.setCustomParam("isOptionCombTrade", (Object)"true");
        String asset = (String)this.getModel().getValue("asset");
        if (backFlag.startsWith("tradenum") && EmptyUtil.isNoEmpty((DynamicObjectCollection)(entryEntity = this.getModel().getEntryEntity("entrys")))) {
            ArrayList<Object> pkIds = new ArrayList<Object>(entryEntity.getRowCount());
            ArrayList<String> invalidTradeNo = new ArrayList<String>(entryEntity.size());
            for (DynamicObject entry : entryEntity) {
                boolean validStatus;
                if (EmptyUtil.isEmpty((DynamicObject)entry.getDynamicObject("tradeno"))) continue;
                DynamicObject trade = QueryServiceHelper.queryOne((String)backFlag.replace("tradenum", "").replace("_l", ""), (String)"id,pair,billno,billstatus,composeaudit,composeno", (QFilter[])new QFilter[]{new QFilter("id", "=", entry.getDynamicObject("tradeno").getPkValue())});
                String billstatus = trade.getString("billstatus");
                Boolean composeaudit = trade.getBoolean("composeaudit");
                String composeno = trade.getString("composeno");
                boolean bl = validStatus = "C,D".contains(billstatus) || "B".equals(billstatus) && composeaudit != false;
                if (validStatus && EmptyUtil.isEmpty((String)composeno) && asset.equals(trade.getString("pair"))) {
                    pkIds.add(entry.getDynamicObject("tradeno").getPkValue());
                    continue;
                }
                invalidTradeNo.add(trade.getString("billno"));
            }
            if (!invalidTradeNo.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ea4\u6613\u53f7\uff1a{0}\u5df2\u4e0d\u6ee1\u8db3\u6784\u5efa\u7ec4\u5408\u7684\u6761\u4ef6\u3002", (String)"OptionComEditPlugin_8", (String)"tmc-tm-formplugin", (Object[])new Object[]{String.join((CharSequence)",", invalidTradeNo)}));
            }
            showParameter.setSelectedRows(pkIds.toArray());
        }
        if (backFlag.startsWith("asset") && EmptyUtil.isNoEmpty((String)asset)) {
            String[] assets = asset.split("/");
            DynamicObject leftCur = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)assets[0])});
            DynamicObject rightCur = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)assets[1])});
            showParameter.setSelectedRows(new Object[]{leftCur.getPkValue(), rightCur.getPkValue()});
        }
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        ListSelectedRowCollection data = (ListSelectedRowCollection)event.getReturnData();
        if (EmptyUtil.isEmpty((Collection)data)) {
            return;
        }
        if (("asset" + OptionComAssetTypeEnum.forex.getValue()).equals(event.getActionId()) && data.size() == 2) {
            String basecurrency = data.get(0).getNumber();
            String termcurrency = data.get(1).getNumber();
            this.getModel().setValue("asset", (Object)(basecurrency + "/" + termcurrency));
        }
        if (("tradenum" + OptionComAssetTypeEnum.forex.getValue()).equals(event.getActionId())) {
            this.callBackHandle(data, OptionComAssetTypeEnum.forex.getValue());
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String billstatus = this.getModel().getDataEntity().getString("billstatus");
        if (TcBillStatusEnum.FINISH.getValue().equals(billstatus)) {
            this.getView().getFormShowParameter().setStatus(OperationStatus.VIEW);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String opKey = args.getOperateKey();
        OperationResult opResult = args.getOperationResult();
        switch (opKey) {
            case "submit": {
                if (opResult != null && opResult.isSuccess()) {
                    this.getModel().setDataChanged(false);
                }
            }
            case "audit": 
            case "unaudit": {
                if (opResult == null || !opResult.isSuccess()) break;
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void callBackHandle(ListSelectedRowCollection selectData, String assetType) {
        ArrayList rowlist = new ArrayList(10);
        Date firstDate = null;
        for (int i = 0; i < selectData.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            Object tradeNo = selectData.get(i).getPrimaryKeyValue();
            map.put("tradeno", tradeNo);
            map.put("tradenum", selectData.get(i).getBillNo());
            Map<String, Object> queryEntryData = this.queryEntryData(tradeNo, assetType);
            map.put("protecttype", queryEntryData.get("protecttype"));
            map.put("optiontype", queryEntryData.get("optiontype"));
            map.put("premium", queryEntryData.get("premium"));
            map.put("strikeprice", queryEntryData.get("strikeprice"));
            map.put("baseamount", queryEntryData.get("baseamount"));
            map.put("basecurrency", queryEntryData.get("basecurrency"));
            map.put("sellcurrency", queryEntryData.get("sellcurrency"));
            map.put("buycurrency", queryEntryData.get("buycurrency"));
            map.put("sellamount", queryEntryData.get("sellamount"));
            map.put("buyamount", queryEntryData.get("buyamount"));
            map.put("premiumcurrency", queryEntryData.get("premiumcurrency"));
            Date exedate = (Date)queryEntryData.get("exedate");
            if (EmptyUtil.isEmpty(firstDate)) {
                firstDate = exedate;
            }
            if (TcDateUtils.getDiffDays((Date)firstDate, (Date)exedate) != 0) {
                this.getView().showErrorNotification(TeBizResource.noOptionStruct());
                return;
            }
            rowlist.add(map);
        }
        this.getModel().deleteEntryData("entrys");
        if (EmptyUtil.isNoEmpty(rowlist)) {
            TmcViewInputHelper.batchFillWithoutPropChg((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"entrys", rowlist, (boolean)false);
        }
    }

    private Map<String, Object> queryEntryData(Object pkValue, String entryKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        if (OptionComAssetTypeEnum.forex.getValue().equals(entryKey)) {
            DynamicObject forex = QueryServiceHelper.queryOne((String)"tm_forex_options", (String)"tradetype,optiontype,premium,exchangerate,premiumcurrency,amount,currency, buy_currency,buy_amount,sell_currency,sell_amount,adjexpiredate", (QFilter[])new QFilter[]{new QFilter("id", "=", pkValue)});
            map.put("protecttype", forex.get("optiontype"));
            map.put("optiontype", forex.get("tradetype"));
            map.put("premium", forex.getBigDecimal("premium"));
            map.put("strikeprice", forex.get("exchangerate"));
            map.put("basecurrency", forex.getLong("currency"));
            map.put("baseamount", forex.getBigDecimal("amount"));
            map.put("sellcurrency", forex.getLong("sell_currency"));
            map.put("sellamount", forex.getBigDecimal("sell_amount"));
            map.put("buycurrency", forex.getLong("buy_currency"));
            map.put("buyamount", forex.getBigDecimal("buy_amount"));
            map.put("premiumcurrency", forex.getLong("premiumcurrency"));
            map.put("exedate", forex.getDate("adjexpiredate"));
        }
        return map;
    }

    private List<Long> getTradeIds() {
        DynamicObjectCollection billEntrys = this.getModel().getEntryEntity("entrys");
        List<Long> tradeIds = billEntrys.stream().filter(v -> v.getDynamicObject("tradeno") != null).map(v -> v.getDynamicObject("tradeno").getLong("id")).collect(Collectors.toList());
        return tradeIds;
    }

    private void buildFloatPlInfo() {
        List<Map<String, Object>> floatplamtList;
        boolean isDataChange = this.getModel().getDataChanged();
        List<Long> tradeIds = this.getTradeIds();
        this.getModel().beginInit();
        boolean removedItemFlag = this.getModel().getDataEntity().getDataEntityState().getRemovedItems();
        this.getModel().deleteEntryData("entry_floatpl");
        if (!removedItemFlag) {
            this.getModel().getDataEntity().getDataEntityState().setRemovedItems(Boolean.FALSE);
        }
        if (!EmptyUtil.isEmpty(tradeIds) && EmptyUtil.isNoEmpty(floatplamtList = this.getFloatPlMaps(tradeIds))) {
            TmcViewInputHelper.batchFillWithoutPropChg((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"entry_floatpl", floatplamtList, (boolean)false);
        }
        this.getModel().endInit();
        this.setDataChanged(isDataChange);
        this.getView().updateView("entry_floatpl");
    }

    private List<Map<String, Object>> getFloatPlMaps(List<Long> tradeIds) {
        QFilter qFilter = new QFilter("tradebill", "in", tradeIds);
        DynamicObjectCollection floatPls = QueryServiceHelper.query((String)"tbo_plinfo", (String)"id,billno, tradebill.number,localcurrency, plcurrency, maxhistoryplinfo.updatedate, maxhistoryplinfo.floatplamt, maxhistoryplinfo.floatpllocalamt", (QFilter[])new QFilter[]{qFilter});
        if (floatPls == null) {
            return null;
        }
        ArrayList<Map<String, Object>> floatplamtList = new ArrayList<Map<String, Object>>(floatPls.size());
        for (int i = 0; i < floatPls.size(); ++i) {
            DynamicObject floatPl = (DynamicObject)floatPls.get(i);
            Long plcurrencyId = floatPl.getLong("plcurrency");
            Long localcurrencyId = floatPl.getLong("localcurrency");
            HashMap<String, Object> floatPlMap = new HashMap<String, Object>(16);
            floatPlMap.put("ftradebill", floatPl.getString("tradebill.number"));
            floatPlMap.put("fplinfobillno", floatPl.getString("billno"));
            floatPlMap.put("fplinfoid", floatPl.getLong("id"));
            floatPlMap.put("fplupdatedate", floatPl.getDate("maxhistoryplinfo.updatedate"));
            floatPlMap.put("fplcurrency", plcurrencyId);
            floatPlMap.put("floatplamt", floatPl.getBigDecimal("maxhistoryplinfo.floatplamt"));
            if (plcurrencyId != null && plcurrencyId.equals(localcurrencyId)) {
                floatPlMap.put("floatpllocalamt", floatPlMap.get("floatplamt"));
            } else {
                floatPlMap.put("floatpllocalamt", floatPl.getBigDecimal("maxhistoryplinfo.floatpllocalamt"));
            }
            floatPlMap.put("flocalcur", localcurrencyId);
            floatplamtList.add(floatPlMap);
        }
        return floatplamtList;
    }

    private void buildPlInfo() {
        List<Map<String, Object>> plamtList;
        boolean isDataChange = this.getModel().getDataChanged();
        List<Long> tradeIds = this.getTradeIds();
        this.getModel().beginInit();
        boolean removedItemFlag = this.getModel().getDataEntity().getDataEntityState().getRemovedItems();
        this.getModel().deleteEntryData("entry_pl");
        if (!removedItemFlag) {
            this.getModel().getDataEntity().getDataEntityState().setRemovedItems(Boolean.FALSE);
        }
        if (!EmptyUtil.isEmpty(tradeIds) && EmptyUtil.isNoEmpty(plamtList = this.getPlMaps(tradeIds))) {
            TmcViewInputHelper.batchFillWithoutPropChg((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"entry_pl", plamtList, (boolean)false);
        }
        this.getModel().endInit();
        this.setDataChanged(isDataChange);
        this.getView().updateView("entry_pl");
    }

    private List<Map<String, Object>> getPlMaps(List<Long> tradeIds) {
        QFilter qFilter = new QFilter("tradebill", "in", tradeIds);
        DynamicObjectCollection pls = QueryServiceHelper.query((String)"tbo_plinfo", (String)"id,billno,entrys.bizbillplcurrency, localcurrency, entrys.bizdate,entrys.settledate,entrys.biztype, entrys.plamt,entrys.pllocalamt, tradebill.number", (QFilter[])new QFilter[]{qFilter.and(new QFilter("entrys.id", "!=", (Object)0L))});
        if (pls == null) {
            return null;
        }
        ArrayList<Map<String, Object>> plamtList = new ArrayList<Map<String, Object>>(pls.size());
        for (DynamicObject pl : pls) {
            Long plcurrencyId = pl.getLong("entrys.bizbillplcurrency");
            Long localcurrencyId = pl.getLong("localcurrency");
            HashMap<String, Object> plamtEntryMap = new HashMap<String, Object>(16);
            plamtEntryMap.put("pltradebill", pl.getString("tradebill.number"));
            plamtEntryMap.put("plinfobillno", pl.getString("billno"));
            plamtEntryMap.put("plinfoid", pl.getLong("id"));
            plamtEntryMap.put("plcurrency", plcurrencyId);
            plamtEntryMap.put("biztype", pl.getString("entrys.biztype"));
            plamtEntryMap.put("opreatdate", pl.getDate("entrys.bizdate"));
            plamtEntryMap.put("settledate", pl.getDate("entrys.settledate"));
            plamtEntryMap.put("plamt", pl.getBigDecimal("entrys.plamt"));
            plamtEntryMap.put("pllocalamt", plcurrencyId.equals(localcurrencyId) ? pl.getBigDecimal("entrys.plamt") : pl.getBigDecimal("entrys.pllocalamt"));
            plamtEntryMap.put("pllocalcur", localcurrencyId);
            plamtList.add(plamtEntryMap);
        }
        return plamtList;
    }

    private void buildCashFlow() {
        List<Map<String, Object>> rowList;
        boolean isDataChange = this.getModel().getDataChanged();
        List<Long> tradeIds = this.getTradeIds();
        this.getModel().beginInit();
        boolean removedItemFlag = this.getModel().getDataEntity().getDataEntityState().getRemovedItems();
        this.getModel().deleteEntryData("cashflow");
        if (!removedItemFlag) {
            this.getModel().getDataEntity().getDataEntityState().setRemovedItems(Boolean.FALSE);
        }
        if (!EmptyUtil.isEmpty(tradeIds) && EmptyUtil.isNoEmpty(rowList = this.getCashFlowMaps(tradeIds))) {
            TmcViewInputHelper.batchFillWithoutPropChg((IDataModel)this.getModel(), (IFormView)this.getView(), (String)"cashflow", rowList, (boolean)false);
        }
        this.getModel().endInit();
        this.setDataChanged(isDataChange);
        this.getView().updateView("cashflow");
    }

    private List<Map<String, Object>> getCashFlowMaps(List<Long> tradeIds) {
        QFilter filter = new QFilter("billid", "in", (Object)tradeIds.toArray());
        DataSet cfDS = QueryServiceHelper.queryDataSet((String)"comboptiontrade-case-dataset", (String)"tm_cashflow", (String)"cftype,cfpayamount,cfcurrency,cfpaydate,cfishis,billnumber", (QFilter[])new QFilter[]{filter}, (String)"billnumber,billno asc");
        ArrayList<Map<String, Object>> rowList = new ArrayList<Map<String, Object>>(10);
        if (cfDS != null) {
            for (Row row : cfDS) {
                HashMap<String, Object> map = new HashMap<String, Object>(16);
                map.put("cftype", row.getString("cftype"));
                map.put("cfpayamount", row.getBigDecimal("cfpayamount"));
                map.put("cfcurrency", row.getLong("cfcurrency"));
                map.put("cfpaydate", row.getDate("cfpaydate"));
                map.put("cfbillno", row.getString("billnumber"));
                map.put("cfishis", row.getBoolean("cfishis"));
                rowList.add(map);
            }
        }
        return rowList;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        BillShowParameter param;
        String fieldName = event.getFieldName();
        if ("tradenum".equals(fieldName)) {
            String assettype = this.getModel().getValue("assettype").toString().replace("_l", "");
            int rowIndex = event.getRowIndex();
            DynamicObject rowData = (DynamicObject)this.getModel().getEntryEntity("entrys").get(rowIndex);
            if (EmptyUtil.isEmpty((DynamicObject)rowData.getDynamicObject("tradeno"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"OptionComEditPlugin_10", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                return;
            }
            param = new BillShowParameter();
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            param.setFormId(assettype);
            param.setStatus(OperationStatus.VIEW);
            param.setPkId(rowData.getDynamicObject("tradeno").getPkValue());
            this.getView().showForm((FormShowParameter)param);
        }
        if ("fplinfobillno".equals(fieldName) || "plinfobillno".equals(fieldName)) {
            int rowIndex = event.getRowIndex();
            String prop = "fplinfobillno".equals(fieldName) ? "fplinfoid" : "plinfoid";
            Long plId = (Long)this.getModel().getValue(prop, rowIndex);
            param = new BillShowParameter();
            param.setFormId("tbo_plinfo");
            param.setPkId((Object)plId);
            param.setStatus(OperationStatus.VIEW);
            param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)param);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setDefaultVariety();
    }

    public void afterCopyData(EventObject e) {
        this.getModel().deleteEntryData("entrys");
        this.getModel().setValue("reqno", null);
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"addtrade", "deleteentry", "asset"});
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObjectCollection entrys = this.getModel().getDataEntity().getDynamicObjectCollection("entrys");
        String assetType = this.getModel().getDataEntity().getString("assettype");
        String reqno = (String)this.getModel().getValue("reqno");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entrys)) {
            boolean isDeleted = false;
            for (int i = 0; i < entrys.getRowCount(); ++i) {
                DynamicObject tradeNo = ((DynamicObject)entrys.get(i)).getDynamicObject("tradeno");
                if (EmptyUtil.isEmpty((DynamicObject)tradeNo)) {
                    isDeleted = true;
                    continue;
                }
                Object tradeNoId = ((DynamicObject)entrys.get(i)).getDynamicObject("tradeno").getPkValue();
                Map<String, Object> queryEntryData = this.queryEntryData(tradeNoId, assetType);
                this.getModel().setValue("protecttype", queryEntryData.get("protecttype"), i);
                this.getModel().setValue("optiontype", queryEntryData.get("optiontype"), i);
                this.getModel().setValue("premium", queryEntryData.get("premium"), i);
                this.getModel().setValue("strikeprice", queryEntryData.get("strikeprice"), i);
                this.getModel().setValue("basecurrency", queryEntryData.get("basecurrency"), i);
                this.getModel().setValue("baseamount", queryEntryData.get("baseamount"), i);
                this.getModel().setValue("sellcurrency", queryEntryData.get("sellcurrency"), i);
                this.getModel().setValue("buycurrency", queryEntryData.get("buycurrency"), i);
                this.getModel().setValue("sellamount", queryEntryData.get("sellamount"), i);
                this.getModel().setValue("buyamount", queryEntryData.get("buyamount"), i);
                this.getModel().setValue("premiumcurrency", queryEntryData.get("premiumcurrency"), i);
            }
            if (isDeleted) {
                if (EmptyUtil.isEmpty((String)reqno)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u5408\u5b9a\u4e49\u4e2d\u7684\u90e8\u5206\u4ea4\u6613\u5355\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u8bf7\u68c0\u67e5\u7ec4\u5408\u3002", (String)"OptionComEditPlugin_9", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u90e8\u5206\u4ea4\u6613\u5355\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5220\u9664\u672c\u5355\u636e\u540e\u91cd\u65b0\u4e0b\u63a8\u3002", (String)"OptionComEditPlugin_11", (String)"tmc-tm-formplugin", (Object[])new Object[0]));
                }
            }
        }
        if (EmptyUtil.isNoEmpty((String)reqno)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"addtrade", "deleteentry", "org", "asset"});
        }
        Tab tabap = (Tab)this.getView().getControl("tabap");
        this.buildTab(tabap.getCurrentTab());
        this.setDataChanged(false);
    }

    private void setDefaultVariety() {
        String assettype = (String)this.getModel().getValue("assettype");
        if (EmptyUtil.isEmpty((String)assettype)) {
            return;
        }
        if (OptionComAssetTypeEnum.forex.getValue().equals(assettype)) {
            this.getModel().setValue("variety", (Object)OptionComAssetTypeEnum.forex.getName());
        } else if (OptionComAssetTypeEnum.rate.getValue().equals(assettype)) {
            this.getModel().setValue("variety", (Object)OptionComAssetTypeEnum.rate.getName());
        }
    }
}

