/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.tm.formplugin.reqlimit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.IListColumn;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class ReqLimitUseList
extends AbstractTmcListPlugin {
    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        super.beforeCreateListColumns(args);
        List listcontrol = args.getListColumns();
        for (int i = 0; i < listcontrol.size(); ++i) {
            IListColumn listcolumn = (IListColumn)listcontrol.get(i);
            String key = listcolumn.getListFieldKey();
            if (!"bill".equals(key)) continue;
            listcolumn.setHyperlink(true);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if ("bill".equals(fieldName)) {
            DynamicObjectCollection entries;
            Optional<DynamicObject> first;
            args.setCancel(true);
            Object primaryKeyValue = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getPrimaryKeyValue();
            Object entryId = ((BillListHyperLinkClickEvent)args.getHyperLinkClickEvent()).getCurrentRow().getEntryPrimaryKeyValue();
            QFilter filter = new QFilter("id", "=", primaryKeyValue);
            DynamicObject reqlimitUse = TmcDataServiceHelper.loadSingle((String)"tm_reqlimit_use", (String)"id,entryentity.billtype,entryentity.billid", (QFilter[])filter.toArray());
            if (reqlimitUse != null && (first = (entries = reqlimitUse.getDynamicObjectCollection("entryentity")).stream().filter(e -> e.getLong("id") == ((Long)entryId).longValue()).findFirst()).isPresent()) {
                DynamicObject dynamicObject = first.get();
                BillShowParameter sp = new BillShowParameter();
                String billtype = dynamicObject.getString("billtype");
                String billid = dynamicObject.getString("billid");
                sp.setBillTypeId(billtype);
                sp.setFormId(billtype);
                sp.setPkId((Object)billid);
                sp.setBillStatus(BillOperationStatus.VIEW);
                sp.setStatus(OperationStatus.VIEW);
                sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)sp);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("limitbillId")) {
            List qFilters = e.getQFilters();
            QFilter filter = new QFilter("limitid", "=", customParams.get("limitbillId"));
            filter.and(QFilter.isNotNull((String)"entryentity"));
            qFilters.add(filter);
        }
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection dataList = super.getData(start, limit);
            if (dataList.isEmpty()) {
                return dataList;
            }
            List limitid = dataList.stream().map(e -> e.getLong("limitid")).collect(Collectors.toList());
            QFilter qFilter = new QFilter("id", "in", limitid);
            DynamicObject[] limitDbs = TmcDataServiceHelper.load((String)"tm_reqlimit", (String)"id,entryentity.currency,entryentity.limitamt,entryentity.useamt,entryentity.remainamt", (QFilter[])qFilter.toArray());
            HashMap result = new HashMap(limitDbs.length);
            for (DynamicObject limitDb : limitDbs) {
                DynamicObjectCollection entryentities = limitDb.getDynamicObjectCollection("entryentity");
                HashMap<Long, DynamicObject> currMap = new HashMap<Long, DynamicObject>();
                for (DynamicObject entryEntity : entryentities) {
                    DynamicObject curr = entryEntity.getDynamicObject("currency");
                    Long currId = (Long)curr.getPkValue();
                    currMap.put(currId, entryEntity);
                }
                result.put(limitDb.getLong("id"), currMap);
            }
            for (DynamicObject data : dataList) {
                Long limitId = data.getLong("limitid");
                DynamicObject curr = data.getDynamicObject("currency");
                Map map = (Map)result.get(limitId);
                DynamicObject object = (DynamicObject)map.get(curr.getLong("id"));
                data.set("limitamt", (Object)object.getBigDecimal("limitamt"));
                data.set("useamt", (Object)object.getBigDecimal("useamt"));
                data.set("remainamt", (Object)object.getBigDecimal("remainamt"));
            }
            return dataList;
        }
    }
}

